/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.forecast;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.forecast.PredictParamFactorService;
import kd.epm.eb.business.forecast.model.MemberDto;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import org.apache.commons.collections4.CollectionUtils;

public class PredictParamTargetService {
    private static final Log log = LogFactory.getLog(PredictParamTargetService.class);
    private static final String ENTITY_NAME = "eb_predict_param_target";

    public static PredictParamTargetService getInstance() {
        return InnerClass.instance;
    }

    private PredictParamTargetService() {
    }

    public DynamicObject query(Long targetId) {
        QFilter qFilter = new QFilter("id", "=", (Object)targetId);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)ENTITY_NAME, (String)"id, model, dataset, dimconf, dimview", (QFilter[])qFilter.toArray());
        if (dynamicObject == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9884\u6d4b\u5bf9\u8c61\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\u3002", (String)"PredictParamTargetService_1", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        return dynamicObject;
    }

    public DynamicObjectCollection queryByModel(Long modelId) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        return QueryServiceHelper.query((String)ENTITY_NAME, (String)"id, model, dataset, dimconf, dimview", (QFilter[])qFilter.toArray());
    }

    public DynamicObjectCollection queryByModelAndDataset(Long modelId, Long datasetId) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and(new QFilter("dataset", "=", (Object)datasetId));
        return QueryServiceHelper.query((String)ENTITY_NAME, (String)"id, model, dataset, dimconf, dimview", (QFilter[])qFilter.toArray());
    }

    public DynamicObject queryMemory(Long modelId) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        DynamicObjectCollection targets = QueryServiceHelper.query((String)ENTITY_NAME, (String)"id, model, dataset, dimconf, dimview", (QFilter[])qFilter.toArray(), (String)"id desc", (int)1);
        return targets.size() == 0 ? null : (DynamicObject)targets.get(0);
    }

    public DynamicObject queryMemory(Long modelId, Long datasetId) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and(new QFilter("dataset", "=", (Object)datasetId));
        DynamicObjectCollection targets = QueryServiceHelper.query((String)ENTITY_NAME, (String)"id, model, dataset, dimconf, dimview", (QFilter[])qFilter.toArray(), (String)"id desc", (int)1);
        return targets.size() == 0 ? null : (DynamicObject)targets.get(0);
    }

    public Set<Long> matchParamTarget(Long modelId, Long datasetId, IModelCacheHelper modelCache, List<Dimension> dimensionList, List<Map<String, String>> validDimNumList) {
        if (CollectionUtils.isEmpty(validDimNumList)) {
            return Collections.emptySet();
        }
        DynamicObjectCollection targets = PredictParamTargetService.getInstance().queryByModelAndDataset(modelId, datasetId);
        HashSet<Long> targetIds = new HashSet<Long>(targets.size());
        validDimNumList.forEach(matchDim -> {
            Set ids = targets.stream().filter(target -> {
                JSONObject dimensionViews = JSON.parseObject((String)target.getString("dimview"));
                JSONObject dimMembers = JSON.parseObject((String)target.getString("dimconf"));
                boolean allMatch = true;
                for (Dimension dimension : dimensionList) {
                    String dimNumber = dimension.getNumber();
                    String members = dimMembers.getString(dimNumber);
                    if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber) || StringUtils.isEmpty((String)members)) continue;
                    Long viewId = IDUtils.toLong((Object)dimensionViews.get((Object)dimNumber));
                    List memberList = JSONObject.parseArray((String)members, MemberDto.class);
                    List targetMember = memberList.stream().flatMap(memberDto -> modelCache.getMember(dimNumber, viewId, memberDto.getNumber(), Integer.parseInt(memberDto.getScope())).stream()).collect(Collectors.toList());
                    allMatch = targetMember.stream().anyMatch(e -> ((String)matchDim.get(dimNumber)).equals(e.getNumber()));
                    if (allMatch) continue;
                    break;
                }
                return allMatch;
            }).map(target -> target.getLong("id")).collect(Collectors.toSet());
            targetIds.addAll(ids);
        });
        return targetIds;
    }

    public Long save(Long id, Long modelId, Long datasetId, String dimConf, String dimView) {
        DynamicObject dynamicObject;
        if (IDUtils.isEmptyLong((Long)id).booleanValue()) {
            id = GlobalIdUtil.genGlobalLongId();
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_NAME);
            dynamicObject.set("id", (Object)id);
        } else {
            dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)ENTITY_NAME);
        }
        dynamicObject.set("model", (Object)modelId);
        dynamicObject.set("dataset", (Object)datasetId);
        dynamicObject.set("dimconf", (Object)dimConf);
        dynamicObject.set("dimview", (Object)dimView);
        dynamicObject.set("modifier", (Object)UserUtils.getUserId());
        dynamicObject.set("modifydate", (Object)TimeServiceHelper.now());
        try (TXHandle tx = TX.required();){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            }
            catch (Throwable e) {
                tx.markRollback();
                log.error(e.getMessage(), e);
                throw new KDBizException(e.getMessage());
            }
        }
        return id;
    }

    public void delete(Long id) {
        try (TXHandle tx = TX.required();){
            try {
                DeleteServiceHelper.delete((String)ENTITY_NAME, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
                PredictParamFactorService.getInstance().deleteByTarget(id);
            }
            catch (Throwable e) {
                tx.markRollback();
                log.error(e.getMessage(), e);
                throw new KDBizException(e.getMessage());
            }
        }
    }

    private static class InnerClass {
        private static final PredictParamTargetService instance = new PredictParamTargetService();

        private InnerClass() {
        }
    }
}

