/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.forecast;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.forecast.ForecastConstants;
import kd.epm.eb.business.forecast.PredictResultService;
import kd.epm.eb.business.forecast.QueryService;
import kd.epm.eb.business.forecast.entity.PredictRecord;
import kd.epm.eb.business.forecast.helper.PredictHelper;
import kd.epm.eb.business.forecast.model.PredModel;
import kd.epm.eb.business.forecast.model.PredTarget;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import org.apache.commons.collections4.CollectionUtils;

public class PredictRecordService {
    private static final Log log = LogFactory.getLog(PredictRecordService.class);
    private static final String ENTITY_NAME = "eb_predict_record";
    private static final String ALL_FIELD = "id, model, bizmodel, dataset, canvas, sandbox, scheme, process, attach, predmodel, target, factor, predstart, predend, samplelen, status, createrid, createdate, modifierid, modifydate";

    public static PredictRecordService getInstance() {
        return InnerClass.instance;
    }

    private PredictRecordService() {
    }

    public PredictRecord load(long recordId) {
        QFilter qFilter = new QFilter("id", "=", (Object)recordId);
        DynamicObject dyObj = QueryServiceHelper.queryOne((String)ENTITY_NAME, (String)ALL_FIELD, (QFilter[])qFilter.toArray());
        if (dyObj != null) {
            return this.transToPredictRecord(dyObj);
        }
        return null;
    }

    public long hasPredicting(long modelId, Long schemeId, Long reportProcessId, Long canvasId) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId).and("status", "in", (Object)Lists.newArrayList((Object[])new String[]{ForecastConstants.Status.DOING.getValue(), ForecastConstants.Status.PREDICT.getValue()})).and("createrid", "=", (Object)RequestContext.get().getCurrUserId());
        this.appendFkId(schemeId, reportProcessId, canvasId, null, qFilter);
        DynamicObject dyObj = QueryServiceHelper.queryOne((String)ENTITY_NAME, (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (dyObj != null) {
            return dyObj.getLong("id");
        }
        return 0L;
    }

    public boolean isComplete(long recordId) {
        QFilter qFilter = new QFilter("id", "=", (Object)recordId).and("status", "in", (Object)Lists.newArrayList((Object[])new String[]{ForecastConstants.Status.SUCCESS.getValue(), ForecastConstants.Status.FAIL.getValue()}));
        return QueryServiceHelper.exists((String)ENTITY_NAME, (QFilter[])new QFilter[]{qFilter});
    }

    private void appendFkId(Long schemeId, Long reportProcessId, Long canvasId, List<Long> sandboxIds, QFilter qFilter) {
        if (IDUtils.isNotEmptyLong((Long)schemeId).booleanValue()) {
            qFilter.and("scheme", "=", (Object)schemeId);
        } else if (IDUtils.isNotEmptyLong((Long)reportProcessId).booleanValue()) {
            qFilter.and("process", "=", (Object)reportProcessId);
        } else {
            qFilter.and("canvas", "=", (Object)canvasId);
            if (CollectionUtils.isNotEmpty(sandboxIds)) {
                qFilter.and("sandbox", "in", sandboxIds);
            }
        }
    }

    public PredModel queryPrevData(long modelId, long dimHashId, Long schemeId, Long reportProcessId, Long canvasId) {
        List<PredModel> predModelList = this.queryDataByDimHash(modelId, dimHashId, schemeId, reportProcessId, canvasId, 2);
        if (CollectionUtils.isEmpty(predModelList) || predModelList.size() < 2) {
            return null;
        }
        return predModelList.get(1);
    }

    public List<PredModel> queryDataByDimHash(long modelId, long dimHashId, Long schemeId, Long reportProcessId, Long canvasId, int pageSize) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT B.fid FROM t_eb_predict_record A, t_eb_predict_result B WHERE A.fid = B.frecordid  AND B.fstatus = ?  AND B.fdimhash = ?  AND A.fmodel = ?  AND A.fcreaterid = ?");
        ArrayList<Object> paramList = new ArrayList<Object>(10);
        paramList.add(ForecastConstants.Status.SUCCESS.getValue());
        paramList.add(dimHashId);
        paramList.add(modelId);
        paramList.add(RequestContext.get().getCurrUserId());
        if (IDUtils.isNotEmptyLong((Long)schemeId).booleanValue()) {
            sb.append(" AND fscheme = ?");
            paramList.add(schemeId);
        } else if (IDUtils.isNotEmptyLong((Long)reportProcessId).booleanValue()) {
            sb.append(" AND fprocess = ?");
            paramList.add(reportProcessId);
        } else {
            sb.append(" AND fcanvas = ?");
            paramList.add(canvasId);
        }
        sb.append(" ORDER BY B.fid desc");
        ArrayList<Long> ids = new ArrayList<Long>(2);
        try (DataSet rows = DB.queryDataSet((String)"queryPrevData", (DBRoute)DBRoute.of((String)"epm"), (String)sb.toString(), (Object[])paramList.toArray());){
            while (rows.hasNext()) {
                ids.add(rows.next().getLong("fid"));
            }
        }
        if (CollectionUtils.isEmpty(ids)) {
            return null;
        }
        List<Long> resultIds = ids.size() <= pageSize ? ids : ids.subList(0, pageSize);
        List<PredModel> predModelList = PredictResultService.getInstance().query(resultIds);
        if (CollectionUtils.isNotEmpty(predModelList)) {
            predModelList.sort((p1, p2) -> Long.compare(Long.parseLong(p2.getId()), Long.parseLong(p1.getId())));
        }
        return predModelList;
    }

    public JSONObject queryCurrDataAndDiff(long recordId, long dimHashId) {
        PredictRecord record = this.load(recordId);
        PredModel predModel = PredictResultService.getInstance().queryByDimHash(record.getModel(), recordId, dimHashId);
        long modelId = record.getModel();
        long datasetId = record.getDataset();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        List allDims = modelCache.getDimensionList(Long.valueOf(datasetId));
        List<String> sortedDimList = allDims.stream().map(BaseCache::getNumber).collect(Collectors.toList());
        HashMap<String, String> allDimNum = new HashMap<String, String>(sortedDimList.size());
        HashMap<String, Set<String>> queryDim = new HashMap<String, Set<String>>(sortedDimList.size());
        List<String> cellMembers = predModel.getMembers();
        AtomicInteger index = new AtomicInteger(0);
        for (String dimNumber : sortedDimList) {
            if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber)) continue;
            int i = index.getAndIncrement();
            String memberName = cellMembers.get(i);
            allDimNum.put(dimNumber, memberName);
            queryDim.put(dimNumber, Sets.newHashSet((Object[])new String[]{memberName}));
        }
        List<String> predIndexNumberList = predModel.getPredIndexNumberList();
        List<Double> predDataList = predModel.getPredDataList();
        queryDim.put(SysDimensionEnum.BudgetPeriod.getNumber(), new HashSet<String>(predIndexNumberList));
        Map<MembersKey, BGCell> baseDataMap = QueryService.getInstance().queryCurrData(modelId, datasetId, record.getSandboxId(), queryDim, predModel.getDimViewMap());
        BigDecimal dataUnitNum = new BigDecimal(predModel.getDataUnit());
        ArrayList<String> currDataList = new ArrayList<String>(predIndexNumberList.size());
        ArrayList<String> diffDataList = new ArrayList<String>(predIndexNumberList.size());
        for (int i = 0; i < predIndexNumberList.size(); ++i) {
            String predNumber = predIndexNumberList.get(i);
            Double predData = predDataList.get(i);
            HashMap queryCellMap = Maps.newHashMap(allDimNum);
            queryCellMap.put(SysDimensionEnum.BudgetPeriod.getNumber(), predNumber);
            Object cellValue = QueryService.getInstance().getCellValue(modelCache, queryCellMap, sortedDimList, baseDataMap, dataUnitNum);
            BigDecimal currData = null;
            BigDecimal diffData = null;
            if (cellValue != null && predData != null) {
                currData = cellValue instanceof Long ? BigDecimal.valueOf((Long)cellValue) : (BigDecimal)cellValue;
                BigDecimal preData = BigDecimal.valueOf(predData);
                if (preData.compareTo(BigDecimal.ZERO) != 0) {
                    diffData = preData.subtract(currData).divide(preData, 4, RoundingMode.HALF_UP);
                }
            }
            currDataList.add(currData == null ? null : currData.toString());
            diffDataList.add(diffData == null ? null : diffData.toString());
        }
        JSONObject result = new JSONObject();
        result.fluentPut("recordId", (Object)recordId);
        result.fluentPut("dimHashId", (Object)dimHashId);
        result.fluentPut("predData", predDataList.stream().map(d -> d == null ? null : String.valueOf(d)).collect(Collectors.toList()));
        result.fluentPut("currData", currDataList);
        result.fluentPut("diffData", diffDataList);
        return result;
    }

    public void deleteCanvasRecord(long canvasId, List<Long> sandboxIds) {
        this.deleteRecord(null, null, null, canvasId, sandboxIds);
    }

    public void deleteSchemeRecord(long modelId, long schemeId) {
        this.deleteRecord(modelId, schemeId, null, null, null);
    }

    public void deleteReportRecord(long modelId, long reportProcessId) {
        this.deleteRecord(modelId, null, reportProcessId, null, null);
    }

    private void deleteRecord(Long modelId, Long schemeId, Long reportProcessId, Long canvasId, List<Long> sandboxIds) {
        QFilter qFilter = new QFilter("createrid", "=", (Object)RequestContext.get().getCurrUserId());
        if (IDUtils.isNotEmptyLong((Long)modelId).booleanValue()) {
            qFilter.and("model", "=", (Object)modelId);
        }
        this.appendFkId(schemeId, reportProcessId, canvasId, sandboxIds, qFilter);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)ENTITY_NAME, (String)"id", (QFilter[])new QFilter[]{qFilter});
        List<Long> recordIds = dynamicObjects.stream().map(dyObj -> dyObj.getLong("id")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(recordIds)) {
            return;
        }
        try (TXHandle tx = TX.required();){
            try {
                PredictResultService.getInstance().deleteByRecord(recordIds);
                DeleteServiceHelper.delete((String)ENTITY_NAME, (QFilter[])qFilter.toArray());
            }
            catch (Throwable e) {
                tx.markRollback();
                log.error(e.getMessage(), e);
                throw new KDBizException(e.getMessage());
            }
        }
    }

    public void cancel(long recordId) {
        try (TXHandle tx = TX.required();){
            try {
                String reason = "cancel";
                PredictResultService.getInstance().cancel(recordId, reason);
                DB.update((DBRoute)BgBaseConstant.epm, (String)"update t_eb_predict_record set fstatus = ?, freason = ? where fid = ?", (Object[])new Object[]{ForecastConstants.Status.FAIL.getValue(), reason, recordId});
            }
            catch (Throwable e) {
                tx.markRollback();
                log.error(e.getMessage(), e);
                throw new KDBizException(e.getMessage());
            }
        }
    }

    public long create(long modelId, long datasetId, Long schemeId, Long reportProcessId, Long canvasId, Long sandboxId, String attach, String target, String factor, String predModel, String predStartNumber, String predEndNumber, Integer sampleLen, List<PredTarget> predTargetList, boolean autoWrite, String factorName, Integer periodType) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        Long bizModelId = modelCache.getBusModelByDataSet(Long.valueOf(datasetId));
        List dimensionList = modelCache.getDimensionList(Long.valueOf(datasetId));
        PredictRecord predictRecord = new PredictRecord();
        predictRecord.setModel(modelId);
        predictRecord.setBizModel(bizModelId);
        predictRecord.setDataset(datasetId);
        predictRecord.setCanvasId(canvasId);
        predictRecord.setSandboxId(sandboxId);
        predictRecord.setSchemeId(schemeId);
        predictRecord.setProcessId(reportProcessId);
        predictRecord.setAttach(attach);
        predictRecord.setPredModel(predModel);
        predictRecord.setPredStart(predStartNumber);
        predictRecord.setPredEnd(predEndNumber);
        predictRecord.setSampleLen(sampleLen.longValue());
        if (target.length() > 150) {
            target = target.substring(0, 150);
        }
        if (factor.length() > 150) {
            factor = factor.substring(0, 150);
        }
        predictRecord.setTarget(target);
        predictRecord.setFactor(factor);
        Throwable throwable = null;
        try (TXHandle tx = TX.required();){
            DynamicObject recordObject = this.packageDynamicObject(predictRecord);
            long recordId = recordObject.getLong("id");
            long[] genIds = GlobalIdUtil.genGlobalLongIds((int)predTargetList.size());
            log.info("genIds:{}", (Object)Arrays.stream(genIds).mapToObj(String::valueOf).collect(Collectors.joining(",")));
            long[] resultIds = Arrays.stream(genIds).sorted().toArray();
            log.info("after sort genIds:{}", (Object)Arrays.stream(resultIds).mapToObj(String::valueOf).collect(Collectors.joining(",")));
            AtomicInteger targetIndex = new AtomicInteger(0);
            DynamicObject[] resultObjArr = (DynamicObject[])predTargetList.stream().map(predTarget -> {
                Map cellDimMap = (Map)JSON.parseObject((String)predTarget.getNumber(), Map.class);
                BigDecimal dataUnit = PredictHelper.getDataUnit(predTarget.getDataUnit());
                return PredictResultService.getInstance().create(recordId, resultIds[targetIndex.getAndIncrement()], predTarget.getName(), dimensionList, cellDimMap, predTarget.getDimView(), dataUnit, String.valueOf(autoWrite), factorName, periodType);
            }).filter(Objects::nonNull).toArray(DynamicObject[]::new);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{recordObject});
            SaveServiceHelper.save((DynamicObject[])resultObjArr);
            long l = recordId;
            return l;
        }
        catch (Throwable e) {
            try {
                tx.markRollback();
                log.error(e.getMessage(), e);
                throw new KDBizException(e.getMessage());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public void updateStatus(long recordId, ForecastConstants.Status status) {
        DynamicObject dyObj = BusinessDataServiceHelper.loadSingleFromCache((Object)recordId, (String)ENTITY_NAME);
        if (dyObj == null) {
            return;
        }
        dyObj.set("status", (Object)status.getValue());
        dyObj.set("modifierid", (Object)RequestContext.get().getCurrUserId());
        dyObj.set("modifydate", (Object)TimeServiceHelper.now());
        try (TXHandle tx = TX.required();){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyObj});
            }
            catch (Throwable e) {
                tx.markRollback();
                log.error(e.getMessage(), e);
                throw new KDBizException(e.getMessage());
            }
        }
    }

    public boolean updatePredict(long recordId) {
        Throwable throwable = null;
        try (TXHandle tx = TX.required();){
            int result = DB.update((DBRoute)BgBaseConstant.epm, (String)"update t_eb_predict_record set fstatus = ? where fid = ? and fstatus = ?", (Object[])new Object[]{ForecastConstants.Status.PREDICT.getValue(), recordId, ForecastConstants.Status.DOING.getValue()});
            boolean bl = result > 0;
            return bl;
        }
        catch (Throwable e) {
            try {
                tx.markRollback();
                log.error(e.getMessage(), e);
                throw new KDBizException(e.getMessage());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public boolean isPredict(long recordId) {
        QFilter qFilter = new QFilter("id", "=", (Object)recordId).and("status", "=", (Object)ForecastConstants.Status.PREDICT.getValue());
        return QueryServiceHelper.exists((String)ENTITY_NAME, (QFilter[])new QFilter[]{qFilter});
    }

    private PredictRecord transToPredictRecord(DynamicObject dynamicObject) {
        PredictRecord model = new PredictRecord();
        model.setId(dynamicObject.getLong("id"));
        model.setModel(dynamicObject.getLong("model"));
        model.setBizModel(dynamicObject.getLong("bizmodel"));
        model.setDataset(dynamicObject.getLong("dataset"));
        model.setCanvasId(dynamicObject.getLong("canvas"));
        model.setSandboxId(dynamicObject.getLong("sandbox"));
        model.setSchemeId(dynamicObject.getLong("scheme"));
        model.setProcessId(dynamicObject.getLong("process"));
        model.setAttach(dynamicObject.getString("attach"));
        model.setPredModel(dynamicObject.getString("predmodel"));
        model.setTarget(dynamicObject.getString("target"));
        model.setFactor(dynamicObject.getString("factor"));
        model.setPredStart(dynamicObject.getString("predstart"));
        model.setPredEnd(dynamicObject.getString("predend"));
        model.setSampleLen(dynamicObject.getLong("samplelen"));
        model.setStatus(dynamicObject.getString("status"));
        model.setCreaterId(dynamicObject.getLong("createrid"));
        model.setCreateDate(dynamicObject.getDate("createdate"));
        model.setModifierId(dynamicObject.getLong("modifierid"));
        model.setModifyDate(dynamicObject.getDate("modifydate"));
        return model;
    }

    private DynamicObject packageDynamicObject(PredictRecord model) {
        String status;
        DynamicObject dynamicObject;
        Long id = model.getId();
        if (IDUtils.isNull((Long)id)) {
            id = GlobalIdUtil.genGlobalLongId();
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_NAME);
            status = ForecastConstants.Status.INIT.getValue();
            dynamicObject.set("createrid", (Object)RequestContext.get().getCurrUserId());
            dynamicObject.set("createdate", (Object)TimeServiceHelper.now());
        } else {
            dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)ENTITY_NAME);
            status = model.getStatus();
        }
        dynamicObject.set("id", (Object)id);
        dynamicObject.set("model", (Object)model.getModel());
        dynamicObject.set("bizmodel", (Object)model.getBizModel());
        dynamicObject.set("dataset", (Object)model.getDataset());
        dynamicObject.set("canvas", (Object)model.getCanvasId());
        dynamicObject.set("sandbox", (Object)model.getSandboxId());
        dynamicObject.set("scheme", (Object)model.getSchemeId());
        dynamicObject.set("process", (Object)model.getProcessId());
        dynamicObject.set("attach", (Object)model.getAttach());
        dynamicObject.set("predmodel", (Object)model.getPredModel());
        dynamicObject.set("target", (Object)model.getTarget());
        dynamicObject.set("factor", (Object)model.getFactor());
        dynamicObject.set("predstart", (Object)model.getPredStart());
        dynamicObject.set("predend", (Object)model.getPredEnd());
        dynamicObject.set("samplelen", (Object)model.getSampleLen());
        dynamicObject.set("status", (Object)status);
        dynamicObject.set("modifierid", (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set("modifydate", (Object)TimeServiceHelper.now());
        return dynamicObject;
    }

    private static class InnerClass {
        private static final PredictRecordService instance = new PredictRecordService();

        private InnerClass() {
        }
    }
}

