/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.forecast;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.forecast.ForecastConstants;
import kd.epm.eb.business.forecast.PredictRecordService;
import kd.epm.eb.business.forecast.entity.PredictResult;
import kd.epm.eb.business.forecast.helper.PredictHelper;
import kd.epm.eb.business.forecast.model.PredModel;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.IDUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class PredictResultService {
    private static final Log log = LogFactory.getLog(PredictResultService.class);
    private static final String ENTITY_NAME = "eb_predict_result";
    private static final int PAGE_SIZE = 50;
    private static final String ALL_FIELD = "id, name, dimhash, recordid, entity, account, members, dimview, dataunit, periodtype,  metric, predindex, preddata, fitdata, sampleindex, sampledata, confidencemin, confidencemax, corr, status, reason, requestid, autowrite, factorname, modifierid, modifydate";

    public static PredictResultService getInstance() {
        return InnerClass.instance;
    }

    private PredictResultService() {
    }

    public int queryAllCount(long recordId) {
        QFilter qFilter = new QFilter("recordid", "=", (Object)recordId);
        DynamicObjectCollection count = QueryServiceHelper.query((String)ENTITY_NAME, (String)"id", (QFilter[])qFilter.toArray());
        return count.size();
    }

    public int queryCompleteCount(long recordId) {
        QFilter qFilter = new QFilter("recordid", "=", (Object)recordId).and("status", "=", (Object)ForecastConstants.Status.SUCCESS.getValue());
        DynamicObjectCollection count = QueryServiceHelper.query((String)ENTITY_NAME, (String)"id", (QFilter[])qFilter.toArray());
        return count.size();
    }

    public List<PredictResult> queryPredict(List<Long> recordIds) {
        QFilter qFilter = new QFilter("recordid", "in", recordIds).and("status", "in", (Object)Lists.newArrayList((Object[])new String[]{ForecastConstants.Status.INIT.getValue(), ForecastConstants.Status.DOING.getValue(), ForecastConstants.Status.PREDICT.getValue()}));
        DynamicObjectCollection dyObjs = QueryServiceHelper.query((String)ENTITY_NAME, (String)ALL_FIELD, (QFilter[])new QFilter[]{qFilter});
        if (CollectionUtils.isEmpty((Collection)dyObjs)) {
            return Collections.emptyList();
        }
        return dyObjs.stream().map(this::transToResultModel).collect(Collectors.toList());
    }

    public List<PredModel> query(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        QFilter qFilter = new QFilter("id", "in", ids);
        DynamicObjectCollection dyObjs = QueryServiceHelper.query((String)ENTITY_NAME, (String)ALL_FIELD, (QFilter[])new QFilter[]{qFilter});
        if (CollectionUtils.isEmpty((Collection)dyObjs)) {
            return Collections.emptyList();
        }
        return dyObjs.stream().map(dyObj -> this.transToPredModel(null, this.transToResultModel((DynamicObject)dyObj))).collect(Collectors.toList());
    }

    public PredModel queryByDimHash(Long modelId, long recordId, long dimHashId) {
        QFilter qFilter = new QFilter("dimhash", "=", (Object)dimHashId).and("recordid", "=", (Object)recordId);
        DynamicObject dyObj = QueryServiceHelper.queryOne((String)ENTITY_NAME, (String)ALL_FIELD, (QFilter[])new QFilter[]{qFilter});
        if (dyObj != null) {
            return this.transToPredModel(modelId, this.transToResultModel(dyObj));
        }
        return null;
    }

    public DynamicObjectCollection querySuccessResult(long recordId) {
        QFilter qFilter = new QFilter("recordid", "=", (Object)recordId).and("status", "=", (Object)ForecastConstants.Status.SUCCESS.getValue());
        return QueryServiceHelper.query((String)ENTITY_NAME, (String)"id, dimhash", (QFilter[])new QFilter[]{qFilter});
    }

    public boolean hasNextPage(long recordId, int currPage) {
        int totalPage = this.getTotalPage(recordId);
        return currPage < totalPage;
    }

    public int getTotalPage(long recordId) {
        int totalCount = this.getTotalCount(recordId);
        return totalCount % 50 == 0 ? totalCount / 50 : totalCount / 50 + 1;
    }

    public int getTotalCount(long recordId) {
        QFilter qFilter = new QFilter("recordid", "=", (Object)recordId);
        ORM orm = ORM.create();
        int count = 0;
        DataSet ds = orm.queryDataSet(ENTITY_NAME, ENTITY_NAME, "count(1) as count", new QFilter[]{qFilter});
        if (ds == null) {
            return count;
        }
        while (ds.hasNext()) {
            count = ds.next().getInteger("count");
        }
        return count;
    }

    public List<PredModel> queryRecordResult(Long modelId, long recordId, int page) {
        QFilter qFilter = new QFilter("recordid", "=", (Object)recordId);
        ORM orm = ORM.create();
        DataSet ds = orm.queryDataSet(ENTITY_NAME, ENTITY_NAME, ALL_FIELD, new QFilter[]{qFilter}, "id", (page - 1) * 50, 50);
        if (ds == null) {
            return Collections.emptyList();
        }
        DynamicObjectCollection rows = orm.toPlainDynamicObjectCollection(ds);
        ds.close();
        return rows.stream().map(dyObj -> this.transToPredModel(modelId, this.transToResultModel((DynamicObject)dyObj))).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public void deleteByRecord(List<Long> recordList) {
        QFilter qFilter = new QFilter("recordid", "in", recordList);
        DeleteServiceHelper.delete((String)ENTITY_NAME, (QFilter[])qFilter.toArray());
    }

    public DynamicObject create(long recordId, long resultId, String name, List<Dimension> dimensionList, Map<String, String> cellDimMap, String dimView, BigDecimal dataUnit, String autoWrite, String factorName, Integer periodType) {
        Pair<Long, String> pair = PredictHelper.genDimMemHash(dimensionList, cellDimMap);
        Long dimHashId = (Long)pair.getLeft();
        String cellMembers = (String)pair.getRight();
        PredictResult resultModel = new PredictResult();
        resultModel.setId(resultId);
        resultModel.setRecordId(recordId);
        resultModel.setDimHash(dimHashId);
        resultModel.setName(name);
        resultModel.setEntity(cellDimMap.get(SysDimensionEnum.Entity.getNumber()));
        resultModel.setAccount(cellDimMap.get(SysDimensionEnum.Account.getNumber()));
        resultModel.setMembers(cellMembers);
        resultModel.setDimView(dimView);
        resultModel.setDataUnit(dataUnit.toString());
        resultModel.setAutoWrite(autoWrite);
        resultModel.setFactorName(factorName);
        resultModel.setPeriodType(Long.parseLong(periodType.toString()));
        return this.packageDynamicObject(resultModel, true);
    }

    public boolean updateDoing(long recordId, long dimHashId) {
        Throwable throwable = null;
        try (TXHandle tx = TX.required();){
            int result = DB.update((DBRoute)BgBaseConstant.epm, (String)"update t_eb_predict_result set fstatus = ? where frecordid = ? and fdimhash = ? and fstatus = ?", (Object[])new Object[]{ForecastConstants.Status.DOING.getValue(), recordId, dimHashId, ForecastConstants.Status.INIT.getValue()});
            boolean bl = result > 0;
            return bl;
        }
        catch (Throwable e) {
            try {
                tx.markRollback();
                log.error(e.getMessage(), e);
                throw new KDBizException(e.getMessage());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public void cancel(long recordId, String reason) {
        DB.update((DBRoute)BgBaseConstant.epm, (String)"update t_eb_predict_result set fstatus = ?, freason = ? where frecordid = ?", (Object[])new Object[]{ForecastConstants.Status.FAIL.getValue(), reason, recordId});
    }

    /*
     * Loose catch block
     */
    public boolean updateStatus(long recordId, long dimHashId, String requestId, ForecastConstants.Status status, String reason) {
        try {
            Throwable throwable = null;
            try (TXHandle tx = TX.required();){
                reason = reason.length() > 100 ? reason.substring(0, 100) : reason;
                String statusString = Stream.of(ForecastConstants.Status.INIT.getValue(), ForecastConstants.Status.DOING.getValue(), ForecastConstants.Status.PREDICT.getValue()).collect(Collectors.joining("','", "('", "')"));
                StringBuilder sqlBuilder = new StringBuilder();
                sqlBuilder.append("update t_eb_predict_result set fstatus = ?, frequestid = ?, freason = ?  ").append("where frecordid = ? and fdimhash = ? and fstatus in ").append(statusString);
                int result = DB.update((DBRoute)BgBaseConstant.epm, (String)sqlBuilder.toString(), (Object[])new Object[]{status.getValue(), requestId, reason, recordId, dimHashId});
                boolean bl = result > 0;
                return bl;
            }
            catch (Throwable e) {
                try {
                    tx.markRollback();
                    log.error(e.getMessage(), e);
                    throw new KDBizException(e.getMessage());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            {
                catch (Throwable throwable3) {
                    throw throwable3;
                }
            }
        }
        finally {
            this.recordStatus(recordId);
        }
    }

    public void update(long recordId, long dimHashId, PredModel predModel, ForecastConstants.Status status, String reason) {
        QFilter qFilter = new QFilter("dimhash", "=", (Object)dimHashId).and("recordid", "=", (Object)recordId);
        DynamicObject dyObj = QueryServiceHelper.queryOne((String)ENTITY_NAME, (String)ALL_FIELD, (QFilter[])new QFilter[]{qFilter});
        if (dyObj == null) {
            return;
        }
        PredictResult resultModel = this.transToResultModel(dyObj);
        resultModel.setStatus(status.getValue());
        if (reason == null) {
            reason = "";
        }
        if (reason.length() > 100) {
            reason = reason.substring(0, 100);
        }
        resultModel.setReason(reason);
        if (status == ForecastConstants.Status.SUCCESS) {
            this.transToResultModel(predModel, resultModel);
        }
        try (TXHandle tx = TX.required();){
            try {
                DynamicObject resultObj = this.packageDynamicObject(resultModel, false);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{resultObj});
            }
            catch (Throwable e) {
                tx.markRollback();
                log.error(e.getMessage(), e);
                throw new KDBizException(e.getMessage());
            }
        }
        this.recordStatus(recordId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordStatus(long recordId) {
        DynamicObjectCollection resultObjects;
        DLock dLock = DLock.createReentrant((String)("bgm/predict/recordStatus/" + recordId));
        dLock.fastMode();
        QFilter recordFilter = new QFilter("recordid", "=", (Object)recordId);
        try {
            dLock.lock();
            resultObjects = QueryServiceHelper.query((String)ENTITY_NAME, (String)"status", (QFilter[])new QFilter[]{recordFilter});
        }
        finally {
            dLock.unlock();
        }
        boolean allFinish = resultObjects.stream().allMatch(r -> ForecastConstants.Status.SUCCESS.getValue().equals(r.getString("status")) || ForecastConstants.Status.FAIL.getValue().equals(r.getString("status")));
        if (allFinish) {
            ForecastConstants.Status recordStatus = ForecastConstants.Status.SUCCESS;
            if (resultObjects.stream().anyMatch(r -> ForecastConstants.Status.FAIL.getValue().equals(r.getString("status")))) {
                recordStatus = ForecastConstants.Status.FAIL;
            }
            PredictRecordService.getInstance().updateStatus(recordId, recordStatus);
        }
    }

    private void transToResultModel(PredModel predModel, PredictResult resultModel) {
        if (predModel == null) {
            return;
        }
        String metric = predModel.getMae() + "," + predModel.getMse() + "," + predModel.getRmse() + "," + predModel.getR2();
        String predIndex = predModel.getPredIndexList() == null ? "" : predModel.getPredIndexList().stream().map(String::valueOf).collect(Collectors.joining(","));
        String predData = predModel.getPredDataList() == null ? "" : predModel.getPredDataList().stream().map(String::valueOf).collect(Collectors.joining(","));
        String fitData = predModel.getFitDataList() == null ? "" : predModel.getFitDataList().stream().map(String::valueOf).collect(Collectors.joining(","));
        String sampleIndex = predModel.getSampleIndexList() == null ? "" : predModel.getSampleIndexList().stream().map(String::valueOf).collect(Collectors.joining(","));
        String sampleData = predModel.getSampleDataList() == null ? "" : predModel.getSampleDataList().stream().map(String::valueOf).collect(Collectors.joining(","));
        String confidenceMin = predModel.getConfidenceMinList() == null ? "" : predModel.getConfidenceMinList().stream().map(String::valueOf).collect(Collectors.joining(","));
        String confidenceMax = predModel.getConfidenceMaxList() == null ? "" : predModel.getConfidenceMaxList().stream().map(String::valueOf).collect(Collectors.joining(","));
        String corr = predModel.getCorrList() == null ? "" : JSON.toJSONString(predModel.getCorrList());
        resultModel.setMetric(metric);
        resultModel.setPredIndex(predIndex);
        resultModel.setPredData(predData);
        resultModel.setFitData(fitData);
        resultModel.setSampleIndex(sampleIndex);
        resultModel.setSampleData(sampleData);
        resultModel.setConfidenceMin(confidenceMin);
        resultModel.setConfidenceMax(confidenceMax);
        resultModel.setCorr(corr);
    }

    private PredModel transToPredModel(Long modelId, PredictResult resultModel) {
        if (resultModel == null) {
            return null;
        }
        PredModel model = new PredModel();
        model.setId(String.valueOf(resultModel.getId()));
        model.setDimHash(String.valueOf(resultModel.getDimHash()));
        model.setName(resultModel.getName());
        model.setDataUnit(resultModel.getDataUnit());
        model.setStatus(resultModel.getStatus());
        model.setReason(resultModel.getReason());
        if (ForecastConstants.Status.SUCCESS.getValue().equals(resultModel.getStatus())) {
            String[] metrics = resultModel.getMetric().split(",");
            int periodType = resultModel.getPeriodType().intValue();
            String mae = metrics[0];
            String mse = metrics[1];
            String rmse = metrics[2];
            String r2 = metrics[3];
            List<Double> confidenceMinList = Collections.emptyList();
            if (StringUtils.isNotBlank((CharSequence)resultModel.getConfidenceMin())) {
                confidenceMinList = Arrays.stream(resultModel.getConfidenceMin().split(",")).map(v -> {
                    if (StringUtils.isNotBlank((CharSequence)v) && !"null".equalsIgnoreCase((String)v)) {
                        return Double.parseDouble(v);
                    }
                    return null;
                }).collect(Collectors.toList());
            }
            List<Double> confidenceMaxList = Collections.emptyList();
            if (StringUtils.isNotBlank((CharSequence)resultModel.getConfidenceMax())) {
                confidenceMaxList = Arrays.stream(resultModel.getConfidenceMax().split(",")).map(v -> {
                    if (StringUtils.isNotBlank((CharSequence)v) && !"null".equalsIgnoreCase((String)v)) {
                        return Double.parseDouble(v);
                    }
                    return null;
                }).collect(Collectors.toList());
            }
            List<Double> predDataList = Collections.emptyList();
            if (StringUtils.isNotBlank((CharSequence)resultModel.getPredData())) {
                predDataList = Arrays.stream(resultModel.getPredData().split(",")).map(v -> {
                    if (StringUtils.isNotBlank((CharSequence)v) && !"null".equalsIgnoreCase((String)v)) {
                        return Double.parseDouble(v);
                    }
                    return null;
                }).collect(Collectors.toList());
            }
            List<Long> predIndexList = Collections.emptyList();
            if (StringUtils.isNotBlank((CharSequence)resultModel.getPredIndex())) {
                predIndexList = Arrays.stream(resultModel.getPredIndex().split(",")).map(v -> {
                    if (StringUtils.isNotBlank((CharSequence)v) && !"null".equalsIgnoreCase((String)v)) {
                        return Long.parseLong(v);
                    }
                    return null;
                }).collect(Collectors.toList());
            }
            List<Double> fitDataList = Collections.emptyList();
            if (StringUtils.isNotBlank((CharSequence)resultModel.getFitData())) {
                fitDataList = Arrays.stream(resultModel.getFitData().split(",")).map(v -> {
                    if (StringUtils.isNotBlank((CharSequence)v) && !"null".equalsIgnoreCase((String)v)) {
                        return Double.parseDouble(v);
                    }
                    return null;
                }).collect(Collectors.toList());
            }
            List<Double> sampleDataList = Collections.emptyList();
            if (StringUtils.isNotBlank((CharSequence)resultModel.getSampleData())) {
                sampleDataList = Arrays.stream(resultModel.getSampleData().split(",")).map(v -> {
                    if (StringUtils.isNotBlank((CharSequence)v) && !"null".equalsIgnoreCase((String)v)) {
                        return Double.parseDouble(v);
                    }
                    return null;
                }).collect(Collectors.toList());
            }
            List<Long> sampleIndexList = Collections.emptyList();
            if (StringUtils.isNotBlank((CharSequence)resultModel.getSampleIndex())) {
                sampleIndexList = Arrays.stream(resultModel.getSampleIndex().split(",")).map(v -> {
                    if (StringUtils.isNotBlank((CharSequence)v) && !"null".equalsIgnoreCase((String)v)) {
                        return Long.parseLong(v);
                    }
                    return null;
                }).collect(Collectors.toList());
            }
            List<String> members = Collections.emptyList();
            if (StringUtils.isNotBlank((CharSequence)resultModel.getMembers())) {
                members = Arrays.stream(resultModel.getMembers().split(",")).collect(Collectors.toList());
            }
            List corrList = Collections.emptyList();
            if (StringUtils.isNotBlank((CharSequence)resultModel.getCorr())) {
                corrList = JSON.parseArray((String)resultModel.getCorr(), JSONObject.class);
            }
            HashMap<String, Long> dimViewMap = new HashMap(16);
            if (StringUtils.isNotBlank((CharSequence)resultModel.getDimView())) {
                JSONObject jsonObject = JSON.parseObject((String)resultModel.getDimView());
                dimViewMap = jsonObject.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> IDUtils.toLong(e.getValue())));
            }
            model.setPeriodType(periodType);
            model.setMae(mae);
            model.setMse(mse);
            model.setRmse(rmse);
            model.setR2(r2);
            model.setConfidenceMinList(confidenceMinList);
            model.setConfidenceMaxList(confidenceMaxList);
            model.setPredDataList(predDataList);
            model.setPredIndexList(predIndexList);
            model.setPredIndexNumberList(PredictHelper.transTime2PeriodNumber(predIndexList, periodType));
            model.setFitDataList(fitDataList);
            model.setSampleDataList(sampleDataList);
            model.setSampleIndexList(sampleIndexList);
            model.setMembers(members);
            model.setDimViewMap(dimViewMap);
            model.setCorrList(corrList);
            if (modelId != null) {
                model.setPredIndexNameList(this.transPeriodName(modelId, model.getPredIndexNumberList()));
            }
        }
        return model;
    }

    private List<String> transPeriodName(long modelId, List<String> numberList) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        return numberList.stream().map(v -> {
            Member member = modelCache.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), null, v);
            return member == null ? "" : member.getName();
        }).collect(Collectors.toList());
    }

    private PredictResult transToResultModel(DynamicObject dynamicObject) {
        PredictResult model = new PredictResult();
        model.setId(dynamicObject.getLong("id"));
        model.setDimHash(dynamicObject.getLong("dimhash"));
        model.setRecordId(dynamicObject.getLong("recordid"));
        model.setName(dynamicObject.getString("name"));
        model.setEntity(dynamicObject.getString("entity"));
        model.setAccount(dynamicObject.getString("account"));
        model.setMembers(dynamicObject.getString("members"));
        model.setDimView(dynamicObject.getString("dimview"));
        model.setDataUnit(dynamicObject.getString("dataunit"));
        model.setPeriodType(dynamicObject.getLong("periodtype"));
        model.setMetric(dynamicObject.getString("metric"));
        model.setPredIndex(dynamicObject.getString("predindex"));
        model.setPredData(dynamicObject.getString("preddata"));
        model.setFitData(dynamicObject.getString("fitdata"));
        model.setSampleIndex(dynamicObject.getString("sampleindex"));
        model.setSampleData(dynamicObject.getString("sampledata"));
        model.setConfidenceMin(dynamicObject.getString("confidencemin"));
        model.setConfidenceMax(dynamicObject.getString("confidencemax"));
        model.setCorr(dynamicObject.getString("corr"));
        model.setStatus(dynamicObject.getString("status"));
        model.setReason(dynamicObject.getString("reason"));
        model.setRequestId(dynamicObject.getString("requestid"));
        model.setAutoWrite(dynamicObject.getString("autowrite"));
        model.setFactorName(dynamicObject.getString("factorname"));
        model.setModifierId(dynamicObject.getLong("modifierid"));
        model.setModifyDate(dynamicObject.getDate("modifydate"));
        return model;
    }

    private DynamicObject packageDynamicObject(PredictResult model, boolean isNew) {
        String status;
        DynamicObject dynamicObject;
        Long id = model.getId();
        if (isNew) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_NAME);
            status = ForecastConstants.Status.INIT.getValue();
        } else {
            dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)ENTITY_NAME);
            status = model.getStatus();
        }
        dynamicObject.set("id", (Object)id);
        dynamicObject.set("dimhash", (Object)model.getDimHash());
        dynamicObject.set("recordid", (Object)model.getRecordId());
        dynamicObject.set("name", (Object)model.getName());
        dynamicObject.set("entity", (Object)model.getEntity());
        dynamicObject.set("account", (Object)model.getAccount());
        dynamicObject.set("members", (Object)model.getMembers());
        dynamicObject.set("dimview", (Object)model.getDimView());
        dynamicObject.set("dataunit", (Object)model.getDataUnit());
        dynamicObject.set("periodtype", (Object)model.getPeriodType());
        dynamicObject.set("metric", (Object)model.getMetric());
        dynamicObject.set("predindex", (Object)model.getPredIndex());
        dynamicObject.set("preddata", (Object)model.getPredData());
        dynamicObject.set("fitdata", (Object)model.getFitData());
        dynamicObject.set("sampleindex", (Object)model.getSampleIndex());
        dynamicObject.set("sampledata", (Object)model.getSampleData());
        dynamicObject.set("confidencemin", (Object)model.getConfidenceMin());
        dynamicObject.set("confidencemax", (Object)model.getConfidenceMax());
        dynamicObject.set("corr", (Object)model.getCorr());
        dynamicObject.set("status", (Object)status);
        dynamicObject.set("reason", (Object)model.getReason());
        dynamicObject.set("autowrite", (Object)model.getAutoWrite());
        dynamicObject.set("factorname", (Object)model.getFactorName());
        dynamicObject.set("modifierid", (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set("modifydate", (Object)TimeServiceHelper.now());
        return dynamicObject;
    }

    private static class InnerClass {
        private static final PredictResultService instance = new PredictResultService();

        private InnerClass() {
        }
    }
}

