/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.forecast;

import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.epm.eb.business.forecast.PredictRecordService;
import kd.epm.eb.business.forecast.PredictResultService;
import kd.epm.eb.common.utils.IDUtils;

public class PredictTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(PredictTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        HashMap<String, String> returnData = new HashMap<String, String>(16);
        this.feedbackProgress(0, ResManager.loadKDString((String)"\u5df2\u7ecf\u8fdb\u5165\u4efb\u52a1\u6267\u884c\u73af\u8282\uff0c\u5f00\u59cb\u6267\u884c\u4efb\u52a1", (String)"PredictTask_0", (String)"epm-eb-business", (Object[])new Object[0]), null);
        long recordId = IDUtils.toLong((Object)map.get("recordId"));
        try {
            int count = PredictResultService.getInstance().queryAllCount(recordId);
            while (true) {
                int completeCount = PredictResultService.getInstance().queryCompleteCount(recordId);
                String desc = ResManager.loadResFormat((String)"\u5f00\u59cb\u8fdb\u884c\u7b2c%1/%2\u6b21\u9884\u6d4b", (String)"PredictTask_1", (String)"epm-eb-business", (Object[])new Object[]{completeCount, count});
                int progress = 100 * completeCount / count;
                this.feedbackProgress(progress, desc, null);
                if (PredictRecordService.getInstance().isComplete(recordId)) break;
                Thread.sleep(2000L);
            }
            returnData.put("status", "success");
        }
        catch (InterruptedException e) {
            log.error(e.getMessage(), (Throwable)e);
            returnData.put("status", "error");
        }
        this.feedbackCustomdata(returnData);
    }
}

