/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.forecast;

import com.google.common.base.Stopwatch;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasBoxService;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasBox;
import kd.epm.eb.business.analysiscanvas.query.dto.QueryDto;
import kd.epm.eb.business.analysiscanvas.query.dto.QueryDtoHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.utils.IDUtils;

public class QueryService {
    private static final Log log = LogFactory.getLog(QueryService.class);
    private static final String LOG_PREFIX = "EB-FORECAST-QUERY";

    public static QueryService getInstance() {
        return InnerClass.instance;
    }

    private QueryService() {
    }

    public Object getCellValue(IModelCacheHelper modelCache, Map<String, String> queryCellMap, List<String> sortedDimList, Map<MembersKey, BGCell> bgCellMap, BigDecimal dataUnit) {
        Object[] keys = new String[sortedDimList.size() + 1];
        for (int i = 0; i < sortedDimList.size(); ++i) {
            String dimNumber = sortedDimList.get(i);
            if (queryCellMap.containsKey(dimNumber)) {
                keys[i + 1] = queryCellMap.get(dimNumber);
                continue;
            }
            Dimension dimension = modelCache.getDimension(dimNumber);
            keys[i + 1] = dimension.getNoneNumber();
        }
        MembersKey membersKey = new MembersKey(keys);
        BGCell bgCell = bgCellMap.get(membersKey);
        Object value = null;
        if (bgCell != null) {
            value = this.getValueWithDataUnit(dataUnit, bgCell.getValue());
        }
        return value;
    }

    private Object getValueWithDataUnit(BigDecimal unit, Object value) {
        if (value != null && unit != null) {
            value = value instanceof Long ? BigDecimal.valueOf((Long)value).divide(unit, 4, RoundingMode.HALF_UP) : ((BigDecimal)value).divide(unit, 4, RoundingMode.HALF_UP);
        }
        return value;
    }

    public Map<MembersKey, BGCell> queryCurrData(long modelId, long datasetId, Long sandboxId, Map<String, Set<String>> queryDim, Map<String, Long> viewMap) {
        Stopwatch totalStopwatch = Stopwatch.createStarted();
        kd.epm.eb.business.analysiscanvas.query.QueryService queryService = kd.epm.eb.business.analysiscanvas.query.QueryService.getInstance();
        ArrayList<QueryDto> queryList = new ArrayList<QueryDto>(1);
        QueryDto queryDto = QueryDtoHelper.getQueryDto(modelId, datasetId, viewMap, queryList);
        QueryDtoHelper.mergeQueryDim(queryDto, queryDim);
        if (IDUtils.isNotEmptyLong((Long)sandboxId).booleanValue()) {
            AnalysisCanvasBox canvasBox = AnalysisCanvasBoxService.getInstance().load(sandboxId);
            queryService.querySandboxData(canvasBox, queryList, null);
        } else {
            queryService.queryBaseData(queryList, null);
        }
        Map<MembersKey, BGCell> result = ((QueryDto)queryList.get(0)).getQueryResult();
        log.info("{} querySampleData modelId:{} datasetId:{} dataSize:{} cost:{}ms", new Object[]{LOG_PREFIX, modelId, datasetId, result.size(), totalStopwatch.elapsed(TimeUnit.MILLISECONDS)});
        return result;
    }

    private static class InnerClass {
        private static final QueryService instance = new QueryService();

        private InnerClass() {
        }
    }
}

