/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.forecast;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Maps;
import com.google.common.hash.Hashing;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasBoxDataService;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasBoxService;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasUtils;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasBox;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasBoxData;
import kd.epm.eb.business.analysiscanvas.item.PredictItemService;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.business.analysiscanvas.model.ModelHelper;
import kd.epm.eb.business.analysiscanvas.model.PredictModel;
import kd.epm.eb.business.analysiscanvas.query.PredictDataService;
import kd.epm.eb.business.bizrule.RuleExecutionService;
import kd.epm.eb.business.forecast.model.PredModel;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.elasticsearch.OlapDataAuditEventEnum;
import kd.epm.eb.common.elasticsearch.OlapDataAuditService;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.olapdao.OlapContext;
import kd.epm.eb.common.olapdao.SaveDataContext;
import kd.epm.eb.common.rule.execute.RuleExecuteTypeEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.olap.impl.bizrule.entity.RuleDto;
import kd.epm.eb.olap.service.biztemplate.SaveBizTemplate;
import kd.epm.eb.olap.service.request.SaveRequest;
import kd.epm.epbs.business.log.trace.OlapTraceServiceHelper;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.tuple.Pair;

public class WriteService {
    private static final Log log = LogFactory.getLog(WriteService.class);
    private static final String LOG_PREFIX = "EB-FORECAST-WRITE";

    public static WriteService getInstance() {
        return InnerClass.instance;
    }

    private WriteService() {
    }

    public void write(long modelId, long datasetId, Long canvasId, Long sandboxId, List<PredModel> predModels) {
        if (IDUtils.isEmptyLong((Long)canvasId).booleanValue()) {
            this.writeToBase(modelId, datasetId, predModels);
        } else {
            this.writeToSandboxData(modelId, datasetId, canvasId, sandboxId, predModels);
        }
    }

    public void writeToBase(long modelId, long datasetId, List<PredModel> predModels) {
        Stopwatch totalStopwatch = Stopwatch.createStarted();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        List allDims = modelCache.getDimensionList(Long.valueOf(datasetId));
        List<String> sortedDimList = allDims.stream().map(BaseCache::getNumber).collect(Collectors.toList());
        HashMap bgCellListMap = Maps.newHashMapWithExpectedSize((int)predModels.size());
        block0: for (PredModel predModel : predModels) {
            Map<String, Long> viewMap = predModel.getDimViewMap();
            Long hashId2 = this.calcHashIdByView(sortedDimList, viewMap);
            List<String> predIndexNumberList = predModel.getPredIndexNumberList();
            List<Double> predDataList = predModel.getPredDataList();
            List<String> members = predModel.getMembers();
            for (int i = 0; i < predIndexNumberList.size(); ++i) {
                Double predValue = predDataList.get(i);
                if (predValue == null) continue;
                String periodNumber = predIndexNumberList.get(i);
                LinkedHashMap<String, String> memberMap = new LinkedHashMap<String, String>(sortedDimList.size());
                AtomicInteger index = new AtomicInteger(0);
                sortedDimList.forEach(dim -> {
                    if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dim)) {
                        memberMap.put(SysDimensionEnum.BudgetPeriod.getNumber(), periodNumber);
                    } else {
                        int j = index.getAndIncrement();
                        if (j >= members.size()) {
                            Dimension dimension = modelCache.getDimension(dim);
                            memberMap.put((String)dim, dimension.getNoneNumber());
                        } else {
                            memberMap.put((String)dim, (String)members.get(j));
                        }
                    }
                });
                RuleDto ruleDto = AnalysisCanvasUtils.getCellRule(modelId, datasetId, viewMap, memberMap);
                if (ruleDto != null) continue;
                String metricType = ModelHelper.getMetricType(memberMap, modelCache);
                if (!MetricDataTypeEnum.isNumber((String)metricType)) continue block0;
                boolean notLeaf = false;
                for (Map.Entry entry : memberMap.entrySet()) {
                    String dimNumber = (String)entry.getKey();
                    String memNumber = (String)entry.getValue();
                    Long viewId = viewMap.get(dimNumber);
                    Member realMember = modelCache.getMember(dimNumber, viewId, memNumber);
                    if (realMember != null && realMember.isLeaf()) continue;
                    notLeaf = true;
                    break;
                }
                if (notLeaf) continue block0;
                BigDecimal dataUnitNum = new BigDecimal(predModel.getDataUnit());
                BigDecimal newData = this.getValueWithDataUnit(dataUnitNum, predValue);
                Pair listMapPair = bgCellListMap.computeIfAbsent(hashId2, key -> Pair.of(new ArrayList(), (Object)viewMap));
                ((List)listMapPair.getLeft()).add(new BGCell(memberMap, (Object)newData));
            }
        }
        log.info("{} doWrite datas:{}", (Object)LOG_PREFIX, (Object)bgCellListMap);
        if (MapUtils.isEmpty((Map)bgCellListMap)) {
            return;
        }
        bgCellListMap.forEach((hashId, pair) -> {
            OlapTraceServiceHelper.setTraceOpInfo((String)String.valueOf(hashId));
            OlapDataAuditService.getInstance().setOperationContextDefaultFormId(OlapDataAuditEventEnum.PredictWrite.getDesc());
            OlapContext.setSaveDataContext((SaveDataContext)new SaveDataContext(OlapDataAuditEventEnum.PredictWrite));
            SaveRequest request = new SaveRequest(Long.valueOf(modelId), Long.valueOf(datasetId), (List)pair.getLeft(), (Map)pair.getRight());
            SaveBizTemplate saveBizTemplate = SaveBizTemplate.newInstance();
            List changedCells = saveBizTemplate.doService(request);
            log.info("{} doWrite Save modelId:{} datasetId:{} dataSize:{} cost:{}ms", new Object[]{LOG_PREFIX, modelId, datasetId, ((List)pair.getLeft()).size(), totalStopwatch.elapsed(TimeUnit.MILLISECONDS)});
            totalStopwatch.reset().start();
            RuleExecutionService.getInstance().executeRuleChain(null, datasetId, modelId, changedCells, RuleExecuteTypeEnum.FORECAST.getType());
            log.info("{} executeRuleChain modelId:{} datasetId:{} cost:{}ms", new Object[]{LOG_PREFIX, modelId, datasetId, totalStopwatch.elapsed(TimeUnit.MILLISECONDS)});
        });
    }

    public void writeToSandboxData(long modelId, long datasetId, long canvasId, long sandboxId, List<PredModel> predModels) {
        AnalysisCanvasBox canvasBox = AnalysisCanvasBoxService.getInstance().load(sandboxId);
        PredictDataService predictDataService = new PredictDataService(canvasBox, null);
        List<Map<String, Object>> changeMembers = predictDataService.buildChangeMember(modelId, datasetId, predModels);
        log.info("{} modelId:{} datasetId:{} canvasId:{} boxId:{} saveChangeMember datas:{}", new Object[]{LOG_PREFIX, modelId, datasetId, canvasId, sandboxId, changeMembers});
        PredictModel predictModel = new PredictModel();
        predictModel.setModel(String.valueOf(modelId));
        predictModel.setDataset(String.valueOf(datasetId));
        predictModel.setChangeMembers(changeMembers);
        CustomItem customItem = new CustomItem();
        customItem.setId(String.valueOf(10000L));
        customItem.setC(new JSONObject().fluentPut("predictModel", (Object)predictModel));
        PredictItemService predictItemService = new PredictItemService();
        predictItemService.saveDataIntoBox(canvasBox, Collections.singletonList(customItem), null);
    }

    public void clearSandboxPredData(long canvasId, long sandboxId) {
        String itemId = String.valueOf(10000L);
        Map<String, AnalysisCanvasBoxData> boxDataMap = AnalysisCanvasBoxDataService.getInstance().querySandboxData(sandboxId, Collections.singletonList(itemId));
        AnalysisCanvasBoxData boxData = boxDataMap.get(itemId);
        if (boxData != null) {
            boxData.setData(new JSONObject().toJSONString());
            AnalysisCanvasBoxDataService.getInstance().save(Collections.singletonList(boxData));
        }
    }

    private BigDecimal getValueWithDataUnit(BigDecimal unit, Double value) {
        if (value != null && unit != null) {
            return BigDecimal.valueOf(value).multiply(unit);
        }
        return null;
    }

    private Long calcHashIdByView(List<String> sortedDimList, Map<String, Long> viewMap) {
        String key = sortedDimList.stream().filter(dim -> !View.NoViewDimNums.contains(dim)).map(viewMap::get).filter(IDUtils::isNotEmptyLong).map(Object::toString).collect(Collectors.joining("!"));
        return Hashing.sha256().hashString((CharSequence)key, StandardCharsets.UTF_8).padToLong();
    }

    private static class InnerClass {
        private static final WriteService instance = new WriteService();

        private InnerClass() {
        }
    }
}

