/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.forecast.gpt;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Year;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.epm.eb.business.forecast.PredictRecordService;
import kd.epm.eb.business.forecast.PredictResultService;
import kd.epm.eb.business.forecast.QueryService;
import kd.epm.eb.business.forecast.gpt.GptForecastService;
import kd.epm.eb.business.forecast.helper.ForecastChartHelper;
import kd.epm.eb.business.forecast.helper.PredictHelper;
import kd.epm.eb.business.forecast.model.MemberDto;
import kd.epm.eb.business.forecast.model.PredFactor;
import kd.epm.eb.business.forecast.model.PredModel;
import kd.epm.eb.business.forecast.model.PredParam;
import kd.epm.eb.business.forecast.model.PredTarget;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.thread.EpmThreadPools;
import kd.epm.eb.common.utils.IDUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class GptForecast {
    private static final Log log = LogFactory.getLog(GptForecast.class);
    private long modelId;
    private long datasetId;
    private Long canvasId;
    private Long sandboxId;
    private IModelCacheHelper modelCache;
    private List<Dimension> dimensionList;
    private JSONObject paramObj;
    private Map<String, String> writeDimMap;
    private Map<String, String> defaultDimMap;
    private Map<String, Long> dimViewMap;
    private List<Long> predDimHashList;
    private List<JSONObject> targetMemList;
    private String targetDimNum;
    private boolean seasonal;
    private boolean holiday;
    private String unusualFill;
    private String useModel;
    private boolean autoWrite;
    private int sampleLen;
    private String predStartNumber;
    private String predEndNumber;
    private PredParam predParam;
    private Map<String, String> dataUnitMap;
    private List<Map<String, String>> regList;
    private List<Map<String, String>> addRegList;
    private final boolean isPredictAction;

    public GptForecast(String param, boolean isPredictAction) {
        this.isPredictAction = isPredictAction;
        this.parseParam(param);
    }

    private void parseParam(String param) {
        this.predParam = new PredParam();
        this.setParamDefault();
        this.paramObj = JSON.parseObject((String)param);
        String modelNumber = this.paramObj.getString("model");
        String datasetNum = this.paramObj.getString("dataset");
        this.modelId = GptForecastService.getInstance().queryModelId(modelNumber);
        this.datasetId = GptForecastService.getInstance().queryDatasetId(this.modelId, datasetNum);
        this.modelCache = ModelCacheContext.getOrCreate((Long)this.modelId);
        this.dimensionList = this.modelCache.getDimensionList(Long.valueOf(this.datasetId));
        this.targetDimNum = this.paramObj.getString("predDim");
        this.initDataUnitMap();
        this.initDefaultDimMap();
        this.initWriteDimMap();
        this.initPredParam();
        this.initPredTimeRange();
        this.initPredDimMem();
        this.initPredRegressor();
        this.clearPredData();
        this.initCanvasAndSandbox();
    }

    private void setParamDefault() {
        this.seasonal = true;
        this.holiday = true;
        this.unusualFill = "linear";
        this.useModel = "prophet";
        this.autoWrite = true;
        this.predParam.setSeasonal(this.seasonal);
        this.predParam.setHoliday(this.holiday);
        this.predParam.setUnFill(this.unusualFill);
        this.predParam.setUseModel(this.useModel);
        this.predParam.setAutoWrite(this.autoWrite);
    }

    private void initDefaultDimMap() {
        String dimMemStr = this.paramObj.getString("dims");
        JSONObject dataUnitObj = JSON.parseObject((String)dimMemStr);
        this.defaultDimMap = dataUnitObj.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> v.getValue().toString(), (o1, o2) -> o2));
    }

    private void initWriteDimMap() {
        String dimMemStr = this.paramObj.getString("writeDim");
        JSONObject dataUnitObj = JSON.parseObject((String)dimMemStr);
        this.writeDimMap = dataUnitObj.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> v.getValue().toString(), (o1, o2) -> o2));
    }

    private void initPredParam() {
        if (Objects.nonNull(this.paramObj.get((Object)"sample"))) {
            this.sampleLen = this.paramObj.getInteger("sample");
        }
        this.predParam.setBpNum(this.sampleLen);
    }

    private void initPredTimeRange() {
        MemberDto memberDto;
        if (StringUtils.isNotEmpty((CharSequence)this.paramObj.getString("start"))) {
            this.predStartNumber = this.paramObj.getString("start");
            memberDto = new MemberDto();
            memberDto.setNumber(this.predStartNumber);
            this.predParam.setBpStart(memberDto);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.paramObj.getString("end"))) {
            this.predEndNumber = this.paramObj.getString("end");
            memberDto = new MemberDto();
            memberDto.setNumber(this.predEndNumber);
            this.predParam.setBpEnd(memberDto);
        }
    }

    private void initPredDimMem() {
        this.dimViewMap = new HashMap<String, Long>(this.dimensionList.size());
        HashMap defaultDim = new HashMap();
        this.dimensionList.forEach(dimension -> {
            Long dimDefaultViewId;
            String dimNumber = dimension.getNumber();
            if (!View.NoViewDimNums.contains(dimNumber) && IDUtils.isNotEmptyLong((Long)(dimDefaultViewId = this.getDimDefaultView(this.modelCache, this.datasetId, dimNumber))).booleanValue()) {
                this.dimViewMap.put(dimNumber, dimDefaultViewId);
            }
            if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber)) {
                return;
            }
            String memNumber = this.defaultDimMap.get(dimNumber);
            if (StringUtils.isNotBlank((CharSequence)memNumber)) {
                defaultDim.put(dimNumber, memNumber);
            } else {
                defaultDim.put(dimNumber, dimension.getNoneNumber());
            }
        });
        ArrayList predDimNumList = new ArrayList(20);
        predDimNumList.add(defaultDim);
        this.predDimHashList = new ArrayList<Long>(predDimNumList.size());
        this.targetMemList = new ArrayList<JSONObject>(predDimNumList.size());
        String dimView = JSONObject.toJSONString(this.dimViewMap);
        ArrayList<PredTarget> targets = new ArrayList<PredTarget>(predDimNumList.size());
        predDimNumList.forEach(allDimNum -> {
            HashMap sampleDimNumMap = new HashMap(allDimNum);
            Member targetMem = this.modelCache.getMember(this.targetDimNum, this.dimViewMap.get(this.targetDimNum), (String)allDimNum.get(this.targetDimNum));
            HashMap<String, String> predDimNumMap = new HashMap<String, String>((Map<String, String>)allDimNum);
            if (MapUtils.isNotEmpty(this.writeDimMap)) {
                predDimNumMap.putAll(this.writeDimMap);
            }
            long dimHashId = PredictHelper.calcDimHashId(this.dimensionList, predDimNumMap);
            this.predDimHashList.add(dimHashId);
            this.targetMemList.add(new JSONObject().fluentPut("hashId", (Object)String.valueOf(dimHashId)).fluentPut("num", (Object)targetMem.getNumber()).fluentPut("name", (Object)targetMem.getName()));
            PredTarget target = new PredTarget();
            target.setName(targetMem.getName());
            target.setHashId(String.valueOf(dimHashId));
            target.setNumber(JSON.toJSONString(predDimNumMap));
            target.setSampleNumber(JSON.toJSONString(sampleDimNumMap));
            target.setDataUnit(PredictHelper.getMetricUnit((String)predDimNumMap.get(SysDimensionEnum.Account.getNumber()), this.dataUnitMap));
            target.setDimView(dimView);
            targets.add(target);
        });
        this.predParam.setTargets(targets);
    }

    private void initPredRegressor() {
        Object addRegressor;
        this.regList = new ArrayList<Map<String, String>>(10);
        this.addRegList = new ArrayList<Map<String, String>>(10);
        Object regressor = this.paramObj.get((Object)"reg");
        if (Objects.nonNull(regressor)) {
            List objList = JSON.parseArray((String)regressor.toString(), JSONObject.class);
            this.regList = objList.stream().map(obj -> obj.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> v.getValue().toString(), (o1, o2) -> o2))).collect(Collectors.toList());
        }
        if (Objects.nonNull(addRegressor = this.paramObj.get((Object)"addReg"))) {
            List objList = JSON.parseArray((String)addRegressor.toString(), JSONObject.class);
            this.addRegList = objList.stream().map(obj -> obj.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> v.getValue().toString(), (o1, o2) -> o2))).collect(Collectors.toList());
            this.regList.addAll(this.addRegList);
        }
        ArrayList<PredFactor> factors = new ArrayList<PredFactor>(this.regList.size());
        this.regList.forEach(reg -> {
            HashMap members = new HashMap(16);
            this.dimensionList.forEach(dimension -> {
                String dimNumber = dimension.getNumber();
                if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber)) {
                    return;
                }
                String memNumber = (String)reg.get(dimNumber);
                if (StringUtils.isBlank((CharSequence)memNumber) && StringUtils.isBlank((CharSequence)(memNumber = this.defaultDimMap.get(dimNumber)))) {
                    memNumber = dimension.getNoneNumber();
                }
                Member member = this.modelCache.getMember(dimNumber, this.dimViewMap.get(dimNumber), memNumber);
                MemberDto memberDto = new MemberDto();
                memberDto.setId(String.valueOf(member.getId()));
                memberDto.setNumber(memNumber);
                memberDto.setName(member.getName());
                memberDto.setScope(String.valueOf(RangeEnum.ONLY.getIndex()));
                members.put(dimNumber, JSON.toJSONString(Collections.singletonList(memberDto)));
            });
            MemberDto accountMember = (MemberDto)JSON.parseArray((String)((String)members.get(SysDimensionEnum.Account.getNumber())), MemberDto.class).get(0);
            String factorName = accountMember.getName();
            Map<String, String> cellDimMap = members.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> ((MemberDto)JSON.parseArray((String)((String)v.getValue()), MemberDto.class).get(0)).getNumber()));
            long dimHashId = PredictHelper.calcDimHashId(this.dimensionList, cellDimMap);
            PredFactor predFactor = new PredFactor();
            predFactor.setName(factorName);
            predFactor.setHashId(String.valueOf(dimHashId));
            predFactor.setModel(String.valueOf(this.modelId));
            predFactor.setDataset(String.valueOf(this.datasetId));
            predFactor.setDimView(JSONObject.toJSONString(this.dimViewMap));
            predFactor.setDimConf(JSON.toJSONString(members));
            predFactor.setDataUnit(PredictHelper.getMetricUnit(accountMember.getNumber(), this.dataUnitMap));
            factors.add(predFactor);
        });
        this.predParam.setFactors(factors);
        this.initRegFactorMap();
    }

    private void clearPredData() {
        Object clearBoxFlag = this.paramObj.get((Object)"clearPred");
        if (Objects.nonNull(clearBoxFlag) && Boolean.parseBoolean(clearBoxFlag.toString())) {
            GptForecastService.getInstance().deleteCanvasSandbox();
        }
    }

    private void initCanvasAndSandbox() {
        GptForecastService.getInstance().initCanvasSandbox();
        Object newBoxFlag = this.paramObj.get((Object)"newBox");
        if (this.isPredictAction && Objects.nonNull(newBoxFlag) && Boolean.parseBoolean(newBoxFlag.toString())) {
            GptForecastService.getInstance().createNewBox();
        }
        Pair<Long, Long> canvasAndBoxId = GptForecastService.getInstance().getCanvasAndBoxId();
        this.canvasId = (Long)canvasAndBoxId.getLeft();
        this.sandboxId = (Long)canvasAndBoxId.getValue();
    }

    private Long getDimDefaultView(IModelCacheHelper modelCache, long datasetId, String dimNumber) {
        return IDUtils.toLong((Object)modelCache.getViewByDataSetAndDimNumber(Long.valueOf(datasetId), dimNumber));
    }

    private void initDataUnitMap() {
        String dataUnitStr = this.paramObj.getString("dataUnit");
        JSONObject dataUnitObj = JSON.parseObject((String)dataUnitStr);
        this.dataUnitMap = dataUnitObj.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> v.getValue().toString(), (o1, o2) -> o2));
    }

    private void initRegFactorMap() {
    }

    public List<Long> doPredict() {
        List predModelList;
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            long recordId = (Long)DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"PredictService", (String)"predict", (Object[])new Object[]{JSON.toJSONString((Object)this.predParam), this.modelId, this.datasetId, 0L, 0L, this.canvasId, this.sandboxId});
            Future future = EpmThreadPools.CommPools.submit(() -> {
                List<Object> predModelResult;
                block2: {
                    boolean complete;
                    predModelResult = new ArrayList(16);
                    int waitCount = 0;
                    while (!(complete = PredictRecordService.getInstance().isComplete(IDUtils.toLong((Object)recordId)))) {
                        if (waitCount < 90) {
                            TimeUnit.SECONDS.sleep(2L);
                            ++waitCount;
                            continue;
                        }
                        break block2;
                    }
                    TimeUnit.SECONDS.sleep(3L);
                    predModelResult = PredictResultService.getInstance().queryRecordResult(this.modelId, IDUtils.toLong((Object)recordId), 1);
                }
                return predModelResult;
            }, RequestContext.get());
            try {
                predModelList = (List)future.get(5L, TimeUnit.MINUTES);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new KDBizException(e.getMessage());
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
        log.info("EB-FORECAST predict predModelSize:{} cost:{}ms", (Object)predModelList.size(), (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        if (CollectionUtils.isEmpty((Collection)predModelList)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u8db3\u591f\u7684\u6837\u672c\u6570\u636e\u8fdb\u884c\u8bad\u7ec3\uff0c\u8bf7\u68c0\u67e5\u9884\u6d4b\u53c2\u6570\u548c\u7528\u6237\u6570\u636e\u6743\u9650\u3002", (String)"ForecastService_14", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        log.info("EB-FORECAST predict and write totalCost:{}ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        return this.predDimHashList;
    }

    public JSONObject getPredData(Long dimHashId) {
        List<PredModel> predModels;
        if (dimHashId == null) {
            dimHashId = this.predDimHashList.get(0);
        }
        if (CollectionUtils.isEmpty(predModels = PredictRecordService.getInstance().queryDataByDimHash(this.modelId, dimHashId, 0L, 0L, this.canvasId, 2))) {
            return new JSONObject();
        }
        PredModel predModel = predModels.get(0);
        PredModel lastPredModel = predModels.size() < 2 ? null : predModels.get(1);
        String dataUnit = predModel.getDataUnit();
        String dataUnitStr = PredictHelper.getDataUnitStr(dataUnit);
        JSONObject dataObj = new JSONObject();
        dataObj.put("predModel", (Object)predModel);
        dataObj.put("lastPredModel", (Object)lastPredModel);
        dataObj.put("targets", this.targetMemList);
        dataObj.put("totalAmount", (Object)Float.valueOf(this.queryAmount(predModel, "FY2023")));
        dataObj.put("totalRate", (Object)Float.valueOf(this.getTotalRate(predModel)));
        dataObj.put("yearTotal", this.buildTotalAmount(predModel, dataUnitStr));
        dataObj.put("dataUnitStr", (Object)dataUnitStr);
        List<String> timeRangeList = ForecastChartHelper.formatTime(predModel.getSampleIndexList(), predModel.getPeriodType());
        timeRangeList.addAll(ForecastChartHelper.formatTime(predModel.getPredIndexList(), predModel.getPeriodType()));
        dataObj.put("xAxis", timeRangeList);
        if (CollectionUtils.isNotEmpty(predModel.getCorrList())) {
            predModel.getCorrList().forEach(obj -> {
                Optional<Map> optional;
                String memNum = obj.getString("num");
                if ("holiday".equals(memNum) || "seasonal".equals(memNum)) {
                    return;
                }
                Member member = this.modelCache.getMember("Account", null, memNum);
                if (member != null) {
                    obj.put("name", (Object)member.getName());
                }
                if ((optional = this.addRegList.stream().filter(addRegMap -> ((String)addRegMap.get("Account")).equals(memNum)).findFirst()).isPresent()) {
                    obj.put("new", (Object)true);
                }
            });
        }
        return dataObj;
    }

    private List<JSONObject> buildTotalAmount(PredModel predModel, String dataUnitStr) {
        List<Year> yearList = PredictHelper.getYearList(this.predStartNumber, this.predEndNumber);
        return yearList.stream().map(year -> {
            JSONObject dataObj = new JSONObject();
            float amount = this.queryAmount(predModel, "FY" + year);
            String name = String.format(ResManager.loadKDString((String)"%s\u5e74\u5408\u8ba1", (String)"ForecastPlugin_47", (String)"epm-eb-formplugin", (Object[])new Object[0]), year);
            return dataObj.fluentPut("name", (Object)name).fluentPut("val", (Object)Float.valueOf(amount)).fluentPut("unit", (Object)dataUnitStr);
        }).collect(Collectors.toList());
    }

    private float queryAmount(PredModel predModel, String bpNum) {
        HashMap<String, String> dimMemMap = new HashMap<String, String>(this.defaultDimMap);
        dimMemMap.put(SysDimensionEnum.BudgetPeriod.getNumber(), bpNum);
        Map<String, Set<String>> queryDim = this.getTotalQueryDim(this.datasetId, this.modelCache, predModel, dimMemMap);
        Map<MembersKey, BGCell> bgCellMap = QueryService.getInstance().queryCurrData(this.modelId, this.datasetId, this.sandboxId, queryDim, this.dimViewMap);
        log.info("queryTotalAmount sandboxId:{} queryDim:{} result:{}", new Object[]{this.sandboxId, queryDim, bgCellMap});
        float result = 0.0f;
        if (MapUtils.isNotEmpty(bgCellMap)) {
            Map<String, String> queryCellMap = queryDim.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> (String)((Set)v.getValue()).iterator().next()));
            List allDims = this.modelCache.getDimensionList(Long.valueOf(this.datasetId));
            List<String> sortedDimList = allDims.stream().map(BaseCache::getNumber).collect(Collectors.toList());
            String unitStr = this.dataUnitMap.get(queryCellMap.get(SysDimensionEnum.Account.getNumber()));
            BigDecimal dataUnit = PredictHelper.getDataUnit(unitStr);
            Object cellValue = QueryService.getInstance().getCellValue(this.modelCache, queryCellMap, sortedDimList, bgCellMap, dataUnit);
            result = ((BigDecimal)cellValue).setScale(2, RoundingMode.HALF_UP).floatValue();
        }
        return result;
    }

    private Map<String, Set<String>> getTotalQueryDim(long datasetId, IModelCacheHelper modelCache, PredModel predModel, Map<String, String> dimMemMap) {
        List allDims = modelCache.getDimensionList(Long.valueOf(datasetId));
        List<String> sortedDimList = allDims.stream().map(BaseCache::getNumber).collect(Collectors.toList());
        List<String> members = predModel.getMembers();
        LinkedHashMap memberMap = new LinkedHashMap(sortedDimList.size());
        AtomicInteger index = new AtomicInteger(0);
        sortedDimList.forEach(dim -> {
            if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dim)) {
                memberMap.put(SysDimensionEnum.BudgetPeriod.getNumber(), dimMemMap.get(SysDimensionEnum.BudgetPeriod.getNumber()));
            } else {
                int j = index.getAndIncrement();
                if (j >= members.size()) {
                    Dimension dimension = modelCache.getDimension(dim);
                    memberMap.put(dim, dimension.getNoneNumber());
                } else {
                    memberMap.put(dim, members.get(j));
                }
                if (dimMemMap.containsKey(dim)) {
                    memberMap.put(dim, dimMemMap.get(dim));
                }
            }
        });
        return memberMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> Sets.newHashSet((Object[])new String[]{(String)v.getValue()})));
    }

    private float getTotalRate(PredModel predModel) {
        HashMap<String, String> dimMemMap = new HashMap<String, String>(this.defaultDimMap);
        dimMemMap.put(SysDimensionEnum.ChangeType.getNumber(), "GrowthRate");
        dimMemMap.put(SysDimensionEnum.Metric.getNumber(), "Percentage");
        dimMemMap.put(SysDimensionEnum.BudgetPeriod.getNumber(), "FY2023");
        Map<String, Set<String>> queryDim = this.getTotalQueryDim(this.datasetId, this.modelCache, predModel, dimMemMap);
        Map<MembersKey, BGCell> bgCellMap = QueryService.getInstance().queryCurrData(this.modelId, this.datasetId, this.sandboxId, queryDim, this.dimViewMap);
        log.info("queryTotalRate queryDim:{} result:{}", queryDim, bgCellMap);
        float result = 0.0f;
        if (MapUtils.isNotEmpty(bgCellMap)) {
            BGCell bgCell = (BGCell)Lists.newArrayList(bgCellMap.values()).get(0);
            Object value = bgCell.getValue();
            result = value instanceof Long ? BigDecimal.valueOf((Long)value).multiply(new BigDecimal(100)).setScale(2, RoundingMode.HALF_UP).floatValue() : ((BigDecimal)value).multiply(new BigDecimal(100)).setScale(2, RoundingMode.HALF_UP).floatValue();
        }
        return result;
    }
}

