/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.forecast.gpt;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasBoxService;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasConstants;
import kd.epm.eb.business.analysiscanvas.AnalysisService;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasBox;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.olap.analysiscanvas.service.AnalysisCubeService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

public class GptForecastService {
    private static final Log log = LogFactory.getLog(GptForecastService.class);
    private static final String LOG_PREFIX = "EB-FORECAST-GPT";
    private static final Long PRED_CANVAS_ID = 777778888899999L;
    private static final String PRED_BOX_PREFIX = "PredV";

    public static GptForecastService getInstance() {
        return InnerClass.instance;
    }

    private GptForecastService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initCanvasSandbox() {
        List<AnalysisCanvasBox> boxList = AnalysisCanvasBoxService.getInstance().loadByCanvas(PRED_CANVAS_ID);
        if (CollectionUtils.isEmpty(boxList)) {
            DLock dLock = DLock.create((String)("bgm/forecast/sandbox/create/" + PRED_CANVAS_ID));
            dLock.fastMode();
            boolean lockFlag = dLock.tryLock(5000L);
            if (!lockFlag) {
                throw new KDBizException("Init canvas sandbox fail. Retry");
            }
            try {
                boxList = AnalysisCanvasBoxService.getInstance().loadByCanvas(PRED_CANVAS_ID);
                if (CollectionUtils.isNotEmpty(boxList)) {
                    return;
                }
                AnalysisCanvasBox baseBox = new AnalysisCanvasBox();
                baseBox.setCanvasId(PRED_CANVAS_ID);
                baseBox.setName("Base");
                baseBox.setType(AnalysisCanvasConstants.BoxType.BASE.getValue());
                baseBox.setStatus(AnalysisCanvasConstants.BoxStatus.UNACTIVATED.getValue());
                baseBox.setSeq(1);
                AnalysisCanvasBoxService.getInstance().save(Collections.singletonList(baseBox));
                AnalysisCanvasBox sandBox = new AnalysisCanvasBox();
                sandBox.setCanvasId(PRED_CANVAS_ID);
                sandBox.setName("PredV1");
                sandBox.setType(AnalysisCanvasConstants.BoxType.SANDBOX.getValue());
                sandBox.setStatus(AnalysisCanvasConstants.BoxStatus.ACTIVATED.getValue());
                sandBox.setSeq(2);
                AnalysisCanvasBoxService.getInstance().save(Collections.singletonList(sandBox));
            }
            finally {
                dLock.unlock();
            }
        }
    }

    public void deleteCanvasSandbox() {
        DLock dLock = DLock.create((String)("bgm/forecast/sandbox/delete/" + PRED_CANVAS_ID));
        dLock.fastMode();
        boolean lockFlag = dLock.tryLock(5000L);
        if (!lockFlag) {
            throw new KDBizException("Init canvas sandbox fail. Retry");
        }
        try {
            AnalysisCanvasBoxService.getInstance().deleteByCanvasId(PRED_CANVAS_ID);
        }
        finally {
            dLock.unlock();
        }
    }

    public Pair<Long, Long> getCanvasAndBoxId() {
        AnalysisCanvasBox canvasBox = AnalysisCanvasBoxService.getInstance().loadActivated(PRED_CANVAS_ID);
        return Pair.of((Object)PRED_CANVAS_ID, (Object)canvasBox.getId());
    }

    public Pair<Long, Long> createNewBox() {
        int seq = AnalysisCanvasBoxService.getInstance().getSeq(PRED_CANVAS_ID);
        AnalysisCanvasBox sandBox = new AnalysisCanvasBox();
        sandBox.setCanvasId(PRED_CANVAS_ID);
        sandBox.setName(PRED_BOX_PREFIX + (seq - 1));
        sandBox.setType(AnalysisCanvasConstants.BoxType.SANDBOX.getValue());
        sandBox.setStatus(AnalysisCanvasConstants.BoxStatus.ACTIVATED.getValue());
        sandBox.setSeq(seq);
        Object[] save = AnalysisCanvasBoxService.getInstance().save(Collections.singletonList(sandBox));
        long newBoxId = ((DynamicObject)save[0]).getLong("id");
        AnalysisCanvasBoxService.getInstance().updateActivatedBox(newBoxId, PRED_CANVAS_ID);
        AnalysisCubeService.getInstance().syncForSaveBox(PRED_CANVAS_ID.longValue(), newBoxId);
        return Pair.of((Object)PRED_CANVAS_ID, (Object)newBoxId);
    }

    public List<Long> getLatestBox(int size) {
        List<Object> ids = AnalysisCanvasBoxService.getInstance().loadLatestBox(PRED_CANVAS_ID, size);
        return ids.stream().map(IDUtils::toLong).collect(Collectors.toList());
    }

    public void rewriteBaseUseBox(int sandbox, IFormView formView) {
        int index = sandbox == 1 ? 1 : 0;
        long boxId = this.getLatestBox(2).get(index);
        AnalysisService.getInstance().coverData(PRED_CANVAS_ID, boxId, formView);
    }

    public long queryModelId(String number) {
        String MODEL_FIELDS = "id, shownumber";
        QFilter filter = new QFilter("shownumber", "=", (Object)number);
        DynamicObject object = QueryServiceHelper.queryOne((String)"epm_model", (String)MODEL_FIELDS, (QFilter[])filter.toArray());
        return object.getLong("id");
    }

    public long queryDatasetId(long modelId, String number) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        QFilter qFilter1 = new QFilter("number", "=", (Object)number);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_dataset", (String)"id", (QFilter[])new QFilter[]{qFilter, qFilter1});
        return dynamicObject.getLong("id");
    }

    private static class InnerClass {
        private static final GptForecastService instance = new GptForecastService();

        private InnerClass() {
        }
    }
}

