/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.forecast.helper;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;

public class ForecastChartHelper {
    public static List<String> formatTime(List<Long> timeList, int periodType) {
        boolean isZh = "zh-CN".equals(RequestContext.get().getLang().getLangTag());
        return timeList.stream().map(t -> ForecastChartHelper.formatTime(t, periodType, isZh)).collect(Collectors.toList());
    }

    private static String formatTime(Long timestamp, int periodType, boolean isZh) {
        Calendar cc = Calendar.getInstance();
        cc.setTimeInMillis(timestamp);
        switch (periodType) {
            case 1: {
                return String.format("%s", cc.get(1));
            }
            case 2: {
                String format;
                String halfYear;
                if (isZh) {
                    halfYear = cc.get(2) / 6 >= 1 ? ResManager.loadKDString((String)"\u4e0b\u534a\u5e74", (String)"ForecastService_9", (String)"epm-eb-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4e0a\u534a\u5e74", (String)"ForecastService_8", (String)"epm-eb-business", (Object[])new Object[0]);
                    format = ResManager.loadKDString((String)"%1$s\u5e74%2$s", (String)"ForecastService_10", (String)"epm-eb-business", (Object[])new Object[0]);
                } else {
                    halfYear = cc.get(2) / 6 >= 1 ? "HF2" : "HF1";
                    format = ResManager.loadKDString((String)"%1$s.%2$s", (String)"ForecastService_11", (String)"epm-eb-business", (Object[])new Object[0]);
                }
                return String.format(format, cc.get(1), halfYear);
            }
            case 3: {
                int quarter = cc.get(2) / 3 + 1;
                String quarterFormat = isZh ? ResManager.loadKDString((String)"%1$s\u5e74%2$s\u5b63\u5ea6", (String)"ForecastService_12", (String)"epm-eb-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"%1$s.Q%2$s", (String)"ForecastService_13", (String)"epm-eb-business", (Object[])new Object[0]);
                return String.format(quarterFormat, cc.get(1), quarter);
            }
        }
        return new SimpleDateFormat("yyyy-MM").format(cc.getTime());
    }
}

