/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.forecast.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.hash.Hashing;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.Year;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.MetricUtils;
import kd.epm.eb.common.utils.period.BgPeriodHelper;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.lang3.tuple.Pair;

public class PredictHelper {
    public static Long calcDimHashId(List<Dimension> dimensionList, Map<String, String> cellDimMap) {
        return (Long)PredictHelper.genDimMemHash(dimensionList, cellDimMap).getLeft();
    }

    public static Pair<Long, String> genDimMemHash(List<Dimension> dimensionList, Map<String, String> cellDimMap) {
        String cellMembers = dimensionList.stream().filter(dim -> !SysDimensionEnum.BudgetPeriod.getNumber().equals(dim.getNumber())).map(dim -> (String)cellDimMap.get(dim.getNumber())).filter(StringUtils::isNotEmpty).collect(Collectors.joining(","));
        Long dimHashId = Hashing.sha256().hashString((CharSequence)cellMembers, StandardCharsets.UTF_8).padToLong();
        return Pair.of((Object)dimHashId, (Object)cellMembers);
    }

    public static <E> Map<String, E> json2Map(String json) {
        JSONObject jsonObj = JSON.parseObject((String)json);
        return jsonObj.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> v.getValue(), (o1, o2) -> o2));
    }

    public static Map<String, Long> getViewMap(String dimViewStr) {
        JSONObject dimView = JSON.parseObject((String)dimViewStr);
        return dimView.entrySet().stream().filter(k -> !View.NoViewDimNums.contains(k.getKey())).collect(Collectors.toMap(Map.Entry::getKey, v -> IDUtils.toLong(v.getValue())));
    }

    public static BigDecimal getDataUnit(String unitStr) {
        if (StringUtils.isBlank((CharSequence)unitStr)) {
            unitStr = "0";
        }
        return MetricUtils.unitStr2BigDecimal((String)("unit" + unitStr));
    }

    public static String getFreq(String periodNumber) {
        BgPeriodHelper.PeriodType periodType = BgPeriodHelper.parse((String)periodNumber);
        if (periodType == null) {
            return "MS";
        }
        switch (periodType.getType()) {
            case 1: {
                return "AS";
            }
            case 2: {
                return "CBMS";
            }
            case 3: {
                return "QS";
            }
        }
        return "MS";
    }

    public static List<String> transTime2PeriodNumber(List<Long> predIndex, Integer reqPeriodType) {
        Calendar c = Calendar.getInstance();
        return predIndex.stream().map(v -> {
            BgPeriodHelper.PeriodType periodType;
            c.setTimeInMillis((long)v);
            int year = c.get(1);
            int month = c.get(2) + 1;
            int period = 0;
            switch (reqPeriodType) {
                case 1: {
                    periodType = BgPeriodHelper.PeriodType.of((int)reqPeriodType, (int)year, (int)period);
                    break;
                }
                case 2: {
                    period = month <= 6 ? 1 : 2;
                    periodType = BgPeriodHelper.PeriodType.of((int)reqPeriodType, (int)year, (int)period);
                    break;
                }
                case 3: {
                    period = month <= 3 ? 1 : (month <= 6 ? 2 : (month <= 9 ? 3 : 4));
                    periodType = BgPeriodHelper.PeriodType.of((int)reqPeriodType, (int)year, (int)period);
                    break;
                }
                default: {
                    periodType = BgPeriodHelper.PeriodType.of((int)reqPeriodType, (int)year, (int)month);
                }
            }
            return BgPeriodHelper.toPeriodNumber((BgPeriodHelper.PeriodType)periodType);
        }).collect(Collectors.toList());
    }

    public static List<Long> buildTimeList(Long startPoint, int length, Integer periodType) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(startPoint);
        ArrayList<Long> timeList = new ArrayList<Long>(length);
        for (int i = 0; i < length; ++i) {
            switch (periodType) {
                case 1: {
                    c.set(1, c.get(1) + 1);
                    break;
                }
                case 2: {
                    c.set(2, c.get(2) + 6);
                    break;
                }
                case 3: {
                    c.set(2, c.get(2) + 3);
                    break;
                }
                default: {
                    c.set(2, c.get(2) + 1);
                }
            }
            timeList.add(c.getTimeInMillis());
        }
        return timeList;
    }

    public static String getDataUnitStr(String dataUnit) {
        switch (dataUnit) {
            case "1000": {
                return ResManager.loadKDString((String)"\u5343", (String)"ForecastService_2", (String)"epm-eb-business", (Object[])new Object[0]);
            }
            case "10000": {
                return ResManager.loadKDString((String)"\u4e07", (String)"ForecastService_3", (String)"epm-eb-business", (Object[])new Object[0]);
            }
            case "1000000": {
                return ResManager.loadKDString((String)"\u767e\u4e07", (String)"ForecastService_4", (String)"epm-eb-business", (Object[])new Object[0]);
            }
            case "100000000": {
                return ResManager.loadKDString((String)"\u4ebf", (String)"ForecastService_5", (String)"epm-eb-business", (Object[])new Object[0]);
            }
        }
        return "";
    }

    public static int getDataUnitInt(String dataUnit) {
        switch (dataUnit) {
            case "1000": {
                return 3;
            }
            case "10000": {
                return 4;
            }
            case "1000000": {
                return 6;
            }
            case "100000000": {
                return 8;
            }
        }
        return 0;
    }

    public static Map<String, Pair<Boolean, String>> getUnitSetting(JSONObject unitSettingObj) {
        return unitSettingObj.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> {
            JSONObject valueObj = (JSONObject)v.getValue();
            Map.Entry valueEntry = (Map.Entry)valueObj.entrySet().iterator().next();
            return Pair.of((Object)Boolean.parseBoolean((String)valueEntry.getKey()), (Object)valueEntry.getValue().toString());
        }, (o1, o2) -> o2));
    }

    public static Map<String, String> getDataUnitMap(Map<String, Pair<Boolean, String>> unitSetting, String dataUnitStr) {
        HashMap<String, String> unitMap = new HashMap<String, String>(16);
        unitMap.put("_Default_Unit", dataUnitStr);
        if (MapUtils.isEmpty(unitSetting)) {
            return unitMap;
        }
        return unitSetting.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> {
            if (((Boolean)((Pair)v.getValue()).getLeft()).booleanValue()) {
                return dataUnitStr;
            }
            return String.valueOf(PredictHelper.getDataUnitInt((String)((Pair)v.getValue()).getRight()));
        }, (o1, o2) -> o2));
    }

    public static String getMetricUnit(String metric, Map<String, String> dataUnitMap) {
        String unit = dataUnitMap.get(metric);
        if (unit == null) {
            unit = dataUnitMap.get("_Default_Unit");
        }
        return unit;
    }

    public static List<Year> getYearList(String predStartNumber, String predEndNumber) {
        Date startDate = PredictHelper.periodNumberToDate(predStartNumber);
        Date endDate = PredictHelper.periodNumberToDate(predEndNumber);
        if (startDate == null || endDate == null) {
            return Collections.emptyList();
        }
        LocalDate startLocalDate = startDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate endLocalDate = endDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        int startYear = startLocalDate.getYear();
        int endYear = endLocalDate.getYear();
        ArrayList<Year> yearList = new ArrayList<Year>(endYear - startYear + 1);
        for (int year = startYear; year <= endYear; ++year) {
            yearList.add(Year.of(year));
        }
        return yearList;
    }

    public static Date periodNumberToDate(String number) {
        Date date = null;
        String format = "yyyy-MM-dd";
        try {
            BgPeriodHelper.PeriodType periodType = BgPeriodHelper.parse((String)number);
            if (periodType == null) {
                return null;
            }
            int year = periodType.getYear();
            if (periodType.getType() == 1) {
                String dateStr = year + "-01-01";
                date = DateUtils.parseDate((String)dateStr, (String[])new String[]{format});
            } else if (periodType.getType() == 2 && periodType.getPeriod() == 1) {
                String dateStr = year + "-01-01";
                date = DateUtils.parseDate((String)dateStr, (String[])new String[]{format});
            } else if (periodType.getType() == 2 && periodType.getPeriod() == 2) {
                String dateStr = year + "-07-01";
                date = DateUtils.parseDate((String)dateStr, (String[])new String[]{format});
            } else if (periodType.getType() == 3 && periodType.getPeriod() == 1) {
                String dateStr = year + "-01-01";
                date = DateUtils.parseDate((String)dateStr, (String[])new String[]{format});
            } else if (periodType.getType() == 3 && periodType.getPeriod() == 2) {
                String dateStr = year + "-04-01";
                date = DateUtils.parseDate((String)dateStr, (String[])new String[]{format});
            } else if (periodType.getType() == 3 && periodType.getPeriod() == 3) {
                String dateStr = year + "-07-01";
                date = DateUtils.parseDate((String)dateStr, (String[])new String[]{format});
            } else if (periodType.getType() == 3 && periodType.getPeriod() == 4) {
                String dateStr = year + "-10-01";
                date = DateUtils.parseDate((String)dateStr, (String[])new String[]{format});
            } else if (periodType.getType() == 4) {
                String dateStr = year + "-" + periodType.getPeriod() + "-01";
                date = DateUtils.parseDate((String)dateStr, (String[])new String[]{format});
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return date;
    }
}

