/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.formula;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.formula.AcctFormulaConfig;
import kd.epm.eb.common.formula.BudFormulaConfig;
import kd.epm.eb.common.pojo.BasedataPojo;
import kd.epm.eb.common.pojo.DimViewMember;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;

public class AcctFormulaParser {
    private static final Map<String, Long> singlePeriodMap = new ConcurrentHashMap<String, Long>(16);

    public static <T extends AcctFormulaConfig> T parser(String formulaStr) {
        if (StringUtils.isEmpty((String)formulaStr)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u516c\u5f0f\u5b57\u7b26\u4e32\u4e3a\u7a7a\u3002", (String)"AcctFormulaParser_1", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        int leftBracketIndex = formulaStr.indexOf("(");
        int rightBracketIndex = formulaStr.indexOf(")");
        if (leftBracketIndex == -1 || rightBracketIndex == -1) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u516c\u5f0f\u5b57\u7b26\u4e32\u683c\u5f0f\u9519\u8bef\uff1a%1", (String)"AcctFormulaParser_2", (String)"epm-eb-business", (Object[])new Object[]{formulaStr}));
        }
        String type = formulaStr.substring(0, leftBracketIndex);
        String paramStr = formulaStr.substring(leftBracketIndex + 1, rightBracketIndex);
        List<String> params = Arrays.asList(paramStr.split(","));
        return AcctFormulaParser.parser(type, params);
    }

    public static <T extends AcctFormulaConfig> T parser(String type, List<String> params) {
        if (!"VBud".equalsIgnoreCase(type)) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u516c\u5f0f\u7c7b\u578b\u9519\u8bef\uff1a%1", (String)"AcctFormulaParser_3", (String)"epm-eb-business", (Object[])new Object[]{type}));
        }
        BudFormulaConfig formulaConfig = new BudFormulaConfig();
        StringBuilder dimBuilder = new StringBuilder();
        StringBuilder memberBuilder = new StringBuilder();
        StringBuilder viewBuilder = new StringBuilder();
        for (String param : params) {
            DimViewMember pojo;
            AcctFormulaParser.selectNumber(dimBuilder, viewBuilder, memberBuilder, param);
            String preSign = dimBuilder.toString();
            String viewNumber = viewBuilder.toString();
            String memberNum = memberBuilder.toString();
            DimViewMember dimViewMember = StringUtils.isEmpty((String)memberNum) ? null : (pojo = new DimViewMember(Long.valueOf(0L), null, memberNum, Long.valueOf(0L), StringUtils.isEmpty((String)viewNumber) ? null : viewNumber));
            if ("Model".equals(preSign)) {
                formulaConfig.setModel((BasedataPojo)pojo);
                continue;
            }
            if ("Cube".equals(preSign)) {
                formulaConfig.setDataset((BasedataPojo)pojo);
                continue;
            }
            if (SysDimensionEnum.BudgetPeriod.getNumber().equals(preSign)) {
                DimViewMember yearPojo = null;
                DimViewMember periodPojo = null;
                if (StringUtils.isNotEmpty((String)memberNum)) {
                    String[] numbers = memberNum.split("\\.");
                    yearPojo = new DimViewMember(Long.valueOf(0L), null, numbers[0]);
                    if (numbers.length > 1) {
                        periodPojo = new DimViewMember(Long.valueOf(0L), null, numbers[1]);
                    }
                }
                formulaConfig.getDimMembers().put(SysDimensionEnum.Year.getNumber(), yearPojo);
                formulaConfig.getDimMembers().put(SysDimensionEnum.Period.getNumber(), periodPojo);
                continue;
            }
            formulaConfig.getDimMembers().put(preSign, pojo);
        }
        Long modelId = AcctFormulaParser.getIdFromCache(formulaConfig.getModelNum(), null);
        if (IDUtils.isEmptyLong((Long)modelId).booleanValue()) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u83b7\u53d6\u4f53\u7cfb\u5931\u8d25\uff1a%1", (String)"AcctFormulaParser_4", (String)"epm-eb-business", (Object[])new Object[]{formulaConfig.getModelNum()}));
        }
        formulaConfig.getModel().setId(modelId);
        Long datasetId = AcctFormulaParser.getIdFromCache(formulaConfig.getDatasetNum(), modelId);
        if (IDUtils.isEmptyLong((Long)datasetId).booleanValue()) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u83b7\u53d6\u6570\u636e\u96c6\u5931\u8d25\uff1a%1", (String)"AcctFormulaParser_5", (String)"epm-eb-business", (Object[])new Object[]{formulaConfig.getDatasetNum()}));
        }
        formulaConfig.getDataset().setId(datasetId);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        Map defaultViewIds = modelCacheHelper.getViewsByDataSet(datasetId);
        Map dimMembers = formulaConfig.getDimMembers();
        AcctFormulaParser.loadPeriod();
        for (Map.Entry member : dimMembers.entrySet()) {
            String dimNum = (String)member.getKey();
            DimViewMember memberInfo = (DimViewMember)member.getValue();
            if (memberInfo == null) {
                if (SysDimensionEnum.Entity.getNumber().equals(dimNum) || SysDimensionEnum.Year.getNumber().equals(dimNum) || SysDimensionEnum.Period.getNumber().equals(dimNum)) continue;
                throw new KDBizException(ResManager.loadResFormat((String)"\u83b7\u53d6\u7ef4\u5ea6%1\u7684\u6210\u5458\u5931\u8d25\uff1a%2", (String)"AcctFormulaParser_6", (String)"epm-eb-business", (Object[])new Object[]{dimNum, null}));
            }
            String membNum = memberInfo.getNumber();
            if ("@".equals(membNum)) continue;
            Long memberId = null;
            Long viewId = null;
            String viewNumber = memberInfo.getViewNumber();
            if (SysDimensionEnum.Period.getNumber().equals(dimNum)) {
                memberId = singlePeriodMap.get(membNum);
            } else {
                Member _member;
                if (SysDimensionEnum.Year.getNumber().equals(dimNum)) {
                    dimNum = SysDimensionEnum.BudgetPeriod.getNumber();
                }
                if (SysDimensionEnum.dimHasView((String)dimNum)) {
                    if (StringUtils.isEmpty((String)viewNumber)) {
                        viewId = (Long)defaultViewIds.get(dimNum);
                        View view = modelCacheHelper.getDimension(dimNum).getView(viewId);
                        if (view != null) {
                            viewNumber = view.getNumber();
                        }
                    } else {
                        viewId = AcctFormulaParser.getViewIdFromCache(viewNumber, modelId, modelCacheHelper.getDimension(dimNum).getId());
                    }
                }
                if ((_member = modelCacheHelper.getMember(dimNum, viewId, membNum)) != null) {
                    memberId = _member.getId();
                }
            }
            if (memberId == null) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u83b7\u53d6\u7ef4\u5ea6%1\u7684\u6210\u5458\u5931\u8d25\uff1a%2", (String)"AcctFormulaParser_6", (String)"epm-eb-business", (Object[])new Object[]{dimNum, membNum}));
            }
            memberInfo.setId(memberId);
            memberInfo.setViewId(viewId);
            memberInfo.setViewNumber(viewNumber);
        }
        return (T)formulaConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void loadPeriod() {
        if (!singlePeriodMap.isEmpty()) return;
        Class<AcctFormulaParser> clazz = AcctFormulaParser.class;
        synchronized (AcctFormulaParser.class) {
            if (!singlePeriodMap.isEmpty()) return;
            DynamicObjectCollection allPeriod = QueryServiceHelper.query((String)"eb_singleperiod", (String)"number,id", null);
            for (DynamicObject obj : allPeriod) {
                singlePeriodMap.put(obj.getString("number"), obj.getLong("id"));
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static void selectNumber(StringBuilder dim, StringBuilder view, StringBuilder member, String paramStr) {
        dim.setLength(0);
        member.setLength(0);
        view.setLength(0);
        if (!StringUtils.isEmpty((String)paramStr)) {
            boolean next = false;
            boolean matchView = false;
            for (int i = 0; i < paramStr.length(); ++i) {
                char c = paramStr.charAt(i);
                if (c == '\"') continue;
                if (c == '.' && !next) {
                    next = true;
                    matchView = true;
                    continue;
                }
                if (c == '-' && !matchView) {
                    matchView = true;
                    continue;
                }
                if (next) {
                    member.append(c);
                    continue;
                }
                if (matchView) {
                    view.append(c);
                    continue;
                }
                dim.append(c);
            }
        }
        if (dim.length() == 0) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u53c2\u6570\u683c\u5f0f\u9519\u8bef\uff1a%1\u3002", (String)"AcctFormulaParser_7", (String)"epm-eb-business", (Object[])new Object[]{paramStr}));
        }
    }

    private static Long getIdFromCache(String number, Long modelId) {
        boolean isModel = modelId == null;
        String cacheKey = isModel ? "modelNumMapModelId" : "datasetNumMapDatasetId";
        String numberKey = isModel ? number : modelId + "_" + number;
        Map cacheId = (Map)ThreadCache.get((Object)cacheKey, () -> new HashMap(16));
        return cacheId.computeIfAbsent(numberKey, key -> {
            Long id = isModel ? (Long)CommonServiceHelper.getValueFromDB((String)"epm_model", (String)"id", (String)"shownumber", (Object[])new Object[]{number}) : (Long)CommonServiceHelper.getValueFromDB((String)"eb_dataset", (String)"id", (String)"number,model", (Object[])new Object[]{number, modelId});
            if (id == null) {
                id = 0L;
            }
            return id;
        });
    }

    private static Long getViewIdFromCache(String viewNumber, Long modelId, Long dimId) {
        String cacheKey = modelId + "_" + dimId;
        Map cacheMap = (Map)ThreadCache.get((Object)cacheKey, () -> new HashMap(16));
        return cacheMap.computeIfAbsent(viewNumber, key -> {
            Long id = (Long)CommonServiceHelper.getValueFromDB((String)"eb_dimensionview", (String)"id", (String)"number,model,dimension", (Object[])new Object[]{key, modelId, dimId});
            if (id == null) {
                id = 0L;
            }
            return id;
        });
    }
}

