/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.language;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.MetaUtils;
import kd.epm.eb.common.utils.StringUtils;
import org.jetbrains.annotations.NotNull;

public class LanguageUpgradeService {
    public static final Log log = LogFactory.getLog(LanguageUpgradeService.class);
    private static final int MAIN_TABLE = 0;
    private static final int ENTITY_NUMBER = 1;
    private static final int LANGUAGE_FIELD = 2;
    private static final int LANGUAGE_LENGTH = 3;
    private static final int MODEL_FIELD = 4;

    public static LanguageUpgradeService get() {
        return new LanguageUpgradeService();
    }

    public void upgrade(Set<Long> modelIds) {
        if (modelIds == null || modelIds.isEmpty()) {
            return;
        }
        List<String[]> upgradeDatas = this.getUpgradeData();
        this.executeUpgrade(modelIds, upgradeDatas);
    }

    private List<String[]> getUpgradeData() {
        LinkedList upgradeDatas = Lists.newLinkedList();
        upgradeDatas.add(new String[]{"t_eb_model", "epm_model", "fname", null, null});
        upgradeDatas.add(new String[]{"t_eb_dimension", "epm_dimension", "fname", null, "fmodelid"});
        upgradeDatas.add(new String[]{"t_eb_structofent", SysDimensionEnum.Entity.getMemberTreemodel(), "fname", null, "fmodelid"});
        upgradeDatas.add(new String[]{"t_eb_structofaccount", SysDimensionEnum.Account.getMemberTreemodel(), "fname", null, "fmodelid"});
        upgradeDatas.add(new String[]{"t_eb_structofaudittrial", SysDimensionEnum.AuditTrail.getMemberTreemodel(), "fname", null, "fmodelid"});
        upgradeDatas.add(new String[]{"t_eb_structofbperiod", SysDimensionEnum.BudgetPeriod.getMemberTreemodel(), "fname", null, "fmodelid"});
        upgradeDatas.add(new String[]{"t_eb_structofdatetype", SysDimensionEnum.DataType.getMemberTreemodel(), "fname", null, "fmodelid"});
        upgradeDatas.add(new String[]{"t_eb_structofcurrency", SysDimensionEnum.Currency.getMemberTreemodel(), "fname", null, "fmodelid"});
        upgradeDatas.add(new String[]{"t_eb_structoffy", SysDimensionEnum.Year.getMemberTreemodel(), "fname", null, "fmodelid"});
        upgradeDatas.add(new String[]{"t_eb_structofperiod", SysDimensionEnum.Period.getMemberTreemodel(), "fname", null, "fmodelid"});
        upgradeDatas.add(new String[]{"t_eb_structoficentity", SysDimensionEnum.InternalCompany.getMemberTreemodel(), "fname", null, "fmodelid"});
        upgradeDatas.add(new String[]{"t_eb_structofmetric", SysDimensionEnum.Metric.getMemberTreemodel(), "fname", null, "fmodelid"});
        upgradeDatas.add(new String[]{"t_eb_structofprocess", SysDimensionEnum.Process.getMemberTreemodel(), "fname", null, "fmodelid"});
        upgradeDatas.add(new String[]{"t_eb_structofscene", SysDimensionEnum.Scenario.getMemberTreemodel(), "fname", null, "fmodelid"});
        upgradeDatas.add(new String[]{"t_eb_structofversion", SysDimensionEnum.Version.getMemberTreemodel(), "fname", null, "fmodelid"});
        upgradeDatas.add(new String[]{"t_eb_structofdefined", "epm_userdefinedmembertree", "fname", null, "fmodelid"});
        upgradeDatas.add(new String[]{"t_eb_viewmember", "eb_viewmember", "fname", null, "fmodelid"});
        upgradeDatas.add(new String[]{"t_eb_customproperty", "eb_customproperty", "fname", null, "fmodelid"});
        upgradeDatas.add(new String[]{"t_eb_dimensionrelation", "epm_dimensionrelation", "fname", null, "fmodelid"});
        upgradeDatas.add(new String[]{"t_eb_dim_membermap", "eb_dim_membermap", "fname", null, "fsrcmodel"});
        upgradeDatas.add(new String[]{"t_eb_templatecatalog", "eb_templatecatalog", "fname", null, "fmodelid"});
        upgradeDatas.add(new String[]{"t_eb_template", "eb_templateentity", "fname", null, "fmodelid"});
        upgradeDatas.add(new String[]{"t_eb_ebtemplatecatalog", "eb_templatecatalog_bg", "fname", null, "fmodelid"});
        upgradeDatas.add(new String[]{"t_eb_ebtemplate", "eb_templateentity_bg", "fname", null, "fmodelid"});
        upgradeDatas.add(new String[]{"t_eb_offsetrulecatalog", "eb_offsetrulecatalog", "fname", null, "fmodelid"});
        upgradeDatas.add(new String[]{"t_eb_offsetrule", "eb_offsetrule", "fname", null, "fmodelid"});
        upgradeDatas.add(new String[]{"t_eb_sharedimension", "eb_sharedimension", "fname", null, "fmodelid"});
        upgradeDatas.add(new String[]{"t_eb_analysiscanvas_cate", "eb_analysiscanvas_cate", "fname", null, null});
        upgradeDatas.add(new String[]{"t_eb_analysiscanvas_cmp", "eb_analysiscanvas_cmp", "fname", null, "fmodelid"});
        upgradeDatas.add(new String[]{"t_eb_analysiscanvas_cmp", "eb_analysiscanvas_cmp", "fdesc", null, "fmodelid"});
        upgradeDatas.add(new String[]{"t_eb_rptscheme", "eb_rptscheme", "fname", null, "fmodelid"});
        upgradeDatas.add(new String[]{"t_eb_periodvariable", "eb_periodvariable", "fname", null, "fmodelid"});
        return upgradeDatas;
    }

    private void executeUpgrade(Set<Long> modelIds, List<String[]> upgradeDatas) {
        if (CollectionUtils.isEmpty(modelIds) || CollectionUtils.isEmpty(upgradeDatas)) {
            return;
        }
        for (Long _modelId : modelIds) {
            for (String[] _upgradeData : upgradeDatas) {
                this.executeUpgrade(_modelId, _upgradeData, true);
            }
        }
        for (String[] _upgradeData : upgradeDatas) {
            this.executeUpgrade(null, _upgradeData, false);
        }
    }

    private void executeUpgrade(Long modelId, String[] upgradeData, boolean hasModelField) {
        if (upgradeData == null || upgradeData.length < 5) {
            log.warn("upgradeData error." + JSONUtils.toString((Object)upgradeData));
            return;
        }
        if (hasModelField) {
            if (IDUtils.isNull((Long)modelId)) {
                log.warn("modelId is null");
                return;
            }
            if (StringUtils.isEmpty((String)upgradeData[4])) {
                log.info("model-Field is null");
                return;
            }
        } else if (StringUtils.isNotEmpty((String)upgradeData[4])) {
            return;
        }
        String upgrade_lang = "zh_CN";
        try {
            SqlBuilder sql = LanguageUpgradeService.getSqlBuilder(modelId, upgradeData, upgrade_lang);
            DB.execute((DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);
            sql = LanguageUpgradeService.getSqlBuilder1(modelId, upgradeData, upgrade_lang);
            DB.execute((DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);
        }
        catch (Throwable ex) {
            log.error("executeUpgrade-error", (Object)CommonServiceHelper.getStackTraceStr((Throwable)ex));
            throw ex;
        }
    }

    @NotNull
    private static SqlBuilder getSqlBuilder(Long modelId, String[] upgradeData, String upgrade_lang) {
        String main_Table = upgradeData[0];
        String lang_Table = main_Table + "_l";
        String lang_Field = upgradeData[2];
        String lang_length = upgradeData[3];
        if (StringUtils.isEmpty((String)lang_length)) {
            lang_length = String.valueOf(MetaUtils.getMetaLength((String)upgradeData[1], (String)lang_Field.substring(1)));
        }
        String model_Field = upgradeData[4];
        SqlBuilder sql = new SqlBuilder();
        if (StringUtils.isNotEmpty((String)model_Field)) {
            sql.append("update " + main_Table + " set " + lang_Field + " = (select left(l." + lang_Field + ", " + lang_length + ") from " + lang_Table + " l where l.fid = " + main_Table + ".fid and flocaleid = '" + upgrade_lang + "') where " + model_Field + " = ?  and " + lang_Field + " = '' and exists (select 1 from " + lang_Table + " where fid = " + main_Table + ".fid and flocaleid = '" + upgrade_lang + "')", new Object[]{modelId});
        } else {
            sql.append("update " + main_Table + " set " + lang_Field + " = (select left(l." + lang_Field + ", " + lang_length + ") from " + lang_Table + " l where l.fid = " + main_Table + ".fid and flocaleid = '" + upgrade_lang + "') where " + lang_Field + " = '' and exists (select 1 from " + lang_Table + " where fid = " + main_Table + ".fid and flocaleid = '" + upgrade_lang + "')", new Object[0]);
        }
        return sql;
    }

    @NotNull
    private static SqlBuilder getSqlBuilder1(Long modelId, String[] upgradeData, String upgrade_lang) {
        String main_Table = upgradeData[0];
        String lang_Table = main_Table + "_l";
        String lang_Field = upgradeData[2];
        String lang_length = upgradeData[3];
        if (StringUtils.isEmpty((String)lang_length)) {
            lang_length = String.valueOf(MetaUtils.getMetaLength((String)upgradeData[1], (String)lang_Field.substring(1)));
        }
        String model_Field = upgradeData[4];
        SqlBuilder sql = new SqlBuilder();
        if (StringUtils.isNotEmpty((String)model_Field)) {
            sql.append("update " + main_Table + " set " + lang_Field + " = (select left(l." + lang_Field + ", " + lang_length + ") from " + lang_Table + " l where l.fid = " + main_Table + ".fid and flocaleid = '" + upgrade_lang + "') where " + model_Field + " = ?  and " + lang_Field + " = ' ' and exists (select 1 from " + lang_Table + " where fid = " + main_Table + ".fid and flocaleid = '" + upgrade_lang + "')", new Object[]{modelId});
        } else {
            sql.append("update " + main_Table + " set " + lang_Field + " = (select left(l." + lang_Field + ", " + lang_length + ") from " + lang_Table + " l where l.fid = " + main_Table + ".fid and flocaleid = '" + upgrade_lang + "') where " + lang_Field + " = ' ' and exists (select 1 from " + lang_Table + " where fid = " + main_Table + ".fid and flocaleid = '" + upgrade_lang + "')", new Object[0]);
        }
        return sql;
    }
}

