/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.memberf7;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.entity.memberF7.RangeF7Param;
import kd.epm.eb.common.entity.property.CustomPropertyValue;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.RangeF7PropertyCataEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.member.f7.MemberParamsUtils;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.CommonUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.spread.template.dimension.DefaultDimMember;
import kd.epm.eb.spread.template.dimension.IDimensionMember;
import kd.epm.eb.spread.template.dimension.RowColDimMember;
import org.jetbrains.annotations.NotNull;

public class NewF7Utils {
    private static final Log log = LogFactory.getLog(NewF7Utils.class);
    private static final String DEFAULT_LEAF_LIST = "eb_memberf7";
    private static final String DEFAULT_LEAF_LIST_VIEW = "eb_memberf7_view";
    private static final String DEFAULT_LEAF_RANGE = "eb_memberf8";
    private static final String DEFAULT_LEAF_RANGE_TEMPLATE = "eb_memberf8_template";
    private static final String DEFAULT_LEAF_VIRTUAL_TREE = "eb_virtualf7";
    private static final String F7_LOOKUP_LIST = "getLookUpList";
    private static final String F7_SET_BY_ID = "setItemByIdFromClient";
    private static final String F7_SET_BY_NUM = "setItemByNumber";
    public static final int F7_LOOKUP_LIST_SIZE = 15;
    private static final F7 F7 = new F7();
    private static final F8 F8 = new F8();
    private static final F8Float F8Float = new F8Float();
    private static final VirtualF7 VIRTUALF7 = new VirtualF7();

    public static void openF7(@NotNull BeforeF7SelectEvent evt, @NotNull MemberF7Parameter f7Param) {
        F7.open(evt, f7Param, null);
    }

    public static void openF7(@NotNull BeforeF7SelectEvent evt, @NotNull MemberF7Parameter f7Param, CloseCallBack closeCallBack) {
        F7.open(evt, f7Param, closeCallBack);
    }

    public static void openF7(@NotNull IFormView view, @NotNull MemberF7Parameter f7Param, @NotNull CloseCallBack closeCallBack) {
        F7.open(view, f7Param, closeCallBack);
    }

    public static void openF8(@NotNull BeforeF7SelectEvent evt, @NotNull MemberF7Parameter f7Param) {
        F8.open(evt, f7Param, null);
    }

    public static void openF8(@NotNull IFormView view, @NotNull MemberF7Parameter f7Param, @NotNull CloseCallBack closeCallBack) {
        F8.open(view, f7Param, closeCallBack);
    }

    public static void openF8Float(@NotNull IFormView view, @NotNull MemberF7Parameter f7Param, @NotNull CloseCallBack closeCallBack) {
        F8Float.open(view, f7Param, closeCallBack);
    }

    public static void openVirtualF7(@NotNull BeforeF7SelectEvent evt, @NotNull MemberF7Parameter f7Param) {
        VIRTUALF7.open(evt, f7Param);
    }

    public static void openVirtualF7(@NotNull BeforeF7SelectEvent evt, @NotNull MemberF7Parameter f7Param, CloseCallBack closeCallBack) {
        VIRTUALF7.open(evt, f7Param, closeCallBack);
    }

    public static void openVirtualF7(@NotNull IFormView view, @NotNull MemberF7Parameter f7Param, @NotNull CloseCallBack closeCallBack) {
        VIRTUALF7.open(view, f7Param, closeCallBack);
    }

    public static void openVirtualF74JC(@NotNull IFormView view, @NotNull MemberF7Parameter f7Param, @NotNull CloseCallBack closeCallBack) {
        if (!CommonUtils.checkBcmJCDataPerm((Long)f7Param.getEbModelId(), (boolean)true)) {
            f7Param.setPermissionType("A");
        } else if (f7Param.getPermissionType() == null) {
            f7Param.setPermissionType("R");
        }
        NewF7Utils.openVirtualF7(view, f7Param, closeCallBack);
    }

    private static void dealListShowParameter(@NotNull FormShowParameter showParameter, @NotNull MemberF7Parameter f7Param, CloseCallBack closeCallBack) {
        String _f7ParamStr = JSON.toJSONString((Object)f7Param);
        log.info("f7Parameter-" + _f7ParamStr);
        showParameter.setCustomParam("Member_F7_Param", (Object)_f7ParamStr);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setShowTitle(false);
        if (showParameter instanceof ListShowParameter) {
            ((ListShowParameter)showParameter).setLookUp(true);
            ((ListShowParameter)showParameter).setShowUsed(false);
            ((ListShowParameter)showParameter).setShowApproved(false);
            ((ListShowParameter)showParameter).setMultiSelect(f7Param.isMultiSelect());
        }
        if (closeCallBack != null) {
            showParameter.setCloseCallBack(closeCallBack);
        }
        StyleCss css = new StyleCss();
        css.setWidth("1200px");
        css.setHeight("750px");
        showParameter.getOpenStyle().setInlineStyleCss(css);
        if (showParameter instanceof ListShowParameter) {
            NewF7Utils.dealSelectRows((ListShowParameter)showParameter, f7Param);
        }
    }

    public static void dealListShowParameter(@NotNull FormShowParameter parameter) {
        parameter.setShowTitle(false);
        StyleCss css = new StyleCss();
        css.setWidth("1200px");
        css.setHeight("750px");
        parameter.getOpenStyle().setInlineStyleCss(css);
    }

    private static void dealSelectRows(ListShowParameter showParameter, MemberF7Parameter f7Param) {
        ListSelectedRowCollection selectedRows = showParameter.getListSelectedRowCollection();
        selectedRows.clear();
        if (f7Param.getSelectIds() != null && !f7Param.getSelectIds().isEmpty()) {
            if (f7Param.isMultiSelect()) {
                selectedRows.addAll((Collection)f7Param.selectedListRows());
            } else {
                selectedRows.add((Object)f7Param.selectedListRows().get(0));
            }
        }
    }

    public static void dealSelectRows(ListShowParameter showParameter, BeforeF7SelectEvent event) {
        ListSelectedRowCollection selectedRows = showParameter.getListSelectedRowCollection();
        selectedRows.clear();
        if (event.getOriginalValue() instanceof DynamicObject) {
            DynamicObject _obj = (DynamicObject)event.getOriginalValue();
            selectedRows.add((Object)new ListSelectedRow((Object)_obj.getLong("id")));
        }
    }

    public static void cantSelectRoot(@NotNull List<QFilter> filters, @NotNull MemberF7Parameter f7Param) {
        if (!f7Param.isCanSelectRoot()) {
            filters.add(new QFilter("number", "!=", (Object)f7Param.getDimensionNumber()));
        }
    }

    public static CloseCallBack closeCallBack(IFormPlugin plugin, String actionId) {
        return new CloseCallBack(plugin, actionId);
    }

    public static MemberF7Parameter singleF7(@NotNull Long modelId, @NotNull Long dimensionId) {
        MemberF7Parameter f7Param = NewF7Utils.createDefaultParam(modelId, NewF7Utils.getDimension(dimensionId));
        f7Param.setMultiSelect(false);
        return f7Param;
    }

    public static MemberF7Parameter singleF7(@NotNull Long modelId, @NotNull String dimensionNumber) {
        MemberF7Parameter f7Param = NewF7Utils.createDefaultParam(modelId, NewF7Utils.getDimension(modelId, dimensionNumber));
        f7Param.setMultiSelect(false);
        return f7Param;
    }

    public static MemberF7Parameter singleF7(@NotNull Long modelId, @NotNull DynamicObject dimension) {
        MemberF7Parameter f7Param = NewF7Utils.createDefaultParam(modelId, dimension);
        f7Param.setMultiSelect(false);
        return f7Param;
    }

    public static MemberF7Parameter singleF7(@NotNull Long modelId, @NotNull DynamicObject dimension, @NotNull String returnClassName) {
        MemberF7Parameter f7Param = NewF7Utils.createDefaultParam(modelId, dimension);
        f7Param.setMultiSelect(false);
        f7Param.setReturnClassName(returnClassName);
        return f7Param;
    }

    public static MemberF7Parameter multipleF7(@NotNull Long modelId, @NotNull Long dimensionId) {
        return NewF7Utils.createDefaultParam(modelId, dimensionId);
    }

    public static MemberF7Parameter multipleF7(@NotNull Long modelId, @NotNull DynamicObject dimension, @NotNull String returnClassName) {
        MemberF7Parameter f7Param = NewF7Utils.createDefaultParam(modelId, dimension);
        f7Param.setReturnClassName(returnClassName);
        return f7Param;
    }

    public static MemberF7Parameter multipleF7(@NotNull Long modelId, @NotNull DynamicObject dimension) {
        return NewF7Utils.createDefaultParam(modelId, dimension);
    }

    public static MemberF7Parameter multipleF8(@NotNull Long modelId, @NotNull DynamicObject dimension, @NotNull String returnClassName) {
        MemberF7Parameter f8Param = NewF7Utils.multipleF8(modelId, dimension);
        f8Param.setReturnClassName(returnClassName);
        return f8Param;
    }

    public static MemberF7Parameter multipleF8(@NotNull Long modelId, @NotNull String dimensionNumber, @NotNull String returnClassName) {
        DynamicObject dimension = NewF7Utils.getDimension(modelId, dimensionNumber);
        return NewF7Utils.multipleF8(modelId, dimension, returnClassName);
    }

    public static MemberF7Parameter multipleF8(@NotNull Long modelId, @NotNull String dimensionNumber) {
        DynamicObject dimension = NewF7Utils.getDimension(modelId, dimensionNumber);
        return NewF7Utils.multipleF8(modelId, dimension);
    }

    public static MemberF7Parameter multipleF8(@NotNull Long modelId, @NotNull DynamicObject dimension) {
        MemberF7Parameter f8Param = NewF7Utils.createDefaultParam(modelId, dimension);
        f8Param.setFunctionType(1);
        f8Param.setShowLeaf(true);
        f8Param.setShowAnalyseMember(false);
        f8Param.setCutTree(false);
        return f8Param;
    }

    private static MemberF7Parameter createDefaultParam(@NotNull Long modelId, @NotNull Long dimensionId) {
        return NewF7Utils.createDefaultParam(modelId, NewF7Utils.getDimension(dimensionId));
    }

    private static MemberF7Parameter createDefaultParam(@NotNull Long modelId, DynamicObject dimension) {
        if (dimension == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (String)"NewF7Utils_0", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        MemberF7Parameter f7Param = new MemberF7Parameter();
        f7Param.setModelId(modelId);
        f7Param.setDimensionId(Long.valueOf(dimension.getLong("id")));
        f7Param.setDimensionNumber(dimension.getString("number"));
        f7Param.setDimensionName(dimension.getString("name"));
        f7Param.setEntityNumber(dimension.getString("membermodel"));
        NewF7Utils.setCanSelectRoot(f7Param);
        NewF7Utils.setShowCusProperty(f7Param, null);
        MemberParamsUtils.F7Params f7SetParams = MemberParamsUtils.getF7ParamsByCache((long)modelId);
        if (f7SetParams != null && f7SetParams.getSelectedDims() != null) {
            f7Param.setShowLeaf(f7SetParams.getSelectedDims().contains(f7Param.getDimensionId()));
        }
        return f7Param;
    }

    public static void setCanSelectRoot(MemberF7Parameter f7Param) {
        f7Param.canSelectRoot();
    }

    public static void setShowCusProperty(MemberF7Parameter f7Param, RangeF7Param rangeF7) {
        if ((SysDimensionEnum.Entity.getNumber().equals(f7Param.getDimensionNumber()) || "epm_userdefinedmembertree".equals(f7Param.baseEntityNumber())) && rangeF7 != null) {
            f7Param.setShowCustomProperty(rangeF7.isOpenProperty());
        }
    }

    private static void loadFromBaseDataEdit(MemberF7Parameter f7Param, Object value) {
        if (f7Param == null || value == null) {
            return;
        }
        LinkedHashSet ids = Sets.newLinkedHashSet();
        if (value instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection _rows = (ListSelectedRowCollection)value;
            for (ListSelectedRow _row : _rows) {
                ids.add(IDUtils.toLong((Object)_row.getPrimaryKeyValue()));
            }
        } else if (value instanceof DynamicObject) {
            ids.add(((DynamicObject)value).getLong("id"));
        } else if (value instanceof DynamicObjectCollection) {
            DynamicObjectCollection _objs = (DynamicObjectCollection)value;
            for (DynamicObject _obj : _objs) {
                ids.add(_obj.getLong("fbasedataid_id"));
            }
        } else if (value instanceof Long) {
            ids.add((Long)value);
        }
        if (!ids.isEmpty()) {
            f7Param.setSelectIds((Set)ids);
        }
    }

    public static <T> List<?> to(List<?> members, @NotNull Class<?> className) {
        if (members == null) {
            return null;
        }
        List<?> _members = NewF7Utils.createList(className, members.size());
        for (Object srcMember : members) {
            T _member;
            if (srcMember == null) continue;
            if (srcMember.getClass().isAssignableFrom(className)) {
                _members.add(srcMember);
                continue;
            }
            if (!srcMember.getClass().isAssignableFrom(Member.class) || (_member = NewF7Utils.toMember((Member)srcMember, className)) == null) continue;
            _members.add(_member);
        }
        return _members;
    }

    private static List<?> createList(@NotNull Class<?> className, int intiSize) {
        if (className.isAssignableFrom(ListSelectedRow.class)) {
            return new ListSelectedRowCollection();
        }
        return new ArrayList(intiSize);
    }

    private static <T> T toMember(Member member, @NotNull Class<?> className) {
        ListSelectedRow _member;
        if (className.isAssignableFrom(ListSelectedRow.class)) {
            _member = NewF7Utils.toListSelectedRow(member);
        } else if (className.isAssignableFrom(kd.epm.eb.common.cache.impl.Member.class)) {
            _member = NewF7Utils.toMember(member);
        } else {
            throw new IllegalStateException();
        }
        return (T)_member;
    }

    private static ListSelectedRow toListSelectedRow(Member member) {
        ListSelectedRow row = new ListSelectedRow();
        row.setPrimaryKeyValue((Object)member.getId());
        row.setNumber(member.getNumber());
        row.setName(member.getName());
        return row;
    }

    private static kd.epm.eb.common.cache.impl.Member toMember(Member member) {
        kd.epm.eb.common.cache.impl.Member _member = new kd.epm.eb.common.cache.impl.Member();
        _member.setId(member.getId());
        _member.setNumber(member.getNumber());
        _member.setName(member.getName());
        return _member;
    }

    public static DynamicObject getDimension(@NotNull Long modelId, @NotNull SysDimensionEnum dimension) {
        return NewF7Utils.getDimension(modelId, dimension.getNumber());
    }

    public static DynamicObject getDimension(@NotNull Long modelId, @NotNull String dimensionNumber) {
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", (Object)modelId);
        builder.add("number", "=", (Object)dimensionNumber);
        return BusinessDataServiceHelper.loadSingleFromCache((String)"epm_dimension", (String)"id,name,number,membermodel,shortnumber", (QFilter[])builder.toArray());
    }

    public static DynamicObject getDimension(@NotNull Long dimensionId) {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)dimensionId, (String)"epm_dimension", (String)"id,name,number,membermodel,shortnumber");
    }

    public static String getDimNumber(String dimKey) {
        SysDimensionEnum dimEnum = SysDimensionEnum.getEnumByNumberIgnoreCase((String)dimKey);
        if (dimEnum != null) {
            return dimEnum.getNumber();
        }
        return null;
    }

    public static Set<Long> transMemberNumber(String dimNumber, Long viewId, Collection<String> memberNumbers, IModelCacheHelper modelCacheHelper) {
        List _memberIds;
        Dimension _dimension;
        if (memberNumbers == null || modelCacheHelper == null) {
            return null;
        }
        HashSet _selectRangeIds = Sets.newHashSetWithExpectedSize((int)memberNumbers.size());
        if (!memberNumbers.isEmpty() && (_dimension = modelCacheHelper.getDimension(dimNumber)) != null && (_memberIds = _dimension.getMemberId(viewId, memberNumbers)) != null) {
            _selectRangeIds.addAll(_memberIds);
        }
        return _selectRangeIds;
    }

    public static Object returnData(@NotNull MemberF7Parameter f7Param, Map<String, Map<String, String>> selectDatas, @NotNull Map<String, Object> dataParams) {
        if (selectDatas == null) {
            return null;
        }
        IModelCacheHelper modelCacheHelper = f7Param.getModelCacheHelper();
        Dimension dimension = modelCacheHelper.getDimension(f7Param.getDimensionId());
        ListSelectedRowCollection returnData = null;
        if (StringUtils.isEmpty((String)f7Param.getReturnClassName())) {
            ListSelectedRowCollection _returnData = new ArrayList(selectDatas.size());
            for (Map<String, String> select : selectDatas.values()) {
                Member _member = new Member(IDUtils.toLong((Object)select.get("id")), select.get("na"), select.get("nu"));
                try {
                    _member.setRange(Integer.parseInt(select.get("sc")));
                }
                catch (Exception ex) {
                    log.warn(ex.getMessage());
                }
                _member.setShowNumber(select.get("snu"));
                if (f7Param.isView()) {
                    _member.setViewId(f7Param.getViewId());
                }
                if ("C".equals(select.get("ty"))) {
                    _member.setIsProperty(Boolean.valueOf(true));
                }
                _returnData.add(_member);
            }
            returnData = _returnData;
        } else {
            try {
                Class<Object> _className = Class.forName(f7Param.getReturnClassName());
                if (_className.isAssignableFrom(ListSelectedRow.class)) {
                    ListSelectedRowCollection _returnData = new ListSelectedRowCollection();
                    for (Map<String, String> select : selectDatas.values()) {
                        ListSelectedRow _data = NewF7Utils.transSelectedRow(select, dimension, f7Param);
                        if (_data == null) continue;
                        _returnData.add((Object)_data);
                    }
                    if (_returnData.isEmpty()) {
                        _returnData.setClearFlag(true);
                    }
                    returnData = _returnData;
                } else if (_className.isAssignableFrom(DynamicObject.class)) {
                    DynamicObjectType dt = new DynamicObjectType("PlainObject");
                    NewF7Utils.registerProperty(dt, f7Param);
                    if (f7Param.isMultiSelect()) {
                        DynamicObjectCollection objects = new DynamicObjectCollection();
                        for (Map<String, String> select : selectDatas.values()) {
                            DynamicObject object = NewF7Utils.transObject(dt, select, dimension, f7Param);
                            if (object == null) continue;
                            objects.add((Object)object);
                        }
                        returnData = objects;
                    } else if (!selectDatas.isEmpty()) {
                        returnData = NewF7Utils.transObject(dt, selectDatas.values().iterator().next(), dimension, f7Param);
                    }
                } else if (_className.isAssignableFrom(DynamicObjectCollection.class)) {
                    DynamicObjectType dt = new DynamicObjectType("PlainObject");
                    NewF7Utils.registerProperty(dt, f7Param);
                    DynamicObjectCollection objects = new DynamicObjectCollection();
                    for (Map<String, String> select : selectDatas.values()) {
                        DynamicObject object = NewF7Utils.transObject(dt, select, dimension, f7Param);
                        if (object == null) continue;
                        objects.add((Object)object);
                        if (f7Param.isMultiSelect() || objects.isEmpty()) continue;
                        break;
                    }
                    returnData = objects;
                } else if (_className.isAssignableFrom(RowColDimMember.class)) {
                    RowColDimMember members = new RowColDimMember();
                    Object value = dataParams.get("chkfloat");
                    if (value instanceof Boolean) {
                        members.setFloat(((Boolean)value).booleanValue());
                    } else {
                        members.setFloat(false);
                    }
                    value = dataParams.get("chkaddnew");
                    if (value instanceof Boolean) {
                        members.setQuickAddNew(((Boolean)value).booleanValue());
                    } else {
                        members.setQuickAddNew(false);
                    }
                    Object _parent = dataParams.get("parent");
                    if (_parent instanceof DynamicObject) {
                        DynamicObject parent = (DynamicObject)_parent;
                        DefaultDimMember defaultMember = new DefaultDimMember();
                        defaultMember.setId(Long.valueOf(parent.getLong("id")));
                        defaultMember.setNumber(parent.getString("number"));
                        defaultMember.setName(parent.getString("name"));
                        members.setDefaultParent((IDimensionMember)defaultMember);
                    }
                    for (Map<String, String> select : selectDatas.values()) {
                        IDimensionMember object = NewF7Utils.transMember(select, dimension, f7Param);
                        if (object == null) continue;
                        members.getMembers().add(object);
                    }
                    returnData = members;
                }
            }
            catch (ClassNotFoundException ex) {
                log.error(CommonServiceHelper.getStackTraceStr((Throwable)ex));
            }
        }
        return returnData;
    }

    private static ListSelectedRow transSelectedRow(Map<String, String> selectData, @NotNull Dimension dimension, @NotNull MemberF7Parameter f7Param) {
        if (selectData == null || selectData.isEmpty()) {
            return null;
        }
        ListSelectedRow selectedRow = new ListSelectedRow();
        String _obj = selectData.get("id");
        if (_obj != null) {
            selectedRow.setPrimaryKeyValue((Object)IDUtils.toLong((Object)_obj));
        }
        if ((_obj = selectData.get("nu")) != null) {
            selectedRow.setNumber(_obj);
        }
        if ((_obj = selectData.get("na")) != null) {
            selectedRow.setName(_obj);
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>(32);
        dataMap.put("id", selectedRow.getPrimaryKeyValue());
        dataMap.put("number", selectedRow.getNumber());
        dataMap.put("name", selectedRow.getName());
        dataMap.put("memberid", selectedRow.getPrimaryKeyValue());
        dataMap.put("viewid", f7Param.getViewId());
        _obj = selectData.get("ty");
        if (StringUtils.equals((String)"A", (String)_obj)) {
            dataMap.put("type", RangeF7PropertyCataEnum.Member.getIndex());
            kd.epm.eb.common.cache.impl.Member _member = dimension.getMember(f7Param.getViewId(), (Long)selectedRow.getPrimaryKeyValue());
            if (_member != null) {
                if (StringUtils.isEmpty((String)selectedRow.getNumber())) {
                    selectedRow.setNumber(_member.getNumber());
                }
                if (StringUtils.isEmpty((String)selectedRow.getName())) {
                    selectedRow.setName(_member.getName());
                }
                dataMap.put("shownumber", _member.getShowNumber());
                dataMap.put("pid", _member.getParentId());
                dataMap.put("longnumber", _member.getLongNumber());
                dataMap.put("level", _member.getLevel());
                dataMap.put("isleaf", _member.isLeaf());
                dataMap.put("aggoprt", _member.getAggType());
                if (SysDimensionEnum.Metric.getNumber().equals(f7Param.getDimensionNumber())) {
                    dataMap.put("isagg", _member.hasAgg() ? "1" : "0");
                    dataMap.put("use", _member.getUse());
                }
                dataMap.put("scope", NewF7Utils.getScopeStr(selectData.get("sc")));
                dataMap.put("dimNumber", f7Param.getDimensionNumber());
                NewF7Utils.dealLevel(selectData, dataMap);
                NewF7Utils.dealExclude(selectData, dataMap);
            }
        } else if (StringUtils.equals((String)"B", (String)_obj)) {
            dataMap.put("type", RangeF7PropertyCataEnum.Var.getIndex());
            dataMap.put("shownumber", selectedRow.getNumber());
            dataMap.put("scope", NewF7Utils.getScopeStr(selectData.get("sc")));
            NewF7Utils.dealExclude(selectData, dataMap);
        } else if (StringUtils.equals((String)"C", (String)_obj)) {
            dataMap.put("type", RangeF7PropertyCataEnum.Property.getIndex());
            dataMap.put("shownumber", selectedRow.getNumber());
            dataMap.put("scope", String.valueOf(RangeEnum.ONLY.getIndex()));
            dataMap.put("longnumber", selectData.get("ln"));
            CustomPropertyValue propertyValue = f7Param.getPropCache().getPropertyValue(dimension.getNumber(), IDUtils.toLong((Object)selectedRow.getPrimaryKeyValue()));
            if (propertyValue != null && propertyValue.getProp() != null) {
                dataMap.put("propid", propertyValue.getProp().getId());
                dataMap.put("propnumber", propertyValue.getProp().getNumber());
                dataMap.put("propname", propertyValue.getProp().getName());
            }
            NewF7Utils.dealExclude(selectData, dataMap);
        }
        selectedRow.setDataMap(dataMap);
        return selectedRow;
    }

    private static ListSelectedRow transSelectedRow(Map<String, String> selectData) {
        if (selectData == null || selectData.isEmpty()) {
            return null;
        }
        ListSelectedRow selectedRow = new ListSelectedRow();
        String _obj = selectData.get("id");
        if (_obj != null) {
            selectedRow.setPrimaryKeyValue((Object)IDUtils.toLong((Object)_obj));
        }
        if ((_obj = selectData.get("nu")) != null) {
            selectedRow.setNumber(_obj);
        }
        if ((_obj = selectData.get("na")) != null) {
            selectedRow.setName(_obj);
        }
        return selectedRow;
    }

    private static void dealLevel(Map<String, String> selectData, Map<String, Object> dataMap) {
        try {
            dataMap.put("scopelevel", Integer.parseInt(selectData.get("le")));
        }
        catch (Exception ex) {
            log.warn(ex.getMessage());
        }
    }

    private static void dealLevel(Map<String, String> selectData, DynamicObject object) {
        try {
            String _value = selectData.get("le");
            if (StringUtils.isNotEmpty((String)_value)) {
                object.set("scopelevel", (Object)Integer.parseInt(_value));
            }
        }
        catch (Exception ex) {
            log.info("dealLevel-error:", (Object)ex);
        }
    }

    private static void dealExclude(Map<String, String> selectData, Map<String, Object> dataMap) {
        try {
            String _value = selectData.get("ex");
            if (StringUtils.isNotEmpty((String)_value)) {
                dataMap.put("exclude", Integer.parseInt(_value));
            }
        }
        catch (Exception ex) {
            log.info("dealExclude-error:", (Object)ex);
        }
    }

    private static void dealExclude(Map<String, String> selectData, DynamicObject object) {
        try {
            String _value = selectData.get("ex");
            if (StringUtils.isNotEmpty((String)_value)) {
                object.set("exclude", (Object)Integer.parseInt(_value));
            }
        }
        catch (Exception ex) {
            log.info("dealExclude-error:", (Object)ex);
        }
    }

    private static void registerProperty(@NotNull DynamicObjectType dt, @NotNull MemberF7Parameter f7Param) {
        dt.registerSimpleProperty(new DynamicSimpleProperty("id", Long.class, null));
        dt.registerSimpleProperty(new DynamicSimpleProperty("memberid", Long.class, null));
        dt.registerSimpleProperty(new DynamicSimpleProperty("mid", Long.class, null));
        dt.registerSimpleProperty(new DynamicSimpleProperty("dimNum", String.class, null));
        dt.registerSimpleProperty(new DynamicSimpleProperty("number", String.class, null));
        dt.registerSimpleProperty(new DynamicSimpleProperty("shownumber", String.class, null));
        dt.registerSimpleProperty(new DynamicSimpleProperty("name", String.class, null));
        dt.registerSimpleProperty(new DynamicSimpleProperty("scope", String.class, null));
        dt.registerSimpleProperty(new DynamicSimpleProperty("scopelevel", Integer.class, (Object)0));
        dt.registerSimpleProperty(new DynamicSimpleProperty("pid", Long.class, null));
        dt.registerSimpleProperty(new DynamicSimpleProperty("viewid", Long.class, null));
        dt.registerSimpleProperty(new DynamicSimpleProperty("type", String.class, null));
        dt.registerSimpleProperty(new DynamicSimpleProperty("exclude", String.class, null));
        dt.registerSimpleProperty(new DynamicSimpleProperty("propid", Long.class, null));
        dt.registerSimpleProperty(new DynamicSimpleProperty("propnumber", Long.class, null));
        dt.registerSimpleProperty(new DynamicSimpleProperty("propname", Long.class, null));
        boolean isMetric = SysDimensionEnum.Metric.getNumber().equals(f7Param.getDimensionNumber());
        if (isMetric) {
            dt.registerSimpleProperty(new DynamicSimpleProperty("use", String.class, null));
        }
        if (f7Param.isReturnAllData()) {
            dt.registerSimpleProperty(new DynamicSimpleProperty("longnumber", String.class, null));
            dt.registerSimpleProperty(new DynamicSimpleProperty("level", Integer.class, null));
            dt.registerSimpleProperty(new DynamicSimpleProperty("aggoprt", String.class, null));
            if (isMetric) {
                dt.registerSimpleProperty(new DynamicSimpleProperty("isagg", String.class, null));
            }
        }
    }

    private static void registerProperty(@NotNull DynamicObjectType dt) {
        dt.registerSimpleProperty(new DynamicSimpleProperty("id", Long.class, null));
        dt.registerSimpleProperty(new DynamicSimpleProperty("number", String.class, null));
        dt.registerSimpleProperty(new DynamicSimpleProperty("name", String.class, null));
    }

    private static DynamicObject transObject(@NotNull DynamicObjectType dt, Map<String, String> selectData, @NotNull Dimension dimension, @NotNull MemberF7Parameter f7Param) {
        if (selectData == null) {
            return null;
        }
        String _obj = selectData.get("id");
        Long _id = _obj != null ? IDUtils.toLong((Object)_obj) : 0L;
        DynamicObject _object = new DynamicObject(dt);
        _object.set("id", (Object)_id);
        _object.set("mid", (Object)_id);
        _object.set("number", (Object)selectData.get("nu"));
        _object.set("name", (Object)selectData.get("na"));
        _object.set("memberid", (Object)_id);
        _object.set("viewid", (Object)f7Param.getViewId());
        _object.set("dimNum", (Object)dimension.getNumber());
        _obj = selectData.get("ty");
        if (StringUtils.equals((String)"A", (String)_obj)) {
            _object.set("type", (Object)RangeF7PropertyCataEnum.Member.getIndex());
            kd.epm.eb.common.cache.impl.Member _member = dimension.getMember(f7Param.getViewId(), _id);
            if (_member == null) {
                _member = dimension.getMember(f7Param.getViewId(), _id);
            }
            if (_member == null) {
                return null;
            }
            _object.set("shownumber", (Object)selectData.get("snu"));
            _object.set("scope", (Object)NewF7Utils.getScopeStr(selectData.get("sc")));
            NewF7Utils.dealLevel(selectData, _object);
            NewF7Utils.dealExclude(selectData, _object);
            _object.set("pid", (Object)_member.getParentId());
            boolean isMetric = SysDimensionEnum.Metric.getNumber().equals(f7Param.getDimensionNumber());
            if (isMetric) {
                _object.set("use", (Object)_member.getUse());
            }
            if (f7Param.isReturnAllData()) {
                _object.set("longnumber", (Object)_member.getLongNumber());
                _object.set("level", (Object)_member.getLevel());
                _object.set("aggoprt", (Object)_member.getAggType());
                if (isMetric) {
                    _object.set("isagg", (Object)(_member.hasAgg() ? "1" : "0"));
                }
            }
        } else if (StringUtils.equals((String)"B", (String)_obj)) {
            _object.set("type", (Object)RangeF7PropertyCataEnum.Var.getIndex());
            _object.set("shownumber", (Object)selectData.get("nu"));
            _object.set("scope", (Object)NewF7Utils.getScopeStr(selectData.get("sc")));
            NewF7Utils.dealExclude(selectData, _object);
        } else if (StringUtils.equals((String)"C", (String)_obj)) {
            _object.set("type", (Object)RangeF7PropertyCataEnum.Property.getIndex());
            _object.set("shownumber", (Object)selectData.get("nu"));
            _object.set("scope", (Object)String.valueOf(RangeEnum.ONLY.getIndex()));
            _object.set("longnumber", (Object)selectData.get("ln"));
            CustomPropertyValue propertyValue = f7Param.getPropCache().getPropertyValue(dimension.getNumber(), _id);
            if (propertyValue != null && propertyValue.getProp() != null) {
                _object.set("propid", (Object)propertyValue.getProp().getId());
                _object.set("propnumber", (Object)propertyValue.getProp().getNumber());
                _object.set("propname", (Object)propertyValue.getProp().getName());
            }
            NewF7Utils.dealExclude(selectData, _object);
        } else {
            _object.set("type", (Object)"");
        }
        return _object;
    }

    private static DynamicObject transObject(@NotNull DynamicObjectType dt, Map<String, String> selectData) {
        if (selectData == null) {
            return null;
        }
        String _obj = selectData.get("id");
        Long _id = _obj != null ? IDUtils.toLong((Object)_obj) : 0L;
        DynamicObject _object = new DynamicObject(dt);
        _object.set("id", (Object)_id);
        _object.set("number", (Object)selectData.get("nu"));
        _object.set("name", (Object)selectData.get("na"));
        return _object;
    }

    public static String getScopeStr(String scopeVal) {
        return String.valueOf(NewF7Utils.getScope(scopeVal));
    }

    public static int getScope(String scopeVal) {
        RangeEnum range = null;
        try {
            if (scopeVal != null) {
                range = RangeEnum.getRangeByVal((int)Integer.parseInt(scopeVal));
            }
        }
        catch (Exception ex) {
            log.info("getScope-error:", (Object)ex);
        }
        return range != null ? range.getIndex() : RangeEnum.ONLY.getIndex();
    }

    private static IDimensionMember transMember(Map<String, String> selectData, @NotNull Dimension dimension, @NotNull MemberF7Parameter f7Param) {
        if (selectData == null || selectData.isEmpty()) {
            return null;
        }
        DefaultDimMember member = null;
        Long _id = IDUtils.toLong((Object)selectData.get("id"));
        kd.epm.eb.common.cache.impl.Member _member = dimension.getMember(f7Param.getViewId(), _id);
        if (_member != null) {
            member = new DefaultDimMember();
            member.setId(_id);
            member.setNumber(selectData.get("nu"));
            member.setShowNumber(selectData.get("snu"));
            member.setName(selectData.get("na"));
            member.setScope(NewF7Utils.getScope(selectData.get("sc")));
            member.setLeaf(_member.isLeaf());
            member.setLongNumber(_member.getLongNumber());
            member.setType(RangeF7PropertyCataEnum.Member.getIndex());
        } else {
            CustomPropertyValue propValue = f7Param.getPropCache().getPropertyValue(dimension.getNumber(), _id);
            if (propValue != null) {
                member = new DefaultDimMember();
                member.setId(propValue.getId());
                member.setNumber(propValue.getNumber());
                member.setShowNumber(propValue.getNumber());
                member.setName(propValue.getName());
                member.setScope(RangeEnum.ONLY.getIndex());
                member.setLongNumber(propValue.getProp().getNumber() + '!' + propValue.getNumber());
                member.setType(RangeF7PropertyCataEnum.Property.getIndex());
            } else {
                DynamicObject varObj = BusinessDataServiceHelper.loadSingleFromCache((Object)_id, (String)"eb_periodvariable", (String)"id,number,name");
                if (varObj != null) {
                    member = new DefaultDimMember();
                    member.setId(Long.valueOf(varObj.getLong("id")));
                    member.setNumber(varObj.getString("number"));
                    member.setShowNumber(varObj.getString("number"));
                    member.setName(varObj.getString("name"));
                    member.setScope(NewF7Utils.getScope(selectData.get("sc")));
                    member.setLongNumber(dimension.getNumber() + '!' + member.getNumber());
                    member.setType(RangeF7PropertyCataEnum.Var.getIndex());
                }
            }
        }
        return member;
    }

    public static List<QFilter> filterF7Param(List<QFilter> filters) {
        if (filters == null || filters.isEmpty()) {
            return null;
        }
        ArrayList<QFilter> after = new ArrayList<QFilter>(filters.size());
        for (QFilter _filter : filters) {
            if (_filter.getProperty().equalsIgnoreCase("model") || _filter.getProperty().equalsIgnoreCase("dimension")) continue;
            if (_filter.getProperty().equalsIgnoreCase("dataset")) {
                if (_filter.getValue() instanceof Collection) {
                    ((Collection)_filter.getValue()).add(0L);
                }
                return after;
            }
            after.add(_filter);
        }
        return after;
    }

    public static Object returnVirtualData(MemberF7Parameter f7Param, Map<String, Map<String, String>> selectDatas) {
        if (selectDatas == null) {
            return null;
        }
        DynamicObjectCollection result = null;
        if (f7Param.isMultiSelect()) {
            if (StringUtils.equals((String)DynamicObjectCollection.class.getName(), (String)f7Param.getReturnClassName())) {
                result = NewF7Utils.getVirtualDataByDynamicObjects(selectDatas);
            } else if (StringUtils.equals((String)ListSelectedRowCollection.class.getName(), (String)f7Param.getReturnClassName())) {
                result = NewF7Utils.getVirtualDataByListSelectedRows(selectDatas);
            }
        } else if (!selectDatas.isEmpty()) {
            if (StringUtils.equals((String)DynamicObject.class.getName(), (String)f7Param.getReturnClassName())) {
                DynamicObjectCollection objects = NewF7Utils.getVirtualDataByDynamicObjects(selectDatas);
                result = objects.isEmpty() ? null : objects.get(0);
            } else if (StringUtils.equals((String)ListSelectedRowCollection.class.getName(), (String)f7Param.getReturnClassName())) {
                result = NewF7Utils.getVirtualDataByListSelectedRows(selectDatas);
            } else if (StringUtils.equals((String)ListSelectedRow.class.getName(), (String)f7Param.getReturnClassName())) {
                ListSelectedRowCollection rows = NewF7Utils.getVirtualDataByListSelectedRows(selectDatas);
                result = rows.isEmpty() ? null : rows.get(0);
            }
        }
        return result;
    }

    private static ListSelectedRowCollection getVirtualDataByListSelectedRows(Map<String, Map<String, String>> selectDatas) {
        ListSelectedRowCollection selectedRows = new ListSelectedRowCollection();
        for (Map<String, String> _select : selectDatas.values()) {
            ListSelectedRow selectedRow = NewF7Utils.transSelectedRow(_select);
            if (selectedRow == null) continue;
            selectedRows.add((Object)selectedRow);
        }
        return selectedRows;
    }

    private static DynamicObjectCollection getVirtualDataByDynamicObjects(Map<String, Map<String, String>> selectDatas) {
        DynamicObjectCollection objects = new DynamicObjectCollection();
        DynamicObjectType dt = new DynamicObjectType("PlainObject");
        NewF7Utils.registerProperty(dt);
        for (Map<String, String> select : selectDatas.values()) {
            DynamicObject object = NewF7Utils.transObject(dt, select);
            if (object == null) continue;
            objects.add((Object)object);
        }
        return objects;
    }

    public static class VirtualF7 {
        public void open(@NotNull BeforeF7SelectEvent evt, @NotNull MemberF7Parameter f7Param) {
            this.open(evt, f7Param, null);
        }

        public void open(@NotNull BeforeF7SelectEvent evt, @NotNull MemberF7Parameter f7Param, CloseCallBack closeCallBack) {
            f7Param.check();
            f7Param.setFunctionType(2);
            f7Param.setVerifyPermission(false);
            f7Param.setVerifyManagerPermission(false);
            if (evt.getSource() instanceof BasedataEdit) {
                BasedataEdit basedataEdit = (BasedataEdit)evt.getSource();
                NewF7Utils.loadFromBaseDataEdit(f7Param, evt.getOriginalValue());
                ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
                showParameter.setFormId(this.getShowFormId());
                NewF7Utils.dealListShowParameter((FormShowParameter)showParameter, f7Param, closeCallBack);
                List filters = showParameter.getListFilterParameter().getQFilters();
                filters.clear();
                filters.addAll(f7Param.listFilter().toList());
                if (basedataEdit.getSearchFilter() != null) {
                    filters.add(basedataEdit.getSearchFilter());
                }
                showParameter.getListFilterParameter().setOrderBy(f7Param.orderBy());
                if (NewF7Utils.F7_LOOKUP_LIST.equals(evt.getSourceMethod()) || NewF7Utils.F7_SET_BY_ID.equals(evt.getSourceMethod()) || NewF7Utils.F7_SET_BY_NUM.equals(evt.getSourceMethod())) {
                    NewF7Utils.cantSelectRoot(filters, f7Param);
                }
            }
        }

        public void open(@NotNull IFormView view, @NotNull MemberF7Parameter f7Param, @NotNull CloseCallBack closeCallBack) {
            f7Param.check();
            f7Param.setFunctionType(2);
            f7Param.setVerifyPermission(false);
            f7Param.setVerifyManagerPermission(false);
            FormShowParameter showParameter = this.getShowParameter();
            String pageId = view.getPageId() + "_" + f7Param.getDimensionId() + "_" + DBServiceHelper.genStringId();
            showParameter.setPageId(pageId);
            NewF7Utils.dealListShowParameter(showParameter, f7Param, closeCallBack);
            showParameter.setFormId(this.getShowFormId());
            if (showParameter instanceof ListShowParameter) {
                List filters = ((ListShowParameter)showParameter).getListFilterParameter().getQFilters();
                filters.clear();
                ((ListShowParameter)showParameter).getListFilterParameter().setOrderBy(null);
            }
            view.showForm(showParameter);
        }

        protected FormShowParameter getShowParameter() {
            return new ListShowParameter();
        }

        protected String getShowFormId() {
            return NewF7Utils.DEFAULT_LEAF_VIRTUAL_TREE;
        }
    }

    public static class F8Float
    extends F8 {
        @Override
        protected String getShowFormId() {
            return NewF7Utils.DEFAULT_LEAF_RANGE_TEMPLATE;
        }
    }

    public static class F8
    extends F7 {
        @Override
        protected FormShowParameter getShowParameter() {
            return new FormShowParameter();
        }

        @Override
        protected String getShowFormId() {
            return NewF7Utils.DEFAULT_LEAF_RANGE;
        }
    }

    public static class F7 {
        public void open(@NotNull BeforeF7SelectEvent evt, @NotNull MemberF7Parameter f7Param) {
            this.open(evt, f7Param, null);
        }

        public void open(@NotNull BeforeF7SelectEvent evt, @NotNull MemberF7Parameter f7Param, CloseCallBack closeCallBack) {
            f7Param.check();
            if (evt.getSource() instanceof BasedataEdit) {
                BasedataEdit basedataEdit = (BasedataEdit)evt.getSource();
                NewF7Utils.loadFromBaseDataEdit(f7Param, evt.getOriginalValue());
                ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
                showParameter.setFormId(this.getShowFormId());
                NewF7Utils.dealListShowParameter((FormShowParameter)showParameter, f7Param, closeCallBack);
                List filters = showParameter.getListFilterParameter().getQFilters();
                filters.clear();
                filters.addAll(f7Param.listFilter().toList());
                if (basedataEdit.getSearchFilter() != null) {
                    filters.add(basedataEdit.getSearchFilter());
                }
                showParameter.getListFilterParameter().setOrderBy(f7Param.orderBy());
                if (NewF7Utils.F7_LOOKUP_LIST.equals(evt.getSourceMethod()) || NewF7Utils.F7_SET_BY_ID.equals(evt.getSourceMethod()) || NewF7Utils.F7_SET_BY_NUM.equals(evt.getSourceMethod())) {
                    if (f7Param.isView()) {
                        DynamicObjectCollection query = QueryServiceHelper.query((String)f7Param.entityNumber(), (String)"memberid", (QFilter[])filters.toArray(new QFilter[0]), (String)f7Param.orderBy());
                        List memberIds = query.stream().map(d -> d.getLong("memberid")).collect(Collectors.toList());
                        if (memberIds.isEmpty()) {
                            memberIds.add(0L);
                        }
                        filters.clear();
                        filters.add(new QFilter("id", "in", memberIds));
                    } else {
                        NewF7Utils.cantSelectRoot(filters, f7Param);
                    }
                }
            }
        }

        public void open(@NotNull IFormView view, @NotNull MemberF7Parameter f7Param, @NotNull CloseCallBack closeCallBack) {
            f7Param.check();
            FormShowParameter showParameter = this.getShowParameter();
            String pageId = view.getPageId() + "_" + f7Param.getDimensionId() + "_" + DBServiceHelper.genStringId();
            showParameter.setPageId(pageId);
            NewF7Utils.dealListShowParameter(showParameter, f7Param, closeCallBack);
            showParameter.setFormId(this.getShowFormId());
            if (showParameter instanceof ListShowParameter) {
                List filters = ((ListShowParameter)showParameter).getListFilterParameter().getQFilters();
                filters.clear();
                filters.addAll(f7Param.listFilter().toList());
                ((ListShowParameter)showParameter).getListFilterParameter().setOrderBy(f7Param.orderBy());
            }
            view.showForm(showParameter);
        }

        protected FormShowParameter getShowParameter() {
            return new ListShowParameter();
        }

        protected String getShowFormId() {
            return NewF7Utils.DEFAULT_LEAF_LIST_VIEW;
        }
    }
}

