/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.model;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.model.entity.AbstractDimensionMemTree;
import kd.epm.eb.business.model.entity.BudgetPeriodMemTree;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.constant.BgFormConstant;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.period.BgPeriodHelper;
import org.apache.commons.lang3.tuple.Pair;

public class BudgetPeriodService {
    private static final Log log = LogFactory.getLog(BudgetPeriodService.class);
    private static final String ENTITY_NAME = "epm_bperiodmembertree";

    public static BudgetPeriodService getInstance() {
        return InnerClass.instance;
    }

    public boolean hasModifyDefault(long modelId) {
        DynamicObjectCollection periods = this.queryPeriodDynamic(modelId);
        if (periods != null) {
            for (DynamicObject period : periods) {
                String number = period.getString("number");
                BgPeriodHelper.PeriodType ptype = BgPeriodHelper.parse((String)number);
                if (ptype == null) continue;
                if (ptype.getType() == 4) {
                    if (period.getInt("effday") == 1 && period.getInt("effmonth") == ptype.getPeriod()) continue;
                    return true;
                }
                Date startDate = period.getDate("startdate");
                Calendar c = Calendar.getInstance();
                c.setTime(startDate);
                if (c.get(1) == ptype.getYear()) continue;
                return true;
            }
        }
        return false;
    }

    private DynamicObjectCollection queryPeriodDynamic(long modelId) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("number", "!=", (Object)SysDimensionEnum.BudgetPeriod.getNumber());
        return QueryServiceHelper.query((String)ENTITY_NAME, (String)"id,name,number,effmonth,effday,startdate", (QFilter[])new QFilter[]{qFilter}, (String)"number");
    }

    private DynamicObjectCollection queryRootChildren(long modelId, long rootId) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("parent", "=", (Object)rootId);
        return QueryServiceHelper.query((String)ENTITY_NAME, (String)"id,number,startdate", (QFilter[])new QFilter[]{qFilter}, (String)"number");
    }

    public DynamicObject queryPeriodObj(long id) {
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)ENTITY_NAME);
    }

    public DynamicObject getFirstPeriod(long modelId) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        Member firstMember = (Member)modelCache.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), null, SysDimensionEnum.BudgetPeriod.getNumber()).getChildrenBySort().get(0);
        return this.queryPeriodObj(firstMember.getId());
    }

    public List<DynamicObject> getDefaultPeriodObj(long modelId) {
        Pair<Dimension, Member> memberPair = this.getRootMember(modelId);
        Dimension dimension = (Dimension)memberPair.getLeft();
        Member rootMember = (Member)memberPair.getRight();
        Pair<Integer, Integer> pair = this.getStartYearAndLength(modelId, rootMember);
        int startYear = (Integer)pair.getLeft();
        int periodLength = (Integer)pair.getRight();
        return this.createSysPeriodObj(startYear, periodLength, modelId, dimension.getId(), rootMember.getId(), rootMember.getNumber(), rootMember.getLongNumber());
    }

    private Pair<Dimension, Member> getRootMember(long modelId) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        Dimension dimension = modelCache.getDimension(SysDimensionEnum.BudgetPeriod.getNumber());
        List rootMemberList = dimension.getRootMember();
        Member rootMember = (Member)rootMemberList.get(0);
        return Pair.of((Object)dimension, (Object)rootMember);
    }

    private Pair<Integer, Integer> getStartYearAndLength(long modelId, Member rootMember) {
        DynamicObjectCollection rootChildren = this.queryRootChildren(modelId, rootMember.getId());
        DynamicObject firstMember = (DynamicObject)rootChildren.get(0);
        DynamicObject lastMember = (DynamicObject)rootChildren.get(rootChildren.size() - 1);
        BgPeriodHelper.PeriodType firstPeriodType = BgPeriodHelper.parse((String)firstMember.getString("number"));
        BgPeriodHelper.PeriodType lastPeriodType = BgPeriodHelper.parse((String)lastMember.getString("number"));
        assert (firstPeriodType != null);
        assert (lastPeriodType != null);
        int startYear = firstPeriodType.getYear();
        int endYear = lastPeriodType.getYear();
        int periodLength = endYear - startYear + 1;
        return Pair.of((Object)startYear, (Object)periodLength);
    }

    private List<DynamicObject> createSysPeriodObj(int startYear, int periodLength, long modelId, long dimensionId, long parentId, String parentNumber, String parentLongNumber) {
        int endYear = startYear + periodLength;
        BudgetPeriodMemTree budgetPeriodMemTree = new BudgetPeriodMemTree(this.getModelObj(modelId), this.getDimensionObj(dimensionId));
        budgetPeriodMemTree.setNumber(parentNumber);
        budgetPeriodMemTree.setLongnumber(parentLongNumber);
        budgetPeriodMemTree.initYearTree(startYear, endYear, 1);
        budgetPeriodMemTree.initPeriodTree(1, true, true, true);
        ArrayList<DynamicObject> periodObjList = new ArrayList<DynamicObject>(periodLength * 19);
        for (AbstractDimensionMemTree treeNode : budgetPeriodMemTree.getChildren()) {
            treeNode.setParent(parentId);
            this.init(treeNode, periodObjList);
        }
        return periodObjList;
    }

    private void init(AbstractDimensionMemTree treeNode, List<DynamicObject> periodObjList) {
        periodObjList.add(treeNode.initToDyna());
        for (AbstractDimensionMemTree child : treeNode.getChildren()) {
            this.init(child, periodObjList);
        }
    }

    private DynamicObject getModelObj(long modelId) {
        return BusinessDataServiceHelper.loadSingle((Object)modelId, (String)"epm_model");
    }

    private DynamicObject getDimensionObj(long dimensionId) {
        return BusinessDataServiceHelper.loadSingle((Object)dimensionId, (String)"epm_dimension");
    }

    public void modifyStartDate(long modelId, DynamicObject firstPeriod) {
        Pair<Dimension, Member> pair = this.getRootMember(modelId);
        Member rootMember = (Member)pair.getRight();
        DynamicObjectCollection rootChildren = this.queryRootChildren(modelId, rootMember.getId());
        DynamicObject afterAddFirstMember = (DynamicObject)rootChildren.get(0);
        BgPeriodHelper.PeriodType firstPeriodType = BgPeriodHelper.parse((String)firstPeriod.getString("number"));
        assert (firstPeriodType != null);
        BgPeriodHelper.PeriodType afterAddPeriodType = BgPeriodHelper.parse((String)afterAddFirstMember.getString("number"));
        assert (afterAddPeriodType != null);
        Calendar c = Calendar.getInstance();
        c.setTime(firstPeriod.getDate("startdate"));
        int startYear = c.get(1);
        int startMonth = c.get(2) + 1;
        int startDay = c.get(5);
        if (afterAddPeriodType.getYear() < firstPeriodType.getYear()) {
            int offsetYear = startYear - firstPeriodType.getYear();
            c.setTime(afterAddFirstMember.getDate("startdate"));
            c.set(1, offsetYear + c.get(1));
            c.set(2, startMonth - 1);
            c.set(5, startDay);
        }
        this.modifyStartDate(modelId, c.getTime());
    }

    public void modifyStartDate(long modelId, Date startDate) {
        Pair<Dimension, Member> memberPair = this.getRootMember(modelId);
        Member rootMember = (Member)memberPair.getRight();
        Pair<Integer, Integer> pair = this.getStartYearAndLength(modelId, rootMember);
        int periodLength = (Integer)pair.getRight();
        List<DynamicObject> periodObjList = this.getDefaultPeriodObj(modelId);
        Calendar c = Calendar.getInstance();
        c.setTime(startDate);
        int startYear = c.get(1);
        int startMonth = c.get(2) + 1;
        int startDay = c.get(5);
        this.resetStartDate(startYear, startMonth, startDay, periodLength, periodObjList);
        this.updateStartDate(modelId, periodObjList);
        ModelCacheContext.removeModel((Long)modelId);
    }

    private void resetStartDate(int startYear, int startMonth, int startDay, int periodLength, List<DynamicObject> periodDyObjList) {
        LocalDateTime startDate = LocalDateTime.of(startYear, startMonth, startDay, 0, 0, 0, 0);
        LocalDateTime endDate = startDate.plusYears(periodLength).minusSeconds(1L);
        ArrayList<Pair> yearList = new ArrayList<Pair>(periodLength);
        ArrayList<Pair> halfYearList = new ArrayList<Pair>(periodLength * 2);
        ArrayList<Pair> quarterList = new ArrayList<Pair>(periodLength * 4);
        ArrayList<Pair> monthList = new ArrayList<Pair>(periodLength * 12);
        LocalDateTime currentMonthStart = startDate;
        while (!currentMonthStart.isAfter(endDate)) {
            LocalDateTime currentMonthEnd = currentMonthStart.plusMonths(1L).minusSeconds(1L);
            monthList.add(Pair.of((Object)currentMonthStart, (Object)currentMonthEnd));
            currentMonthStart = currentMonthStart.plusMonths(1L);
        }
        LocalDateTime currentQuarterStart = startDate;
        while (!currentQuarterStart.isAfter(endDate)) {
            LocalDateTime currentQuarterEnd = currentQuarterStart.plusMonths(3L).minusSeconds(1L);
            quarterList.add(Pair.of((Object)currentQuarterStart, (Object)currentQuarterEnd));
            currentQuarterStart = currentQuarterStart.plusMonths(3L);
        }
        LocalDateTime currentHalfYearStart = startDate;
        while (!currentHalfYearStart.isAfter(endDate)) {
            LocalDateTime currentHalfYearEnd = currentHalfYearStart.plusMonths(6L).minusSeconds(1L);
            halfYearList.add(Pair.of((Object)currentHalfYearStart, (Object)currentHalfYearEnd));
            currentHalfYearStart = currentHalfYearStart.plusMonths(6L);
        }
        LocalDateTime currentYearStart = startDate;
        while (!currentYearStart.isAfter(endDate)) {
            LocalDateTime currentYearEnd = currentYearStart.plusYears(1L).minusSeconds(1L);
            yearList.add(Pair.of((Object)currentYearStart, (Object)currentYearEnd));
            currentYearStart = currentYearStart.plusYears(1L);
        }
        AtomicInteger yearIndex = new AtomicInteger(0);
        AtomicInteger halfYearIndex = new AtomicInteger(0);
        AtomicInteger quarterIndex = new AtomicInteger(0);
        AtomicInteger monthIndex = new AtomicInteger(0);
        ZoneId zoneId = ZoneId.systemDefault();
        periodDyObjList.forEach(dyObj -> {
            Pair datePair;
            String number = dyObj.getString("number");
            BgPeriodHelper.PeriodType periodType = BgPeriodHelper.parse((String)number);
            if (periodType == null) {
                return;
            }
            switch (periodType.getType()) {
                case 1: {
                    datePair = (Pair)yearList.get(yearIndex.getAndIncrement());
                    break;
                }
                case 2: {
                    datePair = (Pair)halfYearList.get(halfYearIndex.getAndIncrement());
                    break;
                }
                case 3: {
                    datePair = (Pair)quarterList.get(quarterIndex.getAndIncrement());
                    break;
                }
                default: {
                    datePair = (Pair)monthList.get(monthIndex.getAndIncrement());
                }
            }
            LocalDateTime start = (LocalDateTime)datePair.getLeft();
            LocalDateTime end = (LocalDateTime)datePair.getRight();
            int effMonth = start.getMonthValue();
            int effDay = start.getDayOfMonth();
            int expMonth = end.getMonthValue();
            int expDay = end.getDayOfMonth();
            Date periodStartDate = Date.from(start.atZone(zoneId).toInstant());
            Date periodEndDate = Date.from(end.atZone(zoneId).toInstant());
            dyObj.set("effmonth", (Object)effMonth);
            dyObj.set("effday", (Object)effDay);
            dyObj.set("expmonth", (Object)expMonth);
            dyObj.set("expday", (Object)expDay);
            dyObj.set("startdate", (Object)periodStartDate);
            dyObj.set("enddate", (Object)periodEndDate);
            dyObj.set("effdate", (Object)ResManager.loadResFormat((String)"%1\u6708%2\u65e5", (String)"BudgetPeriodMemTree_6", (String)"epm-eb-business", (Object[])new Object[]{start.getMonthValue(), start.getDayOfMonth()}));
            dyObj.set("expdate", (Object)ResManager.loadResFormat((String)"%1\u6708%2\u65e5", (String)"BudgetPeriodMemTree_6", (String)"epm-eb-business", (Object[])new Object[]{end.getMonthValue(), end.getDayOfMonth()}));
        });
    }

    public void updateStartDate(long modelId, List<DynamicObject> periodDyObjList) {
        long updateUserId = RequestContext.get().getCurrUserId();
        Date updateTime = new Date();
        try (TXHandle th = TX.required();){
            try {
                String sql = "update t_eb_structofbperiod set feffdate=?, fexpdate=?, feffmonth=?, feffday=?, fexpmonth=?, fexpday=?, fstartdate=?, fenddate=?, fmodifierid=?, fmodifytime=? where fnumber = ? and fmodelid = ?";
                List values = periodDyObjList.stream().map(dyObj -> {
                    Object[] oneRowVal = new Object[12];
                    int index = 0;
                    oneRowVal[index++] = dyObj.getString("effdate");
                    oneRowVal[index++] = dyObj.getString("expdate");
                    oneRowVal[index++] = dyObj.getInt("effmonth");
                    oneRowVal[index++] = dyObj.getInt("effday");
                    oneRowVal[index++] = dyObj.getInt("expmonth");
                    oneRowVal[index++] = dyObj.getInt("expday");
                    oneRowVal[index++] = dyObj.getDate("startdate");
                    oneRowVal[index++] = dyObj.getDate("enddate");
                    oneRowVal[index++] = updateUserId;
                    oneRowVal[index++] = updateTime;
                    oneRowVal[index++] = dyObj.getString("number");
                    oneRowVal[index] = modelId;
                    return oneRowVal;
                }).collect(Collectors.toList());
                DB.executeBatch((DBRoute)BgFormConstant.DBROUTE, (String)sql, values);
            }
            catch (Exception e) {
                th.markRollback();
                log.error(e.getMessage());
                throw new KDBizException(e.getMessage());
            }
        }
    }

    private static class InnerClass {
        private static final BudgetPeriodService instance = new BudgetPeriodService();

        private InnerClass() {
        }
    }
}

