/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.model.entity;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.model.entity.DimensionMember;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MemberSourceEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.model.interfaces.IDimensionComponent;
import kd.epm.eb.model.interfaces.IInitSpecialTree;
import kd.epm.eb.model.interfaces.ISaveTreeAndOlap;
import org.apache.commons.collections4.CollectionUtils;

public abstract class AbstractDimensionMemTree
implements IDimensionComponent,
ISaveTreeAndOlap,
IInitSpecialTree {
    private static final long serialVersionUID = 1L;
    private List<AbstractDimensionMemTree> children = new ArrayList<AbstractDimensionMemTree>();
    private Long id = GlobalIdUtil.genGlobalLongId();
    protected Object dimension;
    protected DynamicObject model;
    private String name;
    private String nameKey;
    private String number;
    private String aggoprt;
    private Long parent = 0L;
    private boolean isleaf = true;
    private int dseq = 1;
    private int level = 1;
    private String longnumber;
    private String membersource = MemberSourceEnum.PRESET.getIndex();
    private String status = "C";
    private String enable = "1";
    private DynamicObject creator;
    private DynamicObject modifier;
    private Date createtime;
    private Date modifytime;
    private String storagetype;

    public AbstractDimensionMemTree() {
    }

    public AbstractDimensionMemTree(DynamicObject model, Object dimension) {
        this.model = model;
        this.dimension = dimension;
        this.checkDyn(dimension);
    }

    private final void checkDyn(Object dimension) {
        if (!(dimension instanceof DynamicObject)) {
            this.dimension = ((IDimensionComponent)dimension).initToDyna();
        }
    }

    @Override
    public String getDynaEntityname() {
        return ((DynamicObject)this.dimension).getString("membermodel");
    }

    @Override
    public DynamicObject initToDyna() {
        this.initDimensionMem();
        return IDimensionComponent.super.initToDyna();
    }

    @Override
    public void initSpecialTrees() {
    }

    private void initDimensionMem() {
        this.creator = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
        this.creator.set("id", (Object)UserUtils.getUserId());
        this.modifier = this.creator;
        this.createtime = this.modifytime = TimeServiceHelper.now();
        new DimensionMem().initToDyna();
    }

    @Override
    public void actionSaveTreeMemAndOlap() {
        ArrayList<DynamicObject> dotmembertrees = new ArrayList<DynamicObject>();
        HashMap<String, DynamicObject> dotmembers = new HashMap<String, DynamicObject>();
        ArrayList<String> numbers = new ArrayList<String>();
        DynamicObject dimensionobj = (DynamicObject)this.getDimension();
        this.iteratorTrees(this, dotmembertrees, dotmembers, numbers);
        numbers.remove("CNone");
        numbers.remove("ICNone");
        numbers.remove("PRONone");
        numbers.remove("BPNone");
        numbers.remove("MBNone");
        numbers.remove("PJNone");
        numbers.remove("VNone");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dimensionobj});
        SaveServiceHelper.save((DynamicObject[])dotmembers.values().toArray(new DynamicObject[0]));
        SaveServiceHelper.save((DynamicObject[])dotmembertrees.toArray(new DynamicObject[0]));
    }

    private void iteratorTrees(AbstractDimensionMemTree tree, List<DynamicObject> dotmembertrees, Map<String, DynamicObject> dotmembers, List<String> numbers) {
        this.saveData(tree, dotmembertrees, dotmembers, numbers);
        if (CollectionUtils.isNotEmpty(dotmembertrees)) {
            for (DynamicObject dotMemberTree : dotmembertrees) {
                if (!dotMemberTree.getDynamicObjectType().getProperties().containsKey((Object)"shownumber")) continue;
                dotMemberTree.set("shownumber", (Object)dotMemberTree.getString("number"));
            }
        }
        Iterator<Object> iterator = tree.getChildren().iterator();
        while (iterator.hasNext()) {
            AbstractDimensionMemTree atree;
            AbstractDimensionMemTree btree = atree = (AbstractDimensionMemTree)iterator.next();
            this.iteratorTrees(btree, dotmembertrees, dotmembers, numbers);
        }
    }

    private void saveData(AbstractDimensionMemTree tree, List<DynamicObject> dotmembertrees, Map<String, DynamicObject> dotmembers, List<String> numbers) {
        if (numbers.contains(tree.getNumber())) {
            return;
        }
        DynamicObject dot = tree.initToDyna();
        numbers.add(tree.getNumber());
        if (((DynamicObject)tree.getDimension()).getString("number").equals(SysDimensionEnum.Entity.getNumber())) {
            if (!tree.getNumber().equals(SysDimensionEnum.Entity.getNumber()) && !tree.getNumber().equals("RatePreset")) {
                numbers.add(SysDimensionEnum.Entity.getNumber() + "_" + tree.getNumber());
            }
        } else if (((DynamicObject)tree.getDimension()).getString("number").equals(SysDimensionEnum.Metric.getNumber()) && (MetricDataTypeEnum.CURRENCY.getIndex().equals(dot.getString("datatype")) || MetricDataTypeEnum.RATE.getIndex().equals(dot.getString("datatype")))) {
            dot.set("decimalnum", (Object)2);
        }
        dotmembertrees.add(dot);
    }

    public List<AbstractDimensionMemTree> getChildren() {
        return this.children;
    }

    public void setChildren(List<AbstractDimensionMemTree> children) {
        this.children = children;
    }

    public String getAggoprt() {
        return this.aggoprt;
    }

    public void setAggoprt(String aggoprt) {
        this.aggoprt = aggoprt;
    }

    public Object getDimension() {
        return this.dimension;
    }

    public DynamicObject getModel() {
        return this.model;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNameKey(String nameKey) {
        this.nameKey = nameKey;
    }

    public String getNameKey() {
        return this.nameKey;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public Long getParent() {
        return this.parent;
    }

    public void setParent(Long parent) {
        this.parent = parent;
    }

    public boolean getIsleaf() {
        return this.isleaf;
    }

    public void setIsleaf(boolean isleaf) {
        this.isleaf = isleaf;
    }

    public int getDseq() {
        return this.dseq;
    }

    public void setDseq(int dseq) {
        this.dseq = dseq;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public String getLongnumber() {
        return this.longnumber;
    }

    public void setLongnumber(String longnumber) {
        this.longnumber = longnumber;
    }

    public void setDimension(Object dimension) {
        this.dimension = dimension;
        this.checkDyn(dimension);
    }

    public void setModel(DynamicObject model) {
        this.model = model;
    }

    public Long getId() {
        return this.id;
    }

    public Object readResolve() {
        this.id = GlobalIdUtil.genGlobalLongId();
        return this;
    }

    public String getMembersource() {
        return this.membersource;
    }

    public void setMembersource(String membersource) {
        this.membersource = membersource;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getEnable() {
        return this.enable;
    }

    public void setEnable(String enable) {
        this.enable = enable;
    }

    public DynamicObject getCreator() {
        return this.creator;
    }

    public void setCreator(DynamicObject creator) {
        this.creator = creator;
    }

    public DynamicObject getModifier() {
        return this.modifier;
    }

    public void setModifier(DynamicObject modifier) {
        this.modifier = modifier;
    }

    public Date getCreatetime() {
        return this.createtime;
    }

    public void setCreatetime(Date createtime) {
        this.createtime = createtime;
    }

    public Date getModifytime() {
        return this.modifytime;
    }

    public void setModifytime(Date modifytime) {
        this.modifytime = modifytime;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getStoragetype() {
        return this.storagetype;
    }

    public void setStoragetype(String storagetype) {
        this.storagetype = storagetype;
    }

    protected AbstractDimensionMemTree searchTree(AbstractDimensionMemTree roottreemodel, String treeNumber) {
        IDimensionComponent child;
        if (treeNumber.equals(roottreemodel.getNumber())) {
            return roottreemodel;
        }
        AbstractDimensionMemTree truetree = null;
        Iterator<AbstractDimensionMemTree> iterator = roottreemodel.getChildren().iterator();
        while (iterator.hasNext() && (truetree = this.searchTree(roottreemodel = (AbstractDimensionMemTree)(child = (IDimensionComponent)iterator.next()), treeNumber)) == null) {
        }
        return truetree;
    }

    private class DimensionMem
    extends DimensionMember {
        public DimensionMem() {
            this.setName(AbstractDimensionMemTree.this.name);
            this.setNumber(AbstractDimensionMemTree.this.number);
            AbstractDimensionMemTree.this.checkDyn(AbstractDimensionMemTree.this.dimension);
            this.setDimension(AbstractDimensionMemTree.this.dimension);
            this.setModel(AbstractDimensionMemTree.this.model);
        }
    }
}

