/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.model.entity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.lang.Lang;
import kd.epm.eb.business.model.entity.AbstractDimensionMemTree;
import kd.epm.eb.common.enums.PresetPeriodEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.resource.ResUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.model.interfaces.IInitSpecialTree;

public class BudgetPeriodMemTree
extends AbstractDimensionMemTree
implements IInitSpecialTree {
    private int effmonth;
    private int effday;
    private int expmonth;
    private int expday;
    private Date startDate;
    private Date endDate;
    private String effdate;
    private String expdate;
    public ILocaleString langName = null;
    private static final long serialVersionUID = 1L;

    public void setLangName(ILocaleString langName) {
        this.langName = langName;
    }

    public ILocaleString getLangName() {
        return this.langName;
    }

    private int[] getDayOfMonth() {
        return new int[]{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    }

    public BudgetPeriodMemTree() {
    }

    public BudgetPeriodMemTree(DynamicObject model, Object dimension) {
        super(model, dimension);
    }

    public int getEffmonth() {
        return this.effmonth;
    }

    public void setEffmonth(int effmonth) {
        this.effmonth = effmonth;
    }

    public int getEffday() {
        return this.effday;
    }

    public void setEffday(int effday) {
        this.effday = effday;
    }

    public int getExpmonth() {
        return this.expmonth;
    }

    public void setExpmonth(int expmonth) {
        this.expmonth = expmonth;
    }

    public int getExpday() {
        return this.expday;
    }

    public void setExpday(int expday) {
        this.expday = expday;
    }

    public String getEffdate() {
        return this.effdate;
    }

    public void setEffdate(String effdate) {
        this.effdate = effdate;
    }

    public String getExpdate() {
        return this.expdate;
    }

    public void setExpdate(String expdate) {
        this.expdate = expdate;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    @Override
    public void initSpecialTrees() {
        String sysperiod = this.model.getString("sysperiod");
        String startYearSeq = this.model.getString("startfy");
        int firstYear = 1997;
        int startYear = Integer.parseInt(startYearSeq) + firstYear - 1;
        int presetyear = this.model.getInt("presetyear");
        int M_Year_StartM = this.model.getInt("beginperiod");
        int endyear = startYear + presetyear;
        this.initYearTree(startYear, endyear, M_Year_StartM);
        int beginPeriod = this.model.getInt("beginperiod");
        if (String.valueOf(PresetPeriodEnum.MONTH.getIndex()).equals(sysperiod)) {
            this.initPeriodTree(beginPeriod, true, true, true);
        } else if (String.valueOf(PresetPeriodEnum.QUARTER.getIndex()).equals(sysperiod)) {
            this.initPeriodTree(beginPeriod, true, true, false);
        } else if (String.valueOf(PresetPeriodEnum.HALFYEAR.getIndex()).equals(sysperiod)) {
            this.initPeriodTree(beginPeriod, true, false, false);
        }
    }

    public void initPeriodTree(int beginPeriod, boolean cludeHalfYear, boolean cludeQrt, boolean cludeMonth) {
        String number;
        LocaleString langName;
        int i;
        AbstractDimensionMemTree[] hfyear = new AbstractDimensionMemTree[2];
        AbstractDimensionMemTree[] qrtyear = new AbstractDimensionMemTree[4];
        ArrayList<BudgetPeriodMemTree> roots = new ArrayList<BudgetPeriodMemTree>();
        AbstractDimensionMemTree parent = null;
        String RESOURCE_PATCH = "bgmdxml.bgmd.BudgetPeriod_insert.xml.BudgetPeriod.";
        String DEFAULT_YEAR = "9999";
        if (cludeHalfYear) {
            for (i = 1; i <= 2; ++i) {
                int hf_startM = this.getMonth(beginPeriod, (i - 1) * 6);
                int hf_startD = 1;
                int hf_endM = this.getMonth(hf_startM, 5);
                int hf_endD = this.getDayOfMonth()[hf_endM];
                langName = i == 1 ? ResManager.getLocaleString((String)"%1\u5e74\u4e0a\u534a\u5e74", (String)"bgmdxml.bgmd.BudgetPeriod_insert.xml.BudgetPeriod.HF1", (String)"epm-eb-business") : ResManager.getLocaleString((String)"%1\u5e74\u4e0b\u534a\u5e74", (String)"bgmdxml.bgmd.BudgetPeriod_insert.xml.BudgetPeriod.HF2", (String)"epm-eb-business");
                langName = ResUtils.loadLocale((ILocaleString)langName, (Object[])new Object[]{DEFAULT_YEAR});
                number = "HF" + i;
                BudgetPeriodMemTree p = this.setPeriodValue((ILocaleString)langName, number, parent, hf_startM, hf_startD, hf_endM, hf_endD, i);
                hfyear[i - 1] = p;
                if (parent != null) continue;
                roots.add(p);
            }
        }
        if (cludeQrt) {
            for (i = 1; i < 5; ++i) {
                parent = cludeHalfYear ? (i == 1 || i == 2 ? hfyear[0] : hfyear[1]) : null;
                int Q_startM = this.getMonth(beginPeriod, (i - 1) * 3);
                int Q_startD = 1;
                int Q_endM = this.getMonth(Q_startM, 2);
                int Q_endD = this.getDayOfMonth()[Q_endM];
                number = "Q" + i;
                langName = ResManager.getLocaleString((String)"%1\u5e74%2\u5b63\u5ea6", (String)(RESOURCE_PATCH + "Q"), (String)"epm-eb-business");
                langName = ResUtils.loadLocale((ILocaleString)langName, (Object[])new Object[]{DEFAULT_YEAR, i});
                BudgetPeriodMemTree qrt = this.setPeriodValue((ILocaleString)langName, number, parent, Q_startM, Q_startD, Q_endM, Q_endD, i);
                qrtyear[i - 1] = qrt;
                if (parent != null) continue;
                roots.add(qrt);
            }
        }
        if (cludeMonth) {
            int count = 12;
            for (int i2 = 1; i2 <= count; ++i2) {
                parent = cludeQrt ? (i2 <= 3 ? qrtyear[0] : (i2 <= 6 ? qrtyear[1] : (i2 <= 9 ? qrtyear[2] : qrtyear[3]))) : (cludeHalfYear ? (i2 <= 6 ? hfyear[0] : hfyear[1]) : null);
                int M_startM = this.getMonth(beginPeriod, (i2 - 1) * 1);
                int M_startD = 1;
                int M_endM = M_startM;
                int Q_endD = this.getDayOfMonth()[M_endM];
                String number2 = "M0" + i2;
                if (i2 >= 10) {
                    number2 = "M" + i2;
                }
                langName = ResManager.getLocaleString((String)"%1\u5e74%2\u6708", (String)(RESOURCE_PATCH + "M"), (String)"epm-eb-business");
                langName = ResUtils.loadLocale((ILocaleString)langName, (Object[])new Object[]{DEFAULT_YEAR, i2});
                BudgetPeriodMemTree mq = this.setPeriodValue((ILocaleString)langName, number2, parent, M_startM, M_startD, M_endM, Q_endD, i2);
                if (parent != null) continue;
                roots.add(mq);
            }
        }
        for (AbstractDimensionMemTree yearTree : this.getChildren()) {
            for (BudgetPeriodMemTree root : roots) {
                int year = Integer.parseInt(yearTree.getNumber().replaceAll("FY", ""));
                yearTree.getChildren().add(this.copyTree(root, (BudgetPeriodMemTree)yearTree, yearTree.getName(), year));
            }
            yearTree.setName(this.transName(yearTree.getName(), yearTree.getNumber()));
            ((BudgetPeriodMemTree)yearTree).setEffdate(this.transData(((BudgetPeriodMemTree)yearTree).getEffdate()));
            ((BudgetPeriodMemTree)yearTree).setExpdate(this.transData(((BudgetPeriodMemTree)yearTree).getExpdate()));
        }
    }

    private BudgetPeriodMemTree copyTree(BudgetPeriodMemTree periodTree, BudgetPeriodMemTree parentTree, String yearName, int year) {
        if (periodTree == null || parentTree == null) {
            return null;
        }
        BudgetPeriodMemTree returnTree = this.getTreeModel();
        returnTree.setName(this.transName(yearName + periodTree.getName(), periodTree.getNumber()));
        if (periodTree.getLangName() != null) {
            LocaleString clone = new LocaleString();
            for (String langString : periodTree.getLangName().keySet()) {
                String name = (String)periodTree.getLangName().get((Object)langString);
                if (name == null) continue;
                clone.setItem(langString, (Object)name.replaceFirst("9999", String.valueOf(year)));
            }
            returnTree.setLangName((ILocaleString)clone);
        }
        returnTree.setNumber("FY" + year + "." + periodTree.getNumber());
        returnTree.setAggoprt(periodTree.getAggoprt());
        returnTree.setIsleaf(periodTree.getIsleaf());
        returnTree.setEffmonth(periodTree.getEffmonth());
        returnTree.setEffday(periodTree.getEffday());
        returnTree.setExpmonth(periodTree.getExpmonth());
        if (periodTree.getExpmonth() == 2 && this.isleapyear(year)) {
            returnTree.setExpday(29);
            returnTree.setExpdate(periodTree.getExpdate().replaceAll("28", "29"));
        } else {
            returnTree.setExpdate(periodTree.getExpdate());
            returnTree.setExpday(periodTree.getExpday());
        }
        returnTree.setEffdate(this.transData(periodTree.getEffdate()));
        returnTree.setStartDate(this.createDate(year, returnTree.getEffmonth(), returnTree.getEffday(), true));
        returnTree.setEndDate(this.createDate(year, returnTree.getExpmonth(), returnTree.getExpday(), false));
        returnTree.setParent(parentTree.getId());
        returnTree.setLevel(parentTree.getLevel() + 1);
        StringBuilder _seq = new StringBuilder(7);
        _seq.append(year).append(returnTree.getLevel());
        if (periodTree.getDseq() < 10) {
            _seq.append(0).append(periodTree.getDseq());
        } else {
            _seq.append(periodTree.getDseq());
        }
        returnTree.setDseq(Integer.parseInt(_seq.toString()));
        returnTree.setLongnumber(parentTree.getLongnumber() + "!" + returnTree.getNumber());
        for (AbstractDimensionMemTree child : periodTree.getChildren()) {
            returnTree.getChildren().add(this.copyTree((BudgetPeriodMemTree)child, returnTree, yearName, year));
        }
        return returnTree;
    }

    private String transData(String dataName) {
        return dataName;
    }

    private String transName(String name, String number) {
        return name;
    }

    private boolean isleapyear(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    private int getMonth(int month, int differ) {
        return month + differ >= 13 ? month + differ - 12 : month + differ;
    }

    public void initYearTree(int startYear, int endyear, int startMonth) {
        int M_Year_EndM = this.getMonth(startMonth, 11);
        int M_Year_EndD = this.getDayOfMonth()[M_Year_EndM];
        int M_Year_StartD = 1;
        ArrayList needYearLangStringList = Lists.newArrayList((Object[])new String[]{Lang.zh_CN.name(), Lang.zh_TW.name()});
        for (int actualYear = startYear; actualYear < endyear; ++actualYear) {
            String number = "FY" + actualYear;
            LocaleString langName = ResManager.getLocaleString((String)"%1\u5e74", (String)"bgmdxml.bgmd.BudgetPeriod_insert.xml.BudgetPeriod.FY", (String)"epm-eb-business");
            langName = ResUtils.loadLocale((ILocaleString)langName, (Object[])new Object[]{actualYear});
            for (String lang : langName.keySet()) {
                if (needYearLangStringList.contains(lang)) continue;
                langName.setItem(lang, (Object)Convert.toStr((Object)actualYear));
            }
            BudgetPeriodMemTree fy = this.setPeriodValue((ILocaleString)langName, number, this, startMonth, M_Year_StartD, M_Year_EndM, M_Year_EndD, actualYear);
            fy.setIsleaf(false);
            fy.setLevel(this.getLevel() + 1);
            fy.setParent(this.getId());
            fy.setStartDate(this.createDate(actualYear, startMonth, M_Year_StartD, true));
            fy.setEndDate(this.createDate(actualYear, M_Year_EndM, M_Year_EndD, false));
            fy.setLongnumber(this.getLongnumber() + "!" + number);
        }
    }

    private Date createDate(int actualYear, int month, int day, boolean isStart) {
        if (isStart) {
            GregorianCalendar calendar = new GregorianCalendar(actualYear, month - 1, day, 0, 0, 0);
            return calendar.getTime();
        }
        GregorianCalendar calendar = new GregorianCalendar(actualYear, month - 1, day, 23, 59, 59);
        return calendar.getTime();
    }

    private BudgetPeriodMemTree setPeriodValue(ILocaleString name, String number, AbstractDimensionMemTree fyparent, int hf_startM, int hf_startD, int hf_endM, int hf_endD, int dseq) {
        BudgetPeriodMemTree pt_f1 = this.getTreeModel();
        pt_f1.setLangName(name);
        pt_f1.setNumber(number);
        pt_f1.setAggoprt("1");
        pt_f1.setDseq(dseq);
        pt_f1.setIsleaf(true);
        pt_f1.setEffmonth(hf_startM);
        pt_f1.setEffday(hf_startD);
        pt_f1.setExpmonth(hf_endM);
        pt_f1.setExpday(hf_endD);
        pt_f1.setEffdate(ResManager.loadResFormat((String)"%1\u6708%2\u65e5", (String)"BudgetPeriodMemTree_6", (String)"epm-eb-business", (Object[])new Object[]{hf_startM, hf_startD}));
        pt_f1.setExpdate(ResManager.loadResFormat((String)"%1\u6708%2\u65e5", (String)"BudgetPeriodMemTree_6", (String)"epm-eb-business", (Object[])new Object[]{hf_endM, hf_endD}));
        if (fyparent != null) {
            fyparent.setIsleaf(false);
            fyparent.getChildren().add(pt_f1);
        }
        return pt_f1;
    }

    private BudgetPeriodMemTree getTreeModel() {
        BudgetPeriodMemTree ye = new BudgetPeriodMemTree();
        ye.setDimension(this.getDimension());
        ye.setModel(this.getModel());
        return ye;
    }

    @Override
    public String getDimensionNumber() {
        return SysDimensionEnum.BudgetPeriod.getNumber();
    }
}

