/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.model.entity;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.epm.eb.business.model.entity.AbstractDimensionMemTree;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.resource.ResUtils;

public class PeriodMemTree
extends AbstractDimensionMemTree {
    private int effmonth;
    private int effday;
    private int expmonth;
    private int expday;
    private String effdate;
    private String expdate;
    private static final long serialVersionUID = 1L;
    public ILocaleString langName = null;

    public void setLangName(ILocaleString langName) {
        this.langName = langName;
    }

    public ILocaleString getLangName() {
        return this.langName;
    }

    public PeriodMemTree() {
    }

    public PeriodMemTree(DynamicObject model, Object dimension) {
        super(model, dimension);
    }

    public int getEffmonth() {
        return this.effmonth;
    }

    public void setEffmonth(int effmonth) {
        this.effmonth = effmonth;
    }

    public int getEffday() {
        return this.effday;
    }

    public void setEffday(int effday) {
        this.effday = effday;
    }

    public int getExpmonth() {
        return this.expmonth;
    }

    public void setExpmonth(int expmonth) {
        this.expmonth = expmonth;
    }

    public int getExpday() {
        return this.expday;
    }

    public void setExpday(int expday) {
        this.expday = expday;
    }

    public String getEffdate() {
        return this.effdate;
    }

    public void setEffdate(String effdate) {
        this.effdate = effdate;
    }

    public String getExpdate() {
        return this.expdate;
    }

    public void setExpdate(String expdate) {
        this.expdate = expdate;
    }

    @Override
    public void initSpecialTrees() {
        if (this.model.getBoolean("isdetailtomonth")) {
            this.initPeriodTree(this, this.model.getBoolean("mincludeyear"), this.model.getBoolean("mincludeqrt"), true, this.model.getBoolean("monthinclude13"), "M");
        } else if (this.model.getBoolean("isdetailtoqrt")) {
            this.initPeriodTree(this, this.model.getBoolean("qrtincludeyear"), true, false, false, "Q");
        } else if (this.model.getBoolean("isdetailtohalfyear")) {
            this.initPeriodTree(this, true, false, false, false, "HF");
        }
    }

    private void initPeriodTree(AbstractDimensionMemTree roottreemodel, boolean cludeHalfYear, boolean cludeQrt, boolean cludeMonth, boolean cludeMonth13, String prefix) {
        String number;
        AbstractDimensionMemTree yeartotal = null;
        AbstractDimensionMemTree hfyear1 = null;
        AbstractDimensionMemTree hfyear2 = null;
        AbstractDimensionMemTree qrtyear1 = null;
        AbstractDimensionMemTree qrtyear2 = null;
        AbstractDimensionMemTree qrtyear3 = null;
        AbstractDimensionMemTree qrtyear4 = null;
        int[] dayofMonth = new int[]{0, 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        int beginPeriod = this.model.getInt("beginperiod");
        int M_Year_startD = 1;
        int M_Year_EndM = this.getMonth(beginPeriod, 11);
        int M_Year_EndD = dayofMonth[M_Year_EndM];
        LocaleString ptname = ResManager.getLocaleString((String)"\u5e74\u5ea6\u5408\u8ba1", (String)"PeriodMemTree_0", (String)"epm-eb-cube");
        String ptnumber = prefix + "_YearTotal";
        yeartotal = this.setPeriodValue((ILocaleString)ptname, ptnumber, roottreemodel, beginPeriod, M_Year_startD, M_Year_EndM, M_Year_EndD, "5");
        if (cludeHalfYear) {
            for (int i = 1; i <= 2; ++i) {
                int hf_startM = this.getMonth(beginPeriod, (i - 1) * 6);
                int hf_startD = 1;
                int hf_endM = this.getMonth(hf_startM, 5);
                int hf_endD = dayofMonth[hf_endM];
                LocaleString name = ResManager.getLocaleString((String)"\u4e0a\u534a\u5e74", (String)"PeriodMemTree_1", (String)"epm-eb-cube");
                if (i == 2) {
                    name = ResManager.getLocaleString((String)"\u4e0b\u534a\u5e74", (String)"PeriodMemTree_2", (String)"epm-eb-cube");
                }
                number = prefix + "_HF" + i;
                AbstractDimensionMemTree p = this.setPeriodValue((ILocaleString)name, number, yeartotal, hf_startM, hf_startD, hf_endM, hf_endD, "1");
                if (i == 1) {
                    hfyear1 = p;
                    continue;
                }
                hfyear2 = p;
            }
        }
        if (cludeQrt) {
            block7: for (int i = 1; i < 5; ++i) {
                AbstractDimensionMemTree parent = cludeHalfYear ? (i == 1 || i == 2 ? hfyear1 : hfyear2) : yeartotal;
                int Q_startM = this.getMonth(beginPeriod, (i - 1) * 3);
                int Q_startD = 1;
                int Q_endM = this.getMonth(Q_startM, 2);
                int Q_endD = dayofMonth[Q_endM];
                number = prefix + "_Q" + i;
                LocaleString name = ResManager.getLocaleString((String)"%1\u5b63", (String)"BudgetPeriodMemTree_8", (String)"epm-eb-business");
                name = ResUtils.loadLocale((ILocaleString)name, (Object[])new Object[]{i});
                AbstractDimensionMemTree qrt = this.setPeriodValue((ILocaleString)name, number, parent, Q_startM, Q_startD, Q_endM, Q_endD, "1");
                switch (i) {
                    case 1: {
                        qrtyear1 = qrt;
                        continue block7;
                    }
                    case 2: {
                        qrtyear2 = qrt;
                        continue block7;
                    }
                    case 3: {
                        qrtyear3 = qrt;
                        continue block7;
                    }
                    case 4: {
                        qrtyear4 = qrt;
                    }
                }
            }
        }
        if (cludeMonth) {
            int count = 12;
            if (cludeMonth13) {
                count = 13;
            }
            for (int i = 1; i <= count; ++i) {
                AbstractDimensionMemTree parent = cludeQrt ? (i <= 3 ? qrtyear1 : (i <= 6 ? qrtyear2 : (i <= 9 ? qrtyear3 : qrtyear4))) : (cludeHalfYear ? (i <= 6 ? hfyear1 : hfyear2) : yeartotal);
                int M_startM = this.getMonth(beginPeriod, i - 1);
                int M_startD = 1;
                int Q_endD = dayofMonth[M_startM];
                LocaleString name = ResManager.getLocaleString((String)"%1\u6708", (String)"BudgetPeriodMemTree_7", (String)"epm-eb-business");
                name = ResUtils.loadLocale((ILocaleString)name, (Object[])new Object[]{M_startM});
                String number2 = "M_M0" + i;
                String aggoprt = "1";
                if (i >= 10) {
                    number2 = "M_M" + i;
                }
                if (parent == null) continue;
                if (i == 13) {
                    name = ResManager.getLocaleString((String)"%s\u671f", (String)"PeriodMemTree_5", (String)"epm-eb-cube");
                    name = ResUtils.loadLocale((ILocaleString)name, (Object[])new Object[]{13});
                    aggoprt = "5";
                    this.setPeriodValue((ILocaleString)name, number2, parent, M_Year_EndM, M_Year_EndD, M_Year_EndM, M_Year_EndD, aggoprt);
                    continue;
                }
                this.setPeriodValue((ILocaleString)name, number2, parent, M_startM, M_startD, M_startM, Q_endD, aggoprt);
            }
        }
    }

    private int getMonth(int month, int differ) {
        return month + differ >= 13 ? month + differ - 12 : month + differ;
    }

    private AbstractDimensionMemTree setPeriodValue(ILocaleString name, String number, AbstractDimensionMemTree fyparent, int hf_startM, int hf_startD, int hf_endM, int hf_endD, String aggoprt) {
        if (fyparent == null) {
            return null;
        }
        PeriodMemTree pt_f1 = this.getTreeModel();
        pt_f1.setLangName(this.transName(name, number));
        pt_f1.setNumber(number);
        pt_f1.setAggoprt(aggoprt);
        pt_f1.setLongnumber(fyparent.getLongnumber() + "!" + pt_f1.getNumber());
        pt_f1.setLevel(fyparent.getLevel() + 1);
        pt_f1.setParent(fyparent.getId());
        pt_f1.setIsleaf(true);
        pt_f1.setDseq(fyparent.getChildren().size() + 1);
        pt_f1.setEffmonth(hf_startM);
        pt_f1.setEffday(hf_startD);
        pt_f1.setExpmonth(hf_endM);
        pt_f1.setExpday(hf_endD);
        String effdate = ResManager.loadResFormat((String)"%1\u6708%2\u65e5", (String)"BudgetPeriodMemTree_6", (String)"epm-eb-business", (Object[])new Object[]{hf_startM, hf_startD});
        pt_f1.setEffdate(this.transData(effdate));
        String expdate = ResManager.loadResFormat((String)"%1\u6708%2\u65e5", (String)"BudgetPeriodMemTree_6", (String)"epm-eb-business", (Object[])new Object[]{hf_endM, hf_endD});
        pt_f1.setExpdate(this.transData(expdate));
        pt_f1.setStoragetype("2");
        fyparent.setIsleaf(false);
        fyparent.getChildren().add(pt_f1);
        return pt_f1;
    }

    private String transData(String dataName) {
        return dataName;
    }

    private ILocaleString transName(ILocaleString name, String number) {
        return name;
    }

    private PeriodMemTree getTreeModel() {
        PeriodMemTree per = new PeriodMemTree();
        per.setModel(this.getModel());
        per.setDimension(this.getDimension());
        return per;
    }

    @Override
    public String getDimensionNumber() {
        return SysDimensionEnum.Period.getNumber();
    }
}

