/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.model.entity;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.lang.Lang;
import kd.epm.eb.business.model.entity.AbstractDimensionMemTree;

public class YearMemTree
extends AbstractDimensionMemTree {
    private static final long serialVersionUID = 1L;

    public YearMemTree() {
    }

    public YearMemTree(DynamicObject model, Object dimension) {
        super(model, dimension);
    }

    @Override
    public void initSpecialTrees() {
        String startYearSeq = this.model.getString("startfy");
        int firstYear = 1997;
        int startYear = Integer.parseInt(startYearSeq) + firstYear - 1;
        int presetyear = this.model.getInt("presetyear");
        AbstractDimensionMemTree fyparent = this.searchTree(this, "AllYear");
        for (int actualYear = startYear; actualYear < startYear + presetyear; ++actualYear) {
            YearMemTree fy = this.getTreeModel();
            fy.setLevel(fyparent.getLevel() + 1);
            fy.setDseq(fyparent.getChildren().size() + 1);
            fy.setIsleaf(true);
            fy.setParent(fyparent.getId());
            fy.setAggoprt("1");
            fy.setNumber("FY" + actualYear);
            fy.setStoragetype("2");
            boolean language = !Lang.get().equals((Object)Lang.zh_CN) && !Lang.get().equals((Object)Lang.zh_TW);
            fy.setName(language ? String.valueOf(actualYear) : ResManager.loadResFormat((String)"%s\u5e74", (String)"YearMemTree_0", (String)"epm-eb-cube", (Object[])new Object[]{actualYear}));
            fy.setLongnumber(fyparent.getLongnumber() + "!" + "FY" + actualYear);
            fyparent.getChildren().add(fy);
            fyparent.setIsleaf(false);
        }
    }

    private YearMemTree getTreeModel() {
        YearMemTree ye = new YearMemTree();
        ye.setDimension(this.getDimension());
        ye.setModel(this.getModel());
        return ye;
    }
}

