/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.model.preDimensionHelper;

import com.google.common.collect.Lists;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.ReflectionUtils;
import kd.epm.eb.business.DimensionView.ApplicationScenarioPreset;
import kd.epm.eb.business.DimensionView.DimensionViewGroupPreset;
import kd.epm.eb.business.DimensionView.DimensionViewPreset;
import kd.epm.eb.business.DimensionView.ViewMemberPreset;
import kd.epm.eb.business.dataset.BizModelPreset;
import kd.epm.eb.business.model.entity.AbstractDimensionMemTree;
import kd.epm.eb.business.model.entity.Dimension;
import kd.epm.eb.business.model.preDimensionHelper.DimensionXmlFactory;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.ebBusiness.serviceHelper.BizRuleCatalogServiceHelper;
import kd.epm.eb.model.interfaces.IDimensionComponent;
import kd.epm.eb.model.interfaces.IInitSpecialTree;
import kd.epm.eb.model.interfaces.ISaveTreeAndOlap;
import kd.epm.eb.model.serviceHelper.DataSetServiceHelper;
import kd.epm.eb.model.serviceHelper.TemplateCatalogServiceHelper;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class PreDimensionUtil {
    private DynamicObject model;
    private String dimensionnumber;
    private String xlsxpath;
    private String xmlpath;
    private Object dimension;
    private ApplicationTypeEnum app;
    private Map<String, Map<String, String>> map;
    private List<String> dimensionNums = new ArrayList<String>();
    private String protypeModel = null;

    public PreDimensionUtil(DynamicObject model, ApplicationTypeEnum app) {
        this.model = model;
        this.app = app;
        this.dimensionNums = Lists.newArrayList((Object[])new String[]{SysDimensionEnum.Account.getNumber(), SysDimensionEnum.AuditTrail.getNumber(), SysDimensionEnum.ChangeType.getNumber(), SysDimensionEnum.Currency.getNumber(), SysDimensionEnum.DataType.getNumber(), SysDimensionEnum.Entity.getNumber(), SysDimensionEnum.InternalCompany.getNumber(), SysDimensionEnum.Version.getNumber()});
    }

    public PreDimensionUtil(DynamicObject model, ApplicationTypeEnum app, Boolean needBaseDimensions) {
        this.model = model;
        this.app = app;
        if (needBaseDimensions.booleanValue()) {
            this.dimensionNums = Lists.newArrayList((Object[])new String[]{SysDimensionEnum.Account.getNumber(), SysDimensionEnum.AuditTrail.getNumber(), SysDimensionEnum.ChangeType.getNumber(), SysDimensionEnum.Currency.getNumber(), SysDimensionEnum.DataType.getNumber(), SysDimensionEnum.Entity.getNumber(), SysDimensionEnum.InternalCompany.getNumber(), SysDimensionEnum.Version.getNumber()});
        }
    }

    public PreDimensionUtil(DynamicObject model, String dimensionnumber, String xmlpath, ApplicationTypeEnum app) {
        this.model = model;
        this.dimensionnumber = dimensionnumber;
        this.xmlpath = xmlpath;
        this.app = app;
    }

    public List<IDimensionComponent> resolveDimemTrees() {
        if (ApplicationTypeEnum.BGMD == this.app) {
            this.dimensionNums.add(SysDimensionEnum.BudgetPeriod.getNumber());
            this.dimensionNums.add(SysDimensionEnum.Metric.getNumber());
        } else {
            this.dimensionNums.add(SysDimensionEnum.Year.getNumber());
            this.dimensionNums.add(SysDimensionEnum.Period.getNumber());
            this.dimensionNums.add(SysDimensionEnum.Process.getNumber());
            this.dimensionNums.add(SysDimensionEnum.Scenario.getNumber());
        }
        ArrayList<IDimensionComponent> roots = new ArrayList<IDimensionComponent>();
        try {
            this.map = this.resolveMapping();
            for (String e : this.dimensionNums) {
                String xlsxaddress;
                String address = DimensionXmlFactory.getXmlName(e, this.app);
                this.xlsxpath = xlsxaddress = DimensionXmlFactory.getXlsxName(e, this.app);
                this.xmlpath = address;
                this.resolveDimension();
                if ("Account".equals(e)) {
                    AbstractDimensionMemTree root = this.resolveDimemXlsxTree();
                    roots.add(root);
                    continue;
                }
                AbstractDimensionMemTree treemodel = DimensionXmlFactory.getXmlTreemodel(e);
                this.protypeModel = ObjectSerialUtil.toByteSerialized((Object)treemodel);
                IDimensionComponent root = this.createTrees();
                roots.add(root);
            }
        }
        catch (Exception e) {
            String message1 = e.getMessage() == null ? "" : e.getMessage();
            StringBuilder message = new StringBuilder(message1);
            if (message.length() == 0) {
                StackTraceElement[] traces;
                for (StackTraceElement trace : traces = e.getStackTrace()) {
                    message.append("\r\n").append(trace.getFileName()).append(' ').append(trace.getClassName()).append(' ').append(trace.getMethodName()).append(' ').append(trace.getLineNumber()).append("\r\n");
                }
            }
            throw new KDBizException(ResManager.loadResFormat((String)"\u8bfb\u53d6xml\u6216\u8005\u6784\u9020\u6811\u5f62\u5bf9\u8c61\u9519\u8bef %s", (String)"PreDimensionUtil_0", (String)"epm-eb-cube", (Object[])new Object[]{message}));
        }
        return roots;
    }

    public void afterModelSaveBGMD(List<IDimensionComponent> dimemtrees, boolean isBgmdModelSave) {
        for (IDimensionComponent dc : dimemtrees) {
            ((IInitSpecialTree)((Object)dc)).initSpecialTrees();
            ((ISaveTreeAndOlap)((Object)dc)).actionSaveTreeMemAndOlap();
        }
        if (ApplicationTypeEnum.BGMD == this.app) {
            TemplateCatalogServiceHelper.setDefaultRootNode(this.model, false);
            List<Long> ids = ApplicationScenarioPreset.presetData(this.model.getString("id"));
            Map<Long, Long> viewMap = DimensionViewPreset.presetData(this.model.getString("id"));
            HashMap<Long, Long> viewGroupMap = new HashMap(16);
            if (isBgmdModelSave) {
                viewGroupMap = DimensionViewGroupPreset.presetData(this.model.getString("id"), viewMap);
                ViewMemberPreset.presetData(this.model.getString("id"), viewMap);
            }
            DimensionViewPreset.setChangeTypePresetData(this.model.getLong("id"));
            BizModelPreset.presetData(this.model.getString("id"), ids, viewMap, viewGroupMap, isBgmdModelSave);
            DataSetServiceHelper.createDefault(this.model);
        } else if (ApplicationTypeEnum.EB == this.app) {
            TemplateCatalogServiceHelper.setDefaultRootNode(this.model, true);
            BizRuleCatalogServiceHelper.setDefaultNode((DynamicObject)this.model, (ApplicationTypeEnum)this.app);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IDimensionComponent createTrees() throws Exception {
        try (InputStream inputStream = null;){
            SAXReader reader = new SAXReader();
            inputStream = this.getClass().getResourceAsStream(this.xmlpath);
            Document document = reader.read(inputStream);
            Element node = document.getRootElement();
            Element rootElement = node.element("membertree");
            AbstractDimensionMemTree roottreemodel = this.getTreeModel();
            if (rootElement != null) {
                this.initNode(rootElement, roottreemodel, new HashMap<String, AbstractDimensionMemTree>());
            }
            AbstractDimensionMemTree abstractDimensionMemTree = roottreemodel;
            return abstractDimensionMemTree;
        }
    }

    private void initNode(Element rootElement, AbstractDimensionMemTree MemTree, Map<String, AbstractDimensionMemTree> alltrees) throws Exception {
        if (rootElement.getParent().isRootElement()) {
            this.setDimensionTreeValue(rootElement, MemTree, null);
            alltrees.put(MemTree.getName() + MemTree.getNumber(), MemTree);
        }
        Iterator it = rootElement.elementIterator();
        while (it.hasNext()) {
            Element element = (Element)it.next();
            String number = element.attribute("number").getValue();
            String reportType = this.model.getString("reporttype");
            if (ApplicationTypeEnum.BG.getIndex().equals(reportType) && "RollBudget".equals(number) || ApplicationTypeEnum.BG.getIndex().equals(reportType) && ("BOP".equals(number) || "EndingBalance".equals(number))) continue;
            AbstractDimensionMemTree benshen = this.getTreeModel();
            Element parentelement = element.getParent();
            StringBuilder resourceID = new StringBuilder(this.xmlpath.substring(1, this.xmlpath.length()).replace('/', '.'));
            resourceID.append('.').append(parentelement.attribute("number").getValue());
            StringBuilder parent_key = new StringBuilder(PreDimensionUtil.getResName(parentelement.attribute("name").getValue(), resourceID.toString()));
            parent_key.append(parentelement.attribute("number").getValue());
            AbstractDimensionMemTree parent = alltrees.get(parent_key.toString());
            this.setDimensionTreeValue(element, benshen, parent);
            alltrees.put(benshen.getName() + benshen.getNumber(), benshen);
            this.initNode(element, null, alltrees);
        }
    }

    private void setDimensionTreeValue(Element element, AbstractDimensionMemTree ziji, AbstractDimensionMemTree parent) throws Exception {
        HashMap<String, Field> fileds = new HashMap<String, Field>();
        for (Class<?> clazz = ziji.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            Field[] classfields;
            for (Field field : classfields = clazz.getDeclaredFields()) {
                fileds.put(field.getName(), field);
            }
        }
        String resourceID = "";
        List list = element.attributes();
        for (Object o : list) {
            Field keyField;
            Attribute attribute = (Attribute)o;
            String fieldName = attribute.getName();
            if ("number".equals(fieldName)) {
                resourceID = this.xmlpath.substring(1).replace('/', '.') + "." + attribute.getText();
            }
            Map<String, String> chidMap = this.map.get(fieldName);
            Field field = (Field)fileds.get(fieldName);
            ReflectionUtils.makeAccessible((Field)field);
            if (chidMap != null) {
                String value = chidMap.get(attribute.getText());
                if ("name".equals(fieldName)) {
                    value = PreDimensionUtil.getResName(value, resourceID);
                    keyField = (Field)fileds.get("nameKey");
                    if (keyField != null) {
                        ReflectionUtils.makeAccessible((Field)keyField);
                        keyField.set(ziji, resourceID);
                    }
                }
                field.set(ziji, value);
                continue;
            }
            if ("name".equals(fieldName)) {
                field.set(ziji, PreDimensionUtil.getResName(attribute.getText(), resourceID));
                keyField = (Field)fileds.get("nameKey");
                if (keyField == null) continue;
                ReflectionUtils.makeAccessible((Field)keyField);
                keyField.set(ziji, resourceID);
                continue;
            }
            field.set(ziji, attribute.getText());
        }
        if (parent != null) {
            ziji.setLevel(parent.getLevel() + 1);
            ziji.setDseq(parent.getChildren().size() + 1);
            ziji.setLongnumber(parent.getLongnumber() + "!" + ziji.getNumber());
            ziji.setParent(parent.getId());
            parent.setIsleaf(Boolean.FALSE);
            parent.getChildren().add(ziji);
        } else {
            ziji.setLongnumber(ziji.getNumber());
        }
        ziji.setEnable("BudgetOccupation".equals(ziji.getNumber()) ? "0" : "1");
    }

    private void resolveDimension() throws Exception {
        try (InputStream inputStream = this.getClass().getResourceAsStream(this.xmlpath);){
            SAXReader reader = new SAXReader();
            Dimension dimension = null;
            Document document = reader.read(inputStream);
            Element node = document.getRootElement();
            Element dimElement = node.element("dimension");
            if (dimElement != null) {
                dimension = new Dimension(this.model);
                List attributes = dimElement.attributes();
                int size = attributes.size();
                for (int i = 0; i < size; ++i) {
                    Attribute attribute = (Attribute)attributes.get(i);
                    String value = attribute.getText();
                    String filedName = attribute.getName();
                    Map<String, String> chidMap = this.map.get(filedName);
                    if (chidMap != null) {
                        value = chidMap.get(value);
                    }
                    Field field = dimension.getClass().getDeclaredField(filedName);
                    ReflectionUtils.makeAccessible((Field)field);
                    field.set(dimension, value);
                }
            }
            if (dimension != null) {
                String resourceID = this.xmlpath.substring(1).replace('/', '.') + "." + dimension.getNumber();
                dimension.setName(PreDimensionUtil.getResName(dimension.getName(), resourceID));
                dimension.setNameKey(resourceID);
                this.dimensionnumber = dimension.getNumber();
                this.dimension = dimension.initToDyna();
            }
        }
    }

    private static String getResName(String name, String resourceID) {
        return ResManager.loadKDString((String)name, (String)resourceID, (String)"epm-eb-cube", (Object[])new Object[0]);
    }

    private AbstractDimensionMemTree getTreeModel() throws Exception {
        AbstractDimensionMemTree treemodel = (AbstractDimensionMemTree)ObjectSerialUtil.deSerializedBytes((String)this.protypeModel);
        treemodel.setDimension(this.dimension);
        treemodel.setModel(this.model);
        return treemodel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Map<String, String>> resolveMapping() throws Exception {
        try (InputStream inputStream = null;){
            SAXReader reader = new SAXReader();
            HashMap<String, Map<String, String>> rootmap = new HashMap<String, Map<String, String>>();
            inputStream = this.getClass().getResourceAsStream("/bgmdxml/mapping/dimension_mapping.xml");
            Document document = reader.read(inputStream);
            Element node = document.getRootElement();
            Iterator iter = node.elementIterator();
            Element RootElement = null;
            while (iter.hasNext()) {
                Element element = (Element)iter.next();
                if ("propertites".equals(element.getName())) continue;
                RootElement = element;
                String rootMappingName = RootElement.attributeValue("type");
                Map<String, String> map = this.creatMap(RootElement, rootmap);
                rootmap.put(rootMappingName, map);
            }
            HashMap<String, Map<String, String>> hashMap = rootmap;
            return hashMap;
        }
    }

    private Map<String, String> creatMap(Element rootElement, Map<String, Map<String, String>> rootmap) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (rootElement.getParent().isRootElement()) {
            rootmap.put(rootElement.attributeValue("type"), map);
        }
        Iterator it = rootElement.elementIterator();
        while (it.hasNext()) {
            Element element = (Element)it.next();
            Element parentelement = element.getParent();
            String parent_key = parentelement.attribute("type").getValue();
            Map<String, String> childmap = rootmap.get(parent_key);
            this.setMapValue(element, rootmap, childmap);
            rootmap.put(parent_key, childmap);
            this.creatMap(element, rootmap);
        }
        return map;
    }

    private void setMapValue(Element element, Map<String, Map<String, String>> rootmap, Map<String, String> childmap) {
        childmap.put(element.attributeValue("name"), element.attributeValue("index"));
        if (rootmap != null) {
            rootmap.put(element.getParent().attributeValue("type"), childmap);
        }
    }

    private AbstractDimensionMemTree resolveDimemXlsxTree() throws Exception {
        this.protypeModel = ObjectSerialUtil.toByteSerialized((Object)DimensionXmlFactory.getXmlTreemodel(this.dimensionnumber));
        XSSFWorkbook xssfWorkbook = new XSSFWorkbook(this.getClass().getResourceAsStream(this.xlsxpath));
        XSSFSheet xssfSheet = xssfWorkbook.getSheetAt(0);
        XSSFRow attribute = xssfSheet.getRow(0);
        HashMap<String, AbstractDimensionMemTree> tree = new HashMap<String, AbstractDimensionMemTree>(16);
        ArrayList<String> attributeList = new ArrayList<String>(10);
        int lastCellNum = attribute.getLastCellNum();
        for (int col = 0; col < lastCellNum; ++col) {
            String ce = attribute.getCell(col).toString();
            if (!StringUtils.isNotEmpty((String)ce)) continue;
            if (!"Parent".equals(ce)) {
                ce = ce.substring(ce.indexOf(40) + 1, ce.indexOf(41));
            }
            attributeList.add(ce);
        }
        HashMap<String, Field> fileds = new HashMap<String, Field>(16);
        int lastLine = xssfSheet.getLastRowNum();
        for (int i = 1; i <= lastLine; ++i) {
            fileds.clear();
            AbstractDimensionMemTree MemTree = this.getTreeModel();
            for (Class<?> clazz = MemTree.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
                Field[] classfields;
                for (Field field : classfields = clazz.getDeclaredFields()) {
                    fileds.put(field.getName(), field);
                }
            }
            XSSFRow rowData = xssfSheet.getRow(i);
            String number = null;
            for (int j = 0; j < attributeList.size(); ++j) {
                String cellValue;
                String colname = (String)attributeList.get(j);
                String string = cellValue = rowData.getCell(j) == null ? null : rowData.getCell(j).toString();
                if (cellValue == null) continue;
                if ("name".equals(colname)) {
                    String resourceID = this.xlsxpath.substring(1).replace('/', '.') + "." + number;
                    cellValue = PreDimensionUtil.getResName(cellValue, resourceID);
                    Field _nameKeyField = (Field)fileds.get("nameKey");
                    if (_nameKeyField != null) {
                        ReflectionUtils.makeAccessible((Field)_nameKeyField);
                        _nameKeyField.set(MemTree, resourceID);
                    }
                }
                if (!"Parent".equals(colname)) {
                    Map<String, String> chidMap;
                    if ("number".equals(colname)) {
                        number = cellValue;
                    }
                    if ((chidMap = this.map.get(colname)) != null) {
                        cellValue = chidMap.get(cellValue);
                    }
                    Field field = (Field)fileds.get(colname);
                    ReflectionUtils.makeAccessible((Field)field);
                    field.set(MemTree, cellValue);
                    continue;
                }
                AbstractDimensionMemTree parent = (AbstractDimensionMemTree)tree.get(cellValue);
                if (parent != null) {
                    MemTree.setLevel(parent.getLevel() + 1);
                    MemTree.setDseq(parent.getChildren().size() + 1);
                    MemTree.setLongnumber(parent.getLongnumber() + "!" + MemTree.getNumber());
                    MemTree.setParent(parent.getId());
                    parent.setIsleaf(Boolean.FALSE);
                    parent.getChildren().add(MemTree);
                    continue;
                }
                MemTree.setLongnumber(MemTree.getNumber());
            }
            tree.put(number, MemTree);
        }
        return (AbstractDimensionMemTree)tree.get("Account");
    }
}

