/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.mutex;

import java.sql.Timestamp;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.epm.eb.common.MutexRecordObj;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.UserUtils;

public class MutexRecordHelper {
    private static final Log log = LogFactory.getLog(MutexRecordHelper.class);

    public static Long addLock(String billType, String billNumber, String opType) {
        long pkId = GlobalIdUtil.genGlobalLongId();
        String sql = "insert into t_eb_mutexrecord(fid,fbilltype,fbillnumber,foptype,fcreator,fcreatedate,fipaddress)values(?,?,?,?,?,?,?)";
        Timestamp now = new Timestamp(TimeServiceHelper.now().getTime());
        Long userId = UserUtils.getUserId();
        RequestContext requestContext = RequestContext.getOrCreate();
        String loginIP = requestContext.getLoginIP();
        try {
            DB.execute((DBRoute)new DBRoute("epm"), (String)sql, (Object[])new Object[]{pkId, billType, billNumber, opType, userId, now, loginIP});
        }
        catch (Exception e) {
            pkId = 0L;
            log.info(billNumber + "-addLock failed:" + e.getMessage());
        }
        return pkId;
    }

    public static MutexRecordObj getLockRecord(String billType, String billNumber, String opType) {
        QFBuilder qb = new QFBuilder();
        qb.add("billtype", "=", (Object)billType);
        qb.add("billnumber", "=", (Object)billNumber);
        qb.add("optype", "=", (Object)opType);
        return MutexRecordHelper.getLockRecord(qb.toArrays());
    }

    public static MutexRecordObj getLockRecord(Long lockId) {
        if (lockId == null) {
            return null;
        }
        return MutexRecordHelper.getLockRecord(new QFilter[]{new QFilter("id", "=", (Object)lockId)});
    }

    public static MutexRecordObj getLockRecord(QFilter[] qFilters) {
        MutexRecordObj recordObj = null;
        DynamicObject lockObj = QueryServiceHelper.queryOne((String)"eb_mutexrecord", (String)"id,billtype,billnumber,optype,creator,creator.name,createdate,ipaddress", (QFilter[])qFilters);
        if (lockObj != null) {
            recordObj = new MutexRecordObj();
            recordObj.setBillnumber(lockObj.getString("billnumber"));
            recordObj.setBilltype(lockObj.getString("billtype"));
            recordObj.setOptype(lockObj.getString("optype"));
            recordObj.setPkId(Long.valueOf(lockObj.getLong("id")));
            recordObj.setCreatedate(lockObj.getDate("createdate"));
            recordObj.setCreator(Long.valueOf(lockObj.getLong("creator")));
            recordObj.setCreatorName(lockObj.getString("creator.name"));
            recordObj.setIpAddress(lockObj.getString("ipaddress"));
        }
        return recordObj;
    }

    public static void removeLock(Long lockId) {
        DeleteServiceHelper.delete((String)"eb_mutexrecord", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)lockId)});
    }
}

