/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.qinganalysis;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.qinganalysis.QingAnalysisDSVarModelService;
import kd.epm.eb.business.qinganalysis.model.DataCell;
import kd.epm.eb.business.qinganalysis.model.DimMemberDto;
import kd.epm.eb.business.qinganalysis.model.DimensionDto;
import kd.epm.eb.business.qinganalysis.model.DsDataModel;
import kd.epm.eb.business.qinganalysis.model.ValueFieldConfigDto;
import kd.epm.eb.business.qinganalysis.processor.IQingAnalysisDSProcessor;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.var.TemplateVarCommonUtil;
import kd.epm.eb.olap.service.biztemplate.QueryBizTemplate;
import kd.epm.eb.olap.service.request.AlgoCalcRequest;
import kd.epm.eb.spread.utils.ReportVar.ReportVarUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

public class QingAnalysisDSQuery {
    private static final Log log = LogFactory.getLog(QingAnalysisDSQuery.class);
    private final DsDataModel dataModel;
    private final IModelCacheHelper modelCache;
    private final long datasetId;
    private final IQingAnalysisDSProcessor processor;
    private final Map<String, Map<String, String>> varConfMap;
    private final LinkedHashMap<String, List<Member>> textFieldMemberMap;
    private final long totalCount;
    private final int startRow;
    private final int limit;
    private static final String LOG_TAG = "QingDSQuery";

    public QingAnalysisDSQuery(DsDataModel dataModel, IModelCacheHelper modelCache, long datasetId, IQingAnalysisDSProcessor processor, int startRow, int limit) {
        this.dataModel = dataModel;
        this.modelCache = modelCache;
        this.datasetId = datasetId;
        this.processor = processor;
        this.varConfMap = QingAnalysisDSVarModelService.getInstance().getModelVarConf(modelCache.getModelobj().getId());
        this.textFieldMemberMap = this.partitionTextFieldMember(dataModel, modelCache);
        this.totalCount = this.calcTotalCount();
        this.startRow = startRow - 1;
        this.limit = limit;
    }

    public void checkMemberIsExits() {
        for (int valIndex = 0; valIndex < this.dataModel.getValueFieldConf().size(); ++valIndex) {
            ValueFieldConfigDto configDto = this.dataModel.getValueFieldConf().get(valIndex);
            this.getValueDimMember(configDto);
        }
        this.getHideDimMember();
    }

    public void query() {
        try {
            Stopwatch totalWatch = Stopwatch.createStarted();
            log.info("{} start startRow:{} limit:{}", new Object[]{LOG_TAG, this.startRow, this.limit});
            Map<String, String> hideDimMemberMap = this.getHideDimMember();
            LinkedHashMap<String, List<Member>> textSubList = this.textFieldMemberMap;
            LinkedHashMap<String, Set<String>> pageMemNumberMap = new LinkedHashMap<String, Set<String>>(textSubList.size());
            ArrayList<String> pageMemRowKeyList = new ArrayList<String>(this.limit);
            Pair<Integer, List<DataCell>> pair = this.processor.buildTextFieldCell(textSubList, pageMemRowKeyList, pageMemNumberMap, this.startRow, this.limit);
            int textColCount = (Integer)pair.getLeft();
            List cellList = (List)pair.getRight();
            log.info("{} buildTextFieldCell cellSize:{} cost:{}ms", new Object[]{LOG_TAG, cellList.size(), totalWatch.elapsed(TimeUnit.MILLISECONDS)});
            Stopwatch subWatch = Stopwatch.createStarted();
            for (int valIndex = 0; valIndex < this.dataModel.getValueFieldConf().size(); ++valIndex) {
                subWatch.reset();
                int colIndex = textColCount + valIndex;
                ValueFieldConfigDto configDto = this.dataModel.getValueFieldConf().get(valIndex);
                Map<String, String> valueDimMemberMap = this.getValueDimMember(configDto);
                ArrayList dimNumberList = new ArrayList(textSubList.keySet());
                dimNumberList.addAll(hideDimMemberMap.keySet());
                dimNumberList.addAll(valueDimMemberMap.keySet());
                HashMap viewMap = Maps.newHashMapWithExpectedSize((int)this.dataModel.getDimensionViews().size());
                for (Map.Entry view : this.dataModel.getDimensionViews().entrySet()) {
                    viewMap.put(view.getKey(), IDUtils.toLong(view.getValue()));
                }
                List<BGCell> cells = this.queryData(this.modelCache.getModelobj().getId(), this.datasetId, pageMemNumberMap, hideDimMemberMap, valueDimMemberMap, viewMap);
                log.info("{} colName:{} colIndex:{} dimSize:{} resultSize:{} cubeQueryCost:{}ms", new Object[]{LOG_TAG, configDto.getName(), colIndex, dimNumberList.size(), cells.size(), subWatch.elapsed(TimeUnit.MILLISECONDS)});
                subWatch.reset();
                HashMap memKeyRowMap = new HashMap(pageMemRowKeyList.size());
                String hideMemberKey = hideDimMemberMap.values().stream().collect(Collectors.joining(String.valueOf('!')));
                String valueMemberKey = valueDimMemberMap.values().stream().collect(Collectors.joining(String.valueOf('!')));
                AtomicInteger dataRow = new AtomicInteger(1);
                pageMemRowKeyList.forEach(rowKey -> {
                    String cellKey = rowKey + hideMemberKey + '!' + valueMemberKey;
                    memKeyRowMap.put(cellKey, dataRow.getAndIncrement());
                });
                cells.forEach(cell -> {
                    Integer row = (Integer)memKeyRowMap.get(cell.getKey(dimNumberList));
                    if (row == null) {
                        return;
                    }
                    cellList.add(new DataCell(row, colIndex, cell.getValue()));
                });
                log.info("{} colName:{} colIndex:{} dimSize:{} resultSize:{} buildCellCost:{}ms", new Object[]{LOG_TAG, configDto.getName(), colIndex, dimNumberList.size(), cells.size(), subWatch.elapsed(TimeUnit.MILLISECONDS)});
            }
            this.processor.process(cellList, pageMemRowKeyList.size());
            log.info("{} finish startRow:{} limit:{} cost:{}ms", new Object[]{LOG_TAG, this.startRow, this.limit, totalWatch.elapsed(TimeUnit.MILLISECONDS)});
        }
        catch (Exception e) {
            log.error(CommonServiceHelper.getStackTraceStr((Throwable)e));
            throw new KDBizException(e.getMessage());
        }
    }

    private Map<String, String> getHideDimMember() {
        long modelId = this.modelCache.getModelobj().getId();
        List<DimensionDto> hideFields = this.dataModel.getHideFields();
        LinkedHashMap<String, String> hideDimMemberNumberMap = new LinkedHashMap<String, String>(hideFields.size());
        for (DimensionDto dimDto : hideFields) {
            if (CollectionUtils.isEmpty(dimDto.getMembers())) continue;
            String dimNumber = dimDto.getDimNumber();
            DimMemberDto memberDto = dimDto.getMembers().get(0);
            String memNumber = memberDto.getNumber();
            if (TemplateVarCommonUtil.checkIsVar((String)memNumber, (String)dimNumber).booleanValue()) {
                memNumber = ReportVarUtil.getRealDimByVar((Long)modelId, (String)memNumber, (String)dimNumber, this.varConfMap);
            }
            hideDimMemberNumberMap.put(dimNumber, memNumber);
        }
        this.checkMemberIsExits(hideDimMemberNumberMap);
        return hideDimMemberNumberMap;
    }

    private Map<String, String> getValueDimMember(ValueFieldConfigDto configDto) {
        long modelId = this.modelCache.getModelobj().getId();
        List<DimensionDto> dims = configDto.getDims();
        LinkedHashMap<String, String> valueDimMemberNumberMap = new LinkedHashMap<String, String>(dims.size());
        for (DimensionDto dimDto : dims) {
            if (CollectionUtils.isEmpty(dimDto.getMembers())) continue;
            String dimNumber = dimDto.getDimNumber();
            DimMemberDto memberDto = dimDto.getMembers().get(0);
            String memNumber = memberDto.getNumber();
            if (TemplateVarCommonUtil.checkIsVar((String)memNumber, (String)dimNumber).booleanValue()) {
                memNumber = ReportVarUtil.getRealDimByVar((Long)modelId, (String)memNumber, (String)dimNumber, this.varConfMap);
            }
            valueDimMemberNumberMap.put(dimNumber, memNumber);
        }
        this.checkMemberIsExits(valueDimMemberNumberMap);
        return valueDimMemberNumberMap;
    }

    private LinkedHashMap<String, List<Member>> partitionTextFieldMember(DsDataModel dataModel, IModelCacheHelper modelCache) {
        JSONObject dimensionViews = dataModel.getDimensionViews();
        long modelId = modelCache.getModelobj().getId();
        LinkedHashMap<String, List<Member>> dimMemberMap = new LinkedHashMap<String, List<Member>>(16);
        for (DimensionDto dimDto : dataModel.getTextFields()) {
            if (CollectionUtils.isEmpty(dimDto.getMembers())) continue;
            String dimNumber = dimDto.getDimNumber();
            HashSet<String> memberNumberSet = new HashSet<String>(16);
            ArrayList<Member> memberList = new ArrayList<Member>(16);
            long viewId = dimensionViews.getLong(dimNumber) == null ? 0L : dimensionViews.getLong(dimNumber);
            for (DimMemberDto memDto : dimDto.getMembers()) {
                String memNumber = memDto.getNumber();
                if (TemplateVarCommonUtil.checkIsVar((String)memNumber, (String)dimNumber).booleanValue()) {
                    memNumber = ReportVarUtil.getRealDimByVar((Long)modelId, (String)memNumber, (String)dimNumber, this.varConfMap);
                }
                List members = modelCache.getMember(dimNumber, Long.valueOf(viewId), memNumber, Integer.parseInt(memDto.getScope()));
                if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber) && "2".equals(this.processor.getQingAnalysisDS().getBpFieldType())) {
                    members = members.stream().map(m -> m.isLeaf() ? m : null).filter(Objects::nonNull).collect(Collectors.toList());
                }
                for (Member m2 : members) {
                    Member member;
                    String mNumber = m2.getNumber();
                    if (SysDimensionEnum.Account.getNumber().equals(dimNumber) && !m2.getDatasetId().equals(this.datasetId) || !memberNumberSet.add(mNumber) || (member = modelCache.getMember(dimNumber, Long.valueOf(viewId), mNumber)) == null) continue;
                    memberList.add(m2);
                }
            }
            if (memberList.isEmpty()) {
                if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber) && "2".equals(this.processor.getQingAnalysisDS().getBpFieldType())) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u9884\u7b97\u671f\u95f4\u4e3a\u65e5\u671f\u7c7b\u578b\u65f6\uff0c\u6210\u5458\u8303\u56f4\u9700\u914d\u7f6e\u4e3a\u660e\u7ec6\u6210\u5458\u3002", (String)"QingAnalysisDSService_14", (String)"epm-eb-business", (Object[])new Object[0]));
                }
                throw new KDBizException(ResManager.loadResFormat((String)"\u67e5\u8be2\u9519\u8bef\uff0c\u5df2\u914d\u7f6e\u7684\u6587\u672c\u5b57\u6bb5\u6210\u5458\u7531\u4e8e\u5220\u9664\u6216\u8d4b\u503c\u6210\u5458\u6240\u5728\u89c6\u56fe\u3001\u6570\u636e\u96c6\u4e0e\u6570\u636e\u6e90\u4e0d\u4e00\u81f4\u5bfc\u81f4\u6210\u5458\u4e0d\u5b58\u5728\uff0c\u6216\u6570\u636e\u4e2d\u7f3a\u5c11%1\u7ef4\u5ea6", (String)"QingAnalysisDSService_13", (String)"epm-eb-business", (Object[])new Object[]{dimNumber}));
            }
            dimMemberMap.put(dimNumber, memberList);
        }
        return this.filterPermRead(dimMemberMap, dimensionViews, modelCache.getModelobj().getId(), this.datasetId, modelCache);
    }

    private long calcTotalCount() {
        return this.textFieldMemberMap.values().stream().mapToLong(List::size).reduce((i1, i2) -> i1 * i2).orElse(0L);
    }

    public long getTotalCount() {
        return this.totalCount;
    }

    private List<BGCell> queryData(long modelId, long datasetId, Map<String, Set<String>> pageMemNumberMap, Map<String, String> hideDimMemberMap, Map<String, String> valueDimMemberMap, Map<String, Long> viewMap) {
        HashMap<String, Set<String>> memberInfo = new HashMap<String, Set<String>>(20);
        memberInfo.putAll(pageMemNumberMap);
        hideDimMemberMap.forEach((dim, mem) -> {
            Set cfr_ignored_0 = memberInfo.put((String)dim, Sets.newHashSet((Object[])new String[]{mem}));
        });
        valueDimMemberMap.forEach((dim, mem) -> {
            Set cfr_ignored_0 = memberInfo.put((String)dim, Sets.newHashSet((Object[])new String[]{mem}));
        });
        QueryBizTemplate queryBizTemplate = QueryBizTemplate.newInstance();
        return queryBizTemplate.doService(new AlgoCalcRequest(Long.valueOf(modelId), Long.valueOf(datasetId), viewMap, memberInfo, (List)Lists.newArrayList()));
    }

    private void checkMemberIsExits(Map<String, String> memberInfo) {
        JSONObject dimensionViews = this.dataModel.getDimensionViews();
        memberInfo.forEach((dim, mem) -> {
            long viewId = dimensionViews.getLong(dim) == null ? 0L : dimensionViews.getLong(dim);
            Member member = this.modelCache.getMember(dim, Long.valueOf(viewId), mem);
            if (member == null || SysDimensionEnum.Account.getNumber().equals(dim) && !member.getDatasetId().equals(this.datasetId)) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u7ef4\u5ea6[%1]\u7684\u6210\u5458[%2]\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\u3002", (String)"QingAnalysisDSService_12", (String)"epm-eb-business", (Object[])new Object[]{dim, mem}));
            }
        });
    }

    private LinkedHashMap<String, List<Member>> filterPermRead(LinkedHashMap<String, List<Member>> dimMemberMap, JSONObject dimensionViews, long modelId, long datasetId, IModelCacheHelper modelCache) {
        HashMap<String, Set> permissionMap = new HashMap<String, Set>(dimMemberMap.size());
        for (String dimNumber : dimMemberMap.keySet()) {
            Long viewId = IDUtils.toLong((Object)dimensionViews.getLong(dimNumber));
            Long bizCtrlRangeId = modelCache.getBusModelByDataSet(Long.valueOf(datasetId));
            Set permMemberNumbers = DimMembPermHelper.getPermMembNumbers((String)dimNumber, (Long)modelId, (Long)bizCtrlRangeId, (Long)viewId, (DimMembPermType)DimMembPermType.READ, (boolean)true);
            permissionMap.put(dimNumber, permMemberNumbers);
        }
        LinkedHashMap<String, List<Member>> newDimMemberMap = new LinkedHashMap<String, List<Member>>(dimMemberMap.size());
        for (Map.Entry<String, List<Member>> entry : dimMemberMap.entrySet()) {
            String dimNumber = entry.getKey();
            List<Member> memberList = entry.getValue();
            Set permMembNumbers = (Set)permissionMap.get(dimNumber);
            if (permMembNumbers == null) {
                newDimMemberMap.put(dimNumber, memberList);
                continue;
            }
            Set memNumberSet = memberList.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
            Sets.SetView hasPermSet = Sets.intersection(memNumberSet, (Set)permMembNumbers);
            if (CollectionUtils.isEmpty((Collection)hasPermSet)) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709(%1)\u7ef4\u5ea6\u7684\u6210\u5458\u8bfb\u53d6\u6743\u9650", (String)"QingAnalysisDSService_10", (String)"epm-eb-business", (Object[])new Object[]{dimNumber}));
            }
            List hasPermList = memberList.stream().filter(arg_0 -> QingAnalysisDSQuery.lambda$filterPermRead$7((Set)hasPermSet, arg_0)).collect(Collectors.toList());
            newDimMemberMap.put(dimNumber, hasPermList);
        }
        return newDimMemberMap;
    }

    private static /* synthetic */ boolean lambda$filterPermRead$7(Set hasPermSet, Member m) {
        return hasPermSet.contains(m.getNumber());
    }
}

