/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.qinganalysis;

import com.alibaba.fastjson.JSON;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.qinganalysis.QingAnalysisDSConstants;
import kd.epm.eb.business.qinganalysis.QingAnalysisDSQuery;
import kd.epm.eb.business.qinganalysis.QingAnalysisDSVarService;
import kd.epm.eb.business.qinganalysis.entity.QingAnalysisDS;
import kd.epm.eb.business.qinganalysis.entity.QingAnalysisDSVar;
import kd.epm.eb.business.qinganalysis.model.DimensionDto;
import kd.epm.eb.business.qinganalysis.model.DsDataModel;
import kd.epm.eb.business.qinganalysis.model.ValueFieldConfigDto;
import kd.epm.eb.business.qinganalysis.processor.DataProviderProcessor;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class QingAnalysisDSService {
    private static final Log log = LogFactory.getLog(QingAnalysisDSQuery.class);
    private static final String ENTITY_NAME = "eb_qinganalysisds";

    public static QingAnalysisDSService getInstance() {
        return InnerClass.instance;
    }

    private QingAnalysisDSService() {
    }

    public QingAnalysisDS load(Long id) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)ENTITY_NAME);
        if (dynamicObject == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"QingAnalysisDSService_1", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        return this.transToModel(dynamicObject);
    }

    public DynamicObjectCollection queryStatus(List<Long> ids) {
        String selectFields = "id, status";
        QFilter qFilter = new QFilter("id", "in", ids);
        return QueryServiceHelper.query((String)ENTITY_NAME, (String)selectFields, (QFilter[])new QFilter[]{qFilter});
    }

    public long save(QingAnalysisDS model) {
        DynamicObject dynamicObject = this.packageDynamicObject(model);
        long qingDsId = dynamicObject.getLong("id");
        try (TXHandle tx = TX.required();){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                ArrayList<DimensionDto> dtoList = new ArrayList<DimensionDto>(20);
                dtoList.addAll(model.getDataModel().getTextFields());
                dtoList.addAll(model.getDataModel().getHideFields());
                model.getDataModel().getValueFieldConf().forEach(valueField -> dtoList.addAll(valueField.getDims()));
                QingAnalysisDSVarService.getInstance().save(model.getModelId(), qingDsId, dtoList);
            }
            catch (Throwable e) {
                log.error(e.getMessage(), e);
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
        return qingDsId;
    }

    public void delete(List<Long> ids) {
        try (TXHandle tx = TX.required();){
            try {
                ids.forEach(id -> {
                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)ENTITY_NAME);
                    if (dynamicObject == null) {
                        return;
                    }
                    long modelId = dynamicObject.getDynamicObject("model").getLong("id");
                    QingAnalysisDSVarService.getInstance().delete(modelId, (long)id);
                });
                DeleteServiceHelper.delete((String)ENTITY_NAME, (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
            }
            catch (Throwable e) {
                log.error(e.getMessage(), e);
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    public void updateStatus(QingAnalysisDSConstants.Status status, List<Long> pkIds) {
        DynamicObject[] objs;
        long currUserId = RequestContext.get().getCurrUserId();
        Date now = TimeServiceHelper.now();
        for (DynamicObject obj : objs = BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)"id,status,modifier,modifydate", (QFilter[])new QFilter[]{new QFilter("id", "in", pkIds)})) {
            obj.set("status", (Object)status.getValue());
            obj.set("modifier", (Object)currUserId);
            obj.set("modifydate", (Object)now);
        }
        SaveServiceHelper.save((DynamicObject[])objs);
    }

    public long copy(Long id) {
        ILocaleString name;
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)ENTITY_NAME);
        if (dynamicObject == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"QingAnalysisDSService_1", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        QingAnalysisDS model = this.transToModel(dynamicObject);
        QingAnalysisDS newModel = new QingAnalysisDS();
        try {
            BeanUtils.copyProperties((Object)newModel, (Object)model);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
        RequestContext requestContext = RequestContext.get();
        Date now = TimeServiceHelper.now();
        ILocaleString nameCopy = name = model.getName();
        for (Map.Entry entry : nameCopy.entrySet()) {
            if (entry.getValue() != null && ((String)entry.getValue()).length() > 46) {
                nameCopy.setItem((String)entry.getKey(), (Object)(((String)entry.getValue()).substring(0, 46) + "copy"));
                continue;
            }
            nameCopy.setItem((String)entry.getKey(), (Object)((String)entry.getValue() + "copy"));
        }
        newModel.setId(0L);
        newModel.setName(nameCopy);
        newModel.setNumber("QingAnalysisDS-" + System.currentTimeMillis());
        newModel.setStatus(QingAnalysisDSConstants.Status.SAVE.getValue());
        newModel.setCreatorId(requestContext.getCurrUserId());
        newModel.setCreateTime(now);
        newModel.setModifierId(requestContext.getCurrUserId());
        newModel.setModifyTime(now);
        return this.save(newModel);
    }

    public QingAnalysisDS transToModel(DynamicObject dynamicObject) {
        QingAnalysisDS model = new QingAnalysisDS();
        model.setId(dynamicObject.getLong("id"));
        model.setNumber(dynamicObject.getString("number"));
        model.setName(dynamicObject.getLocaleString("name"));
        model.setStatus(dynamicObject.getString("status"));
        model.setModelId(dynamicObject.getDynamicObject("model").getLong("id"));
        model.setBizModelId(dynamicObject.getDynamicObject("bizmodel").getLong("id"));
        DynamicObject dataset = dynamicObject.getDynamicObject("dataset");
        if (dataset == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u4e0d\u5b58\u5728\uff0c\u8bf7\u5220\u9664\u91cd\u65b0\u914d\u7f6e\u3002", (String)"QingAnalysisDSService_9", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        model.setDataset(dataset.getLong("id"));
        model.setTextField(dynamicObject.getString("textfield"));
        model.setValueField(dynamicObject.getString("valuefield"));
        model.setData(dynamicObject.getString("data"));
        model.setFilterEmpty(dynamicObject.getBoolean("filterempty"));
        model.setBpFieldType(dynamicObject.getString("bpfieldtype"));
        model.setModifierId(dynamicObject.getDynamicObject("modifier").getLong("id"));
        model.setModifyTime(dynamicObject.getDate("modifydate"));
        if (StringUtils.isNotBlank((CharSequence)model.getData())) {
            model.setDataModel((DsDataModel)JSON.parseObject((String)model.getData(), DsDataModel.class));
        }
        return model;
    }

    private DynamicObject packageDynamicObject(QingAnalysisDS model) {
        DynamicObject dynamicObject;
        Long id = model.getId();
        if (IDUtils.isNull((Long)id)) {
            id = GlobalIdUtil.genGlobalLongId();
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_NAME);
            dynamicObject.set("creater", (Object)model.getCreatorId());
            dynamicObject.set("createdate", (Object)model.getCreateTime());
            dynamicObject.set("status", (Object)model.getStatus());
        } else {
            dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)ENTITY_NAME);
        }
        if (dynamicObject == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u6e90\u4e0d\u5b58\u5728\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"QingAnalysisDSService_0", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        dynamicObject.set("id", (Object)id);
        dynamicObject.set("number", (Object)model.getNumber());
        dynamicObject.set("name", (Object)model.getName());
        dynamicObject.set("status", (Object)model.getStatus());
        dynamicObject.set("model", (Object)model.getModelId());
        dynamicObject.set("bizmodel", (Object)model.getBizModelId());
        dynamicObject.set("dataset", (Object)model.getDataset());
        dynamicObject.set("textfield", (Object)model.getTextField());
        dynamicObject.set("valuefield", (Object)model.getValueField());
        dynamicObject.set("data", (Object)model.getData());
        dynamicObject.set("filterempty", (Object)model.getFilterEmpty());
        dynamicObject.set("bpfieldtype", (Object)model.getBpFieldType());
        dynamicObject.set("modifier", (Object)model.getModifierId());
        dynamicObject.set("modifydate", (Object)model.getCreateTime());
        return dynamicObject;
    }

    public DsDataModel publishCheck(long id, IFormView view) {
        QingAnalysisDS qingAnalysisDS = this.load(id);
        DsDataModel dataModel = qingAnalysisDS.getDataModel();
        if (!this.checkVariableIsComplete(qingAnalysisDS.getModelId(), id, view)) {
            return null;
        }
        dataModel = this.checkFieldIsComplete(qingAnalysisDS.getModelId(), dataModel, view);
        if (dataModel != null) {
            try {
                IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)qingAnalysisDS.getModelId());
                DataProviderProcessor processor = new DataProviderProcessor(qingAnalysisDS);
                QingAnalysisDSQuery qingAnalysisDSQuery = new QingAnalysisDSQuery(dataModel, modelCache, qingAnalysisDS.getDataset(), processor, 0, 0);
                long totalCount = qingAnalysisDSQuery.getTotalCount();
                qingAnalysisDSQuery.checkMemberIsExits();
                String maxDataCount = System.getProperty("qing_analysis_ds_max_data_count", "10000000");
                if (totalCount > (long)Integer.parseInt(maxDataCount)) {
                    view.showTipNotification(ResManager.loadResFormat((String)"\u6570\u636e\u91cf\u8d85\u8fc7\u201c%1\u201d\uff0c\u8bf7\u7f29\u5c0f\u6587\u672c\u5b57\u6bb5\u914d\u7f6e\u7684\u8303\u56f4\u3002", (String)"QingAnalysisDSService_8", (String)"epm-eb-business", (Object[])new Object[]{maxDataCount}));
                    return null;
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new KDBizException(qingAnalysisDS.getName().toString() + ":" + e.getMessage());
            }
        }
        return dataModel;
    }

    public DsDataModel checkFieldIsComplete(long modelId, DsDataModel dataModel, IFormView view) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        List<DimensionDto> hideFields = dataModel.getHideFields();
        for (DimensionDto dimensionDto : hideFields) {
            if (!CollectionUtils.isEmpty(dimensionDto.getMembers())) continue;
            Dimension dimension = modelCache.getDimension(dimensionDto.getDimNumber());
            view.showTipNotification(ResManager.loadResFormat((String)"\u8bf7\u6307\u5b9a%1\u7ef4\u5ea6\u6210\u5458\u3002", (String)"QingAnalysisDSService_2", (String)"epm-eb-business", (Object[])new Object[]{dimension.getName()}));
            return null;
        }
        List<DimensionDto> textFields = dataModel.getTextFields();
        for (DimensionDto d : textFields) {
            if (!CollectionUtils.isEmpty(d.getMembers())) continue;
            Dimension dimension = modelCache.getDimension(d.getDimNumber());
            view.showTipNotification(ResManager.loadResFormat((String)"\u8bf7\u6307\u5b9a%1\u7ef4\u5ea6\u6210\u5458\u3002", (String)"QingAnalysisDSService_2", (String)"epm-eb-business", (Object[])new Object[]{dimension.getName()}));
            return null;
        }
        List<String> list = dataModel.getValueFields();
        if (CollectionUtils.isEmpty(list)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u7ec4\u6210\u6570\u503c\u5b57\u6bb5\u7ef4\u5ea6\u81f3\u5c11\u6709\u4e00\u4e2a\u7ef4\u5ea6\u3002", (String)"QingAnalysisDSService_3", (String)"epm-eb-business", (Object[])new Object[0]));
            return null;
        }
        List<ValueFieldConfigDto> dtoList = dataModel.getValueFieldConf();
        if (CollectionUtils.isEmpty(dtoList)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u6570\u503c\u5b57\u6bb5\u3002", (String)"QingAnalysisDSService_4", (String)"epm-eb-business", (Object[])new Object[0]));
            return null;
        }
        ValueFieldConfigDto configDto = dtoList.get(0);
        if (configDto.getDims().size() != list.size()) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u6570\u503c\u5b57\u6bb5\u3002", (String)"QingAnalysisDSService_4", (String)"epm-eb-business", (Object[])new Object[0]));
            return null;
        }
        for (DimensionDto dto : configDto.getDims()) {
            if (list.contains(dto.getDimNumber()) && !CollectionUtils.isEmpty(dto.getMembers())) continue;
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5b8c\u5584\u6570\u503c\u5b57\u6bb5\u7684\u914d\u7f6e\u3002", (String)"QingAnalysisDSService_5", (String)"epm-eb-business", (Object[])new Object[0]));
            return null;
        }
        return dataModel;
    }

    private boolean checkVariableIsComplete(long modelId, long qingDsId, IFormView view) {
        Optional<QingAnalysisDSVar> optional;
        List<QingAnalysisDSVar> varList = QingAnalysisDSVarService.getInstance().queryVarConf(modelId, qingDsId);
        if (CollectionUtils.isNotEmpty(varList) && (optional = varList.stream().filter(var -> StringUtils.isEmpty((CharSequence)var.getVariableJson())).findAny()).isPresent()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u8d4b\u503c\u53d8\u91cf\uff0c\u8bf7\u5148\u4e8e\u53d8\u91cf\u8d4b\u503c\u4e2d\u8d4b\u503c\u540e\u518d\u8fdb\u884c\u53d1\u5e03\u3002", (String)"QingAnalysisDSService_11", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        return true;
    }

    private static class InnerClass {
        private static final QingAnalysisDSService instance = new QingAnalysisDSService();

        private InnerClass() {
        }
    }
}

