/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.qinganalysis;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.qinganalysis.entity.QingAnalysisDSVarModel;
import kd.epm.eb.business.qinganalysis.model.DimMemberDto;
import kd.epm.eb.business.qinganalysis.model.DimensionDto;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.var.TemplateVarCommonUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class QingAnalysisDSVarModelService {
    private static final String ENTITY_NAME = "eb_qingds_mvar";

    public static QingAnalysisDSVarModelService getInstance() {
        return InnerClass.instance;
    }

    private QingAnalysisDSVarModelService() {
    }

    public Map<String, Map<String, String>> getModelVarConf(long modelId) {
        List<QingAnalysisDSVarModel> varConfList = this.queryByModel(modelId);
        if (CollectionUtils.isEmpty(varConfList)) {
            return Collections.emptyMap();
        }
        HashMap<String, Map<String, String>> dimVarMap = new HashMap<String, Map<String, String>>(16);
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        varConfList.forEach(var -> {
            long dimId = var.getDimensionId();
            Dimension dimension = modelCache.getDimension(Long.valueOf(dimId));
            if (dimension == null || StringUtils.isEmpty((CharSequence)var.getVariableJson())) {
                return;
            }
            String dimNumber = dimension.getNumber();
            Map varMap = dimVarMap.computeIfAbsent(dimNumber, k -> new HashMap(16));
            List varMemberInfos = (List)SerializationUtils.fromJsonString((String)var.getVariableJson(), List.class);
            Map varMemberInfo = (Map)varMemberInfos.get(0);
            String realNumber = varMemberInfo.get("number").toString();
            String memName = varMemberInfo.get("name").toString();
            varMap.put(var.getVarNumber() + "!" + memName, realNumber);
        });
        return dimVarMap;
    }

    public List<QingAnalysisDSVarModel> queryByModel(long modelId) {
        String selectField = "id, modelid, dimensionid, variableid, varnumber, variablejson, usecount";
        QFilter qFilter = new QFilter("modelid", "=", (Object)modelId);
        DynamicObjectCollection dataList = QueryServiceHelper.query((String)ENTITY_NAME, (String)selectField, (QFilter[])qFilter.toArray());
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            return Collections.emptyList();
        }
        return dataList.stream().map(this::transToModel).collect(Collectors.toList());
    }

    public List<QingAnalysisDSVarModel> queryByVariable(long modelId, List<Long> variableIds) {
        String selectField = "id, modelid, dimensionid, variableid, varnumber, variablejson, usecount";
        QFilter qFilter = new QFilter("modelid", "=", (Object)modelId);
        qFilter.and("variableid", "in", variableIds);
        DynamicObjectCollection dataList = QueryServiceHelper.query((String)ENTITY_NAME, (String)selectField, (QFilter[])qFilter.toArray());
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            return Collections.emptyList();
        }
        return dataList.stream().map(this::transToModel).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(long modelId, Set<Long> dsVarSet, List<DimensionDto> dimensionDtoList) {
        HashMap<Long, Long> varDimMap = new HashMap<Long, Long>(16);
        HashMap<Long, DimMemberDto> varMemMap = new HashMap<Long, DimMemberDto>(16);
        ArrayList<Long> variableIdList = new ArrayList<Long>(16);
        this.extractVariable(modelId, dimensionDtoList, varDimMap, varMemMap, variableIdList, dsVarSet);
        if (CollectionUtils.isEmpty(variableIdList)) {
            return;
        }
        DLock dLock = DLock.create((String)("bgmd/qing/analysis/ds/var/" + modelId));
        dLock.fastMode();
        boolean lockFlag = dLock.tryLock(5000L);
        if (!lockFlag) {
            return;
        }
        try {
            List<QingAnalysisDSVarModel> varRecords = this.queryByVariable(modelId, variableIdList);
            Set exitsVarIdSet = varRecords.stream().map(QingAnalysisDSVarModel::getVariableId).collect(Collectors.toSet());
            HashSet<Long> variableIdSet = new HashSet<Long>(variableIdList);
            Sets.SetView needUpdateVarSet = Sets.intersection(variableIdSet, exitsVarIdSet);
            Sets.SetView needInsertVarSet = Sets.difference(variableIdSet, exitsVarIdSet);
            DynamicObject[] dynamicObjects = (DynamicObject[])needInsertVarSet.stream().map(varId -> {
                DynamicObject data = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_NAME);
                data.set("modelid", (Object)modelId);
                data.set("dimensionid", varDimMap.get(varId));
                data.set("variableid", varId);
                data.set("varnumber", (Object)((DimMemberDto)varMemMap.get(varId)).getNumber());
                data.set("usecount", (Object)1);
                return data;
            }).toArray(DynamicObject[]::new);
            this.increaseUseCount(modelId, (Collection<Long>)needUpdateVarSet);
            SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        }
        finally {
            dLock.unlock();
        }
    }

    public void extractVariable(long modelId, List<DimensionDto> dimensionDtoList, Map<Long, Long> varDimMap, Map<Long, DimMemberDto> varMemMap, List<Long> variableIdList, Set<Long> dsVarSet) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        DimMemberDto bpBaseYVar = QingAnalysisDSVarModelService.getInstance().getBpBaseYVar(modelId);
        dimensionDtoList.forEach(dimDto -> {
            String dimNumber = dimDto.getDimNumber();
            Dimension dimension = modelCache.getDimension(dimNumber);
            Long dimensionId = dimension.getId();
            dimDto.getMembers().forEach(memDto -> {
                String memNumber = memDto.getNumber();
                if (TemplateVarCommonUtil.checkIsVar((String)memNumber, (String)dimNumber).booleanValue()) {
                    Long variableId;
                    if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber) && (memNumber.startsWith("@NextY") || memNumber.startsWith("@BaseY") || memNumber.startsWith("@LastY"))) {
                        variableId = bpBaseYVar.getId();
                        memDto = bpBaseYVar;
                    } else {
                        variableId = memDto.getId();
                    }
                    if (dsVarSet == null || dsVarSet.contains(variableId)) {
                        varDimMap.put(variableId, dimensionId);
                        varMemMap.put(variableId, (DimMemberDto)memDto);
                        variableIdList.add(variableId);
                    }
                }
            });
        });
    }

    public DimMemberDto getBpBaseYVar(long modelId) {
        String varNumber = "@BaseY";
        String dimNumber = SysDimensionEnum.BudgetPeriod.getNumber();
        DynamicObject dyObj = this.getVariableObj(modelId, dimNumber, varNumber);
        DimMemberDto memDto = new DimMemberDto();
        if (dyObj != null) {
            memDto.setId(dyObj.getLong("id"));
            memDto.setNumber(dyObj.getString("number"));
            memDto.setName(dyObj.getString("name"));
        }
        return memDto;
    }

    public DynamicObject getVariableObj(long modelId, String dimNumber, String varNumber) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        Dimension dimension = modelCache.getDimension(dimNumber);
        QFilter qFilter = new QFilter("model", "=", (Object)modelId).and("number", "=", (Object)varNumber).and("dimension", "=", (Object)dimension.getId());
        return QueryServiceHelper.queryOne((String)"eb_periodvariable", (String)"id, name, number, grouptype, dimension", (QFilter[])new QFilter[]{qFilter});
    }

    public void increaseUseCount(long modelId, Collection<Long> variableIds) {
        if (CollectionUtils.isEmpty(variableIds)) {
            return;
        }
        String sql = "update t_eb_qingds_mvar set fusecount = fusecount + 1 where fmodelid = ? and fvariableid = ?";
        List params = variableIds.stream().map(varId -> {
            Object[] objs = new Object[]{modelId, varId};
            return objs;
        }).collect(Collectors.toList());
        DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)sql, params);
    }

    public void decreaseUseCount(long modelId, Collection<Long> variableIds) {
        if (CollectionUtils.isEmpty(variableIds)) {
            return;
        }
        String sql = "update t_eb_qingds_mvar set fusecount = fusecount - 1 where fmodelid = ? and fvariableid = ?";
        List params = variableIds.stream().map(varId -> {
            Object[] objs = new Object[]{modelId, varId};
            return objs;
        }).collect(Collectors.toList());
        DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)sql, params);
    }

    public void delete(long modelId, Collection<Long> variableIds) {
        QFilter qFilter = new QFilter("modelid", "=", (Object)modelId);
        qFilter.and("variableid", "in", variableIds);
        qFilter.and("usecount", "<=", (Object)0);
        DeleteServiceHelper.delete((String)ENTITY_NAME, (QFilter[])new QFilter[]{qFilter});
    }

    public void update(long modelId, DynamicObjectCollection varConfList) {
        Object[] dynamicObjects = (DynamicObject[])varConfList.stream().map(v -> {
            String varJson = v.getString("variablejson");
            if (StringUtils.isBlank((CharSequence)varJson)) {
                return null;
            }
            DynamicObject data = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_NAME);
            data.set("id", (Object)v.getLong("dataid"));
            data.set("modelid", (Object)modelId);
            data.set("variablejson", (Object)varJson);
            return data;
        }).filter(Objects::nonNull).toArray(DynamicObject[]::new);
        if (ArrayUtils.isEmpty((Object[])dynamicObjects)) {
            return;
        }
        try (TXHandle tx = TX.required();){
            try {
                SaveServiceHelper.update((DynamicObject[])dynamicObjects);
            }
            catch (Throwable e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    public QingAnalysisDSVarModel transToModel(DynamicObject dynamicObject) {
        QingAnalysisDSVarModel model = new QingAnalysisDSVarModel();
        model.setId(dynamicObject.getLong("id"));
        model.setModelId(dynamicObject.getLong("modelid"));
        model.setDimensionId(dynamicObject.getLong("dimensionid"));
        model.setVariableId(dynamicObject.getLong("variableid"));
        model.setVarNumber(dynamicObject.getString("varnumber"));
        model.setUseCount(dynamicObject.getLong("usecount"));
        model.setVariableJson(dynamicObject.getString("variablejson"));
        return model;
    }

    private static class InnerClass {
        private static final QingAnalysisDSVarModelService instance = new QingAnalysisDSVarModelService();

        private InnerClass() {
        }
    }
}

