/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.qinganalysis;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dlock.DLock;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.qinganalysis.QingAnalysisDSVarModelService;
import kd.epm.eb.business.qinganalysis.entity.QingAnalysisDSVar;
import kd.epm.eb.business.qinganalysis.entity.QingAnalysisDSVarModel;
import kd.epm.eb.business.qinganalysis.model.DimMemberDto;
import kd.epm.eb.business.qinganalysis.model.DimensionDto;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.enums.memberQuote.MemberTypeEnum;
import org.apache.commons.collections4.CollectionUtils;

public class QingAnalysisDSVarService {
    private static final String ENTITY_NAME = "eb_qingds_var";

    public static QingAnalysisDSVarService getInstance() {
        return InnerClass.instance;
    }

    private QingAnalysisDSVarService() {
    }

    public List<QingAnalysisDSVar> queryVarConf(long modelId, long qingDsId) {
        List<QingAnalysisDSVar> varList = this.query(qingDsId);
        if (CollectionUtils.isEmpty(varList)) {
            return Collections.emptyList();
        }
        List<Long> varIdList = varList.stream().map(QingAnalysisDSVar::getVariableId).collect(Collectors.toList());
        List<QingAnalysisDSVarModel> varConfList = QingAnalysisDSVarModelService.getInstance().queryByVariable(modelId, varIdList);
        Map<Long, String> varConfMap = varConfList.stream().collect(Collectors.toMap(QingAnalysisDSVarModel::getVariableId, QingAnalysisDSVarModel::getVariableJson, (o1, o2) -> o2));
        varList.forEach(var -> var.setVariableJson((String)varConfMap.get(var.getVariableId())));
        return varList;
    }

    public List<QingAnalysisDSVar> query(long qingDsId) {
        String selectField = "id, qingdsid, dimensionid, variableid, varnumber, variablejson";
        QFilter qFilter = new QFilter("qingdsid", "=", (Object)qingDsId);
        DynamicObjectCollection dataList = QueryServiceHelper.query((String)ENTITY_NAME, (String)selectField, (QFilter[])qFilter.toArray());
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            return Collections.emptyList();
        }
        return dataList.stream().map(this::transToModel).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(long modelId, long qingDsId, List<DimensionDto> dimensionDtoList) {
        HashMap<Long, Long> varDimMap = new HashMap<Long, Long>(16);
        HashMap<Long, DimMemberDto> varMemMap = new HashMap<Long, DimMemberDto>(16);
        ArrayList<Long> variableIdList = new ArrayList<Long>(16);
        QingAnalysisDSVarModelService.getInstance().extractVariable(modelId, dimensionDtoList, varDimMap, varMemMap, variableIdList, null);
        DLock dLock = DLock.create((String)("bgmd/qing/analysis/ds/var/" + qingDsId));
        dLock.fastMode();
        boolean lockFlag = dLock.tryLock(5000L);
        if (!lockFlag) {
            return;
        }
        try {
            List<QingAnalysisDSVar> varRecords = this.query(qingDsId);
            if (CollectionUtils.isEmpty(variableIdList) && CollectionUtils.isEmpty(varRecords)) {
                return;
            }
            Set exitsVarIdSet = varRecords.stream().map(QingAnalysisDSVar::getVariableId).collect(Collectors.toSet());
            HashSet<Long> variableIdSet = new HashSet<Long>(variableIdList);
            Sets.SetView needInsertVarSet = Sets.difference(variableIdSet, exitsVarIdSet);
            Sets.SetView needDeleteVarSet = Sets.difference(exitsVarIdSet, variableIdSet);
            DynamicObject[] dynamicObjects = (DynamicObject[])needInsertVarSet.stream().map(varId -> {
                DynamicObject data = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_NAME);
                data.set("qingdsid", (Object)qingDsId);
                data.set("dimensionid", varDimMap.get(varId));
                data.set("variableid", varId);
                data.set("varnumber", (Object)((DimMemberDto)varMemMap.get(varId)).getNumber());
                return data;
            }).toArray(DynamicObject[]::new);
            if (CollectionUtils.isNotEmpty((Collection)needDeleteVarSet)) {
                QFilter delFilter = new QFilter("variableid", "in", (Object)needDeleteVarSet).and("qingdsid", "=", (Object)qingDsId);
                DeleteServiceHelper.delete((String)ENTITY_NAME, (QFilter[])new QFilter[]{delFilter});
                QingAnalysisDSVarModelService.getInstance().decreaseUseCount(modelId, (Collection<Long>)needDeleteVarSet);
                QingAnalysisDSVarModelService.getInstance().delete(modelId, (Collection<Long>)needDeleteVarSet);
            }
            if (CollectionUtils.isNotEmpty((Collection)needInsertVarSet)) {
                SaveServiceHelper.save((DynamicObject[])dynamicObjects);
                QingAnalysisDSVarModelService.getInstance().save(modelId, (Set<Long>)needInsertVarSet, dimensionDtoList);
            }
            if (CollectionUtils.isNotEmpty(variableIdSet)) {
                List quotes = variableIdSet.stream().map(varId -> new MemberQuoteDao(Long.valueOf(modelId), Long.valueOf(0L), (Long)varDimMap.get(varId), varId, MemberTypeEnum.VARIABLE, MemberQuoteResourceEnum.QING_ANALYSIS_DS, Long.valueOf(qingDsId))).collect(Collectors.toList());
                DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"delete", (Object[])new Object[]{MemberQuoteResourceEnum.QING_ANALYSIS_DS.getType(), Collections.singletonList(qingDsId)});
                DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"save", (Object[])new Object[]{quotes});
            } else {
                DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"delete", (Object[])new Object[]{MemberQuoteResourceEnum.QING_ANALYSIS_DS.getType(), Collections.singletonList(qingDsId)});
            }
        }
        finally {
            dLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(long modelId, long qingDsId) {
        DLock dLock = DLock.create((String)("bgmd/qing/analysis/ds/var/" + qingDsId));
        dLock.fastMode();
        boolean lockFlag = dLock.tryLock(5000L);
        if (!lockFlag) {
            return;
        }
        try {
            List<QingAnalysisDSVar> varRecords = this.query(qingDsId);
            if (CollectionUtils.isEmpty(varRecords)) {
                return;
            }
            Set<Long> needDeleteVarSet = varRecords.stream().map(QingAnalysisDSVar::getVariableId).collect(Collectors.toSet());
            QFilter delFilter = new QFilter("qingdsid", "=", (Object)qingDsId);
            DeleteServiceHelper.delete((String)ENTITY_NAME, (QFilter[])new QFilter[]{delFilter});
            QingAnalysisDSVarModelService.getInstance().decreaseUseCount(modelId, needDeleteVarSet);
            QingAnalysisDSVarModelService.getInstance().delete(modelId, needDeleteVarSet);
        }
        finally {
            dLock.unlock();
        }
    }

    public QingAnalysisDSVar transToModel(DynamicObject dynamicObject) {
        QingAnalysisDSVar model = new QingAnalysisDSVar();
        model.setId(dynamicObject.getLong("id"));
        model.setQingDsId(dynamicObject.getLong("qingdsid"));
        model.setDimensionId(dynamicObject.getLong("dimensionid"));
        model.setVariableId(dynamicObject.getLong("variableid"));
        model.setVarNumber(dynamicObject.getString("varnumber"));
        model.setVariableJson(dynamicObject.getString("variablejson"));
        return model;
    }

    private static class InnerClass {
        private static final QingAnalysisDSVarService instance = new QingAnalysisDSVarService();

        private InnerClass() {
        }
    }
}

