/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.qinganalysis.processor;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.Field;
import kd.bos.entity.qing.ParentChildDimension;
import kd.bos.entity.qing.QingData;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.entity.qing.QingMeta;
import kd.epm.eb.business.qinganalysis.entity.QingAnalysisDS;
import kd.epm.eb.business.qinganalysis.model.DataCell;
import kd.epm.eb.business.qinganalysis.model.DimensionDto;
import kd.epm.eb.business.qinganalysis.model.DsDataModel;
import kd.epm.eb.business.qinganalysis.model.ValueFieldConfigDto;
import kd.epm.eb.business.qinganalysis.processor.IQingAnalysisDSProcessor;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.period.BgPeriodHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class DataProviderProcessor
implements IQingAnalysisDSProcessor {
    private final DsDataModel dataModel;
    private final QingAnalysisDS qingAnalysisDS;
    private final QingData qingData;
    private final int colCount;
    private final int textColCount;
    private final long modelId;
    private static final String POSTFIX_PARENT = "_parent";
    private static final String POSTFIX_ALIAS = "_alias";
    private static final String SPE_CHAR = "!";

    public DataProviderProcessor(QingAnalysisDS qingAnalysisDS) {
        this.qingAnalysisDS = qingAnalysisDS;
        this.dataModel = qingAnalysisDS.getDataModel();
        this.modelId = qingAnalysisDS.getModelId();
        this.qingData = new QingData();
        Pair<Integer, Integer> colInfo = this.buildDataIndex();
        this.textColCount = (Integer)colInfo.getLeft();
        this.colCount = (Integer)colInfo.getRight();
    }

    @Override
    public void process(List<DataCell> dataCellList, int batchRow) {
        LinkedHashMap<Integer, Object[]> rowMap = new LinkedHashMap<Integer, Object[]>(batchRow);
        for (DataCell dataCell : dataCellList) {
            int cellRow = dataCell.getRow();
            int cellCol = dataCell.getCol();
            Object[] row = rowMap.computeIfAbsent(cellRow, k -> new Object[this.colCount]);
            row[cellCol] = dataCell.getValue();
        }
        for (int index = 1; index <= batchRow; ++index) {
            Object[] row = rowMap.computeIfAbsent(index, k -> new Object[this.colCount]);
            boolean isEmptyRow = this.fillOneRow(row, this.qingAnalysisDS.getFilterEmpty());
            if (!this.qingAnalysisDS.getFilterEmpty().booleanValue() || !isEmptyRow) continue;
            rowMap.remove(index);
        }
        if (this.qingData.getRows() == null) {
            this.qingData.setRows(new ArrayList(rowMap.values()));
        } else {
            this.qingData.getRows().addAll(rowMap.values());
        }
    }

    private boolean fillOneRow(Object[] row, boolean filterEmpty) {
        boolean isEmptyRow = true;
        if (row != null) {
            for (int i = this.textColCount; i < this.colCount; ++i) {
                if (filterEmpty) {
                    if (row[i] == null) continue;
                    isEmptyRow = false;
                    continue;
                }
                isEmptyRow = false;
                if (row[i] != null) continue;
                row[i] = 0;
            }
        }
        return isEmptyRow;
    }

    private Pair<Integer, Integer> buildDataIndex() {
        List<DimensionDto> textFields = this.dataModel.getTextFields();
        List<ValueFieldConfigDto> valueFieldConf = this.dataModel.getValueFieldConf();
        HashMap<String, Integer> dataIndex = new HashMap<String, Integer>(textFields.size() + valueFieldConf.size());
        AtomicInteger colIndex = new AtomicInteger(0);
        for (DimensionDto dto : textFields) {
            String dimNumber = dto.getDimNumber();
            dataIndex.put(dimNumber, colIndex.getAndIncrement());
            if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber) && "2".equals(this.qingAnalysisDS.getBpFieldType())) continue;
            dataIndex.put(dimNumber + POSTFIX_PARENT, colIndex.getAndIncrement());
            dataIndex.put(dimNumber + POSTFIX_ALIAS, colIndex.getAndIncrement());
        }
        int textColCount = colIndex.get();
        for (ValueFieldConfigDto dto : valueFieldConf) {
            dataIndex.put(dto.getKey(), colIndex.getAndIncrement());
        }
        this.qingData.setDataindex(dataIndex);
        return Pair.of((Object)textColCount, (Object)colIndex.get());
    }

    public QingMeta buildQingMeta(String dsName) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.modelId);
        QingMeta meta = new QingMeta();
        for (DimensionDto dimensionDto : this.dataModel.getTextFields()) {
            String dimNumber = dimensionDto.getDimNumber();
            Dimension dimension = modelCache.getDimension(dimNumber);
            String dimName = dimension.getName() == null ? "" : dimension.getName();
            Field field = new Field();
            field.setKey(dimNumber);
            if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber) && !"1".equals(this.qingAnalysisDS.getBpFieldType())) {
                field.setFieldType(QingFieldType.Date.toNumber());
                field.setName(new LocaleString(dimName));
            } else {
                field.setFieldType(QingFieldType.String.toNumber());
                field.setName(new LocaleString(ResManager.loadResFormat((String)"%1\u7f16\u7801", (String)"QingAnalysisDSService_6", (String)"epm-eb-business", (Object[])new Object[]{dimName})));
            }
            meta.addColumn(field);
            if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber) && !"1".equals(this.qingAnalysisDS.getBpFieldType())) continue;
            Field parentField = new Field();
            parentField.setKey(dimNumber + POSTFIX_PARENT);
            parentField.setName(new LocaleString(dimNumber + POSTFIX_PARENT));
            parentField.setFieldType(QingFieldType.String.toNumber());
            parentField.setHide(true);
            Field aliasField = new Field();
            aliasField.setKey(dimNumber + POSTFIX_ALIAS);
            aliasField.setName(new LocaleString(ResManager.loadResFormat((String)"%1\u540d\u79f0", (String)"QingAnalysisDSService_7", (String)"epm-eb-business", (Object[])new Object[]{dimName})));
            aliasField.setFieldType(QingFieldType.String.toNumber());
            aliasField.setHide(false);
            meta.addColumn(parentField);
            meta.addColumn(aliasField);
            ParentChildDimension pcd = new ParentChildDimension(dimNumber, dimName, field, parentField);
            pcd.setNecessary(ParentChildDimension.Necessary.Indispensable);
            pcd.setDefaultDisplayName(aliasField);
            pcd.setSortAccording(field);
            meta.addParentChildDimension(pcd);
        }
        for (ValueFieldConfigDto valueFieldConfigDto : this.dataModel.getValueFieldConf()) {
            Field column = new Field();
            column.setKey(valueFieldConfigDto.getKey());
            column.setFieldType(QingFieldType.Number.toNumber());
            column.setName(new LocaleString(valueFieldConfigDto.getName()));
            meta.addColumn(column);
        }
        return meta;
    }

    @Override
    public Pair<Integer, List<DataCell>> buildTextFieldCell(Map<String, List<Member>> memberMap, List<String> pageMemRowKeyList, Map<String, Set<String>> pageMemNumberMap, int startRow, int limit) {
        HashMap<String, Pair<String, String>> memObjMap = new HashMap<String, Pair<String, String>>(memberMap.size());
        HashMap memNumberMap = new HashMap(memberMap.size());
        memberMap.forEach((dimNumber, members) -> {
            Set memNumberSet = members.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
            memNumberMap.put(dimNumber, memNumberSet);
        });
        List<List<String>> subNumberList = this.cartesianAndPartition(memberMap, startRow, limit, memObjMap);
        ArrayList cellList = new ArrayList(subNumberList.size());
        AtomicInteger colCount = new AtomicInteger(0);
        AtomicInteger numberRow = new AtomicInteger(1);
        subNumberList.forEach(list -> {
            AtomicInteger dataCol = new AtomicInteger(0);
            StringBuilder rowKey = new StringBuilder();
            list.forEach(str -> {
                String[] arr = str.split(SPE_CHAR);
                String dimNumber = arr[0];
                String memNumber = arr[1];
                if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber) && "2".equals(this.qingAnalysisDS.getBpFieldType())) {
                    Date date = BgPeriodHelper.periodNumberToDate((String)memNumber);
                    cellList.add(new DataCell(numberRow.get(), dataCol.getAndIncrement(), date == null ? 0L : date.getTime()));
                } else {
                    cellList.add(new DataCell(numberRow.get(), dataCol.getAndIncrement(), memNumber));
                }
                Pair memInfo = (Pair)memObjMap.get(str);
                if (memInfo != null) {
                    Set memNumberSet;
                    String parentNumber;
                    String string = parentNumber = memInfo.getRight() == null ? "" : (String)memInfo.getRight();
                    if (StringUtils.isNotBlank((CharSequence)parentNumber) && (memNumberSet = (Set)memNumberMap.get(dimNumber)) != null && !memNumberSet.contains(parentNumber)) {
                        parentNumber = "";
                    }
                    cellList.add(new DataCell(numberRow.get(), dataCol.getAndIncrement(), parentNumber));
                    cellList.add(new DataCell(numberRow.get(), dataCol.getAndIncrement(), memInfo.getLeft()));
                }
                Set memList = pageMemNumberMap.computeIfAbsent(dimNumber, k -> new LinkedHashSet(16));
                memList.add(memNumber);
                rowKey.append(memNumber).append('!');
            });
            numberRow.incrementAndGet();
            if (colCount.get() == 0) {
                colCount.set(dataCol.get());
            }
            pageMemRowKeyList.add(rowKey.toString());
        });
        return Pair.of((Object)colCount.get(), cellList);
    }

    private List<List<String>> cartesianAndPartition(Map<String, List<Member>> memberMap, int startRow, int limit, Map<String, Pair<String, String>> memObjMap) {
        ArrayList numberList = new ArrayList(memberMap.size());
        memberMap.forEach((dimNumber, memberList) -> {
            ArrayList memNumberList = new ArrayList(memberList.size());
            memberList.forEach(m -> {
                if (StringUtils.isBlank((CharSequence)m.getName())) {
                    return;
                }
                if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber) && "2".equals(this.qingAnalysisDS.getBpFieldType()) && !m.isLeaf()) {
                    return;
                }
                String key = dimNumber + SPE_CHAR + m.getNumber();
                memNumberList.add(key);
                if (!SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber) || "1".equals(this.qingAnalysisDS.getBpFieldType())) {
                    String parentNumber = m.getLevel() == 2 ? null : m.getParentNumber();
                    memObjMap.put(key, Pair.of((Object)m.getName(), (Object)parentNumber));
                }
            });
            numberList.add(memNumberList);
        });
        List numberCartesianList = Lists.cartesianProduct(numberList);
        int endRow = startRow + limit;
        if (endRow > numberCartesianList.size()) {
            endRow = numberCartesianList.size();
        }
        return numberCartesianList.subList(startRow, endRow);
    }

    public QingData getQingData() {
        return this.qingData;
    }

    @Override
    public Long getQingDsId() {
        return this.qingAnalysisDS.getId();
    }

    @Override
    public QingAnalysisDS getQingAnalysisDS() {
        return this.qingAnalysisDS;
    }
}

