/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.qinganalysis.processor;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.epm.eb.business.qinganalysis.QingAnalysisDSService;
import kd.epm.eb.business.qinganalysis.entity.QingAnalysisDS;
import kd.epm.eb.business.qinganalysis.model.DataCell;
import kd.epm.eb.business.qinganalysis.model.DimensionDto;
import kd.epm.eb.business.qinganalysis.model.DsDataModel;
import kd.epm.eb.business.qinganalysis.model.ValueFieldConfigDto;
import kd.epm.eb.business.qinganalysis.processor.IQingAnalysisDSProcessor;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.ebSpread.util.GZIPUtils;
import kd.epm.eb.spread.command.rangedefined.CellArea;
import kd.epm.eb.spread.command.style.AreasStyle;
import kd.epm.eb.spread.command.style.CellStyleInfo;
import kd.epm.eb.spread.command.style.HorizontalAlignEnum;
import kd.epm.eb.spread.control.SpreadContainer;
import kd.epm.eb.spread.domain.view.js.SpreadProperties;
import kd.epm.eb.spread.template.spreadmanager.book.EBook;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class PreviewProcessor
implements IQingAnalysisDSProcessor {
    private final SpreadContainer spreadContainer;
    private final IModelCacheHelper modelCache;
    private final DsDataModel dataModel;
    private final Long qingDsId;
    private QingAnalysisDS qingAnalysisDS;
    private static final String BORDER_COLOR = "#4c4c4c";
    private static final String BORDER_STYLE = "thin";
    private static final String HEAD_FONT_COLOR = "#DEE6FC";
    private static final String TIPS_FONT_COLOR = "#FF5F1F";
    private static final String FIELD_FONT_COLOR = "#E6E8EE";
    private static final String VALUE_FONT_COLOR = "#FFF8E1";
    private static final String SPE_CHAR = "!";

    public PreviewProcessor(Long qingDsId, SpreadContainer spreadContainer, IModelCacheHelper modelCache, DsDataModel dataModel) {
        this.spreadContainer = spreadContainer;
        this.dataModel = dataModel;
        this.modelCache = modelCache;
        this.qingDsId = qingDsId;
    }

    @Override
    public void process(List<DataCell> dataCellList, int batchRow) {
        int fieldColSize = this.dataModel.getTextFields().size();
        int valueColSize = this.dataModel.getValueFieldConf().size();
        int totalRow = batchRow + 2;
        int totalCol = fieldColSize + valueColSize;
        this.setDefaultStyle(totalRow, totalCol);
        this.writeHead();
        List<Map<String, Object>> cellList = this.transToCell(dataCellList);
        this.spreadContainer.updateCellValue(cellList);
        int startRow = 2;
        this.setCellStyle(startRow, batchRow, 0, fieldColSize, false, false);
        this.setCellStyle(startRow, batchRow, fieldColSize, valueColSize, false, true);
        ArrayList<Integer> colList = new ArrayList<Integer>(totalCol);
        for (int i = 0; i < totalCol; ++i) {
            colList.add(i);
        }
        this.spreadContainer.setColsAutoFit(colList);
    }

    private List<Map<String, Object>> transToCell(List<DataCell> dataCellList) {
        return dataCellList.parallelStream().map(dataCell -> this.buildCell(dataCell.getRow() + 1, dataCell.getCol(), dataCell.getValue())).collect(Collectors.toList());
    }

    private void writeHead() {
        int headRow = 0;
        int headCol = 0;
        ArrayList<Map<String, Object>> headCellList = new ArrayList<Map<String, Object>>(16);
        headCellList.add(this.buildCell(headRow, headCol, ResManager.loadKDString((String)"\u9884\u89c8\u6700\u591a\u53ef\u5c55\u793a1000\u884c\u6570\u636e\u3002", (String)"PreviewProcessor_1", (String)"epm-eb-business", (Object[])new Object[0])));
        ++headRow;
        for (DimensionDto dimDto : this.dataModel.getTextFields()) {
            Dimension dimension = this.modelCache.getDimension(dimDto.getDimNumber());
            headCellList.add(this.buildCell(headRow, headCol++, dimension.getName()));
        }
        for (ValueFieldConfigDto configDto : this.dataModel.getValueFieldConf()) {
            headCellList.add(this.buildCell(headRow, headCol++, configDto.getName()));
        }
        this.spreadContainer.updateCellValue(headCellList);
        this.setHeadTipsStyle(headCol);
        this.setCellStyle(1, 1, 0, headCol, true, false);
    }

    private Map<String, Object> buildCell(int row, int col, Object value) {
        HashMap<String, Object> valMap = new HashMap<String, Object>(3);
        valMap.put(SpreadProperties.UpdataValueMethod.R.k(), row);
        valMap.put(SpreadProperties.UpdataValueMethod.C.k(), col);
        valMap.put(SpreadProperties.UpdataValueMethod.V.k(), String.valueOf(value));
        return valMap;
    }

    private void setDefaultStyle(int totalRow, int totalCol) {
        byte[] bb;
        EBook ieBook = new EBook(new String[]{"Sheet1"});
        ISheet sheet = ieBook.getSheet(0);
        sheet.setStyleCell(true);
        sheet.getECell(totalRow - 1, totalCol - 1);
        HashMap defaultStyle = Maps.newHashMapWithExpectedSize((int)2);
        defaultStyle.put("borderColor", "#D3D3D3");
        defaultStyle.put("font", "13px Microsoft YaHei");
        sheet.setDefaultDataNodeStyle((Map)defaultStyle);
        try {
            String spreadJson = ieBook.toJsonWithRealRowCol();
            bb = Base64.getEncoder().encode(GZIPUtils.compress((String)spreadJson));
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
        this.spreadContainer.rebuildSpread("base64" + new String(bb));
        this.spreadContainer.setToolbarExpandBtnVisible(Boolean.valueOf(false));
    }

    private void setCellStyle(int startRow, int rowSize, int startCol, int colSize, boolean isHead, boolean isValue) {
        CellArea cellArea = new CellArea(startRow, startCol, rowSize, colSize);
        CellStyleInfo cellStyleInfo = new CellStyleInfo();
        cellStyleInfo.setBlc(Collections.singletonList(BORDER_COLOR));
        cellStyleInfo.setBls(Collections.singletonList(BORDER_STYLE));
        cellStyleInfo.setL(Boolean.valueOf(true));
        if (isHead) {
            cellStyleInfo.setBkc(HEAD_FONT_COLOR);
        } else if (isValue) {
            cellStyleInfo.setBkc(VALUE_FONT_COLOR);
            cellStyleInfo.setHa(HorizontalAlignEnum.RIGHT);
        } else {
            cellStyleInfo.setBkc(FIELD_FONT_COLOR);
        }
        AreasStyle areasStyle = new AreasStyle();
        areasStyle.setRange(Collections.singletonList(cellArea));
        areasStyle.setStyle(cellStyleInfo);
        this.spreadContainer.setCellStyle(Collections.singletonList(areasStyle));
    }

    private void setHeadTipsStyle(int colSize) {
        CellArea cellArea = new CellArea(0, 0, 1, colSize);
        CellStyleInfo cellStyleInfo = new CellStyleInfo();
        cellStyleInfo.setBlc(Collections.singletonList(BORDER_COLOR));
        cellStyleInfo.setBls(Collections.singletonList(BORDER_STYLE));
        cellStyleInfo.setL(Boolean.valueOf(true));
        cellStyleInfo.setBkc(HEAD_FONT_COLOR);
        cellStyleInfo.setFrc(TIPS_FONT_COLOR);
        AreasStyle areasStyle = new AreasStyle();
        areasStyle.setRange(Collections.singletonList(cellArea));
        areasStyle.setStyle(cellStyleInfo);
        this.spreadContainer.setCellStyle(Collections.singletonList(areasStyle));
        this.spreadContainer.setSpan(Collections.singletonList(cellArea));
    }

    @Override
    public Pair<Integer, List<DataCell>> buildTextFieldCell(Map<String, List<Member>> memberMap, List<String> pageMemRowKeyList, Map<String, Set<String>> pageMemNumberMap, int startRow, int limit) {
        AtomicInteger cartesianSize = new AtomicInteger(1);
        ArrayList nameList = new ArrayList(memberMap.size());
        memberMap.forEach((dimNumber, memberList) -> {
            List list = memberList.stream().map(m -> dimNumber + SPE_CHAR + m.getNumber() + SPE_CHAR + (StringUtils.isNotBlank((CharSequence)m.getName()) ? m.getName() : m.getNumber())).collect(Collectors.toList());
            nameList.add(list);
            cartesianSize.set(cartesianSize.get() * list.size());
        });
        List nameCartesianList = Lists.cartesianProduct(nameList);
        int endRow = startRow + limit;
        if (endRow > nameCartesianList.size()) {
            endRow = nameCartesianList.size();
        }
        List subList = nameCartesianList.subList(startRow, endRow);
        ArrayList cellList = new ArrayList(cartesianSize.get());
        AtomicInteger colCount = new AtomicInteger(0);
        AtomicInteger nameRow = new AtomicInteger(1);
        subList.forEach(list -> {
            AtomicInteger dataCol = new AtomicInteger(0);
            StringBuilder rowKey = new StringBuilder();
            list.forEach(col -> {
                String[] arr = col.split(SPE_CHAR);
                String dimNumber = arr[0];
                String memNumber = arr[1];
                String memName = arr[2];
                cellList.add(new DataCell(nameRow.get(), dataCol.getAndIncrement(), memName));
                Set memList = pageMemNumberMap.computeIfAbsent(dimNumber, k -> new LinkedHashSet(16));
                memList.add(memNumber);
                rowKey.append(memNumber).append('!');
            });
            nameRow.incrementAndGet();
            if (colCount.get() == 0) {
                colCount.set(dataCol.get());
            }
            pageMemRowKeyList.add(rowKey.toString());
        });
        return Pair.of((Object)colCount.get(), cellList);
    }

    @Override
    public Long getQingDsId() {
        return this.qingDsId;
    }

    @Override
    public QingAnalysisDS getQingAnalysisDS() {
        if (this.qingAnalysisDS == null) {
            this.qingAnalysisDS = QingAnalysisDSService.getInstance().load(this.qingDsId);
        }
        return this.qingAnalysisDS;
    }
}

