/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.quote;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.quote.CheckQuote;
import kd.epm.eb.business.quote.QuoteCheckResult;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.enums.memberQuote.MemberTypeEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractQuoteCheck {
    public static final Log log = LogFactory.getLog(AbstractQuoteCheck.class);
    private static final Map<Integer, List<Object[]>> register = Maps.newLinkedHashMap();
    private static final Map<Integer, List<Object[]>> regEb = Maps.newLinkedHashMap();
    private static final Map<Integer, List<Object[]>> regMbg = Maps.newLinkedHashMap();
    protected static final int INDEX_RESOURCE_TYPE = 0;
    protected static final int INDEX_ENTITY_NUMBER = 1;
    protected static final int INDEX_TABLE = 2;
    protected static final int INDEX_MAIN_TABLE = 3;
    protected static final int INDEX_CLASS = 4;
    protected static final int INDEX_FIELD = 5;
    protected static final int INDEX_PK_FIELD = 6;
    protected static final int INDEX_CHECK_TYPE = 7;
    public static final int MAX_RESULT_SIZE = 5000;
    public static final Map<String, String> TABLE_VIEW;
    private IModelCacheHelper modelCache = null;

    protected static Map<Integer, List<Object[]>> getRegister() {
        return register;
    }

    protected static Map<Integer, List<Object[]>> getRegEb() {
        return regEb;
    }

    protected static Map<Integer, List<Object[]>> getRegMbg() {
        return regMbg;
    }

    protected static void register(@NotNull Map<Integer, List<Object[]>> register, @NotNull MemberTypeEnum memberType, @NotNull MemberQuoteResourceEnum resource, String entityNumber, @NotNull String table, String mainTable, String customClass, @NotNull String field, String pkField, int checkType) {
        List params = register.computeIfAbsent(memberType.getType(), f -> Lists.newArrayList());
        params.add(new Object[]{resource, entityNumber, table, mainTable, customClass, field, pkField, checkType});
    }

    protected static void register(@NotNull Map<Integer, List<Object[]>> register, @NotNull MemberTypeEnum memberType, @NotNull MemberQuoteResourceEnum resource, String entityNumber, @NotNull String table, String mainTable, @NotNull String field, String pkField) {
        AbstractQuoteCheck.register(register, memberType, resource, entityNumber, table, mainTable, null, field, pkField, 0);
    }

    protected static void register(@NotNull Map<Integer, List<Object[]>> register, @NotNull MemberTypeEnum memberType, @NotNull MemberQuoteResourceEnum resource, String entityNumber, @NotNull String table, @NotNull String field) {
        AbstractQuoteCheck.register(register, memberType, resource, entityNumber, table, null, null, field, null, 0);
    }

    protected static void register(@NotNull Map<Integer, List<Object[]>> register, @NotNull MemberTypeEnum memberType, @NotNull MemberQuoteResourceEnum resource, String entityNumber, @NotNull String table, @NotNull String field, @NotNull String pkField) {
        AbstractQuoteCheck.register(register, memberType, resource, entityNumber, table, null, null, field, pkField, 0);
    }

    protected IModelCacheHelper getModelCache(@NotNull Long modelId) {
        if (this.modelCache == null || this.modelCache.getModelobj().getId().compareTo(modelId) != 0) {
            this.modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        }
        return this.modelCache;
    }

    public abstract Set<Long> checkQuote(@NotNull CheckQuote var1);

    public abstract QuoteCheckResult checkQuoteResult(@NotNull CheckQuote var1);

    protected DynamicObjectCollection loadResourceMap(String entityNumber, Set<Long> resourceIds) {
        return this.loadMap(entityNumber, resourceIds);
    }

    protected DynamicObjectCollection loadMap(@NotNull String entityNumber, Set<Long> ids) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        if (dataEntityType.getProperty("name") != null) {
            return this.loadMap(entityNumber, "id, number,name", ids);
        }
        return this.loadMap(entityNumber, "id, number", ids);
    }

    protected DynamicObjectCollection loadMap(@NotNull String entityNumber, @NotNull String fields, Set<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            return new DynamicObjectCollection();
        }
        return QueryServiceHelper.query((String)entityNumber, (String)fields, (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
    }

    protected void buildMsgInfo(CheckQuote checkQuote, Object[] checkParam, StringBuilder str, int memberType, Map<Long, Long> memberIds, Map<Long, Map<Integer, Set<Long>>> resourceMap) {
        MemberTypeEnum memberTypeEnum = MemberTypeEnum.getEnum((int)memberType);
        if (memberTypeEnum == null) {
            throw new IllegalStateException();
        }
        String baseMsg = this.getQuoteTypeMsg(checkParam, memberTypeEnum);
        if (baseMsg == null) {
            return;
        }
        if (MemberTypeEnum.MEMBER == memberTypeEnum) {
            this.buildDimMemberInfo(checkQuote, str, baseMsg, memberIds, resourceMap);
        } else {
            this.buildOtherInfo(checkQuote, str, baseMsg, memberIds, resourceMap, memberTypeEnum);
        }
    }

    private void buildDimMemberInfo(CheckQuote checkQuote, StringBuilder str, String baseMsg, Map<Long, Long> memberIds, Map<Long, Map<Integer, Set<Long>>> resourceMap) {
        if (memberIds.isEmpty()) {
            return;
        }
        ArrayList<String> allMembers = new ArrayList<String>(memberIds.size());
        Dimension dimension = this.getModelCache(checkQuote.getModelId()).getDimension(checkQuote.getDimensionId());
        if (dimension == null) {
            return;
        }
        for (Map.Entry<Long, Long> quote : memberIds.entrySet()) {
            Member member;
            Long quoteId = quote.getKey();
            Long memberId = quote.getValue();
            if (dimension == null || (member = dimension.getMember(checkQuote.getViewId(), memberId)) == null) continue;
            Map<Integer, Set<Long>> resTypeMap = resourceMap.get(quoteId);
            if (resTypeMap == null || resTypeMap.isEmpty()) {
                resTypeMap = resourceMap.get(memberId);
            }
            if (resTypeMap == null || resTypeMap.isEmpty()) continue;
            Object[] tmpStr = new String[]{member.getNumber() + '_' + member.getName(), this.buildQuoteInfo(checkQuote, resTypeMap)};
            allMembers.add(StringUtils.replace((String)baseMsg, (Object[])tmpStr));
        }
        if (!allMembers.isEmpty()) {
            str.append(dimension.getName()).append(StringUtils.join(allMembers, (String)", ")).append(',');
        }
    }

    private String buildQuoteInfo(CheckQuote checkQuote, Map<Integer, Set<Long>> resTypeMap) {
        ArrayList<String> allTypes = new ArrayList<String>();
        for (Map.Entry<Integer, Set<Long>> type : resTypeMap.entrySet()) {
            ArrayList<String> numbers;
            DynamicObjectCollection resourceMap;
            MainEntityType doType;
            MemberQuoteResourceEnum resourceEnum = MemberQuoteResourceEnum.getEnum((int)type.getKey());
            if (resourceEnum == null) continue;
            String entityNumber = resourceEnum.getEntityNumber();
            if (StringUtils.isEmpty((String)entityNumber)) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u7ef4\u5ea6\u6210\u5458\u5f15\u7528\u68c0\u67e5\u9519\u8bef\uff0c\u4e0d\u660e\u786e\u7684\u5f15\u7528\u57fa\u7840\u6570\u636e\u6765\u6e90\u7c7b\u522b(%1)", (String)"AbstractQuoteCheck_0", (String)"epm-eb-business", (Object[])new Object[]{resourceEnum.getType()}));
            }
            if (resourceEnum == MemberQuoteResourceEnum.Template && this.getModelCache(checkQuote.getModelId()).getModelobj().isModelByEB()) {
                entityNumber = "eb_templateentity_bg";
            }
            if ((doType = EntityMetadataCache.getDataEntityType((String)entityNumber)).getProperty("number") != null) {
                resourceMap = this.loadResourceMap(entityNumber, type.getValue());
                if (resourceMap.isEmpty()) {
                    allTypes.add(resourceEnum.getName());
                    continue;
                }
                numbers = new ArrayList<String>(resourceMap.size());
                for (DynamicObject resource : resourceMap) {
                    if (MemberQuoteResourceEnum.TaskList.getType() == type.getKey().intValue()) {
                        numbers.add(resource.getString("name"));
                        continue;
                    }
                    numbers.add(resource.getString("number"));
                }
                if (MemberQuoteResourceEnum.MAINSUBMODEL_BASE.getType() == type.getKey().intValue()) {
                    allTypes.add(ResManager.loadResFormat((String)"\u5b50\u4f53\u7cfb\u201c%1\u201d\u7684\u7ba1\u63a7\u7b56\u7565", (String)"MainSubModel_001", (String)"epm-eb-business", (Object[])new Object[]{StringUtils.join(numbers, (char)',')}));
                    continue;
                }
                allTypes.add(resourceEnum.getName() + '_' + StringUtils.join(numbers, (char)','));
                continue;
            }
            if (doType.getProperty("code") != null) {
                resourceMap = doType.getProperty("name") != null ? this.loadMap(entityNumber, "id, code,name", type.getValue()) : this.loadMap(entityNumber, "id, code", type.getValue());
                if (resourceMap.isEmpty()) continue;
                numbers = new ArrayList(resourceMap.size());
                for (DynamicObject resource : resourceMap) {
                    if (MemberQuoteResourceEnum.TaskList.getType() == type.getKey().intValue()) {
                        numbers.add(resource.getString("name"));
                        continue;
                    }
                    numbers.add(resource.getString("code"));
                }
                allTypes.add(resourceEnum.getName() + '_' + StringUtils.join(numbers, (char)','));
                continue;
            }
            Model model = this.getModelCache(checkQuote.getModelId()).getModelobj();
            String modelMsg = ResManager.loadKDString((String)"\u4f53\u7cfb", (String)"BasedataEnum_3", (String)"epm-eb-business", (Object[])new Object[0]);
            allTypes.add(resourceEnum.getName() + '{' + modelMsg + ':' + model.getName() + '-' + model.getNumber() + '}');
        }
        if (!allTypes.isEmpty()) {
            return StringUtils.join(allTypes, (String)"; ");
        }
        return "";
    }

    private void buildOtherInfo(CheckQuote checkQuote, StringBuilder str, String baseMsg, Map<Long, Long> memberIds, Map<Long, Map<Integer, Set<Long>>> resourceMap, MemberTypeEnum memberType) {
        if (memberIds.isEmpty()) {
            return;
        }
        ArrayList<String> allMembers = new ArrayList<String>(memberIds.size());
        Map<Long, Map<String, Object>> objects = this.getObjectInfo(memberType, new HashSet<Long>(memberIds.values()));
        for (Map.Entry<Long, Long> quote : memberIds.entrySet()) {
            Long quoteId = quote.getKey();
            Long memberId = quote.getValue();
            Map<String, Object> _object = objects.get(memberId);
            if (_object == null) continue;
            Map<Integer, Set<Long>> resTypeMap = resourceMap.get(quoteId);
            if (resTypeMap == null || resTypeMap.isEmpty()) {
                resTypeMap = resourceMap.get(memberId);
            }
            if (resTypeMap == null || resTypeMap.isEmpty()) continue;
            Object[] tmpStr = new String[]{(String)_object.get("number") + '_' + _object.get("name"), this.buildQuoteInfo(checkQuote, resTypeMap)};
            allMembers.add(StringUtils.replace((String)baseMsg, (Object[])tmpStr));
        }
        if (!allMembers.isEmpty()) {
            str.append(StringUtils.join(allMembers, (String)", ")).append(',');
        }
    }

    private Map<Long, Map<String, Object>> getObjectInfo(MemberTypeEnum memberType, Set<Long> memberIds) {
        if (memberIds == null || memberIds.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap objects = Maps.newHashMapWithExpectedSize((int)memberIds.size());
        if (memberType == null) {
            throw new IllegalStateException();
        }
        String entityNumber = memberType.getFormKey();
        String algoKey = "query" + memberType.name();
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityNumber, (String)"id, number, name", (QFilter[])new QFilter[]{new QFilter("id", "in", memberIds)}, null);){
            if (ds != null) {
                for (Row row : ds) {
                    HashMap<String, Object> object = new HashMap<String, Object>();
                    object.put("id", row.getLong("id"));
                    object.put("number", row.getString("number"));
                    object.put("name", row.getString("name"));
                    objects.put(row.getLong("id"), object);
                }
            }
        }
        return objects;
    }

    private String getQuoteTypeMsg(Object[] checkParam, MemberTypeEnum memberTypeEnum) {
        String msg;
        if (memberTypeEnum == null) {
            throw new IllegalStateException();
        }
        if (MemberTypeEnum.MEMBER == memberTypeEnum) {
            msg = ResManager.loadKDString((String)"\u6210\u5458\u201c%1\u201d\u6216\u4e0b\u7ea7\u6210\u5458\u5df2\u88ab\u201c%2\u201d\u5f15\u7528\u3002", (String)"QuoteCheck_0", (String)"epm-eb-business", (Object[])new Object[0]);
            if (checkParam != null && checkParam[0] == MemberQuoteResourceEnum.Template && StringUtils.equals((String)((String)checkParam[4]), (String)"kd.epm.eb.business.quote.impl.ReportQuoteCheckImpl")) {
                msg = ResManager.loadKDString((String)"\u6210\u5458(%1)\u6216\u8005\u4e0b\u7ea7\u6210\u5458\u88ab(%2)\u5173\u8054\u751f\u6210\u7684\u62a5\u8868\u5b9e\u4f8b\u5f15\u7528", (String)"QuoteCheck_9", (String)"epm-eb-business", (Object[])new Object[0]);
            }
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append(memberTypeEnum.getName()).append(ResManager.loadResFormat((String)"\u201c%1\u201d\u5df2\u88ab\u201c%2\u201d\u5f15\u7528", (String)"QuoteCheck_7", (String)"epm-eb-business", (Object[])new Object[0]));
            msg = sb.toString();
        }
        return msg;
    }

    protected void getChildren(@NotNull CheckQuote checkQuote) {
        checkQuote.getMemberIds().remove(null);
        checkQuote.getMemberIds().remove(0L);
        if (checkQuote.getMemberIds().isEmpty() || !checkQuote.isCheckChild()) {
            return;
        }
        if (checkQuote.getMemberTypeEnum() != MemberTypeEnum.MEMBER) {
            return;
        }
        if (!checkQuote.isInitChild()) {
            List members;
            IModelCacheHelper modelCache = this.getModelCache(checkQuote.getModelId());
            if (modelCache == null || modelCache.getModelobj() == null) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u7ef4\u5ea6\u6210\u5458\u5f15\u7528\u68c0\u67e5\u5931\u8d25\uff0c\u9519\u8bef\u7684\u4f53\u7cfbId\uff1a\u201c%1\u201d\u3002", (String)"QuoteCheck_2", (String)"epm-eb-business", (Object[])new Object[]{checkQuote.getDimensionId()}));
            }
            Dimension dimension = modelCache.getDimension(checkQuote.getDimensionId());
            if (dimension == null) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u7ef4\u5ea6\u6210\u5458\u5f15\u7528\u68c0\u67e5\u5931\u8d25\uff0c\u9519\u8bef\u7684\u7ef4\u5ea6Id\uff1a\u201c%1\u201d\u3002", (String)"QuoteCheck_3", (String)"epm-eb-business", (Object[])new Object[]{checkQuote.getDimensionId()}));
            }
            View view = null;
            if (IDUtils.isNotNull((Long)checkQuote.getViewId())) {
                view = dimension.getView(checkQuote.getViewId());
            }
            List list = members = view != null ? view.getLeafMembers(checkQuote.getMemberIds()) : dimension.getLeafMembers(checkQuote.getMemberIds());
            if (members != null && !members.isEmpty()) {
                LinkedHashSet _memberIds = Sets.newLinkedHashSet();
                members.forEach(_member -> _memberIds.add(_member.getId()));
                checkQuote.setOldMemberIds(new LinkedHashSet<Long>(checkQuote.getMemberIds()));
                checkQuote.getMemberIds().addAll(_memberIds);
            }
            checkQuote.setInitChild(true);
        }
    }

    static {
        AbstractQuoteCheck.register(AbstractQuoteCheck.getRegMbg(), MemberTypeEnum.MEMBER, MemberQuoteResourceEnum.Account, SysDimensionEnum.Metric.getMemberTreemodel(), "t_eb_accountmetric", "fmetric");
        AbstractQuoteCheck.register(AbstractQuoteCheck.getRegMbg(), MemberTypeEnum.MEMBER, MemberQuoteResourceEnum.ViewMember, null, "t_eb_viewmember", "fmemberid,fdimensionid");
        AbstractQuoteCheck.register(AbstractQuoteCheck.getRegMbg(), MemberTypeEnum.MEMBER, MemberQuoteResourceEnum.ViewMember, null, "t_eb_viewmember", "fmemberid", "fviewid");
        AbstractQuoteCheck.register(AbstractQuoteCheck.getRegMbg(), MemberTypeEnum.DIMENSION, MemberQuoteResourceEnum.CustomProperty, "epm_dimension", "t_eb_customproperty", "fdimensionid");
        AbstractQuoteCheck.register(AbstractQuoteCheck.getRegMbg(), MemberTypeEnum.DIMENSION, MemberQuoteResourceEnum.DimView, null, "t_eb_dimensionview", "fdimensionid");
        AbstractQuoteCheck.register(AbstractQuoteCheck.getRegMbg(), MemberTypeEnum.DIMENSION, MemberQuoteResourceEnum.BusinessModel, null, "t_eb_viewentry", "fdimensionid");
        AbstractQuoteCheck.register(AbstractQuoteCheck.getRegMbg(), MemberTypeEnum.VIEW, MemberQuoteResourceEnum.DimView, null, "t_eb_dimensionview", "fparentid");
        AbstractQuoteCheck.register(AbstractQuoteCheck.getRegMbg(), MemberTypeEnum.VIEW, MemberQuoteResourceEnum.BusinessModel, null, "t_eb_viewentry", "fviewid");
        AbstractQuoteCheck.register(AbstractQuoteCheck.getRegMbg(), MemberTypeEnum.MEMBER, MemberQuoteResourceEnum.TaskList, SysDimensionEnum.Entity.getMemberTreemodel(), "t_eb_tasksave", "forgid", "ftasklistid");
        AbstractQuoteCheck.register(AbstractQuoteCheck.getRegMbg(), MemberTypeEnum.VIEW, MemberQuoteResourceEnum.TaskList, null, "t_eb_tasklist", "forgview");
        AbstractQuoteCheck.register(AbstractQuoteCheck.getRegMbg(), MemberTypeEnum.VIEW, MemberQuoteResourceEnum.TaskRelease, null, "t_eb_taskprocess", "forgviewid");
        AbstractQuoteCheck.register(AbstractQuoteCheck.getRegMbg(), MemberTypeEnum.VIEW, MemberQuoteResourceEnum.RptScheme, null, "t_eb_rptscheme", "forgviewid");
        AbstractQuoteCheck.register(AbstractQuoteCheck.getRegMbg(), MemberTypeEnum.MEMBER, MemberQuoteResourceEnum.RptScheme, SysDimensionEnum.Entity.getMemberTreemodel(), "t_eb_templateorg", "forgid", "fschemeid");
        AbstractQuoteCheck.register(AbstractQuoteCheck.getRegMbg(), MemberTypeEnum.MEMBER, MemberQuoteResourceEnum.TemplateUserPerm, SysDimensionEnum.Entity.getMemberTreemodel(), "t_eb_templateuser", "fentityid");
        AbstractQuoteCheck.register(AbstractQuoteCheck.getRegMbg(), MemberTypeEnum.MEMBER, MemberQuoteResourceEnum.SchemeAssign, SysDimensionEnum.BudgetPeriod.getMemberTreemodel(), "t_eb_schemeassign", "fyearid");
        AbstractQuoteCheck.register(AbstractQuoteCheck.getRegMbg(), MemberTypeEnum.MEMBER, MemberQuoteResourceEnum.SchemeAssign, SysDimensionEnum.DataType.getMemberTreemodel(), "t_eb_schemeassign", "fdatatypeid");
        AbstractQuoteCheck.register(AbstractQuoteCheck.getRegMbg(), MemberTypeEnum.MEMBER, MemberQuoteResourceEnum.SchemeAssign, SysDimensionEnum.Version.getMemberTreemodel(), "t_eb_schemeassign", "fversionid");
        AbstractQuoteCheck.register(AbstractQuoteCheck.getRegMbg(), MemberTypeEnum.MEMBER, MemberQuoteResourceEnum.Report, SysDimensionEnum.Version.getMemberTreemodel(), "t_eb_reportprocess", "fversion");
        AbstractQuoteCheck.register(AbstractQuoteCheck.getRegEb(), MemberTypeEnum.MEMBER, MemberQuoteResourceEnum.Report, SysDimensionEnum.Entity.getMemberTreemodel(), "t_eb_report", "fentityid");
        AbstractQuoteCheck.register(AbstractQuoteCheck.getRegEb(), MemberTypeEnum.MEMBER, MemberQuoteResourceEnum.Report, SysDimensionEnum.Year.getMemberTreemodel(), "t_eb_report", "ffyid");
        AbstractQuoteCheck.register(AbstractQuoteCheck.getRegEb(), MemberTypeEnum.MEMBER, MemberQuoteResourceEnum.Report, SysDimensionEnum.Period.getMemberTreemodel(), "t_eb_report", "fperiodid");
        AbstractQuoteCheck.register(AbstractQuoteCheck.getRegEb(), MemberTypeEnum.MEMBER, MemberQuoteResourceEnum.Report, SysDimensionEnum.Currency.getMemberTreemodel(), "t_eb_report", "fcurrencyid");
        AbstractQuoteCheck.register(AbstractQuoteCheck.getRegEb(), MemberTypeEnum.MEMBER, MemberQuoteResourceEnum.Report, SysDimensionEnum.Scenario.getMemberTreemodel(), "t_eb_report", "fsceneid");
        AbstractQuoteCheck.register(AbstractQuoteCheck.getRegMbg(), MemberTypeEnum.MEMBER, MemberQuoteResourceEnum.Convert, SysDimensionEnum.Currency.getMemberTreemodel(), "t_eb_currencyconvertschem", "fcurrencyraw");
        AbstractQuoteCheck.register(AbstractQuoteCheck.getRegMbg(), MemberTypeEnum.MEMBER, MemberQuoteResourceEnum.Convert, SysDimensionEnum.Currency.getMemberTreemodel(), "t_eb_currencyconvertschem", "fcurrencyrate");
        AbstractQuoteCheck.register(AbstractQuoteCheck.getRegMbg(), MemberTypeEnum.MEMBER, MemberQuoteResourceEnum.RollInit, SysDimensionEnum.BudgetPeriod.getMemberTreemodel(), "t_eb_rollconfig", "fstartdate");
        AbstractQuoteCheck.register(AbstractQuoteCheck.getRegMbg(), MemberTypeEnum.MEMBER, MemberQuoteResourceEnum.RollInit, SysDimensionEnum.Version.getMemberTreemodel(), "t_eb_rollconfig", "frollversion");
        AbstractQuoteCheck.register(AbstractQuoteCheck.getRegMbg(), MemberTypeEnum.MEMBER, MemberQuoteResourceEnum.RollInit, SysDimensionEnum.Version.getMemberTreemodel(), "t_eb_rollconfig", "factversion");
        AbstractQuoteCheck.register(AbstractQuoteCheck.getRegMbg(), MemberTypeEnum.MEMBER, MemberQuoteResourceEnum.RollInit, SysDimensionEnum.Version.getMemberTreemodel(), "t_eb_rollconfig", "fversion");
        AbstractQuoteCheck.register(AbstractQuoteCheck.getRegMbg(), MemberTypeEnum.MEMBER, MemberQuoteResourceEnum.RollInit, SysDimensionEnum.DataType.getMemberTreemodel(), "t_eb_rollconfig", "fdatatype");
        AbstractQuoteCheck.register(AbstractQuoteCheck.getRegMbg(), MemberTypeEnum.DIMENSION, MemberQuoteResourceEnum.Integration_Mapping, null, "t_eb_integration_map", "fdimtarget");
        AbstractQuoteCheck.register(AbstractQuoteCheck.getRegMbg(), MemberTypeEnum.VIEW, MemberQuoteResourceEnum.Integration_Mapping, null, "t_eb_integration_map", "fdimview");
        AbstractQuoteCheck.register(AbstractQuoteCheck.getRegMbg(), MemberTypeEnum.MEMBER, MemberQuoteResourceEnum.ReceiveParam, SysDimensionEnum.Version.getMemberTreemodel(), "t_eb_receiveparameter", "fversionid");
        AbstractQuoteCheck.register(AbstractQuoteCheck.getRegister(), MemberTypeEnum.MEMBER, MemberQuoteResourceEnum.ControlVersion, SysDimensionEnum.Version.getMemberTreemodel(), "t_eb_controlversion", "fversion");
        AbstractQuoteCheck.register(AbstractQuoteCheck.getRegister(), MemberTypeEnum.MEMBER, MemberQuoteResourceEnum.ControlVersion, SysDimensionEnum.DataType.getMemberTreemodel(), "t_eb_controlversion", "fdatatype");
        AbstractQuoteCheck.register(AbstractQuoteCheck.getRegister(), MemberTypeEnum.MEMBER, MemberQuoteResourceEnum.ControlVersion, SysDimensionEnum.AuditTrail.getMemberTreemodel(), "t_eb_controlversion", "faudittrail");
        AbstractQuoteCheck.register(AbstractQuoteCheck.getRegister(), MemberTypeEnum.MEMBER, MemberQuoteResourceEnum.ControlRule, SysDimensionEnum.Metric.getMemberTreemodel(), "t_eb_dimmaterulebill", null, "fmetricfield", "fdetailid");
        AbstractQuoteCheck.register(AbstractQuoteCheck.getRegister(), MemberTypeEnum.MEMBER, MemberQuoteResourceEnum.ControlSet, SysDimensionEnum.Account.getMemberTreemodel(), "t_eb_controlruleaccount", "faccountid");
        AbstractQuoteCheck.register(AbstractQuoteCheck.getRegister(), MemberTypeEnum.MEMBER, MemberQuoteResourceEnum.ControlSet, "epm_userdefinedmembertree", "t_eb_controlruledefineds", "fuserdefinedid1");
        AbstractQuoteCheck.register(AbstractQuoteCheck.getRegister(), MemberTypeEnum.MEMBER, MemberQuoteResourceEnum.ControlSet, "epm_userdefinedmembertree", "t_eb_controlruledefineds", "fuserdefinedid2");
        AbstractQuoteCheck.register(AbstractQuoteCheck.getRegister(), MemberTypeEnum.MEMBER, MemberQuoteResourceEnum.ControlSet, "epm_userdefinedmembertree", "t_eb_controlruledefineds", "fuserdefinedid3");
        AbstractQuoteCheck.register(AbstractQuoteCheck.getRegister(), MemberTypeEnum.MEMBER, MemberQuoteResourceEnum.ControlSet, "epm_userdefinedmembertree", "t_eb_controlruledefineds", "fuserdefinedid4");
        AbstractQuoteCheck.register(AbstractQuoteCheck.getRegister(), MemberTypeEnum.MEMBER, MemberQuoteResourceEnum.ControlSet, "epm_userdefinedmembertree", "t_eb_controlruledefineds", "fuserdefinedid5");
        AbstractQuoteCheck.register(AbstractQuoteCheck.getRegister(), MemberTypeEnum.MEMBER, MemberQuoteResourceEnum.ControlSet, "epm_userdefinedmembertree", "t_eb_controlruledefineds", "fuserdefinedid6");
        AbstractQuoteCheck.register(AbstractQuoteCheck.getRegister(), MemberTypeEnum.MEMBER, MemberQuoteResourceEnum.ControlSet, "epm_userdefinedmembertree", "t_eb_controlruledefineds", "fuserdefinedid7");
        AbstractQuoteCheck.register(AbstractQuoteCheck.getRegister(), MemberTypeEnum.MEMBER, MemberQuoteResourceEnum.ControlMapping, null, "t_eb_membermapping", "fdimmemberid");
        AbstractQuoteCheck.register(AbstractQuoteCheck.getRegister(), MemberTypeEnum.RULE, MemberQuoteResourceEnum.RuleCase, null, "t_eb_ruleexeccase_rule", "fruleid");
        AbstractQuoteCheck.register(AbstractQuoteCheck.getRegister(), MemberTypeEnum.MEMBER, MemberQuoteResourceEnum.BGCONTROLRECORD, SysDimensionEnum.Entity.getMemberTreemodel(), "", "forgunitid");
        AbstractQuoteCheck.register(AbstractQuoteCheck.getRegister(), MemberTypeEnum.MEMBER, MemberQuoteResourceEnum.BGCONTROLRECORD, SysDimensionEnum.Account.getMemberTreemodel(), "", "faccountid");
        AbstractQuoteCheck.register(AbstractQuoteCheck.getRegister(), MemberTypeEnum.MEMBER, MemberQuoteResourceEnum.BGCONTROLRECORD, SysDimensionEnum.Year.getMemberTreemodel(), "", "fyearid");
        AbstractQuoteCheck.register(AbstractQuoteCheck.getRegister(), MemberTypeEnum.MEMBER, MemberQuoteResourceEnum.BGCONTROLRECORD, SysDimensionEnum.Period.getMemberTreemodel(), "", "fperiodid");
        AbstractQuoteCheck.register(AbstractQuoteCheck.getRegister(), MemberTypeEnum.MEMBER, MemberQuoteResourceEnum.BGCONTROLRECORD, SysDimensionEnum.BudgetPeriod.getMemberTreemodel(), "", "fbgperiodid");
        AbstractQuoteCheck.register(AbstractQuoteCheck.getRegister(), MemberTypeEnum.MEMBER, MemberQuoteResourceEnum.RECIPIENT_MAPPING, SysDimensionEnum.Entity.getMemberTreemodel(), "t_eb_recipientmapentry", "forg");
        AbstractQuoteCheck.register(AbstractQuoteCheck.getRegister(), MemberTypeEnum.MEMBER, MemberQuoteResourceEnum.WARNNINGSCHEMA, SysDimensionEnum.Entity.getMemberTreemodel(), "t_eb_warnningentity", "fentity");
        AbstractQuoteCheck.register(AbstractQuoteCheck.getRegister(), MemberTypeEnum.MEMBER, MemberQuoteResourceEnum.WARNNINGTARGT, null, "t_eb_warnningtargetentity", null, "kd.epm.eb.business.quote.impl.WarnningTargetQuoteCheckImpl", "fmember", null, 0);
        AbstractQuoteCheck.register(AbstractQuoteCheck.getRegMbg(), MemberTypeEnum.DIMENSION, MemberQuoteResourceEnum.MAINSUBMODEL_BASE, null, "t_eb_mainsubmodel", null, "kd.epm.eb.business.quote.impl.MainSubModelBaseQuoteCheckImpl", "fcontroltype", null, 1);
        AbstractQuoteCheck.register(AbstractQuoteCheck.getRegMbg(), MemberTypeEnum.MEMBER, MemberQuoteResourceEnum.Template, null, "t_eb_template", "", "kd.epm.eb.business.quote.impl.ReportQuoteCheckImpl", "", null, 1);
        AbstractQuoteCheck.register(AbstractQuoteCheck.getRegMbg(), MemberTypeEnum.DIMENSION, MemberQuoteResourceEnum.MAINSUBMODEL_BASE, null, "t_eb_mainsubmodel", null, "kd.epm.eb.business.quote.impl.MainSubModelBaseQuoteCheckImpl", "fcontroltype", null, 1);
        TABLE_VIEW = new Hashtable<String, String>();
        TABLE_VIEW.put("t_eb_tasksave", "forgviewid");
    }
}

