/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.quote;

import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.enums.memberQuote.MemberTypeEnum;
import org.jetbrains.annotations.NotNull;

public class CheckQuote
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 2739537329228846440L;
    private final Long modelId;
    private Set<Long> busModelIds = null;
    private Long datasetId = null;
    private final Long dimensionId;
    private final Long viewId;
    private final Set<Long> memberIds = Sets.newLinkedHashSet();
    private Set<Long> oldMemberIds = null;
    private int memberType;
    private MemberQuoteResourceEnum resourceEnum;
    private boolean dataCheck = true;
    private boolean checkChild = false;
    private Set<MemberQuoteResourceEnum> excludes = null;
    private boolean initChild = false;
    private boolean onlyCurrView = false;

    public boolean isDataCheck() {
        return this.dataCheck;
    }

    public void setDataCheck(boolean dataCheck) {
        this.dataCheck = dataCheck;
    }

    public void setCheckChild(boolean checkChild) {
        this.checkChild = checkChild;
    }

    public boolean isCheckChild() {
        return this.checkChild;
    }

    public Set<MemberQuoteResourceEnum> getExcludes() {
        return this.excludes;
    }

    public void addExclude(@NotNull MemberQuoteResourceEnum resource) {
        if (this.excludes == null) {
            this.excludes = new HashSet<MemberQuoteResourceEnum>();
        }
        this.excludes.add(resource);
    }

    public void setInitChild(boolean initChild) {
        this.initChild = initChild;
    }

    public boolean isInitChild() {
        return this.initChild;
    }

    public CheckQuote(@NotNull Long modelId, @NotNull Long dimensionId, @NotNull Set<Long> memberIds) {
        this(modelId, dimensionId, memberIds, MemberTypeEnum.MEMBER);
    }

    public CheckQuote(@NotNull Long modelId, @NotNull Long dimensionId, @NotNull Set<Long> memberIds, @NotNull MemberTypeEnum memberType) {
        this(modelId, dimensionId, 0L, memberIds, memberType);
    }

    public CheckQuote(@NotNull Long modelId, @NotNull Long dimensionId, @NotNull Long viewId, @NotNull Set<Long> memberIds, @NotNull MemberTypeEnum memberType) {
        this.modelId = modelId;
        this.dimensionId = dimensionId;
        this.viewId = viewId;
        this.memberIds.addAll(memberIds);
        this.memberType = memberType.getType();
    }

    public CheckQuote(@NotNull Long modelId, @NotNull Long dimensionId, @NotNull Long viewId, @NotNull Set<Long> memberIds, @NotNull MemberTypeEnum memberType, MemberQuoteResourceEnum resourceEnum) {
        this.modelId = modelId;
        this.dimensionId = dimensionId;
        this.viewId = viewId;
        this.memberIds.addAll(memberIds);
        this.memberType = memberType.getType();
        this.resourceEnum = resourceEnum;
    }

    public Long getModelId() {
        return this.modelId;
    }

    public void setBusModelIds(Set<Long> busModelIds) {
        this.busModelIds = busModelIds;
    }

    public Set<Long> getBusModelIds() {
        return this.busModelIds;
    }

    public Long getDatasetId() {
        return this.datasetId;
    }

    public void setDatasetId(Long datasetId) {
        this.datasetId = datasetId;
    }

    public Long getDimensionId() {
        return this.dimensionId;
    }

    public Long getViewId() {
        return this.viewId;
    }

    public void setOnlyCurrView(boolean onlyCurrView) {
        this.onlyCurrView = onlyCurrView;
    }

    public boolean isOnlyCurrView() {
        return this.onlyCurrView;
    }

    public Set<Long> getMemberIds() {
        return this.memberIds;
    }

    public void setOldMemberIds(Set<Long> oldMemberIds) {
        this.oldMemberIds = oldMemberIds;
    }

    public Set<Long> getOldMemberIds() {
        return this.oldMemberIds;
    }

    public int getMemberType() {
        return this.memberType;
    }

    public void setMemberType(int memberType) {
        this.memberType = memberType;
    }

    public MemberTypeEnum getMemberTypeEnum() {
        return MemberTypeEnum.getEnum((int)this.memberType);
    }

    public MemberQuoteResourceEnum getResourceEnum() {
        return this.resourceEnum;
    }

    public void setResourceEnum(MemberQuoteResourceEnum resourceEnum) {
        this.resourceEnum = resourceEnum;
    }

    protected Object clone() throws CloneNotSupportedException {
        CheckQuote checkQuote = (CheckQuote)super.clone();
        return checkQuote;
    }
}

