/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.quote;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.quote.CheckQuote;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.enums.memberQuote.MemberTypeEnum;
import kd.epm.eb.common.utils.QFBuilder;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class QuoteBuilder {
    public static List<MemberQuoteDao> build(@NotNull Long modelId, @NotNull Long datasetId, Map<String, Collection<String>> quoteMembers, @NotNull MemberQuoteResourceEnum resource, @NotNull Long resourceId, IModelCacheHelper modelCache) {
        Set varNumbers;
        Dimension dimension;
        String dimensionNumber;
        if (modelCache.getModelobj() == null) {
            return Collections.emptyList();
        }
        LinkedList quotes = Lists.newLinkedList();
        Map dimensionMap = modelCache.getDimensionMap();
        boolean hasVariable = false;
        HashMap dimVarNumbers = Maps.newHashMapWithExpectedSize((int)dimensionMap.size());
        HashSet allVarNumbers = Sets.newHashSetWithExpectedSize((int)64);
        Map viewIds = modelCache.getViewsByDataSet(datasetId);
        for (Map.Entry<String, Collection<String>> entry : quoteMembers.entrySet()) {
            dimensionNumber = entry.getKey();
            dimension = (Dimension)dimensionMap.get(dimensionNumber);
            if (dimension == null) continue;
            boolean hasPeriod = SysDimensionEnum.BudgetPeriod.getNumber().equals(dimensionNumber) || SysDimensionEnum.Year.getNumber().equals(dimensionNumber);
            Long viewId = (Long)viewIds.get(dimensionNumber);
            LinkedHashSet memberIds = Sets.newLinkedHashSet();
            for (String memberNumber : entry.getValue()) {
                if (!memberNumber.isEmpty() && memberNumber.charAt(0) == '@') {
                    hasVariable = true;
                    if (hasPeriod) {
                        memberNumber = memberNumber.split("[+\\- ]")[0];
                    }
                }
                if (hasVariable) {
                    varNumbers = dimVarNumbers.computeIfAbsent(dimensionNumber, f -> Sets.newHashSetWithExpectedSize((int)16));
                    varNumbers.add(memberNumber);
                    allVarNumbers.add(memberNumber);
                    continue;
                }
                Member member = dimension.getMember(viewId, memberNumber);
                if (member == null) continue;
                memberIds.add(member.getId());
            }
            if (!CollectionUtils.isNotEmpty((Collection)memberIds)) continue;
            quotes.add(new MemberQuoteDao(modelId, datasetId, dimension.getId(), (Collection)memberIds, resource, resourceId));
        }
        if (!dimVarNumbers.isEmpty()) {
            HashMap dimVarIds = Maps.newHashMapWithExpectedSize((int)dimVarNumbers.size());
            QFBuilder builder = new QFBuilder();
            builder.add("model", "=", (Object)modelId);
            builder.add("number", "in", (Object)allVarNumbers);
            Map _variables = BusinessDataServiceHelper.loadFromCache((String)"eb_periodvariable", (String)"id, number, dimension.number", (QFilter[])builder.toArray());
            for (DynamicObject dynamicObject : _variables.values()) {
                dimensionNumber = dynamicObject.getString("dimension.number");
                varNumbers = (Set)dimVarNumbers.get(dimensionNumber);
                if (varNumbers == null || !varNumbers.contains(dynamicObject.getString("number"))) continue;
                Set varIds = dimVarIds.computeIfAbsent(dimensionNumber, f -> Sets.newHashSetWithExpectedSize((int)32));
                varIds.add(dynamicObject.getLong("id"));
            }
            if (!dimVarIds.isEmpty()) {
                for (Map.Entry entry : dimVarIds.entrySet()) {
                    dimension = (Dimension)dimensionMap.get(entry.getKey());
                    if (dimension == null) continue;
                    MemberQuoteDao quote = new MemberQuoteDao(modelId, Long.valueOf(0L), dimension.getId(), (Collection)entry.getValue(), resource, resourceId);
                    quote.setMemberType(MemberTypeEnum.VARIABLE);
                    quotes.add(quote);
                }
            }
        }
        return quotes;
    }

    public static List<MemberQuoteDao> buildView(@NotNull Long modelId, @NotNull Long datasetId, @NotNull Map<String, Long> viewIds, @NotNull MemberQuoteResourceEnum resource, @NotNull Long resourceId, IModelCacheHelper modelCache) {
        if (modelCache.getModelobj() == null) {
            return Collections.emptyList();
        }
        ArrayList quotes = Lists.newArrayListWithExpectedSize((int)viewIds.size());
        Map dimensionMap = modelCache.getDimensionMap();
        for (Map.Entry<String, Long> view : viewIds.entrySet()) {
            Dimension dimension;
            String dimensionNumber = view.getKey();
            if (dimensionNumber.indexOf(95) >= 0) {
                dimensionNumber = dimensionNumber.split("_")[0];
            }
            if ((dimension = (Dimension)dimensionMap.get(dimensionNumber)) == null) continue;
            MemberQuoteDao quote = new MemberQuoteDao(modelId, datasetId, dimension.getId(), view.getValue(), resource, resourceId);
            quote.setMemberType(MemberTypeEnum.VIEW);
            quotes.add(quote);
        }
        return quotes;
    }

    public static CheckQuote build(@NotNull Long modelId, @NotNull Long dimensionId, @NotNull Long memberId) {
        HashSet<Long> memberIds = new HashSet<Long>();
        memberIds.add(memberId);
        return QuoteBuilder.build(modelId, dimensionId, memberIds);
    }

    public static CheckQuote build(@NotNull Long modelId, @NotNull Long dimensionId, @NotNull Collection<Long> memberIds) {
        return QuoteBuilder.build(modelId, dimensionId, new HashSet<Long>(memberIds));
    }

    public static CheckQuote build(@NotNull Long modelId, @NotNull Long dimensionId, @NotNull Set<Long> memberIds) {
        return QuoteBuilder.build(modelId, dimensionId, 0L, memberIds, MemberTypeEnum.MEMBER);
    }

    public static CheckQuote build(@NotNull Long modelId, @NotNull Long dimensionId, @NotNull Set<Long> memberIds, MemberQuoteResourceEnum resource) {
        return QuoteBuilder.build(modelId, dimensionId, 0L, memberIds, MemberTypeEnum.MEMBER, resource);
    }

    public static CheckQuote build(@NotNull Long modelId, @NotNull Long dimensionId, @NotNull Long memberId, @NotNull MemberTypeEnum memberTypeEnum) {
        HashSet<Long> memberIds = new HashSet<Long>();
        memberIds.add(memberId);
        return QuoteBuilder.build(modelId, dimensionId, 0L, memberIds, memberTypeEnum);
    }

    public static CheckQuote build(@NotNull Long modelId, @NotNull Long dimensionId, @NotNull Set<Long> memberIds, @NotNull MemberTypeEnum memberType) {
        return new CheckQuote(modelId, dimensionId, 0L, memberIds, memberType);
    }

    public static CheckQuote build(@NotNull Long modelId, @NotNull Long dimensionId, @NotNull Long viewId, @NotNull Set<Long> memberIds, @NotNull MemberTypeEnum memberType) {
        return new CheckQuote(modelId, dimensionId, viewId, memberIds, memberType);
    }

    public static CheckQuote build(@NotNull Long modelId, @NotNull Long dimensionId, @NotNull Long viewId, @NotNull Set<Long> memberIds, @NotNull MemberTypeEnum memberType, @NotNull MemberQuoteResourceEnum resourceEnum) {
        return new CheckQuote(modelId, dimensionId, viewId, memberIds, memberType, resourceEnum);
    }
}

