/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.quote;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.epm.eb.business.quote.AbstractQuoteCheck;
import kd.epm.eb.business.quote.CheckQuote;
import kd.epm.eb.business.quote.QuoteCheckResult;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.memberQuote.MemberTypeEnum;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.olap.service.view.ViewGroupManager;
import org.jetbrains.annotations.NotNull;

public class QuoteCheck
extends AbstractQuoteCheck {
    public static QuoteCheck get() {
        return new QuoteCheck();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Long> checkQuote(@NotNull CheckQuote checkQuote) {
        LogStats stats = new LogStats("member-quote-log:");
        stats.addInfo("begin-checkDataQuote.");
        if (checkQuote.getMemberIds().isEmpty()) {
            stats.addInfo("memberIds is null.");
            log.info(stats.toString());
            return Collections.emptySet();
        }
        this.getChildren(checkQuote);
        SqlBuilder sql = new SqlBuilder();
        sql.append("select distinct t.fmemberid from ", new Object[0]).append("t_eb_memberquote", new Object[0]).append(" t ", new Object[0]);
        if (IDUtils.isNotNull((Long)checkQuote.getViewId())) {
            sql.append(" left join ", new Object[0]).append("t_eb_memberquoteentry", new Object[0]).append(" e on t.fid = e.fquoteid ", new Object[0]);
        }
        sql.append(" where t.fmodelid = ?", new Object[]{checkQuote.getModelId()});
        if (checkQuote.getMemberType() == MemberTypeEnum.DIMENSION.getType() && IDUtils.isNotNull((Long)checkQuote.getDatasetId())) {
            sql.append(" and t.fdatasetid = ?", new Object[]{checkQuote.getDatasetId()});
        }
        sql.append(" and t.fdimensionid = ?", new Object[]{checkQuote.getDimensionId()});
        if (checkQuote.getMemberType() != MemberTypeEnum.DIMENSION.getType()) {
            sql.append(" and ", new Object[0]).appendIn("t.fmemberid", checkQuote.getMemberIds().toArray());
        }
        sql.append(" and t.fstatus = '1'", new Object[0]);
        if (IDUtils.isNotNull((Long)checkQuote.getViewId())) {
            Set groupViewIds = checkQuote.isOnlyCurrView() ? CollectionUtils.asSet((Object[])new Long[]{checkQuote.getViewId()}) : ViewGroupManager.getInstance().getViewsByViewId(checkQuote.getViewId().longValue());
            sql.append(" and ", new Object[0]).appendIn("e.fviewid", groupViewIds.toArray());
        }
        LinkedHashSet quoteIds = Sets.newLinkedHashSet();
        try (DataSet ds = DB.queryDataSet((String)"queryQuote", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            if (ds != null) {
                for (Row row : ds) {
                    quoteIds.add(row.getLong(0));
                }
            }
        }
        finally {
            stats.addInfo("end-checkDataQuote.");
            log.info(stats.toString());
        }
        return quoteIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QuoteCheckResult checkQuoteResult(@NotNull CheckQuote checkQuote) {
        LogStats stats = new LogStats("member-quote-log:");
        stats.addInfo("begin-checkQuoteResult.");
        this.getChildren(checkQuote);
        if (checkQuote.getMemberIds().isEmpty()) {
            stats.addInfo("memberIds is null.");
            log.info(stats.toString());
            return QuoteCheckResult.PASS_RESULT;
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("select t.fid, t.fmemberid, t.ftype from ", new Object[0]).append("t_eb_memberquote", new Object[0]).append(" t ", new Object[0]);
        if (IDUtils.isNotNull((Long)checkQuote.getViewId())) {
            sql.append(" left join ", new Object[0]).append("t_eb_memberquoteentry", new Object[0]).append(" e on t.fid = e.fquoteid ", new Object[0]);
        }
        sql.append(" where t.fmodelid = ?", new Object[]{checkQuote.getModelId()});
        if (checkQuote.getMemberType() == MemberTypeEnum.DIMENSION.getType() && IDUtils.isNotNull((Long)checkQuote.getDatasetId())) {
            sql.append(" and t.fdatasetid = ?", new Object[]{checkQuote.getDatasetId()});
        }
        sql.append(" and t.fdimensionid = ?", new Object[]{checkQuote.getDimensionId()});
        if (checkQuote.getMemberType() != MemberTypeEnum.DIMENSION.getType()) {
            sql.append(" and ", new Object[0]).appendIn("t.fmemberid", checkQuote.getMemberIds().toArray());
        }
        sql.append(" and t.fstatus = '1'", new Object[0]);
        if (IDUtils.isNotNull((Long)checkQuote.getViewId())) {
            Set groupViewIds = checkQuote.isOnlyCurrView() ? CollectionUtils.asSet((Object[])new Long[]{checkQuote.getViewId()}) : ViewGroupManager.getInstance().getViewsByViewId(checkQuote.getViewId().longValue());
            sql.append(" and ", new Object[0]).appendIn("e.fviewid", groupViewIds.toArray());
        }
        LinkedHashMap typeMaps = Maps.newLinkedHashMap();
        LinkedHashSet quoteIds = Sets.newLinkedHashSet();
        try {
            try (DataSet ds = DB.queryDataSet((String)"queryQuote", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
                if (ds != null) {
                    for (Row row : ds) {
                        Map quoteMaps = typeMaps.computeIfAbsent(row.getInteger(2), f -> Maps.newLinkedHashMap());
                        quoteMaps.put(row.getLong(0), row.getLong(1));
                        quoteIds.add(row.getLong(0));
                    }
                }
            }
            QuoteCheckResult quoteCheckResult = this.getQuoteResult(checkQuote, typeMaps, quoteIds);
            return quoteCheckResult;
        }
        finally {
            stats.addInfo("end-checkQuoteResult.");
            log.info(stats.toString());
        }
    }

    private QuoteCheckResult getQuoteResult(CheckQuote checkQuote, Map<Integer, Map<Long, Long>> typeMaps, Set<Long> quoteIds) {
        QuoteCheckResult result;
        if (quoteIds.isEmpty()) {
            return QuoteCheckResult.PASS_RESULT;
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fquoteid, fsourcetype, fsourceid from ", new Object[0]).append("t_eb_memberquoteentry", new Object[0]).append(" where ", new Object[0]);
        sql.appendIn("fquoteid", quoteIds.toArray());
        if (checkQuote.getResourceEnum() != null) {
            sql.append(" and fsourcetype =?", new Object[]{checkQuote.getResourceEnum().getType()});
        }
        LinkedHashMap resourceMap = Maps.newLinkedHashMap();
        try (DataSet ds = DB.queryDataSet((String)"queryQuote", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            if (ds != null) {
                for (Row row : ds) {
                    Map resTypeMap = resourceMap.computeIfAbsent(row.getLong(0), f -> Maps.newLinkedHashMap());
                    Set resources = resTypeMap.computeIfAbsent(row.getInteger(1), f -> Sets.newLinkedHashSet());
                    resources.add(row.getLong(2));
                }
            }
        }
        if (resourceMap.isEmpty()) {
            result = QuoteCheckResult.PASS_RESULT;
        } else {
            StringBuilder str = new StringBuilder();
            for (Map.Entry<Integer, Map<Long, Long>> entry : typeMaps.entrySet()) {
                this.buildMsgInfo(checkQuote, null, str, entry.getKey(), entry.getValue(), resourceMap);
                if (str.length() <= 5000) continue;
                str.setLength(5000);
                str.append("......");
                break;
            }
            result = new QuoteCheckResult(true, str.toString());
        }
        return result;
    }
}

