/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.quote;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;

public class QuoteDelete {
    private static final Log log = LogFactory.getLog(QuoteDelete.class);

    public static QuoteDelete get() {
        return new QuoteDelete();
    }

    public boolean delete(int resource, Long sourceId) {
        if (IDUtils.isNull((Long)sourceId)) {
            return false;
        }
        HashSet<Long> sourceIds = new HashSet<Long>();
        sourceIds.add(sourceId);
        return this.delete(resource, sourceIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(int resource, Collection<Long> sourceIds) {
        LogStats stats = new LogStats("member-quote-log:");
        stats.addInfo("begin-delete-quote.");
        try {
            boolean bl = this._delete(MemberQuoteResourceEnum.getEnumByIndex((int)resource), sourceIds, stats);
            return bl;
        }
        finally {
            stats.addInfo("end-delete-quote.");
            log.info(stats.toString());
        }
    }

    private boolean _delete(MemberQuoteResourceEnum resource, Collection<Long> sourceIds, LogStats stats) {
        if (resource == null) {
            stats.addInfo("source is null.");
            return false;
        }
        if (sourceIds == null || sourceIds.isEmpty()) {
            stats.addInfo("sourceIds is null.");
            return false;
        }
        Set<Long> quoteIds = this.queryQuoteIds(resource, sourceIds, stats);
        boolean re = this.deleteEntry(resource, sourceIds);
        this.updateStates(quoteIds, stats);
        return re;
    }

    private Set<Long> queryQuoteIds(MemberQuoteResourceEnum resource, Collection<Long> sourceIds, LogStats stats) {
        if (resource == null || sourceIds == null || sourceIds.isEmpty()) {
            stats.addInfo("source or sourceIds is null.");
            return Collections.emptySet();
        }
        HashSet<Long> _sourceIds = new HashSet<Long>(sourceIds);
        _sourceIds.add(0L);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fquoteid from ", new Object[0]).append("t_eb_memberquoteentry", new Object[0]).append(" where ", new Object[0]);
        sqlBuilder.append("fsourcetype = ?", new Object[]{resource.getType()});
        sqlBuilder.append(" and ", new Object[0]).appendIn("fsourceId", _sourceIds.toArray(new Object[0]));
        LinkedHashSet quoteIds = Sets.newLinkedHashSet();
        try (DataSet ds = DB.queryDataSet((String)"queryQuote", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sqlBuilder);){
            if (ds != null) {
                for (Row row : ds) {
                    quoteIds.add(row.getLong("fquoteid"));
                }
            }
        }
        stats.addInfo("quoteIds-size = " + quoteIds.size());
        return quoteIds;
    }

    private boolean deleteEntry(MemberQuoteResourceEnum resource, Collection<Long> sourceIds) {
        boolean re;
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("delete from ", new Object[0]).append("t_eb_memberquoteentry", new Object[0]).append(" where ", new Object[0]);
        sqlBuilder.append("fsourcetype = ?", new Object[]{resource.getType()});
        sqlBuilder.append(" and ", new Object[0]).appendIn("fsourceId", sourceIds.toArray(new Object[0]));
        try {
            re = DB.execute((DBRoute)BgBaseConstant.epm, (SqlBuilder)sqlBuilder);
        }
        catch (Exception ex) {
            log.error("delete-member-quote:", (Throwable)ex);
            throw ex;
        }
        return re;
    }

    private void updateStates(Set<Long> quoteIds, LogStats stats) {
        List _refIds;
        if (quoteIds == null || quoteIds.isEmpty()) {
            stats.addInfo("quoteIds is null.");
            return;
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("select distinct fquoteid from ", new Object[0]).append("t_eb_memberquoteentry", new Object[0]).append(" where ", new Object[0]).appendIn("fquoteid", quoteIds.toArray());
        try (DataSet ds = DB.queryDataSet((String)"queryQuote", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            _refIds = IDUtils.toLongs((List)CommonServiceHelper.transDataSetByField((DataSet)ds, (String)"fquoteid"));
        }
        HashSet<Long> _quoteIds = new HashSet<Long>(quoteIds);
        _refIds.forEach(_quoteIds::remove);
        if (!_quoteIds.isEmpty()) {
            sql = new SqlBuilder();
            sql.append("update ", new Object[0]).append("t_eb_memberquote", new Object[0]).append(" set fstatus = '0' where ", new Object[0]).appendIn("fid", _quoteIds.toArray()).append(" and fstatus = '1'", new Object[0]);
            DB.execute((DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);
        }
    }
}

