/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.quote;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.quote.AbstractQuoteCheck;
import kd.epm.eb.business.quote.CheckQuote;
import kd.epm.eb.business.quote.ICustomQuoteCheck;
import kd.epm.eb.business.quote.QuoteCheckResult;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.enums.memberQuote.MemberTypeEnum;
import kd.epm.eb.common.reportprocess.helper.SchemeRecordDeleteEntityHelper;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.NewEbAppUtil;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.SqlBatchUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.control.utils.BgControlUtils;
import kd.epm.eb.olap.service.view.ViewGroupManager;
import org.jetbrains.annotations.NotNull;

public class QuoteRegDataCheck
extends AbstractQuoteCheck {
    private String[] bgControlRecordTable = null;

    public static QuoteRegDataCheck get() {
        return new QuoteRegDataCheck();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Long> checkQuote(@NotNull CheckQuote checkQuote) {
        LogStats stats = new LogStats("member-quote-log:");
        stats.addInfo("begin-checkDataQuote.");
        try {
            Set<Long> set = this._checkQuote(checkQuote, stats);
            return set;
        }
        finally {
            ModelCacheContext.remove();
            MemberPropCacheService.remove();
            stats.addInfo("end-checkDataQuote.");
            log.info(stats.toString());
        }
    }

    private Set<Long> _checkQuote(@NotNull CheckQuote checkQuote, LogStats stats) {
        if (checkQuote.getMemberIds().isEmpty()) {
            return Collections.emptySet();
        }
        List<Object[]> checkParams = this.getCheckParams(checkQuote);
        if (checkParams.isEmpty()) {
            stats.addInfo("checkParams is null.");
            return Collections.emptySet();
        }
        this.getChildren(checkQuote);
        LinkedHashSet quoteIds = Sets.newLinkedHashSet();
        Map dimensionMap = this.getModelCache(checkQuote.getModelId()).getDimensionMapById();
        for (Object[] checkParam : checkParams) {
            Map<Long, Set<Long>> _memberMap;
            String _cusClass = (String)checkParam[4];
            if (StringUtils.isNotEmpty((String)_cusClass)) {
                try {
                    ICustomQuoteCheck cutCheckFace = (ICustomQuoteCheck)Class.forName(_cusClass).newInstance();
                    _memberMap = cutCheckFace.getResourceMap(checkQuote, checkParam);
                }
                catch (Exception ex) {
                    log.error("cusQuoteCheck-init-error:" + _cusClass);
                    log.error((Throwable)ex);
                    throw new KDBizException(ex.getMessage());
                }
            } else {
                _memberMap = this._checkQuote(checkQuote, (Dimension)dimensionMap.get(checkQuote.getDimensionId()), checkParam, stats);
            }
            if (_memberMap == null || _memberMap.isEmpty()) continue;
            quoteIds.addAll(_memberMap.keySet());
        }
        return quoteIds;
    }

    private List<Object[]> getCheckParams(CheckQuote checkQuote) {
        IModelCacheHelper modelCache = this.getModelCache(checkQuote.getModelId());
        LinkedList checkParams = Lists.newLinkedList();
        List<Object[]> _checkParams = QuoteRegDataCheck.getRegister().get(checkQuote.getMemberType());
        if (_checkParams != null) {
            checkParams.addAll(_checkParams);
        }
        List<Object[]> list = _checkParams = modelCache.getModelobj().isModelByEB() ? QuoteRegDataCheck.getRegEb().get(checkQuote.getMemberType()) : QuoteRegDataCheck.getRegMbg().get(checkQuote.getMemberType());
        if (_checkParams != null) {
            checkParams.addAll(_checkParams);
        }
        return checkParams;
    }

    private Map<Long, Set<Long>> _checkQuote(CheckQuote checkQuote, Dimension dimension, Object[] checkParam, LogStats stats) {
        Set<MemberQuoteResourceEnum> excludes = checkQuote.getExcludes();
        if (NewEbAppUtil.isNewEbModel((Long)checkQuote.getModelId())) {
            if (excludes == null) {
                excludes = new HashSet<MemberQuoteResourceEnum>(1);
            }
            excludes.add(MemberQuoteResourceEnum.BusinessModel);
        }
        if (excludes != null && excludes.contains(checkParam[0])) {
            return Collections.emptyMap();
        }
        String _entityNumber = (String)checkParam[1];
        String[] _tables = new String[]{(String)checkParam[2]};
        if (checkParam[0] == MemberQuoteResourceEnum.BGCONTROLRECORD) {
            _tables = this.getBgControlRecordTable(checkQuote);
        }
        if (StringUtils.isEmptyArray((String[])_tables)) {
            Collections.emptyMap();
        }
        String _field = (String)checkParam[5];
        String _pkField = (String)checkParam[6];
        int _checkType = (Integer)checkParam[7];
        if (StringUtils.isEmpty((String)_pkField)) {
            _pkField = "fid";
        }
        String _dimField = null;
        if (_field.indexOf(44) >= 0) {
            String[] _tmpStr = _field.split(",");
            if (_tmpStr.length >= 1) {
                _field = _tmpStr[0];
            }
            if (_tmpStr.length >= 2) {
                _dimField = _tmpStr[1];
            }
            if (_tmpStr.length > 3) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u7ef4\u5ea6\u6210\u5458\u68c0\u67e5\u6ce8\u518c\u7684\u5b57\u6bb5\u6570\u636e\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u201c%1\u201d\u3002", (String)"QuoteDataCheck_0", (String)"epm-eb-business", (Object[])new Object[]{_field}));
            }
        }
        if (checkQuote.getMemberType() == MemberTypeEnum.MEMBER.getType()) {
            if (dimension == null) {
                throw new KDBizException("error-dimensionId." + checkQuote.getDimensionId());
            }
            if (StringUtils.isNotEmpty((String)_entityNumber) && !_entityNumber.equals(dimension.getMemberModel())) {
                return Collections.emptyMap();
            }
        }
        LinkedHashMap quoteIds = Maps.newLinkedHashMap();
        IModelCacheHelper modelCacheHelper = this.getModelCache(checkQuote.getModelId());
        for (String _table : _tables) {
            Set resourceIds;
            if (StringUtils.isEmpty((String)_table)) continue;
            if (_checkType == 0) {
                Object load;
                SqlBuilder sql = new SqlBuilder();
                if (checkParam[0] == MemberQuoteResourceEnum.BGCONTROLRECORD) {
                    sql.append("select top 1 ", new Object[0]).append(_field, new Object[0]).append(" from ", new Object[0]).append(_table, new Object[0]).append(" where ", new Object[0]);
                    if (modelCacheHelper.getModelobj().isModelByEB()) {
                        sql.append("fmodelid = ? and ", new Object[]{checkQuote.getModelId()});
                    }
                } else {
                    if (checkParam[0] == MemberQuoteResourceEnum.RptScheme) {
                        QFilter qFilter = new QFilter("org", "in", checkQuote.getMemberIds());
                        qFilter.and(new QFilter("scheme.orgview", "=", (Object)checkQuote.getViewId()));
                        load = QueryServiceHelper.query((String)"eb_templateorg", (String)"id,scheme.id,org.id,orgrange", (QFilter[])qFilter.toArray());
                        if (load != null && load.size() > 0) {
                            List recordIdList = load.stream().map(x -> x.getLong("id")).collect(Collectors.toList());
                            Map recordDeleteEntity = SchemeRecordDeleteEntityHelper.queryDeleteEntityByRecordId(recordIdList);
                            Iterator iterator = load.iterator();
                            while (iterator.hasNext()) {
                                int orgRange;
                                DynamicObject dynamicObject = (DynamicObject)iterator.next();
                                Set set = (Set)recordDeleteEntity.get(dynamicObject.getLong("id"));
                                if (CollectionUtils.isNotEmpty((Collection)set) && (orgRange = dynamicObject.getInt("orgrange")) == RangeEnum.ONLY.getIndex() && set.contains(dynamicObject.getLong("org.id"))) continue;
                                resourceIds = quoteIds.computeIfAbsent(dynamicObject.getLong("org.id"), f -> Sets.newLinkedHashSet());
                                resourceIds.add(dynamicObject.getLong("scheme.id"));
                            }
                        }
                        return quoteIds;
                    }
                    sql.append("select distinct ", new Object[0]).append(_pkField, new Object[0]).append(",", new Object[0]).append(_field, new Object[0]).append(" from ", new Object[0]).append(_table, new Object[0]).append(" where ", new Object[0]);
                }
                if (StringUtils.isNotEmpty((String)_dimField)) {
                    sql.append(_dimField, new Object[0]).append(" = ? and ", new Object[]{checkQuote.getDimensionId()});
                }
                sql.appendIn(_field, checkQuote.getMemberIds().toArray());
                this.processResourceCondition(checkQuote, checkParam, sql, modelCacheHelper);
                this.processFilterView(checkQuote, checkParam, sql, _table);
                DataSet ds = this.queryQuote(sql);
                load = null;
                try {
                    if (ds == null) continue;
                    if (checkParam[0] == MemberQuoteResourceEnum.BGCONTROLRECORD) {
                        for (Row row : ds) {
                            quoteIds.put(row.getLong(0), null);
                        }
                        continue;
                    }
                    for (Row row : ds) {
                        resourceIds = quoteIds.computeIfAbsent(row.getLong(1), f -> Sets.newLinkedHashSet());
                        resourceIds.add(row.getLong(0));
                    }
                    continue;
                }
                catch (Throwable throwable) {
                    load = throwable;
                    throw throwable;
                }
                finally {
                    if (ds != null) {
                        if (load != null) {
                            try {
                                ds.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)load).addSuppressed(throwable);
                            }
                        } else {
                            ds.close();
                        }
                    }
                }
            }
            if (_checkType != 1) continue;
            Map<String, Long> memberMap = this.loadMemberMap(checkQuote, dimension);
            if (memberMap.isEmpty()) {
                stats.addInfo("load-member is null.");
                continue;
            }
            SqlBuilder sql = new SqlBuilder();
            sql.append("select distinct ", new Object[0]).append(_pkField, new Object[0]).append(",", new Object[0]).append(_field, new Object[0]).append(" from ", new Object[0]).append(_table, new Object[0]).append(" where ", new Object[0]);
            if (StringUtils.isNotEmpty((String)_dimField)) {
                sql.append(_dimField, new Object[0]).append(" = ? and ", new Object[]{checkQuote.getDimensionId()});
            }
            sql.appendIn(_field, memberMap.keySet().toArray());
            this.processResourceCondition(checkQuote, checkParam, sql, modelCacheHelper);
            this.processFilterView(checkQuote, checkParam, sql, _table);
            DataSet ds = this.queryQuote(sql);
            Object object = null;
            try {
                if (ds == null) continue;
                for (Row row : ds) {
                    resourceIds = quoteIds.computeIfAbsent(memberMap.get(row.getString(1)), f -> Sets.newLinkedHashSet());
                    resourceIds.add(row.getLong(0));
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (ds != null) {
                    if (object != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
        }
        return quoteIds;
    }

    private DataSet queryQuote(SqlBuilder sql) {
        return DB.queryDataSet((String)"queryQuote", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);
    }

    private String[] getBgControlRecordTable(CheckQuote checkQuote) {
        if (this.bgControlRecordTable == null) {
            IModelCacheHelper modelCacheHelper = this.getModelCache(checkQuote.getModelId());
            if (modelCacheHelper.getModelobj().isModelByEB()) {
                this.bgControlRecordTable = new String[]{"t_eb_bgcontrolrecord"};
            } else {
                QFBuilder builder = new QFBuilder();
                builder.add("model", "=", (Object)checkQuote.getModelId());
                try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryControlDims", (String)"eb_bgmcontroldimension", (String)"id,businessmodel", (QFilter[])builder.toArrays(), null);){
                    if (ds != null) {
                        ArrayList<String> tables = new ArrayList<String>();
                        for (Row row : ds) {
                            String _bgControlRecordTable = BgControlUtils.getBgControlRecordTable(checkQuote.getModelId(), row.getLong("businessmodel"));
                            if (!SqlBatchUtils.hasTable((String)_bgControlRecordTable)) continue;
                            tables.add(_bgControlRecordTable);
                        }
                        this.bgControlRecordTable = tables.toArray(new String[tables.size()]);
                    }
                }
            }
        }
        return this.bgControlRecordTable;
    }

    private void processResourceCondition(CheckQuote checkQuote, Object[] checkParam, SqlBuilder sql, IModelCacheHelper modelCacheHelper) {
        if (checkQuote.getMemberType() == MemberTypeEnum.DIMENSION.getType() && MemberQuoteResourceEnum.DimView == checkParam[0]) {
            sql.append(" and fsource = '0'", new Object[0]);
        } else if (checkParam[0] == MemberQuoteResourceEnum.Report && "t_eb_reportprocess".equals(checkParam[2])) {
            sql.append(" and fmodel = ?", new Object[]{modelCacheHelper.getModelobj().getId()});
        }
    }

    private void processFilterView(CheckQuote checkQuote, Object[] checkParam, SqlBuilder sql, String tableName) {
        if (IDUtils.isNull((Long)checkQuote.getViewId())) {
            return;
        }
        String viewField = (String)TABLE_VIEW.get(tableName);
        if (StringUtils.isNotEmpty((String)viewField)) {
            Set groupViewIds = ViewGroupManager.getInstance().getViewsByViewId(checkQuote.getViewId().longValue());
            sql.append(" and ", new Object[0]).appendIn(viewField, groupViewIds.toArray());
        }
    }

    private Map<String, Long> loadMemberMap(CheckQuote checkQuote, Dimension dimension) {
        LinkedHashMap memberMap;
        block4: {
            block5: {
                block3: {
                    memberMap = Maps.newLinkedHashMap();
                    if (checkQuote.getMemberType() != MemberTypeEnum.MEMBER.getType()) break block3;
                    View view = dimension.getView(checkQuote.getViewId());
                    List members = view != null ? view.getMemberByIds(checkQuote.getMemberIds()) : dimension.getMemberByIds(checkQuote.getMemberIds());
                    for (Member member : members) {
                        memberMap.put(member.getNumber(), member.getId());
                    }
                    break block4;
                }
                if (checkQuote.getMemberType() != MemberTypeEnum.VARIABLE.getType()) break block5;
                DynamicObjectCollection objects = this.loadMap("eb_periodvariable", "id, number", checkQuote.getMemberIds());
                for (DynamicObject obj : objects) {
                    memberMap.put(obj.getString("number"), obj.getLong("id"));
                }
                break block4;
            }
            if (checkQuote.getMemberType() != MemberTypeEnum.DIMENSION.getType()) break block4;
            DynamicObjectCollection objects = this.loadMap("epm_dimension", "id, name, number", checkQuote.getMemberIds());
            for (DynamicObject obj : objects) {
                memberMap.put(obj.getString("number"), obj.getLong("id"));
            }
        }
        return memberMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QuoteCheckResult checkQuoteResult(@NotNull CheckQuote checkQuote) {
        LogStats stats = new LogStats("member-quote-log:");
        stats.addInfo("begin-checkQuoteResult.");
        try {
            QuoteCheckResult quoteCheckResult = this._checkQuoteResult(checkQuote, stats);
            return quoteCheckResult;
        }
        finally {
            ModelCacheContext.remove();
            MemberPropCacheService.remove();
            stats.addInfo("end-checkQuoteResult.");
            log.info(stats.toString());
        }
    }

    private QuoteCheckResult _checkQuoteResult(@NotNull CheckQuote checkQuote, LogStats stats) {
        if (checkQuote.getMemberIds().isEmpty()) {
            return QuoteCheckResult.PASS_RESULT;
        }
        List<Object[]> checkParams = this.getCheckParams(checkQuote);
        if (checkParams.isEmpty()) {
            stats.addInfo("checkParams is null.");
            return QuoteCheckResult.PASS_RESULT;
        }
        this.getChildren(checkQuote);
        Map dimensionMap = this.getModelCache(checkQuote.getModelId()).getDimensionMapById();
        StringBuilder str = new StringBuilder();
        for (Object[] checkParam : checkParams) {
            Map<Long, Map<Integer, Set<Long>>> _resourceMap;
            Map<Long, Set<Long>> _memberMap;
            String _cusClass = (String)checkParam[4];
            if (StringUtils.isNotEmpty((String)_cusClass)) {
                try {
                    ICustomQuoteCheck cutCheckFace = (ICustomQuoteCheck)Class.forName(_cusClass).newInstance();
                    _memberMap = cutCheckFace.getResourceMap(checkQuote, checkParam);
                }
                catch (Exception ex) {
                    log.error("cusQuoteCheck-init-error:" + _cusClass);
                    log.error((Throwable)ex);
                    throw new KDBizException(ex.getMessage());
                }
            } else {
                _memberMap = this._checkQuote(checkQuote, (Dimension)dimensionMap.get(checkQuote.getDimensionId()), checkParam, stats);
            }
            if (_memberMap == null || _memberMap.isEmpty() || (_resourceMap = this.getResourceMap(checkQuote, checkParam, _memberMap)).isEmpty()) continue;
            HashMap memberIds = Maps.newHashMapWithExpectedSize((int)_memberMap.size());
            for (Long _memberId : _memberMap.keySet()) {
                memberIds.put(_memberId, _memberId);
            }
            this.buildMsgInfo(checkQuote, checkParam, str, checkQuote.getMemberType(), memberIds, _resourceMap);
            if (str.length() <= 5000) continue;
            str.setLength(5000);
            str.append("......");
            break;
        }
        QuoteCheckResult result = str.length() == 0 ? QuoteCheckResult.PASS_RESULT : new QuoteCheckResult(true, str.toString());
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<Long, Map<Integer, Set<Long>>> getResourceMap(CheckQuote checkQuote, Object[] checkParam, Map<Long, Set<Long>> memberMap) {
        MemberQuoteResourceEnum _resourceType = (MemberQuoteResourceEnum)checkParam[0];
        String _mainTable = (String)checkParam[3];
        String _cusClass = (String)checkParam[4];
        LinkedHashMap resourceMap = Maps.newLinkedHashMap();
        if (StringUtils.isNotEmpty((String)_mainTable)) {
            LinkedHashSet resourceIds = Sets.newLinkedHashSet();
            for (Set<Long> _resIds : memberMap.values()) {
                resourceIds.addAll(_resIds);
            }
            SqlBuilder sql = new SqlBuilder();
            sql.append("select distinct fid, fentryid from ", new Object[0]).append(_mainTable, new Object[0]).append(" where ", new Object[0]).appendIn("fentryid", resourceIds.toArray());
            try (DataSet ds = DB.queryDataSet((String)"queryResource", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
                if (ds == null) return resourceMap;
                for (Row row : ds) {
                    for (Map.Entry<Long, Set<Long>> entry : memberMap.entrySet()) {
                        if (!entry.getValue().contains(row.getLong("fentryid"))) continue;
                        Map map = resourceMap.computeIfAbsent(entry.getKey(), f -> new HashMap(32));
                        Set ids = map.computeIfAbsent(_resourceType.getType(), l -> new HashSet(16));
                        ids.add(row.getLong("fid"));
                    }
                }
                return resourceMap;
            }
        } else {
            for (Map.Entry<Long, Set<Long>> entry : memberMap.entrySet()) {
                HashMap<Integer, Set<Long>> resource = new HashMap<Integer, Set<Long>>();
                resource.put(_resourceType.getType(), entry.getValue());
                resourceMap.put(entry.getKey(), resource);
            }
        }
        return resourceMap;
    }
}

