/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.quote;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DBServiceHelper;
import kd.epm.eb.business.quote.QuoteDelete;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;

public class QuoteSave {
    private static final Log log = LogFactory.getLog(QuoteSave.class);

    public static QuoteSave get() {
        return new QuoteSave();
    }

    public void save(List<MemberQuoteDao> quotes) {
        LogStats stats = new LogStats("member-quote-log:");
        stats.addInfo("begin-save-quote.");
        try {
            this._save(quotes, stats);
        }
        catch (KDException ex) {
            log.error("save-member-quote-error:", (Throwable)ex);
            throw new KDBizException(ResManager.loadKDString((String)"\u4fdd\u5b58\u5f15\u7528\u5173\u7cfb\u6570\u636e\u91cd\u590d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"QuoteSave_0", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        catch (Exception ex) {
            log.error("save-member-quote-error:", (Throwable)ex);
            throw ex;
        }
        finally {
            stats.add("end-save-quote.");
            log.info(stats.toString());
        }
    }

    private void _save(List<MemberQuoteDao> quotes, LogStats stats) {
        if (quotes == null || quotes.isEmpty()) {
            stats.addInfo("memberQuotes is null.");
            return;
        }
        quotes = this.mergeQuote(quotes);
        this.buildQuoteData(quotes, stats);
        this.saveQuote(quotes, this.queryQuoteData(quotes), stats);
    }

    private List<MemberQuoteDao> mergeQuote(List<MemberQuoteDao> quotes) {
        if (quotes == null || quotes.isEmpty()) {
            return quotes;
        }
        LinkedHashMap quoteDaoMap = Maps.newLinkedHashMap();
        for (MemberQuoteDao _quote : quotes) {
            MemberQuoteDao quote = quoteDaoMap.computeIfAbsent(_quote.getQuoteKey(), f -> new MemberQuoteDao(_quote.getModelId(), _quote.getDatasetId(), _quote.getDimensionId(), _quote.getResource(), _quote.getResourceId(), _quote.getMemberRangeMap()));
            quote.setDatasetId(_quote.getDatasetId());
            quote.setMemberType(_quote.getMemberType());
            quote.getMemberIds().addAll(_quote.getMemberIds());
            CollectionUtils.merge((Map)quote.getMemberRangeMap(), (Map)_quote.getMemberRangeMap());
            CollectionUtils.merge((Map)quote.getMemberViewMap(), (Map)_quote.getMemberViewMap());
            quote.mergeExtInfo(_quote.getExtInfo());
        }
        return new ArrayList<MemberQuoteDao>(quoteDaoMap.values());
    }

    private void buildQuoteData(List<MemberQuoteDao> quotes, LogStats stats) {
        stats.add("begin-buildQuoteData.");
        String insert = "insert into t_eb_memberquote(fid, fmodelid, fdatasetid, fdimensionid, fmemberid, ftype, fstatus) select ?, a.fmodelid, a.fdatasetid, a.fdimensionid, a.fmemberid, a.ftype, '1' from (select fmodelid, fdatasetid, fdimensionid, fmemberid, ftype  from t_eb_memberquote where fmodelid = ? and fdatasetid = ? and fdimensionid = ? and fmemberid = ? union select ?, ?, ?, ?, ?) as a where not exists (select fid from t_eb_memberquote where fmodelid = ? and fdatasetid = ? and fdimensionid = ? and fmemberid = ?)";
        LinkedList<Object[]> sqlParams = new LinkedList<Object[]>();
        int exeCount = 0;
        int exeMax = 1000;
        for (MemberQuoteDao quote : quotes) {
            Long modelId = quote.getModelId();
            Long datasetId = quote.getDatasetId();
            Long dimensionId = quote.getDimensionId();
            int index = 0;
            long[] ids = DBServiceHelper.genLongIds((String)"t_eb_memberquote", (int)quote.getMemberIds().size());
            Set<Long> existData = this.beforeCheck(quote);
            for (Long memberId : quote.getMemberIds()) {
                if (this.checkExist(existData, memberId)) continue;
                sqlParams.add(new Object[]{ids[index++], modelId, datasetId, dimensionId, memberId, modelId, datasetId, dimensionId, memberId, quote.getMemberType().getType(), modelId, datasetId, dimensionId, memberId});
                if (++exeCount < exeMax || sqlParams.isEmpty()) continue;
                DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)insert, sqlParams);
                sqlParams.clear();
                exeCount = 0;
            }
        }
        if (!sqlParams.isEmpty()) {
            stats.addInfo("execute size = " + sqlParams.size());
            DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)insert, sqlParams);
        }
        stats.add("end-buildQuoteData.");
    }

    private Set<Long> beforeCheck(MemberQuoteDao quote) {
        if (quote.getMemberIds() == null || quote.getMemberIds().isEmpty()) {
            return Collections.emptySet();
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fmemberid from t_eb_memberquote where fmodelid = ? and fdimensionid = ? and fdatasetid = ? and ", new Object[]{quote.getModelId(), quote.getDimensionId(), quote.getDatasetId()});
        sql.appendIn("fmemberid", (Object[])quote.getMemberIds().toArray(new Long[0]));
        LinkedHashSet<Long> existData = new LinkedHashSet<Long>(1000);
        try (DataSet ds = DB.queryDataSet((String)"queryQuote", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            if (ds != null) {
                for (Row row : ds) {
                    existData.add(row.getLong("fmemberid"));
                }
            }
        }
        return existData;
    }

    private boolean checkExist(Set<Long> existData, Long memberId) {
        if (IDUtils.isNull((Long)memberId)) {
            return true;
        }
        return existData.contains(memberId);
    }

    private Map<Long, Map<Long, Map<Long, Long>>> queryQuoteData(List<MemberQuoteDao> quotes) {
        if (quotes.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap modelQuotes = Maps.newLinkedHashMap();
        for (MemberQuoteDao quote : quotes) {
            Map<Long, Long> _memberQuote = this.queryMemberQuote(quote);
            if (_memberQuote == null || _memberQuote.isEmpty()) continue;
            Map dimQuotes = modelQuotes.computeIfAbsent(quote.getModelId(), f -> Maps.newLinkedHashMap());
            Map memberQuotes = dimQuotes.computeIfAbsent(quote.getDimensionId(), f -> Maps.newLinkedHashMap());
            memberQuotes.putAll(_memberQuote);
        }
        return modelQuotes;
    }

    private Map<Long, Long> queryMemberQuote(MemberQuoteDao quote) {
        if (quote == null || quote.getMemberIds() == null || quote.getMemberIds().size() == 0) {
            return null;
        }
        HashMap memberQuote = Maps.newHashMapWithExpectedSize((int)quote.getMemberIds().size());
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fid, fmemberid from ", new Object[0]).append("t_eb_memberquote", new Object[0]).append(" where fmodelid = ?", new Object[]{quote.getModelId()}).append(" and fdatasetid = ?", new Object[]{quote.getDatasetId()}).append(" and fdimensionid = ?", new Object[]{quote.getDimensionId()}).append(" and ", new Object[0]).appendIn("fmemberid", (Object[])quote.getMemberIds().toArray(new Long[0]));
        try (DataSet ds = DB.queryDataSet((String)"query-member-quote", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            if (ds != null) {
                for (Row row : ds) {
                    memberQuote.put(row.getLong("fmemberid"), row.getLong("fid"));
                }
            }
        }
        return memberQuote;
    }

    private void saveQuote(List<MemberQuoteDao> quotes, Map<Long, Map<Long, Map<Long, Long>>> modelQuotes, LogStats stats) {
        if (quotes.isEmpty()) {
            return;
        }
        LinkedHashMap resourceMap = Maps.newLinkedHashMap();
        for (MemberQuoteDao memberQuoteDao : quotes) {
            Set resourceIds = resourceMap.computeIfAbsent(memberQuoteDao.getResource(), f -> Sets.newLinkedHashSet());
            resourceIds.add(memberQuoteDao.getResourceId());
        }
        QuoteDelete delete = QuoteDelete.get();
        for (Map.Entry entry : resourceMap.entrySet()) {
            delete.delete(((MemberQuoteResourceEnum)entry.getKey()).getType(), (Collection)entry.getValue());
        }
        String string = "insert into t_eb_memberquoteentry(fid, fquoteid, fsourcetype, fsourceid, frange, fviewid, fext) values (?,?,?,?,?,?,?)";
        ArrayList arrayList = Lists.newArrayListWithExpectedSize((int)quotes.size());
        int ONLY = RangeEnum.ONLY.getIndex();
        LinkedHashSet quoteIds = Sets.newLinkedHashSet();
        String extStr = null;
        for (MemberQuoteDao quote : quotes) {
            Map<Long, Long> memberQuotes;
            Map<Long, Map<Long, Long>> dimQuotes = modelQuotes.get(quote.getModelId());
            if (dimQuotes == null || (memberQuotes = dimQuotes.get(quote.getDimensionId())) == null) continue;
            Map memberRangeMap = quote.getMemberRangeMap();
            Map memberViewMap = quote.getMemberViewMap();
            for (Long memberId : quote.getMemberIds()) {
                Set ranges;
                Long viewId;
                Long quoteId = memberQuotes.get(memberId);
                if (quoteId == null) continue;
                if (memberViewMap != null) {
                    viewId = (Long)memberViewMap.get(memberId);
                    if (viewId == null) {
                        viewId = 0L;
                    }
                } else {
                    viewId = 0L;
                }
                extStr = null;
                if (quote.getExtInfo() != null) {
                    Map extInfo = (Map)quote.getExtInfo().get(memberId);
                    if (extInfo != null && !extInfo.isEmpty()) {
                        extStr = JSON.toJSONString((Object)extInfo);
                    }
                    if (extStr != null && extStr.length() > 256) {
                        extStr = extStr.substring(0, 256);
                    }
                }
                if (CollectionUtils.isNotEmpty((Collection)(ranges = (Set)memberRangeMap.get(memberId)))) {
                    for (Integer range : ranges) {
                        arrayList.add(new Object[]{null, quoteId, quote.getResource().getType(), quote.getResourceId(), range, viewId, extStr});
                        quoteIds.add(quoteId);
                    }
                    continue;
                }
                arrayList.add(new Object[]{null, quoteId, quote.getResource().getType(), quote.getResourceId(), ONLY, viewId, extStr});
                quoteIds.add(quoteId);
            }
        }
        if (!arrayList.isEmpty()) {
            long[] ids = DBServiceHelper.genLongIds((String)"t_eb_memberquoteentry", (int)arrayList.size());
            int in = ids.length;
            for (int i = 0; i < in; ++i) {
                ((Object[])arrayList.get((int)i))[0] = ids[i];
            }
            DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)string, (List)arrayList);
            SqlBuilder upSql = new SqlBuilder();
            upSql.append("update ", new Object[0]).append("t_eb_memberquote", new Object[0]).append(" set fstatus = '1' where ", new Object[0]).appendIn("fid", quoteIds.toArray()).append(" and fstatus = '0'", new Object[0]);
            DB.execute((DBRoute)BgBaseConstant.epm, (SqlBuilder)upSql);
        }
    }
}

