/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.quote;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.quote.AbstractQuoteCheck;
import kd.epm.eb.business.quote.CheckQuote;
import kd.epm.eb.business.quote.QuoteCheckResult;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MemberSourceEnum;
import kd.epm.eb.common.enums.memberQuote.MemberTypeEnum;
import kd.epm.eb.common.shrek.controller.EbShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.viewgroup.ViewGroupServiceHelper;
import org.jetbrains.annotations.NotNull;

public class QuoteShrekDataCheck
extends AbstractQuoteCheck {
    public static QuoteShrekDataCheck get() {
        return new QuoteShrekDataCheck();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Long> checkQuote(@NotNull CheckQuote checkQuote) {
        LogStats stats = new LogStats("member-quote-log:");
        stats.addInfo("begin-checkDataQuote.");
        if (checkQuote.getMemberType() == MemberTypeEnum.VARIABLE.getType() || checkQuote.getMemberType() == MemberTypeEnum.VIEW.getType()) {
            stats.addInfo("variable or view not check shrek data.");
            return Collections.emptySet();
        }
        try {
            HashSet<Long> hashSet = new HashSet<Long>(this._checkQuote(checkQuote, stats).values());
            return hashSet;
        }
        finally {
            stats.addInfo("end-checkDataQuote.");
            log.info(stats.toString());
        }
    }

    private Map<String, Long> _checkQuote(@NotNull CheckQuote checkQuote, LogStats stats) {
        Map<String, Long> result;
        if (checkQuote.getMemberIds().isEmpty()) {
            stats.addInfo("memberIds is null.");
            return Collections.emptyMap();
        }
        if (checkQuote.getMemberType() == MemberTypeEnum.MEMBER.getType()) {
            result = this.checkShrekData(checkQuote, stats);
        } else if (checkQuote.getMemberType() == MemberTypeEnum.DIMENSION.getType()) {
            result = this.checkDimensionData(checkQuote, stats);
            try {
                CheckQuote _cloneCheck = (CheckQuote)checkQuote.clone();
                _cloneCheck.setMemberType(MemberTypeEnum.MEMBER.getType());
                _cloneCheck.setCheckChild(true);
                _cloneCheck.getMemberIds().clear();
                IModelCacheHelper modelCache = this.getModelCache(checkQuote.getModelId());
                Dimension _dimension = modelCache.getDimension(_cloneCheck.getDimensionId());
                if (IDUtils.isNotNull((Long)_cloneCheck.getViewId())) {
                    _cloneCheck.getMemberIds().add(modelCache.getRootMember(_dimension.getNumber(), _cloneCheck.getViewId()).getId());
                } else {
                    _cloneCheck.getMemberIds().add(_dimension.getMember(_dimension.getNumber()).getId());
                }
                Map<String, Long> _result = this.checkShrekData(_cloneCheck, stats);
                result.putAll(_result);
            }
            catch (CloneNotSupportedException ex) {
                log.error("checkQuote-clone-error:", (Throwable)ex);
            }
        } else {
            result = Collections.emptyMap();
        }
        return result;
    }

    private Map<String, Long> checkShrekData(@NotNull CheckQuote checkQuote, LogStats stats) {
        Set existNumber;
        this.getChildren(checkQuote);
        IModelCacheHelper modelCache = this.getModelCache(checkQuote.getModelId());
        Dimension dimension = modelCache.getDimension(checkQuote.getDimensionId());
        Set viewIds = null;
        Set viewGroupIds = null;
        if (IDUtils.isNotNull((Long)checkQuote.getViewId())) {
            viewGroupIds = ViewGroupServiceHelper.getInstance().getViewGroupIdByViewId(checkQuote.getViewId().longValue());
            viewIds = ViewGroupServiceHelper.getInstance().getViewsByViewId(checkQuote.getViewId().longValue());
        }
        LinkedHashMap memberMap = Maps.newLinkedHashMap();
        LinkedHashSet datasetIds = Sets.newLinkedHashSet();
        boolean hasAccount = SysDimensionEnum.Account.getNumber().equals(dimension.getNumber());
        if (viewIds != null) {
            for (Long _viewId : viewIds) {
                View view = dimension.getView(_viewId);
                if (view == null) continue;
                List members = view.getMemberByIds(checkQuote.getMemberIds());
                if (members != null && !members.isEmpty()) {
                    members.forEach(m -> {
                        if (m.isLeaf()) {
                            memberMap.put(m.getNumber(), m.getId());
                        }
                    });
                    continue;
                }
                stats.addInfo("members is null.");
            }
        } else {
            List members = dimension.getMemberByIds(checkQuote.getMemberIds());
            if (members != null && !members.isEmpty()) {
                members.forEach(m -> {
                    if (m.isLeaf()) {
                        memberMap.put(m.getNumber(), m.getId());
                    }
                    if (hasAccount) {
                        datasetIds.add(m.getDatasetId());
                    }
                });
                datasetIds.remove(null);
                datasetIds.remove(0L);
            } else {
                stats.addInfo("members is null.");
            }
        }
        if (memberMap.isEmpty()) {
            return Collections.emptyMap();
        }
        if (modelCache.getModelobj().isModelByEB()) {
            existNumber = EbShrekOlapServiceHelper.getExistDataMember((Model)modelCache.getModelobj(), (String)dimension.getNumber(), memberMap.keySet());
        } else {
            if (hasAccount) {
                Member rootAccount = dimension.getMember("Account");
                if (checkQuote.getMemberIds().contains(rootAccount.getId())) {
                    datasetIds.addAll(CollectionUtils.asSet((Object[])DatasetServiceHelper.queryDatasetIds((Long)checkQuote.getModelId())));
                }
            } else {
                if (checkQuote.getBusModelIds() != null) {
                    datasetIds.addAll(DatasetServiceHelper.getDataSetIdByBusModelIds(checkQuote.getBusModelIds()));
                } else if (viewGroupIds != null) {
                    List busModelIds = BusinessModelServiceHelper.getInstance().getBusModelIdsByViewGroupId(checkQuote.getModelId(), viewGroupIds);
                    if (!busModelIds.isEmpty()) {
                        datasetIds.addAll(DatasetServiceHelper.getDataSetIdByBusModelIds(new HashSet(busModelIds)));
                    }
                } else {
                    datasetIds.addAll(DatasetServiceHelper.queryDatasetIds((Long)checkQuote.getModelId(), (Long)checkQuote.getDimensionId()));
                }
                if (IDUtils.isNotNull((Long)checkQuote.getDatasetId()) && datasetIds.contains(checkQuote.getDatasetId())) {
                    datasetIds.clear();
                    datasetIds.add(checkQuote.getDatasetId());
                }
            }
            ArrayList datasets = new ArrayList(datasetIds.size());
            DynamicObjectCollection _datasets = DatasetServiceHelper.loadDatasets((Long[])datasetIds.toArray(new Long[0]));
            if (_datasets != null && !_datasets.isEmpty()) {
                _datasets.forEach(d -> datasets.add(Dataset.of((DynamicObject)d)));
            } else {
                stats.addInfo("datasetIds is null.");
            }
            existNumber = ShrekOlapServiceHelper.getExistDataMember((Model)modelCache.getModelobj(), datasets, (String)dimension.getNumber(), memberMap.keySet());
        }
        if (!existNumber.isEmpty()) {
            HashSet<String> removes = new HashSet<String>(memberMap.size());
            for (String _existNumber : memberMap.keySet()) {
                if (existNumber.contains(_existNumber)) continue;
                removes.add(_existNumber);
            }
            if (!removes.isEmpty()) {
                removes.forEach(memberMap::remove);
            }
            return memberMap;
        }
        return Collections.emptyMap();
    }

    private Map<String, Long> checkDimensionData(@NotNull CheckQuote checkQuote, LogStats stats) {
        String templateEntityNumber;
        QFBuilder builder;
        DynamicObject dimension = QueryServiceHelper.queryOne((String)"epm_dimension", (String)"id, number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)checkQuote.getDimensionId())});
        if (dimension == null) {
            throw new KDBizException("not find dimension. dimensionId = " + checkQuote.getDimensionId());
        }
        LinkedHashMap exitsMap = Maps.newLinkedHashMap();
        if (IDUtils.isNull((Long)checkQuote.getDatasetId())) {
            HashSet<String> sources = new HashSet<String>();
            sources.add(MemberSourceEnum.PRESET.getIndex());
            builder = new QFBuilder();
            builder.add(new QFilter("model", "=", (Object)checkQuote.getModelId()));
            builder.add(new QFilter("dimension", "=", (Object)checkQuote.getDimensionId()));
            builder.add(new QFilter("membersource", "not in", sources));
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryMemberCount", (String)"epm_userdefinedmembertree", (String)"id", (QFilter[])builder.toArrays(), null, (int)1);){
                if (ds != null && ds.hasNext()) {
                    exitsMap.put(dimension.getString("number"), dimension.getLong("id"));
                }
            }
        }
        stats.addInfo("check-eb-template-size.");
        builder = new QFBuilder();
        builder.add("model", "=", (Object)checkQuote.getModelId());
        IModelCacheHelper modelCache = this.getModelCache(checkQuote.getModelId());
        if (modelCache.getModelobj().isModelByEB()) {
            templateEntityNumber = "eb_templateentity_bg";
        } else {
            templateEntityNumber = "eb_templateentity";
            builder.add("dataset", "=", (Object)checkQuote.getDatasetId());
        }
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryMemberCount", (String)templateEntityNumber, (String)"id", (QFilter[])builder.toArrays(), null, (int)1);){
            if (ds != null && ds.hasNext()) {
                exitsMap.put(dimension.getString("number"), dimension.getLong("id"));
            }
        }
        return exitsMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QuoteCheckResult checkQuoteResult(@NotNull CheckQuote checkQuote) {
        LogStats stats = new LogStats("member-quote-log:");
        stats.addInfo("begin-checkQuoteResult.");
        if (checkQuote.getMemberIds().isEmpty()) {
            stats.addInfo("memberIds is null.");
            return QuoteCheckResult.PASS_RESULT;
        }
        if (checkQuote.getMemberType() == MemberTypeEnum.VARIABLE.getType() || checkQuote.getMemberType() == MemberTypeEnum.VIEW.getType() || checkQuote.getMemberType() == MemberTypeEnum.BUSINESS_MODEL.getType() || checkQuote.getMemberType() == MemberTypeEnum.DATASET.getType() || checkQuote.getMemberType() == MemberTypeEnum.ATTRIBUTEVALUE.getType()) {
            stats.addInfo("variable or view not check shrek data.");
            return QuoteCheckResult.PASS_RESULT;
        }
        try {
            Map<String, Long> _existMembers = this._checkQuote(checkQuote, stats);
            if (!_existMembers.isEmpty()) {
                String _number = StringUtils.join(_existMembers.keySet(), (char)',');
                String _msg = "";
                if (checkQuote.getMemberType() == MemberTypeEnum.MEMBER.getType()) {
                    _msg = ResManager.loadResFormat((String)"\u7ef4\u5ea6\u6210\u5458(%1)\u88ab\u591a\u7ef4\u6570\u636e\u5e93\u6570\u636e\u5f15\u7528", (String)"QuoteShrekDataCheck_0", (String)"epm-eb-business", (Object[])new Object[]{_number});
                } else if (checkQuote.getMemberType() == MemberTypeEnum.DIMENSION.getType()) {
                    IModelCacheHelper modelCache = this.getModelCache(checkQuote.getModelId());
                    _msg = modelCache.getModelobj().isModelByEB() ? ResManager.loadResFormat((String)"\u7ef4\u5ea6(%1)\u88ab\u6570\u636e\u3001\u7ef4\u5ea6\u6210\u5458\u6216\u8005\u6a21\u677f\u5f15\u7528", (String)"QuoteShrekDataCheck_1", (String)"epm-eb-business", (Object[])new Object[]{_number}) : ResManager.loadResFormat((String)"\u7ef4\u5ea6(%1)\u88ab\u6570\u636e\u3001\u975e\u9884\u7f6e\u7ef4\u5ea6\u6210\u5458\u5f15\u7528", (String)"QuoteShrekDataCheck_2", (String)"epm-eb-business", (Object[])new Object[]{_number});
                }
                QuoteCheckResult quoteCheckResult = new QuoteCheckResult(true, _msg);
                return quoteCheckResult;
            }
            QuoteCheckResult quoteCheckResult = QuoteCheckResult.PASS_RESULT;
            return quoteCheckResult;
        }
        finally {
            stats.addInfo("end-checkQuoteResult.");
            log.info(stats.toString());
        }
    }
}

