/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.quote;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.quote.utils.QuoteTemplateBuilder;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.enums.BgTemplateTypeEnum;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.spread.report.excel.helper.TemplateHelper;
import kd.epm.eb.spread.template.ITemplateModel;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class QuoteTemplateUpgradeService {
    private static final Log log = LogFactory.getLog(QuoteTemplateUpgradeService.class);

    public void updateTemplateMemberQuote() {
        List models = null;
        try (DataSet ds = DB.queryDataSet((String)"queryModel", (DBRoute)BgBaseConstant.epm, (String)"select fid, fshownumber, freportType from t_eb_model where freportType = '7'");){
            if (ds != null) {
                models = CommonServiceHelper.transDataSet((DataSet)ds);
            }
        }
        if (models == null || models.isEmpty()) {
            return;
        }
        for (Map model : models) {
            Long modelId = IDUtils.toLong(model.get("fid"));
            this.saveTemplateMemberQuote(modelId);
        }
    }

    public int saveTemplateMemberQuote(Long modelId) {
        DynamicObjectCollection templateObjs = QueryServiceHelper.query((String)"eb_templateentity", (String)"varbaseforeb,id,name,number, templatetype, dataunit, model.id, templateCatalog.id, data, dataset.id, spreadserial", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId)});
        if (CollectionUtils.isEmpty((Collection)templateObjs)) {
            return 0;
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        ArrayList<MemberQuoteDao> quotes = new ArrayList<MemberQuoteDao>(16);
        for (DynamicObject templateObj : templateObjs) {
            try {
                ITemplateModel iTemplateModel = TemplateHelper.parseTemplateModel((DynamicObject)templateObj);
                if (iTemplateModel == null) continue;
                int templatetype = iTemplateModel.getTemplateBaseInfo().getTemplatetype();
                if (BgTemplateTypeEnum.EBFIX.getNumber().equals(templatetype + "")) {
                    quotes.addAll(this.saveFixMemberQuote(modelCacheHelper, iTemplateModel));
                    continue;
                }
                quotes.addAll(this.saveDynMemberQuote(modelCacheHelper, iTemplateModel));
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        if (quotes.size() > 0) {
            DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"save", (Object[])new Object[]{quotes});
        }
        return templateObjs.size();
    }

    public List<MemberQuoteDao> saveDynMemberQuote(IModelCacheHelper modelCacheHelper, ITemplateModel templateModel) {
        if (templateModel != null) {
            Long resourceId = templateModel.getTemplateBaseInfo().getId();
            Long datasetId = templateModel.getTemplateBaseInfo().getDatasetID();
            return QuoteTemplateBuilder.get().build(templateModel.getModelId(), datasetId, templateModel, resourceId, modelCacheHelper);
        }
        return Lists.newArrayList();
    }

    public List<MemberQuoteDao> saveFixMemberQuote(IModelCacheHelper modelCacheHelper, ITemplateModel templateModel) {
        if (templateModel != null) {
            Long resourceId = templateModel.getTemplateBaseInfo().getId();
            Long datasetId = templateModel.getTemplateBaseInfo().getDatasetID();
            return QuoteTemplateBuilder.get().build(templateModel.getModelId(), datasetId, templateModel, resourceId, modelCacheHelper);
        }
        return Lists.newArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upgradeTemplateQuote(Long modelId, boolean isRepeatUpgrade) {
        if (IDUtils.isEmptyLong((Long)modelId).booleanValue()) {
            return;
        }
        try (DLock lock = DLock.create((String)("eb/upgradeTemplateQuote/" + modelId));){
            try {
                if (isRepeatUpgrade) {
                    new QuoteTemplateUpgradeService().saveTemplateMemberQuote(modelId);
                } else {
                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"epm_upgrade_log", (String)"id, upgradestatus", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId)});
                    if (dynamicObject == null) {
                        if (!lock.tryLock()) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u6709\u7528\u6237\u6b63\u5728\u8fdb\u884c\u6a21\u677f\u5f15\u7528\u5347\u7ea7\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ReportPreparationListPlugin_40", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        }
                        new QuoteTemplateUpgradeService().saveTemplateMemberQuote(modelId);
                        DynamicObject dynamicObject1 = BusinessDataServiceHelper.newDynamicObject((String)"epm_upgrade_log");
                        dynamicObject1.set("id", (Object)DB.genGlobalLongId());
                        dynamicObject1.set("upgradestatus", (Object)"1");
                        dynamicObject1.set("model", (Object)modelId);
                        dynamicObject1.set("creator", (Object)RequestContext.get().getCurrUserId());
                        dynamicObject1.set("createdate", (Object)TimeServiceHelper.now());
                        DynamicObject[] toSaveObjs = new DynamicObject[]{dynamicObject1};
                        SaveServiceHelper.save((DynamicObject[])toSaveObjs);
                    } else {
                        String upgradestatus = dynamicObject.getString("upgradestatus");
                        if (!StringUtils.equals((CharSequence)upgradestatus, (CharSequence)"1")) {
                            if (!lock.tryLock()) {
                                throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u6709\u7528\u6237\u6b63\u5728\u8fdb\u884c\u6a21\u677f\u5f15\u7528\u5347\u7ea7\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ReportPreparationListPlugin_40", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                            }
                            new QuoteTemplateUpgradeService().saveTemplateMemberQuote(modelId);
                            dynamicObject.set("upgradestatus", (Object)"1");
                            DynamicObject[] toSaveObjs = new DynamicObject[]{dynamicObject};
                            SaveServiceHelper.update((DynamicObject[])toSaveObjs);
                        }
                    }
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                if (e instanceof KDBizException) {
                    throw e;
                }
                log.error(this.getClass().getName() + ":upgrade failed.");
                DynamicObject dynamicObject1 = BusinessDataServiceHelper.newDynamicObject((String)"epm_upgrade_log");
                dynamicObject1.set("id", (Object)DB.genGlobalLongId());
                dynamicObject1.set("upgradestatus", (Object)"0");
                dynamicObject1.set("model", (Object)modelId);
                dynamicObject1.set("creator", (Object)RequestContext.get().getCurrUserId());
                dynamicObject1.set("createdate", (Object)TimeServiceHelper.now());
                DynamicObject[] toSaveObjs = new DynamicObject[]{dynamicObject1};
                SaveServiceHelper.save((DynamicObject[])toSaveObjs);
            }
            finally {
                lock.unlock();
            }
        }
    }
}

