/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.quote;

import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;
import org.jetbrains.annotations.NotNull;

public class QuoteUpgradeService {
    private final Map<Integer, Map<Long, Map<String, Long>>> resourceMap = Maps.newLinkedHashMap();

    private QuoteUpgradeService() {
    }

    public static QuoteUpgradeService get() {
        return new QuoteUpgradeService();
    }

    public void updateMemberQuote(@NotNull LogStats stats) {
        List models = null;
        DataSet ds = DB.queryDataSet((String)"queryModel", (DBRoute)BgBaseConstant.epm, (String)"select fid, fshownumber, freporttype from t_eb_model where freportType = '7'");
        Object object = null;
        try {
            if (ds != null) {
                models = CommonServiceHelper.transDataSet((DataSet)ds);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        LinkedHashSet<Long> existModelIds = new LinkedHashSet<Long>(500);
        try (DataSet ds2 = DB.queryDataSet((String)"queryQuote", (DBRoute)BgBaseConstant.epm, (String)"select distinct fmodelid from t_eb_memberquote");){
            if (ds2 != null) {
                for (Row row : ds2) {
                    existModelIds.add(row.getLong("fmodelid"));
                }
            }
        }
        if (models == null || models.isEmpty()) {
            stats.addInfo("no-models");
            return;
        }
        stats.addInfo("model.size = " + models.size());
        for (Map model : models) {
            if (!existModelIds.contains(model.get("fid"))) {
                this.updateMemberQuoteByModel(model, stats);
                continue;
            }
            stats.addInfo("model is upgrade." + model.get("fshownumber"));
        }
    }

    private void updateMemberQuoteByModel(Map<String, Object> model, LogStats stats) {
        if (model == null || model.isEmpty()) {
            stats.addInfo("model data is null.");
            return;
        }
        Long modelId = IDUtils.toLong((Object)model.get("fid"));
        String modelNumber = (String)model.get("fshownumber");
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        List dimensionMap = null;
        try (DataSet ds = DB.queryDataSet((String)"queryDimension", (DBRoute)BgBaseConstant.epm, (String)"select fid, fnumber from t_eb_dimension where fmodelid = ?", (Object[])new Object[]{modelId});){
            if (ds != null) {
                dimensionMap = CommonServiceHelper.transDataSet((DataSet)ds);
            }
        }
        if (dimensionMap == null || dimensionMap.isEmpty()) {
            stats.addInfo("model dimension is null. modelNumber = " + modelNumber);
            return;
        }
        for (Map dimension : dimensionMap) {
            this.updateMemberQuoteByDimension(modelCacheHelper, dimension);
        }
    }

    private void updateMemberQuoteByDimension(IModelCacheHelper modelCacheHelper, Map<String, Object> dimension) {
        if (dimension == null || dimension.isEmpty()) {
            return;
        }
        Dimension _dimension = modelCacheHelper.getDimension((String)dimension.get("fnumber"));
        if (_dimension == null) {
            return;
        }
        if (_dimension.getMemberModel() != null && _dimension.getMemberModel().startsWith("bcm")) {
            return;
        }
        Long modelId = modelCacheHelper.getModelobj().getId();
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fmembernumber, fquotenumber, fresource from t_eb_member_quote where fmodelnumber = ? and fdimensionnumber = ?", new Object[]{modelCacheHelper.getModelobj().getNumber(), _dimension.getNumber()});
        LinkedList<MemberQuoteDao> quotes = new LinkedList<MemberQuoteDao>();
        boolean hasBgmd = ApplicationTypeEnum.isBGMD((String)modelCacheHelper.getModelobj().getReportType());
        boolean hasNewBg = ApplicationTypeEnum.BG.getIndex().equals(modelCacheHelper.getModelobj().getReportType());
        boolean hasAccount = SysDimensionEnum.Account.getNumber().equals(_dimension.getNumber());
        try (DataSet ds = DB.queryDataSet((String)"queryMemberQuote", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            if (ds != null) {
                for (Row row : ds) {
                    Map resourceIdMap;
                    Map resourceIds;
                    MemberQuoteResourceEnum resource;
                    Member member = _dimension.getStructOfMember(row.getString("fmembernumber"));
                    if (member == null || _dimension.getNumber().equals(member.getNumber()) || (resource = this.getNewResource(row.getString("fresource"))) == null || (resourceIds = (Map)(resourceIdMap = this.resourceMap.computeIfAbsent(resource.getType(), f -> this.queryResourceIds(resource))).get(modelId)) == null) continue;
                    Long resourceId = (Long)resourceIds.get(row.getString("fquotenumber"));
                    if (resourceId == null && resource == MemberQuoteResourceEnum.BizRule) {
                        resourceId = (Long)resourceIds.get("Account:" + row.getString("fquotenumber"));
                    }
                    if (resourceId == null) continue;
                    if ((hasBgmd || hasNewBg) && hasAccount) {
                        if (IDUtils.isNotNull((Long)member.getDatasetId())) {
                            quotes.add(new MemberQuoteDao(modelId, member.getDatasetId(), _dimension.getId(), member.getId(), resource, resourceId));
                        }
                    } else {
                        quotes.add(new MemberQuoteDao(modelId, _dimension.getId(), member.getId(), resource, resourceId));
                    }
                    if (quotes.size() <= 50000) continue;
                    DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"save", (Object[])new Object[]{quotes});
                    quotes.clear();
                }
                if (!quotes.isEmpty()) {
                    DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"save", (Object[])new Object[]{quotes});
                }
            }
        }
    }

    private Map<Long, Map<String, Long>> queryResourceIds(MemberQuoteResourceEnum resource) {
        LinkedHashMap<Long, Map<String, Long>> _resourceIdMap = new LinkedHashMap<Long, Map<String, Long>>();
        try (DataSet _ds = QueryServiceHelper.queryDataSet((String)"queryResource", (String)resource.getEntityNumber(), (String)"id, number, model.id", null, null);){
            if (_ds != null) {
                for (Row row : _ds) {
                    Map _resourceIds = _resourceIdMap.computeIfAbsent(row.getLong("model.id"), f -> new LinkedHashMap());
                    _resourceIds.put(row.getString("number"), row.getLong("id"));
                }
            }
        }
        return _resourceIdMap;
    }

    private MemberQuoteResourceEnum getNewResource(String oldResourceValue) {
        if (oldResourceValue == null) {
            return null;
        }
        MemberQuoteResourceEnum resource = null;
        switch (oldResourceValue) {
            case "01": {
                resource = MemberQuoteResourceEnum.Template;
                break;
            }
            case "02": {
                resource = MemberQuoteResourceEnum.BizRule;
                break;
            }
            case "03": {
                resource = MemberQuoteResourceEnum.Examine;
                break;
            }
            case "04": {
                resource = MemberQuoteResourceEnum.OffsetRule;
                break;
            }
            case "05": {
                break;
            }
            case "6": {
                resource = MemberQuoteResourceEnum.TaskList;
                break;
            }
            case "07": {
                break;
            }
            case "08": {
                resource = MemberQuoteResourceEnum.RollInit;
                break;
            }
            case "09": {
                break;
            }
            case "10": {
                break;
            }
            case "11": {
                resource = MemberQuoteResourceEnum.Scheme;
            }
        }
        return resource;
    }
}

