/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.quote.impl;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.quote.CheckQuote;
import kd.epm.eb.business.quote.ICustomQuoteCheck;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.reportprocess.helper.SchemeRecordDeleteEntityHelper;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import org.jetbrains.annotations.NotNull;

public class ReportQuoteCheckImpl
implements ICustomQuoteCheck {
    @Override
    public Map<Long, Set<Long>> getResourceMap(@NotNull CheckQuote checkQuote, @NotNull Object[] checkParam) {
        return this.getResourceMap(checkQuote.getModelId(), checkQuote.getViewId(), checkQuote.getMemberIds());
    }

    public Map<Long, Set<Long>> getResourceMap(Long modelId, Long viewId, Set<Long> memberIds) {
        HashMap memberMap = Maps.newHashMap();
        this.getSchemeResourceMap(modelId, viewId, memberIds, memberMap);
        this.getTaskRptQuote(viewId, memberIds, memberMap);
        return memberMap;
    }

    private void getSchemeResourceMap(Long modelId, Long viewId, Set<Long> memeberIds, Map<Long, Set<Long>> memberMap) {
        Set id;
        QFilter qFilter1;
        DynamicObjectCollection load;
        if (IDUtils.isNull((Long)modelId) || CollectionUtils.isEmpty(memeberIds)) {
            return;
        }
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("scheme.orgview.id", "=", (Object)viewId);
        DynamicObject[] query = BusinessDataServiceHelper.load((String)"eb_schemeassign", (String)"scheme.id as id", (QFilter[])new QFilter[]{qFilter});
        if (query != null && query.length > 0 && (load = QueryServiceHelper.query((String)"eb_templateorg", (String)"id,template.id,org.id,orgrange,templatetype,applytemplate", (QFilter[])new QFilter[]{qFilter1 = new QFilter("scheme.id", "in", id = Arrays.stream(query).map(x -> x.getLong("scheme.id")).collect(Collectors.toSet()))})) != null && load.size() > 0) {
            List recordIdList = load.stream().map(x -> x.getLong("id")).collect(Collectors.toList());
            Map recordDeleteEntity = SchemeRecordDeleteEntityHelper.queryDeleteEntityByRecordId(recordIdList);
            IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)modelId);
            for (DynamicObject dynamicObject : load) {
                int rangetype = dynamicObject.getInt("orgrange");
                long org = dynamicObject.getLong("org.id");
                String templatetype = dynamicObject.getString("templatetype");
                Long templateId = "0".equals(templatetype) ? dynamicObject.getLong("template.id") : dynamicObject.getLong("applytemplate.id");
                if (rangetype == RangeEnum.ONLY.getIndex()) {
                    if (!memeberIds.contains(org)) continue;
                    Set set = memberMap.computeIfAbsent(org, k -> new HashSet());
                    set.add(templateId);
                    continue;
                }
                Member member = orCreate.getMember(SysDimensionEnum.Entity.getNumber(), viewId, Long.valueOf(org));
                if (member == null) continue;
                List member1 = orCreate.getMember(SysDimensionEnum.Entity.getNumber(), viewId, member.getNumber(), rangetype);
                Set collect = member1.stream().map(x -> x.getId()).collect(Collectors.toSet());
                Set deleteSet = (Set)recordDeleteEntity.get(dynamicObject.getLong("id"));
                if (CollectionUtils.isNotEmpty((Collection)deleteSet)) {
                    collect.removeAll(deleteSet);
                }
                if (!CollectionUtils.isNotEmpty(collect) || Collections.disjoint(memeberIds, collect)) continue;
                Set set = memberMap.computeIfAbsent(org, k -> new HashSet());
                set.add(templateId);
            }
        }
    }

    private void getTaskRptQuote(Long viewId, Set<Long> memberIds, Map<Long, Set<Long>> memberMap) {
        if (CollectionUtils.isEmpty(memberIds)) {
            return;
        }
        QFilter viewFilter = new QFilter("orgview", "=", (Object)viewId);
        QFilter orgFilter = new QFilter("org", "in", memberIds);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"eb_taskprocess", (String)"org,template", (QFilter[])new QFilter[]{viewFilter, orgFilter});
        for (DynamicObject dynamicObject : dynamicObjects) {
            Set longs = memberMap.computeIfAbsent(dynamicObject.getLong("org"), v -> new HashSet(16));
            longs.add(dynamicObject.getLong("template"));
        }
    }
}

