/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.quote.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.entity.property.CustomPropertyValue;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.RangeF7PropertyCataEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.enums.memberQuote.MemberTypeEnum;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.period.PeriodLeadUtils;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.afix.multisetting.IMultiAreaSetting;
import kd.epm.eb.spread.template.afix.multisetting.MultiAreaSetting;
import kd.epm.eb.spread.template.arearangedim.IAreaRangeEntry;
import kd.epm.eb.spread.template.arearangedim.IRowColDimensionEntry;
import kd.epm.eb.spread.template.dimension.IDimension;
import kd.epm.eb.spread.template.dimension.IDimensionMember;
import kd.epm.eb.spread.template.headerarea.IHeaderInfo;
import kd.epm.eb.spread.template.pagedim.IPageDimensionEntry;
import kd.epm.eb.spread.template.partition.RowColPartition;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;
import kd.epm.eb.spread.template.viewpointdim.IViewPointDimensionEntry;

public class QuoteTemplateBuilder {
    public static final Log log = LogFactory.getLog(QuoteTemplateBuilder.class);

    public static QuoteTemplateBuilder get() {
        return new QuoteTemplateBuilder();
    }

    public List<MemberQuoteDao> build(Long modelId, Long datasetId, ITemplateModel templateModel, Long resourceId, IModelCacheHelper modelCache) {
        if (IDUtils.isNull((Long)modelId) || IDUtils.isNull((Long)datasetId) || templateModel == null || IDUtils.isNull((Long)resourceId) || modelCache == null) {
            return Collections.emptyList();
        }
        QuoteBuilderData builderData = new QuoteBuilderData();
        this.buildViewDim(modelId, datasetId, templateModel, resourceId, modelCache, builderData);
        this.buildPageDim(modelId, datasetId, templateModel, resourceId, modelCache, builderData);
        this.buildRangeDim(modelId, datasetId, templateModel, resourceId, modelCache, builderData);
        this.buildRowColDim(modelId, datasetId, templateModel, resourceId, modelCache, builderData);
        ArrayList<MemberQuoteDao> quotes = new ArrayList<MemberQuoteDao>(builderData.getQuotesMap().values());
        quotes.addAll(this.buildVarQuote(modelId, resourceId, modelCache, builderData));
        quotes.addAll(this.buildPropertyQuote(modelId, resourceId, modelCache, builderData));
        quotes.addAll(this.buildPropertyValueQuote(modelId, resourceId, modelCache, builderData));
        quotes.addAll(this.buildView(modelId, datasetId, templateModel.getDimemsionViews(), resourceId, modelCache));
        return quotes;
    }

    private void buildViewDim(Long modelId, Long datasetId, ITemplateModel templateModel, Long resourceId, IModelCacheHelper modelCache, QuoteBuilderData builderData) {
        for (IViewPointDimensionEntry viewEntry : templateModel.getViewpointmembentry()) {
            this.buildViewPointDim(modelId, datasetId, viewEntry, templateModel, resourceId, modelCache, builderData);
        }
    }

    private void buildViewPointDim(Long modelId, Long datasetId, IViewPointDimensionEntry viewEntry, ITemplateModel templateModel, Long resourceId, IModelCacheHelper modelCache, QuoteBuilderData builderData) {
        Dimension dimension = IDUtils.isNull((Long)viewEntry.getDimension().getId()) ? modelCache.getDimension(viewEntry.getDimension().getNumber()) : modelCache.getDimension(viewEntry.getDimension().getId());
        if (dimension != null) {
            Long dimensionId = dimension.getId();
            Long viewId = (Long)templateModel.getDimemsionViews().get(dimension.getNumber());
            String quoteKey = dimension.getNumber();
            if (IDUtils.isNotNull((Long)viewId)) {
                quoteKey = quoteKey + (64L + viewId);
            }
            MemberQuoteDao quote = builderData.getQuotesMap().computeIfAbsent(quoteKey, f -> new MemberQuoteDao(modelId, datasetId, dimensionId, MemberQuoteResourceEnum.Template, resourceId));
            if (viewEntry.getMember() != null && RangeF7PropertyCataEnum.Member == this.getMemberCata(viewEntry.getMember())) {
                Member member = IDUtils.isNull((Long)viewEntry.getMember().getId()) ? dimension.getMember(viewId, viewEntry.getMember().getNumber()) : dimension.getMember(viewId, viewEntry.getMember().getId());
                if (member != null) {
                    quote.getMemberIds().add(member.getId());
                    if (IDUtils.isNotNull((Long)viewId)) {
                        quote.getMemberViewMap().put(member.getId(), viewId);
                    }
                } else {
                    log.warn("QuoteTemplateBuilder-member-error" + SerializationUtils.toJsonString((Object)viewEntry.getMember()));
                }
            }
            this.buildVar(viewEntry.getDimension(), viewId, CollectionUtils.asList((Object[])new IDimensionMember[]{viewEntry.getMember()}), builderData);
            this.buildProperty(viewEntry.getDimension(), CollectionUtils.asList((Object[])new IDimensionMember[]{viewEntry.getMember()}), modelCache, builderData);
        } else {
            log.warn("QuoteTemplateBuilder-dimension-error" + SerializationUtils.toJsonString((Object)viewEntry.getDimension()));
        }
    }

    private void buildPageDim(Long modelId, Long datasetId, ITemplateModel templateModel, Long resourceId, IModelCacheHelper modelCache, QuoteBuilderData builderData) {
        for (IPageDimensionEntry pageEntry : templateModel.getPagemembentry()) {
            Dimension dimension = IDUtils.isNull((Long)pageEntry.getDimension().getId()) ? modelCache.getDimension(pageEntry.getDimension().getNumber()) : modelCache.getDimension(pageEntry.getDimension().getId());
            if (dimension != null) {
                Long dimensionId = dimension.getId();
                Long viewId = (Long)templateModel.getDimemsionViews().get(dimension.getNumber());
                String quoteKey = dimension.getNumber();
                if (IDUtils.isNotNull((Long)viewId)) {
                    quoteKey = quoteKey + (64L + viewId);
                }
                MemberQuoteDao quote = builderData.getQuotesMap().computeIfAbsent(quoteKey, f -> new MemberQuoteDao(modelId, datasetId, dimensionId, MemberQuoteResourceEnum.Template, resourceId));
                for (IDimensionMember _member : pageEntry.getMembers()) {
                    if (_member == null || RangeF7PropertyCataEnum.Member != this.getMemberCata(_member)) continue;
                    Member member = IDUtils.isNull((Long)_member.getId()) ? dimension.getMember(viewId, _member.getNumber()) : dimension.getMember(viewId, _member.getId());
                    if (member != null) {
                        quote.getMemberIds().add(member.getId());
                        if (RangeEnum.ONLY.getIndex() != _member.getScope()) {
                            Set rangeSet = quote.getMemberRangeMap().computeIfAbsent(member.getId(), f -> Sets.newLinkedHashSet());
                            rangeSet.add(_member.getScope());
                        }
                        if (!IDUtils.isNotNull((Long)viewId)) continue;
                        quote.getMemberViewMap().put(member.getId(), viewId);
                        continue;
                    }
                    log.warn("QuoteTemplateBuilder-member-error" + SerializationUtils.toJsonString((Object)_member));
                }
                if (SysDimensionEnum.Entity.getNumber().equals(pageEntry.getDimension().getNumber())) {
                    List viewGroupViewsByDataSetAndDimNumber = modelCache.getViewGroupViewsByDataSetAndDimNumber(datasetId, SysDimensionEnum.Entity.getNumber());
                    for (Long aLong : viewGroupViewsByDataSetAndDimNumber) {
                        Member rootMember = modelCache.getRootMember(SysDimensionEnum.Entity.getNumber(), aLong);
                        if (rootMember == null) continue;
                        quote.getMemberIds().add(rootMember.getId());
                    }
                }
                this.buildVar(pageEntry.getDimension(), viewId, pageEntry.getMembers(), builderData);
                this.buildProperty(pageEntry.getDimension(), pageEntry.getMembers(), modelCache, builderData);
                continue;
            }
            log.warn("QuoteTemplateBuilder-dimension-error" + SerializationUtils.toJsonString((Object)pageEntry.getDimension()));
        }
    }

    private void buildRangeDim(Long modelId, Long datasetId, ITemplateModel templateModel, Long resourceId, IModelCacheHelper modelCache, QuoteBuilderData builderData) {
        if (templateModel.getAreaRangeEntry() != null) {
            IAreaRangeEntry rangeEntry = templateModel.getAreaRangeEntry();
            if (rangeEntry.getRowHeaders() != null) {
                for (Object head : rangeEntry.getRowHeaders()) {
                    this.buildRangeHead((IHeaderInfo)head, modelCache, builderData);
                }
            }
            if (rangeEntry.getColHeaders() != null) {
                for (Object head : rangeEntry.getColHeaders()) {
                    this.buildRangeHead((IHeaderInfo)head, modelCache, builderData);
                }
            }
        }
        if (templateModel.getAreaRanges() != null) {
            for (IMultiAreaSetting _multiArea : templateModel.getAreaRanges()) {
                if (_multiArea.getRowHeaders() != null) {
                    for (IHeaderInfo head : _multiArea.getRowHeaders()) {
                        this.buildRangeHead(head, modelCache, builderData);
                    }
                }
                if (_multiArea.getColHeaders() != null) {
                    for (IHeaderInfo head : _multiArea.getColHeaders()) {
                        this.buildRangeHead(head, modelCache, builderData);
                    }
                }
                if (_multiArea.getAreaViewpointmembentry() != null) {
                    for (IViewPointDimensionEntry entry : _multiArea.getAreaViewpointmembentry()) {
                        this.buildViewPointDim(modelId, datasetId, entry, templateModel, resourceId, modelCache, builderData);
                    }
                }
                if (_multiArea.getFloatInfos() != null) {
                    String[] tmpStr = _multiArea.getAreaRange().split(":");
                    String tag = tmpStr.length > 0 ? tmpStr[0] : _multiArea.getAreaRange();
                    for (MultiAreaSetting.FloatInfo floatData : _multiArea.getFloatInfos()) {
                        if (floatData.getPartition() == null) continue;
                        this.buildPartitionDim(modelId, datasetId, templateModel, CollectionUtils.asList((Object[])new RowColPartition[]{floatData.getPartition()}), tag, resourceId, modelCache, builderData);
                    }
                }
                this.buildSheetDim(modelId, datasetId, _multiArea, templateModel, resourceId, modelCache, builderData);
            }
        }
    }

    private void buildRangeHead(IHeaderInfo head, IModelCacheHelper modelCache, QuoteBuilderData builderData) {
        Dimension dimension;
        if (StringUtils.equals((String)"Property", (String)head.getType()) && (dimension = modelCache.getDimension(head.getRefDimension())) != null) {
            Set properties = builderData.getPropertyMap().computeIfAbsent(dimension.getId(), f -> Sets.newHashSet());
            properties.add(head.getNumber());
        }
    }

    private void buildSheetDim(Long modelId, Long datasetId, IMultiAreaSetting multiArea, ITemplateModel templateModel, Long resourceId, IModelCacheHelper modelCache, QuoteBuilderData builderData) {
        if (multiArea == null || modelCache == null || builderData == null) {
            return;
        }
        ISheet sheet = multiArea.getAreaSheet();
        if (sheet != null) {
            String[] tmpStr = multiArea.getAreaRange().split(":");
            String tag = tmpStr.length > 0 ? tmpStr[0] : multiArea.getAreaRange();
            sheet.iteratorECells(cell -> {
                if (cell.hasUserObject()) {
                    Dimension _dimension;
                    String dimNumber = String.valueOf(cell.getUserObject("dimnumber"));
                    String memberNumber = String.valueOf(cell.getUserObject("number"));
                    if (StringUtils.isNotEmpty((String)dimNumber) && StringUtils.isNotEmpty((String)memberNumber) && (_dimension = modelCache.getDimension(dimNumber)) != null) {
                        Member member;
                        Long viewId = (Long)templateModel.getDimemsionViews().get(_dimension.getNumber() + '_' + tag);
                        String quoteKey = _dimension.getNumber();
                        if (IDUtils.isNotNull((Long)viewId)) {
                            quoteKey = quoteKey + (64L + viewId);
                        }
                        if ((member = _dimension.getMember(viewId, memberNumber)) != null) {
                            MemberQuoteDao quote = builderData.getQuotesMap().computeIfAbsent(quoteKey, f -> new MemberQuoteDao(modelId, datasetId, _dimension.getId(), MemberQuoteResourceEnum.Template, resourceId));
                            quote.getMemberIds().add(member.getId());
                            if (IDUtils.isNotNull((Long)viewId)) {
                                quote.getMemberViewMap().put(member.getId(), viewId);
                            }
                        } else {
                            RangeF7PropertyCataEnum cata = this.hasVarCata(memberNumber);
                            if (RangeF7PropertyCataEnum.Var == cata) {
                                boolean hasPeriod = this.hasPeriod(_dimension.getNumber());
                                this.buildVar(_dimension.getNumber(), viewId, memberNumber, RangeEnum.ONLY.getIndex(), hasPeriod, builderData);
                            } else {
                                log.warn("QuoteTemplateBuilder-member-error" + memberNumber);
                            }
                        }
                    }
                }
            });
        }
    }

    private void buildRowColDim(Long modelId, Long datasetId, ITemplateModel templateModel, Long resourceId, IModelCacheHelper modelCache, QuoteBuilderData builderData) {
        if (templateModel.getPartitionSetting() != null) {
            this.buildPartitionDim(modelId, datasetId, templateModel, templateModel.getPartitionSetting().getRowPartition(), "r", resourceId, modelCache, builderData);
            this.buildPartitionDim(modelId, datasetId, templateModel, templateModel.getPartitionSetting().getColPartition(), "c", resourceId, modelCache, builderData);
        }
    }

    private void buildPartitionDim(Long modelId, Long datasetId, ITemplateModel templateModel, List<RowColPartition> partitions, String rowColTag, Long resourceId, IModelCacheHelper modelCache, QuoteBuilderData builderData) {
        int index = 0;
        boolean hasRowCol = StringUtils.equals((String)"r", (String)rowColTag) || StringUtils.equals((String)"c", (String)rowColTag);
        for (RowColPartition partition : partitions) {
            MemberQuoteDao quote;
            for (IRowColDimensionEntry entry : partition.getRowColDimensionEntries()) {
                Dimension dimension = IDUtils.isNull((Long)entry.getDimension().getId()) ? modelCache.getDimension(entry.getDimension().getNumber()) : modelCache.getDimension(entry.getDimension().getId());
                if (dimension != null) {
                    Member member;
                    Long dimensionId = dimension.getId();
                    Long viewId = hasRowCol ? (Long)templateModel.getDimemsionViews().get(dimension.getNumber() + '_' + rowColTag + index) : (Long)templateModel.getDimemsionViews().get(dimension.getNumber() + '_' + rowColTag);
                    String quoteKey = dimension.getNumber();
                    if (IDUtils.isNotNull((Long)viewId)) {
                        quoteKey = quoteKey + (64L + viewId);
                    }
                    quote = builderData.getQuotesMap().computeIfAbsent(quoteKey, f -> new MemberQuoteDao(modelId, datasetId, dimensionId, MemberQuoteResourceEnum.Template, resourceId));
                    for (IDimensionMember _member : entry.getMembers()) {
                        if (_member == null || RangeF7PropertyCataEnum.Member != this.getMemberCata(_member)) continue;
                        member = IDUtils.isNull((Long)_member.getId()) ? dimension.getMember(viewId, _member.getNumber()) : dimension.getMember(viewId, _member.getId());
                        if (member != null) {
                            quote.getMemberIds().add(member.getId());
                            Set rangeSet = quote.getMemberRangeMap().computeIfAbsent(member.getId(), f -> Sets.newLinkedHashSet());
                            rangeSet.add(_member.getScope());
                            if (!IDUtils.isNotNull((Long)viewId)) continue;
                            quote.getMemberViewMap().put(member.getId(), viewId);
                            continue;
                        }
                        log.warn("QuoteTemplateBuilder-member-error" + SerializationUtils.toJsonString((Object)_member));
                    }
                    if (entry.isQuickAddNew() && StringUtils.isNotEmpty((String)entry.getDefaultParentNum())) {
                        member = dimension.getMember(viewId, entry.getDefaultParentNum());
                        if (member != null) {
                            quote.getMemberIds().add(member.getId());
                            if (IDUtils.isNotNull((Long)viewId)) {
                                quote.getMemberViewMap().put(member.getId(), viewId);
                            }
                        } else {
                            log.warn("QuoteTemplateBuilder-member-error" + entry.getDefaultParentNum());
                        }
                    }
                    this.buildVar(entry.getDimension(), viewId, entry.getMembers(), builderData);
                    this.buildProperty(entry.getDimension(), entry.getMembers(), modelCache, builderData);
                    continue;
                }
                log.warn("QuoteTemplateBuilder-dimension-error" + SerializationUtils.toJsonString((Object)entry.getDimension()));
            }
            ++index;
            if (partition.getMetricDimMmebers().isEmpty()) continue;
            Dimension metricDim = modelCache.getDimension("Metric");
            quote = builderData.getQuotesMap().computeIfAbsent(metricDim.getNumber(), f -> new MemberQuoteDao(modelId, datasetId, metricDim.getId(), MemberQuoteResourceEnum.Template, resourceId));
            for (IDimensionMember _metric : partition.getMetricDimMmebers()) {
                quote.getMemberIds().add(_metric.getId());
            }
        }
    }

    private RangeF7PropertyCataEnum getMemberCata(IDimensionMember member) {
        if (member == null) {
            return null;
        }
        RangeF7PropertyCataEnum cataEnum = member.getNumber() != null && member.getNumber().charAt(0) == '@' ? RangeF7PropertyCataEnum.Var : (RangeF7PropertyCataEnum.Property.getIndex().equals(member.getType()) ? RangeF7PropertyCataEnum.Property : RangeF7PropertyCataEnum.Member);
        return cataEnum;
    }

    private RangeF7PropertyCataEnum hasVarCata(String memberNumber) {
        if (StringUtils.isEmpty((String)memberNumber)) {
            return null;
        }
        RangeF7PropertyCataEnum cataEnum = null;
        if (memberNumber.charAt(0) == '@') {
            cataEnum = RangeF7PropertyCataEnum.Var;
        }
        return cataEnum;
    }

    private void buildVar(IDimension dimension, Long viewId, Collection<IDimensionMember> members, QuoteBuilderData builderData) {
        if (dimension == null || members == null || members.isEmpty() || builderData == null) {
            return;
        }
        boolean hasPeriod = this.hasPeriod(dimension.getNumber());
        for (IDimensionMember member : members) {
            if (member == null || RangeF7PropertyCataEnum.Var != this.getMemberCata(member)) continue;
            this.buildVar(dimension.getNumber(), viewId, member.getNumber(), member.getScope(), hasPeriod, builderData);
        }
    }

    private boolean hasPeriod(String dimensionNumber) {
        return StringUtils.equals((String)dimensionNumber, (String)"BudgetPeriod") || StringUtils.equals((String)dimensionNumber, (String)"Year");
    }

    private void buildVar(String dimensionNumber, Long viewId, String memberNumber, int scope, boolean hasPeriod, QuoteBuilderData builderData) {
        if (StringUtils.isEmpty((String)dimensionNumber) || StringUtils.isEmpty((String)memberNumber) || builderData == null) {
            return;
        }
        String[] varNumbers = memberNumber.split("[+\\- ]");
        String varNumber = varNumbers[0];
        Set varNumberSet = builderData.getVarNumberMap().computeIfAbsent(dimensionNumber, f -> Sets.newHashSet());
        varNumberSet.add(varNumber);
        builderData.getVarViewMap().put(varNumber, viewId);
        if (hasPeriod) {
            int SEP_INDEX = memberNumber.indexOf(45);
            if (varNumbers.length > 1) {
                String offset = varNumbers[1];
                if (SEP_INDEX > 0) {
                    offset = "-" + varNumbers[1];
                }
                Set extInfo = builderData.getVarExtMap().computeIfAbsent(varNumber, f -> Sets.newHashSet());
                extInfo.add(offset);
            }
            if (RangeEnum.ONLY.getIndex() != scope) {
                Set varRanges = builderData.getVarRangeMap().computeIfAbsent(varNumber, t -> Sets.newHashSet());
                varRanges.add(scope);
            }
        }
    }

    private List<MemberQuoteDao> buildVarQuote(Long modelId, Long resourceId, IModelCacheHelper modelCache, QuoteBuilderData builderData) {
        if (IDUtils.isNull((Long)modelId) || modelCache == null || builderData == null || builderData.getVarNumberMap().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<MemberQuoteDao> quotes = new ArrayList<MemberQuoteDao>(16);
        LinkedHashSet allVarNumbers = new LinkedHashSet(16);
        builderData.getVarNumberMap().values().forEach(allVarNumbers::addAll);
        Map<String, Long> varViewMap = builderData.getVarViewMap();
        HashMap<Long, Long> varIdViewMap = new HashMap<Long, Long>(16);
        Map dimensionMap = modelCache.getDimensionMap();
        HashMap dimVarIds = Maps.newHashMapWithExpectedSize((int)allVarNumbers.size());
        HashMap varRangeMap = Maps.newHashMapWithExpectedSize((int)allVarNumbers.size());
        HashMap varExtDataMap = Maps.newHashMapWithExpectedSize((int)builderData.getVarExtMap().size());
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", (Object)modelId);
        builder.add("number", "in", allVarNumbers);
        Map _variables = BusinessDataServiceHelper.loadFromCache((String)"eb_periodvariable", (String)"id, number, dimension.number", (QFilter[])builder.toArray());
        for (DynamicObject variable : _variables.values()) {
            Set<String> varExtSet;
            String dimensionNumber = variable.getString("dimension.number");
            long varId2 = variable.getLong("id");
            String varNumber = variable.getString("number");
            Set<String> varNumbers = builderData.getVarNumberMap().get(dimensionNumber);
            if (varNumbers != null && varNumbers.contains(varNumber)) {
                Set varIds = dimVarIds.computeIfAbsent(dimensionNumber, f -> Sets.newHashSetWithExpectedSize((int)32));
                varIds.add(varId2);
                Long viewId = varViewMap.get(varNumber);
                if (IDUtils.isNotEmptyLong((Long)viewId).booleanValue()) {
                    varIdViewMap.put(varId2, viewId);
                }
            }
            if (builderData.getVarRangeMap().containsKey(varNumber)) {
                Set varRanges = varRangeMap.computeIfAbsent(varId2, t -> Sets.newHashSet());
                varRanges.addAll((Collection)builderData.getVarRangeMap().get(varNumber));
            }
            if (!PeriodLeadUtils.hasPeriodDim((String)dimensionNumber) || (varExtSet = builderData.getVarExtMap().get(variable.getString("number"))) == null) continue;
            Map varExtData = varExtDataMap.computeIfAbsent(varId2, f -> Maps.newHashMap());
            varExtData.put("offset", StringUtils.join(varExtSet, (char)';'));
        }
        if (!dimVarIds.isEmpty()) {
            for (Map.Entry varEntry : dimVarIds.entrySet()) {
                Dimension dimension = (Dimension)dimensionMap.get(varEntry.getKey());
                if (dimension == null) continue;
                MemberQuoteDao quote = new MemberQuoteDao(modelId, Long.valueOf(0L), dimension.getId(), (Collection)varEntry.getValue(), MemberQuoteResourceEnum.Template, resourceId, (Map)varRangeMap);
                quote.setMemberType(MemberTypeEnum.VARIABLE);
                ((Set)varEntry.getValue()).forEach(varId -> {
                    Long cfr_ignored_0 = (Long)quote.getMemberViewMap().put(varId, varIdViewMap.get(varId));
                });
                if (PeriodLeadUtils.hasPeriodDim((String)dimension.getNumber()) && !varExtDataMap.isEmpty()) {
                    quote.setExtInfo((Map)varExtDataMap);
                }
                quotes.add(quote);
            }
        }
        return quotes;
    }

    private void buildProperty(IDimension dimension, Collection<IDimensionMember> members, IModelCacheHelper modelCache, QuoteBuilderData builderData) {
        if (dimension == null || members == null || members.isEmpty()) {
            return;
        }
        for (IDimensionMember member : members) {
            Dimension _dimension;
            if (!RangeF7PropertyCataEnum.Property.getIndex().equals(member.getType()) || (_dimension = IDUtils.isNull((Long)dimension.getId()) ? modelCache.getDimension(dimension.getNumber()) : modelCache.getDimension(dimension.getId())) == null) continue;
            Set propertyNumbers = builderData.getPropertyValueMap().computeIfAbsent(_dimension.getId(), f -> Sets.newLinkedHashSet());
            propertyNumbers.add(member.getLongNumber());
        }
    }

    private List<MemberQuoteDao> buildPropertyQuote(Long modelId, Long resourceId, IModelCacheHelper modelCache, QuoteBuilderData builderData) {
        if (IDUtils.isNull((Long)modelId) || modelCache == null || builderData == null || builderData.getPropertyMap().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<MemberQuoteDao> quotes = new ArrayList<MemberQuoteDao>();
        HashSet propertyNumbers = new HashSet();
        builderData.getPropertyMap().values().forEach(propertyNumbers::addAll);
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", (Object)modelId);
        builder.add("number", "in", propertyNumbers);
        Map properties = BusinessDataServiceHelper.loadFromCache((String)"eb_customproperty", (String)"id,dimension.id,number", (QFilter[])builder.toArray());
        HashMap propertyMap = Maps.newHashMapWithExpectedSize((int)builderData.getPropertyMap().size());
        properties.values().forEach(p -> {
            Set _propertyIds = propertyMap.computeIfAbsent(p.getLong("dimension.id"), f -> new HashSet());
            _propertyIds.add(p.getLong("id"));
        });
        for (Map.Entry<Long, Set<String>> dimProperty : builderData.getPropertyMap().entrySet()) {
            Set propertyIds;
            Dimension dimension = modelCache.getDimension(dimProperty.getKey());
            if (dimension == null || (propertyIds = (Set)propertyMap.get(dimension.getId())).isEmpty()) continue;
            quotes.add(new MemberQuoteDao(modelId, Long.valueOf(0L), dimProperty.getKey(), (Collection)propertyIds, MemberTypeEnum.ATTRIBUTE, MemberQuoteResourceEnum.Template, resourceId));
        }
        return quotes;
    }

    private List<MemberQuoteDao> buildPropertyValueQuote(Long modelId, Long resourceId, IModelCacheHelper modelCache, QuoteBuilderData builderData) {
        if (IDUtils.isNull((Long)modelId) || modelCache == null || builderData == null || builderData.getPropertyValueMap().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<MemberQuoteDao> quotes = new ArrayList<MemberQuoteDao>();
        MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)modelId);
        for (Map.Entry<Long, Set<String>> dimProperty : builderData.getPropertyValueMap().entrySet()) {
            Set propValueIds;
            List propertyValues = memberPropCache.getPropertyValuesByDim(dimProperty.getKey());
            if (propertyValues == null || propertyValues.isEmpty() || (propValueIds = propertyValues.stream().filter(e -> ((Set)dimProperty.getValue()).contains(e.getProp().getNumber() + "!" + e.getNumber())).map(CustomPropertyValue::getId).collect(Collectors.toSet())).isEmpty()) continue;
            quotes.add(new MemberQuoteDao(modelId, Long.valueOf(0L), dimProperty.getKey(), propValueIds, MemberTypeEnum.ATTRIBUTEVALUE, MemberQuoteResourceEnum.Template, resourceId));
        }
        return quotes;
    }

    private List<MemberQuoteDao> buildView(Long modelId, Long datasetId, Map<String, Long> viewIds, Long resourceId, IModelCacheHelper modelCache) {
        if (IDUtils.isNull((Long)modelId) || viewIds == null || viewIds.isEmpty() || IDUtils.isNull((Long)resourceId) || modelCache == null) {
            return Collections.emptyList();
        }
        ArrayList quotes = Lists.newArrayListWithExpectedSize((int)viewIds.size());
        Map dimensionMap = modelCache.getDimensionMap();
        for (Map.Entry<String, Long> view : viewIds.entrySet()) {
            Dimension dimension;
            String dimensionNumber = view.getKey();
            if (dimensionNumber.indexOf(95) >= 0) {
                dimensionNumber = dimensionNumber.split("_")[0];
            }
            if ((dimension = (Dimension)dimensionMap.get(dimensionNumber)) == null) continue;
            MemberQuoteDao quote = new MemberQuoteDao(modelId, datasetId, dimension.getId(), view.getValue(), MemberQuoteResourceEnum.Template, resourceId);
            quote.setMemberType(MemberTypeEnum.VIEW);
            quotes.add(quote);
        }
        return quotes;
    }

    public static class QuoteBuilderData {
        private final Map<String, MemberQuoteDao> quotesMap = Maps.newHashMapWithExpectedSize((int)64);
        private final Map<String, Set<String>> varNumberMap = Maps.newHashMapWithExpectedSize((int)32);
        private final Map<String, Long> varViewMap = Maps.newHashMapWithExpectedSize((int)32);
        private final Map<String, Set<Integer>> varRangeMap = Maps.newHashMapWithExpectedSize((int)64);
        private final Map<String, Set<String>> varExtMap = Maps.newHashMapWithExpectedSize((int)32);
        private final Map<Long, Set<String>> propertyValueMap = Maps.newHashMapWithExpectedSize((int)32);
        private final Map<Long, Set<String>> propertyMap = Maps.newHashMapWithExpectedSize((int)32);

        public Map<String, MemberQuoteDao> getQuotesMap() {
            return this.quotesMap;
        }

        public Map<String, Set<String>> getVarNumberMap() {
            return this.varNumberMap;
        }

        public Map<String, Long> getVarViewMap() {
            return this.varViewMap;
        }

        public Map<String, Set<Integer>> getVarRangeMap() {
            return this.varRangeMap;
        }

        public Map<String, Set<String>> getVarExtMap() {
            return this.varExtMap;
        }

        public Map<Long, Set<String>> getPropertyValueMap() {
            return this.propertyValueMap;
        }

        public Map<Long, Set<String>> getPropertyMap() {
            return this.propertyMap;
        }
    }
}

