/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.rejectbill;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.epm.eb.business.applybill.util.ApplyTemplateUtils;
import kd.epm.eb.business.centralapproval.ApproveBillUtil;
import kd.epm.eb.business.centralapproval.ApproveRecordUtil;
import kd.epm.eb.business.centralapproval.CentralAppBillService;
import kd.epm.eb.business.rejectbill.constant.RejectStatusEnum;
import kd.epm.eb.business.rejectbill.entity.RejectBill;
import kd.epm.eb.business.rejectbill.entity.RejectInfo;
import kd.epm.eb.business.rejectbill.entity.RejectLog;
import kd.epm.eb.business.rejectbill.entity.RejectLogDetail;
import kd.epm.eb.business.rejectbill.entity.RejectUserDto;
import kd.epm.eb.common.applybill.ApplyBillConstant;
import kd.epm.eb.common.applybill.EntityRowDataType;
import kd.epm.eb.common.applytemplatecolumn.BaseColumn;
import kd.epm.eb.common.applytemplatecolumn.CalculateColumn;
import kd.epm.eb.common.applytemplatecolumn.ColumnList;
import kd.epm.eb.common.applytemplatecolumn.DimensionDataColumn;
import kd.epm.eb.common.applytemplatecolumn.EntryTemplateConfig;
import kd.epm.eb.common.applytemplatecolumn.FixedValueColumn;
import kd.epm.eb.common.applytemplatecolumn.MeasureColumn;
import kd.epm.eb.common.applytemplatecolumn.NumberColumn;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.centralapproval.AdjustRecordColInfo;
import kd.epm.eb.common.centralapproval.AppAdjustRecord;
import kd.epm.eb.common.centralapproval.AppBillStatusEnum;
import kd.epm.eb.common.centralapproval.ApproveBill;
import kd.epm.eb.common.centralapproval.ApproveBillConfig;
import kd.epm.eb.common.centralapproval.ApproveRecord;
import kd.epm.eb.common.centralapproval.ApproveRecordEntry;
import kd.epm.eb.common.centralapproval.CentralAppChain;
import kd.epm.eb.common.ebcommon.common.util.ThrowableHelper;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.Builder;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogSignHelper;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;

public class RejectBillService {
    private static final Log log = LogFactory.getLog(RejectBillService.class);
    private Map<Long, String> userMap = Maps.newLinkedHashMap();

    public static RejectBillService getInstance() {
        return InnerClass.instance;
    }

    private RejectBillService() {
    }

    public String getBhNumber(String spNumber) {
        String bhNumber = org.apache.commons.lang3.StringUtils.replace((String)spNumber, (String)"SP", (String)"BH") + "_";
        QFilter qf = new QFilter("billnumber", "like", (Object)(bhNumber + "%"));
        DynamicObjectCollection list = QueryServiceHelper.query((String)"eb_bgapplybill", (String)"billnumber", (QFilter[])qf.toArray());
        if (list.isEmpty()) {
            bhNumber = bhNumber + "01";
        } else {
            Integer max = list.stream().map(e -> {
                String number = e.getString("billnumber");
                String last = org.apache.commons.lang3.StringUtils.substringAfterLast((String)number, (String)"_");
                return Integer.parseInt(last);
            }).max(Integer::compareTo).get();
            if (max < 9) {
                max = max + 1;
                bhNumber = bhNumber + "0" + max;
            } else {
                max = max + 1;
                bhNumber = bhNumber + max;
            }
        }
        return bhNumber;
    }

    public String getNextBhNumber(String bhNumber) {
        String last = org.apache.commons.lang3.StringUtils.substringAfterLast((String)bhNumber, (String)"_");
        int curNumber = Integer.parseInt(last);
        int next = curNumber + 1;
        String nextStr = next + "";
        if (next < 10) {
            nextStr = "0" + next;
        }
        String pre = org.apache.commons.lang3.StringUtils.substringBeforeLast((String)bhNumber, (String)"_");
        return pre + "_" + nextStr;
    }

    public RejectBill getRejectBill(String bhNumber, Long modelId) {
        RejectBill rejectBill = new RejectBill();
        QFilter filter = new QFilter("billnumber", "=", (Object)bhNumber);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"eb_bgapplybill", (QFilter[])filter.toArray());
        rejectBill.setId(dynamicObject.getLong("id"));
        Date createdate = dynamicObject.getDate("createdate");
        Date modifydate = dynamicObject.getDate("modifydate");
        Long creater = dynamicObject.getLong("creater.id");
        Long modifier = dynamicObject.getLong("modifier.id");
        rejectBill.setCreateDate(createdate);
        rejectBill.setCreator(creater);
        rejectBill.setModifier(modifier);
        rejectBill.setModifyDate(modifydate);
        return rejectBill;
    }

    public List<RejectLog> listRejectLogBySpnumber(String spNumber) {
        QFilter qf = new QFilter("spbillnumber", "=", (Object)spNumber);
        List<RejectLog> rejectLogs = RejectBillService.getRejectLogs(qf);
        return rejectLogs;
    }

    public List<RejectLog> listRejectLogBySpnumber(String spNumber, Long templateId) {
        QFilter qf = new QFilter("spbillnumber", "=", (Object)spNumber);
        qf.and("templateid", "=", (Object)templateId);
        List<RejectLog> rejectLogs = RejectBillService.getRejectLogs(qf);
        return rejectLogs;
    }

    public Set<String> getBhNumbersBySpNumber(String spNumber) {
        HashSet<String> result = new HashSet<String>(16);
        QFilter qf = new QFilter("spbillnumber", "=", (Object)spNumber);
        List<RejectLog> rejectLogs = RejectBillService.getRejectLogs(qf);
        for (RejectLog rejectLog : rejectLogs) {
            String bhbillNumber = rejectLog.getBhbillNumber();
            result.add(bhbillNumber);
        }
        return result;
    }

    public Map<String, Set<String>> getBhNumbersBySpNumbers(Set<String> spNumbers) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>(16);
        QFilter qf = new QFilter("spbillnumber", "in", spNumbers);
        List<RejectLog> rejectLogs = RejectBillService.getRejectLogs(qf);
        for (RejectLog rejectLog : rejectLogs) {
            String bhbillNumber = rejectLog.getBhbillNumber();
            String spbillNumber = rejectLog.getSpbillNumber();
            Set numbers = result.computeIfAbsent(spbillNumber, t -> new HashSet(16));
            numbers.add(bhbillNumber);
        }
        return result;
    }

    private static List<RejectLog> getRejectLogs(QFilter qf) {
        String fields = "id,spbillnumber,bhbillnumber,templateid,datajson,afterdatajson,summarydatajson,rejectstatus,rejecttxt,rejectuser,modifyrowdatajson,aftermodifyrowdatajson,creater,createdate";
        DynamicObjectCollection list = QueryServiceHelper.query((String)"eb_billrejectlog", (String)fields, (QFilter[])qf.toArray());
        ArrayList<RejectLog> logs = new ArrayList<RejectLog>(list.size());
        for (DynamicObject dy : list) {
            RejectLog log = (RejectLog)Builder.of(RejectLog::new).with(RejectLog::setId, (Object)dy.getLong("id")).with(RejectLog::setSpbillNumber, (Object)dy.getString("spbillnumber")).with(RejectLog::setBhbillNumber, (Object)dy.getString("bhbillnumber")).with(RejectLog::setTemplateId, (Object)dy.getLong("templateid")).with(RejectLog::setDataJson, (Object)dy.getString("datajson")).with(RejectLog::setAfterDataJson, (Object)dy.getString("afterdatajson")).with(RejectLog::setSummaryDataJson, (Object)dy.getString("summarydatajson")).with(RejectLog::setRejectStatus, (Object)dy.getString("rejectstatus")).with(RejectLog::setRejectTxt, (Object)dy.getString("rejecttxt")).with(RejectLog::setRejectuser, (Object)dy.getLong("rejectuser")).with(RejectLog::setModifyrowdatajson, (Object)dy.getString("modifyrowdatajson")).with(RejectLog::setAftermodifyrowdatajson, (Object)dy.getString("aftermodifyrowdatajson")).with(RejectLog::setCreator, (Object)dy.getLong("creater")).with(RejectLog::setCreatedate, (Object)dy.getDate("createdate")).build();
            logs.add(log);
        }
        return logs;
    }

    public Object[] buildOldRowData(Object[] newRowData, Object[] oldRowData, List<BaseColumn> baseColumns, boolean isAdd) {
        List bigDecimalKeys = baseColumns.stream().filter(t -> t instanceof MeasureColumn || t instanceof CalculateColumn || t instanceof FixedValueColumn || t instanceof NumberColumn).map(BaseColumn::getKey).collect(Collectors.toList());
        newRowData = this.setRowDataToMap(newRowData, baseColumns);
        oldRowData = this.setRowDataToMap(oldRowData, baseColumns);
        Object[] beforeAdjData = new Object[newRowData.length];
        for (int i = 0; i < oldRowData.length; ++i) {
            Object oldData = oldRowData[i];
            if (!(oldData instanceof Map)) {
                beforeAdjData[i] = oldData;
                continue;
            }
            Map oldDataValueMap = (Map)oldData;
            String oldKey = "";
            for (BaseColumn baseColumn : baseColumns) {
                Object o;
                String key = baseColumn.getKey();
                if (!bigDecimalKeys.contains(key) || (o = oldDataValueMap.get(key)) == null) continue;
                oldKey = key;
                break;
            }
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)oldKey)) {
                beforeAdjData[i] = oldData;
                continue;
            }
            Object oldVal = oldDataValueMap.get(oldKey);
            for (Object newData : newRowData) {
                Map newDataValueMap;
                Object newVal;
                if (!(newData instanceof Map) || (newVal = (newDataValueMap = (Map)newData).get(oldKey)) == null) continue;
                Map<String, String> map = new HashMap<String, String>(16);
                try {
                    BigDecimal val = isAdd ? new BigDecimal(newVal.toString()).add(new BigDecimal(oldVal.toString())) : new BigDecimal(newVal.toString()).subtract(new BigDecimal(oldVal.toString()));
                    String format = String.format("%.2f", val);
                    map.put(oldKey, format);
                }
                catch (Exception exception) {
                    log.error((Throwable)exception);
                    log.info("newVal:" + newVal);
                    log.info("oldVal:" + oldVal);
                    map = oldDataValueMap;
                }
                beforeAdjData[i] = map;
                break;
            }
            if (beforeAdjData[i] != null) continue;
            beforeAdjData[i] = oldData;
        }
        return beforeAdjData;
    }

    public boolean isBigDecimalCol(BaseColumn column) {
        return column instanceof MeasureColumn || column instanceof DimensionDataColumn || column instanceof CalculateColumn || column instanceof NumberColumn || column instanceof FixedValueColumn;
    }

    public Set<String> getBigDecimalKeys(List<BaseColumn> cols) {
        HashSet<String> result = new HashSet<String>(16);
        for (BaseColumn col : cols) {
            if (!this.isBigDecimalCol(col)) continue;
            result.add(col.getKey());
        }
        return result;
    }

    public boolean isDataJsonChildData(Object[] dataJson, Object[] modifyRowData, List<BaseColumn> baseColumns, IModelCacheHelper modelCacheHelper, Map<String, Long> dimViewMap) {
        Map valueMap;
        Object memberId;
        String key;
        String baseEntityId;
        HashMap<String, Set> allMemberMap = new HashMap<String, Set>(16);
        block0: for (Object o : dataJson) {
            if (!(o instanceof Map)) continue;
            for (BaseColumn baseColumn : baseColumns) {
                baseEntityId = baseColumn.getBaseEntityId();
                key = baseColumn.getKey();
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)baseEntityId) || !((memberId = (valueMap = (Map)o).get(key)) instanceof Long)) continue;
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache(memberId, (String)baseEntityId);
                String dimNum = dynamicObject.getDynamicObject("dimension").getString("number");
                String memberNum = dynamicObject.getString("number");
                List member = modelCacheHelper.getMember(dimNum, dimViewMap.get(dimNum), memberNum, RangeEnum.ALL.getIndex());
                Set memberIdSet = member.stream().map(BaseCache::getId).collect(Collectors.toSet());
                memberIdSet.add(IDUtils.toLong(memberId));
                Set sets = allMemberMap.computeIfAbsent(baseEntityId, t -> new HashSet(16));
                sets.addAll(memberIdSet);
                continue block0;
            }
        }
        block2: for (Object o : modifyRowData) {
            if (!(o instanceof Map)) continue;
            for (BaseColumn baseColumn : baseColumns) {
                baseEntityId = baseColumn.getBaseEntityId();
                key = baseColumn.getKey();
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)baseEntityId)) continue;
                valueMap = (Map)o;
                memberId = valueMap.get(key);
                Set ids = (Set)allMemberMap.get(baseEntityId);
                if (!(memberId instanceof Long)) continue;
                if (ids.contains(IDUtils.toLong(memberId))) continue block2;
                return false;
            }
        }
        return true;
    }

    public List<RejectLog> getRejectLogsByFilter(QFilter qf) {
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"eb_billrejectlog", (String)"id, model, spbillnumber, bhbillnumber, templateid, datajson, summarydatajson, afterdatajson, modifyrowdatajson, aftermodifyrowdatajson, rejectstatus, rejecttxt, rejectuser, creater, createdate,entryentity, entryentity.fmodifyrowdatajson, entryentity.fmodifyrowdatajsonnew, entryentity.faftermodifyrowdatajson, isupdate", (QFilter[])qf.toArray());
        ArrayList<RejectLog> logs = new ArrayList<RejectLog>(16);
        for (DynamicObject value : load) {
            RejectLog rejectLog = new RejectLog();
            rejectLog.setId(value.getLong("id"));
            rejectLog.setSpbillNumber(value.getString("spbillnumber"));
            rejectLog.setBhbillNumber(value.getString("bhbillnumber"));
            rejectLog.setTemplateId(value.getLong("templateid"));
            rejectLog.setDataJson(value.getString("datajson"));
            rejectLog.setRejectStatus(value.getString("rejectstatus"));
            rejectLog.setRejectuser(value.getLong("rejectuser.id"));
            rejectLog.setCreatedate(value.getDate("createdate"));
            rejectLog.setCreator(value.getLong("creater.id"));
            DynamicObjectCollection entryentity = value.getDynamicObjectCollection("entryentity");
            if (org.apache.commons.collections4.CollectionUtils.isNotEmpty((Collection)entryentity)) {
                for (DynamicObject dynamicObject : entryentity) {
                    String fmodifyrowdatajson = dynamicObject.getString("fmodifyrowdatajson");
                    String fmodifyrowdatajsonnew = dynamicObject.getString("fmodifyrowdatajsonnew");
                    String faftermodifyrowdatajson = dynamicObject.getString("faftermodifyrowdatajson");
                    String isupdate = dynamicObject.getString("isupdate");
                    RejectLogDetail rejectLogDetail = new RejectLogDetail();
                    rejectLogDetail.setFmodifyrowdatajson(fmodifyrowdatajson);
                    rejectLogDetail.setFmodifyrowdatajsonnew(fmodifyrowdatajsonnew);
                    rejectLogDetail.setFaftermodifyrowdatajson(faftermodifyrowdatajson);
                    rejectLogDetail.setIsUpdate(isupdate);
                    rejectLog.addRejectLogDetail(rejectLogDetail);
                }
            }
            logs.add(rejectLog);
        }
        return logs;
    }

    public String getRejectStatusTxtByRowDimKey(String rowDimKeys, EntryTemplateConfig entryTemplateConfig, List<RejectLog> allLog) {
        boolean flag;
        List<String> ids;
        String[] split;
        String[] rowDimMemberIds = rowDimKeys.split(",");
        List rejectLogs = allLog.stream().filter(e -> RejectStatusEnum.reject.getCode().equals(e.getRejectStatus())).collect(Collectors.toList());
        List<Object[]> rejectLogArrayList = rejectLogs.stream().map(e -> JSON.parseArray((String)e.getDataJson(), Object.class)).map(List::toArray).collect(Collectors.toList());
        List<String> rejectDimKeyList = this.getDimKeyByData(rejectLogArrayList, entryTemplateConfig);
        List handleLog = allLog.stream().filter(e -> RejectStatusEnum.handled.getCode().equals(e.getRejectStatus())).collect(Collectors.toList());
        List<Object[]> handleLogArrayList = handleLog.stream().map(e -> JSON.parseArray((String)e.getDataJson(), Object.class)).map(List::toArray).collect(Collectors.toList());
        List<String> handleDimKeyList = this.getDimKeyByData(handleLogArrayList, entryTemplateConfig);
        for (String s : rejectDimKeyList) {
            split = s.split(",");
            ids = Arrays.asList(split);
            flag = true;
            for (String rowDimMemberId : rowDimMemberIds) {
                if (ids.contains(rowDimMemberId)) continue;
                flag = false;
                break;
            }
            if (!flag) continue;
            return RejectStatusEnum.reject.getDesc();
        }
        for (String s : handleDimKeyList) {
            split = s.split(",");
            ids = Arrays.asList(split);
            flag = true;
            for (String rowDimMemberId : rowDimMemberIds) {
                if (ids.contains(rowDimMemberId)) continue;
                flag = false;
                break;
            }
            if (!flag) continue;
            return RejectStatusEnum.handled.getDesc();
        }
        return "";
    }

    public Map<String, Set<String>> getAllDimChildCombination(EntryTemplateConfig entryTemplateConfig, List<RejectLog> allLog, IModelCacheHelper modelCacheHelper) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>(16);
        Set reject = result.computeIfAbsent("reject", t -> new HashSet(16));
        Set handle = result.computeIfAbsent("handle", t -> new HashSet(16));
        List rejectLogs = allLog.stream().filter(e -> RejectStatusEnum.reject.getCode().equals(e.getRejectStatus())).collect(Collectors.toList());
        List rejectLogArrayList = rejectLogs.stream().map(e -> JSON.parseArray((String)e.getDataJson(), Object.class)).map(List::toArray).collect(Collectors.toList());
        for (Object[] row : rejectLogArrayList) {
            reject.addAll(this.getAllDimKeyByData(row, entryTemplateConfig, modelCacheHelper));
        }
        List handleLog = allLog.stream().filter(e -> RejectStatusEnum.handled.getCode().equals(e.getRejectStatus())).collect(Collectors.toList());
        List handleLogArrayList = handleLog.stream().map(e -> JSON.parseArray((String)e.getDataJson(), Object.class)).map(List::toArray).collect(Collectors.toList());
        for (Object[] row : handleLogArrayList) {
            handle.addAll(this.getAllDimKeyByData(row, entryTemplateConfig, modelCacheHelper));
        }
        return result;
    }

    public List<String> getDimKeyByData(List<Object[]> modifyData, EntryTemplateConfig entryTemplateConfig) {
        ArrayList<String> dimKeyList = new ArrayList<String>(10);
        for (Object[] row : modifyData) {
            String dimKey = this.getDimKeyByData(row, entryTemplateConfig);
            dimKeyList.add(dimKey);
        }
        return dimKeyList;
    }

    public String getDimKeyByData(Object[] rowData, EntryTemplateConfig templateConfig) {
        List<BaseColumn> mainColumns = templateConfig.getEntryColumns().stream().filter(ee -> !ee.getKey().endsWith("_text")).collect(Collectors.toList());
        List dimKeysList = templateConfig.getDimKeysList();
        Object[] objects = this.setRowDataToMap(rowData, mainColumns);
        ArrayList<Long> dimMemberIdList = new ArrayList<Long>(10);
        for (BaseColumn column : mainColumns) {
            if (!dimKeysList.contains(column.getKey())) continue;
            Object value = this.getValueFromRowDataArray(objects, column.getKey());
            dimMemberIdList.add((Long)value);
        }
        return org.apache.commons.lang3.StringUtils.join(dimMemberIdList, (String)",");
    }

    public Set<String> getAllDimKeyByData(Object[] rowData, EntryTemplateConfig templateConfig, IModelCacheHelper modelCacheHelper) {
        HashSet<String> result = new HashSet<String>(16);
        Map dimViewMap = modelCacheHelper.getViewsByDataSet(Long.valueOf(templateConfig.getDatasetId()));
        List<BaseColumn> mainColumns = templateConfig.getEntryColumns().stream().filter(ee -> !ee.getKey().endsWith("_text")).collect(Collectors.toList());
        List dimKeysList = templateConfig.getDimKeysList();
        Object[] objects = this.setRowDataToMap(rowData, mainColumns);
        for (BaseColumn column : mainColumns) {
            String baseEntityId = column.getBaseEntityId();
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)baseEntityId) || !dimKeysList.contains(column.getKey())) continue;
            Object value = this.getValueFromRowDataArray(objects, column.getKey());
            result.add(value.toString());
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)value, (String)baseEntityId);
            if (dynamicObject == null) continue;
            String dimNum = dynamicObject.getString("dimension.number");
            String memberNum = dynamicObject.getString("number");
            List member = modelCacheHelper.getMember(dimNum, (Long)dimViewMap.get(dimNum), memberNum, RangeEnum.ALL.getIndex());
            result.addAll(member.stream().map(t -> t.getId() + "").collect(Collectors.toSet()));
        }
        return result;
    }

    public Object[] changeRowMapValueByUnit(Object[] rowData, String unitData, List<BaseColumn> baseColumns, Set<String> currencyColumnKeys, boolean isDivide) {
        rowData = this.setRowDataToMap(rowData, baseColumns);
        BigDecimal unit = this.getUnitData(unitData);
        unit = isDivide ? BigDecimal.ONE.divide(unit) : BigDecimal.ONE.multiply(unit);
        block0: for (int i = 0; i < rowData.length; ++i) {
            Object o = rowData[i];
            if (!(o instanceof Map)) continue;
            Iterator<BaseColumn> iterator = baseColumns.iterator();
            while (iterator.hasNext()) {
                Map valMap = (Map)o;
                BaseColumn baseColumn = iterator.next();
                String key = baseColumn.getKey();
                Object o1 = valMap.get(key);
                if (o1 == null || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)o1.toString()) || !(o1 instanceof BigDecimal) || !currencyColumnKeys.contains(key)) continue;
                valMap.put(key, this.changeValByUnit(o1, unit));
                rowData[i] = valMap;
                continue block0;
            }
        }
        return rowData;
    }

    public BigDecimal changeValueToBigDecimal(List<BaseColumn> baseColumns, String key, Object value) {
        BaseColumn baseColumn = baseColumns.stream().filter(t -> t.getKey().equals(key)).findFirst().get();
        if (baseColumn instanceof MeasureColumn || baseColumn instanceof CalculateColumn || baseColumn instanceof NumberColumn || baseColumn instanceof FixedValueColumn) {
            try {
                return new BigDecimal(value.toString());
            }
            catch (Exception exception) {
                log.error(this.getClass().getName() + ":changeValueToBigDecimal:exception:" + ThrowableHelper.toString((Exception)exception));
                log.error(this.getClass().getName() + ":changeValueToBigDecimal:value:" + SerializationUtils.toJsonString((Object)value));
            }
        }
        return BigDecimal.ZERO;
    }

    private BigDecimal getUnitData(String unitStr) {
        int unit = this.getUnit(unitStr);
        return BigDecimal.TEN.pow(unit);
    }

    private int getUnit(String val) {
        int unit = 0;
        switch (val) {
            case "1": {
                unit = 0;
                break;
            }
            case "2": {
                unit = 3;
                break;
            }
            case "3": {
                unit = 4;
                break;
            }
            case "4": {
                unit = 5;
                break;
            }
            case "5": {
                unit = 6;
                break;
            }
            case "6": {
                unit = 7;
                break;
            }
            case "7": {
                unit = 8;
            }
        }
        return unit;
    }

    public Object getValueFromRowDataArray(Object[] rowData, String key) {
        for (Object data : rowData) {
            Map map;
            Object o;
            if (!(data instanceof Map) || (o = (map = (Map)data).get(key)) == null) continue;
            return o;
        }
        return null;
    }

    public void copyColValue(Object[] srcRowData, Object[] desRowData, List<BaseColumn> baseColumns) {
        for (BaseColumn baseColumn : baseColumns) {
            String key = baseColumn.getKey();
            int index1 = this.getColIndexFromRowDataByKey(srcRowData, key);
            int index2 = this.getColIndexFromRowDataByKey(desRowData, key);
            if (index1 == -1 || index2 == -1) continue;
            desRowData[index2] = srcRowData[index1];
        }
    }

    public int getColIndexFromRowDataByKey(Object[] rowData, String key) {
        int result = -1;
        for (int i = 0; i < rowData.length; ++i) {
            Map map;
            Object o;
            Object data = rowData[i];
            if (!(data instanceof Map) || (o = (map = (Map)data).get(key)) == null) continue;
            result = i;
            break;
        }
        return result;
    }

    public boolean compareTowRowDataDim(Object[] objects1, Object[] objects2, List<String> dimKeysList) {
        Object memberId;
        String dimKey;
        Map map;
        Iterator<String> iterator;
        if (objects1.length != objects2.length) {
            return false;
        }
        HashSet<Long> memberIds = new HashSet<Long>(16);
        block0: for (Object o : objects1) {
            if (!(o instanceof Map)) continue;
            iterator = dimKeysList.iterator();
            while (iterator.hasNext()) {
                map = (Map)o;
                dimKey = iterator.next();
                memberId = map.get(dimKey);
                if (!(memberId instanceof Long)) continue;
                memberIds.add(IDUtils.toLong(memberId));
                continue block0;
            }
        }
        block2: for (Object o : objects2) {
            if (!(o instanceof Map)) continue;
            iterator = dimKeysList.iterator();
            while (iterator.hasNext()) {
                map = (Map)o;
                dimKey = iterator.next();
                memberId = map.get(dimKey);
                if (!(memberId instanceof Long)) continue;
                if (memberIds.contains(IDUtils.toLong(memberId))) continue block2;
                return false;
            }
        }
        return true;
    }

    public Object[] setRowDataToMap(Object[] rowData, List<BaseColumn> baseColumns) {
        Object[] newRowData = new Object[rowData.length];
        int fixLen = ApplyBillConstant.fixEntityTableKey.length;
        for (int i = 0; i < rowData.length; ++i) {
            Object data = rowData[i];
            if (i < fixLen || data instanceof Map) {
                newRowData[i] = rowData[i];
                continue;
            }
            HashMap<String, Object> map = new HashMap<String, Object>(4);
            if (i - fixLen >= baseColumns.size()) continue;
            BaseColumn baseColumn = baseColumns.get(i - fixLen);
            map.put(baseColumn.getKey(), data);
            newRowData[i] = map;
        }
        return newRowData;
    }

    private Object changeValByUnit(Object oldVal, BigDecimal unit) {
        if (oldVal instanceof BigDecimal) {
            if (oldVal == BigDecimal.ZERO) {
                return new BigDecimal(String.format("%.2f", oldVal));
            }
            oldVal = ((BigDecimal)oldVal).multiply(unit);
        }
        return new BigDecimal(String.format("%.2f", oldVal));
    }

    public List<RejectUserDto> getRejectUserList(String billNo, List<Map<String, String>> rejectDataList, List<Map<String, String>> rejectDataAllLowLevelList, Long modelId, Long datasetId, EntryTemplateConfig entryTemplateConfig) {
        ArrayList<RejectUserDto> result = new ArrayList<RejectUserDto>(16);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        ArrayList<Map<String, String>> all = new ArrayList<Map<String, String>>(16);
        all.addAll(rejectDataList);
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(rejectDataAllLowLevelList)) {
            all.addAll(rejectDataAllLowLevelList);
        }
        List<RejectUserDto> rejectUserListFromAuditRecord = this.getRejectUserListFromAuditRecord(billNo, all, modelId, modelCacheHelper, entryTemplateConfig);
        result.addAll(rejectUserListFromAuditRecord);
        HashMap<String, RejectUserDto> resultMap = new HashMap<String, RejectUserDto>(16);
        for (RejectUserDto rejectUserDto : result) {
            Long userId = rejectUserDto.getUserId();
            String approveNodeName = rejectUserDto.getApproveNodeName();
            String key = userId + "#" + approveNodeName + "#" + rejectUserDto.getBillNo();
            RejectUserDto rejectUserDto1 = (RejectUserDto)resultMap.get(key);
            if (rejectUserDto1 != null) {
                resultMap.put(key, rejectUserDto1);
                continue;
            }
            resultMap.put(key, rejectUserDto);
        }
        result = new ArrayList(resultMap.values());
        return result;
    }

    public void addLog(String logKey, Object logValue) {
        Set logSignsFromForm = LogSignHelper.getLogSignByGropNum((String)"RejectBillService");
        if (logSignsFromForm.contains(logKey)) {
            CommonServiceHelper.handleLog((Log)log, (String)logKey, (String)SerializationUtils.toJsonString((Object)logValue));
        }
    }

    public List<RejectUserDto> getRejectUserListFromAuditRecord(String billNo, List<Map<String, String>> rejectDataList, Long modelId, IModelCacheHelper modelCacheHelper, EntryTemplateConfig entryTemplateConfig) {
        ArrayList<RejectUserDto> result = new ArrayList<RejectUserDto>(16);
        HashSet<String> billnos = new HashSet<String>(16);
        Set<ApproveRecord> approveRecordSet = ApproveRecordUtil.getInstance().getAllApproveRecord(billNo, modelId, rejectDataList, modelCacheHelper, billnos, entryTemplateConfig);
        QFilter filter = new QFilter("billno", "in", billnos);
        this.addLog("approveRecordSet:", billnos);
        filter.and(new QFilter("model", "=", (Object)modelId));
        DynamicObject[] centralbills = BusinessDataServiceHelper.load((String)"eb_centralappbill", (String)"id,parentid,billno,creater,centralapprptentity,centralapprptentity.centralentity,centralapprptentity.sumbillno,centralapprptentity.reportbillno,createdate,modifydate", (QFilter[])filter.toArray(), (String)"createdate asc");
        if (centralbills != null && centralbills.length > 0) {
            for (DynamicObject centralbill : centralbills) {
                RejectUserDto rejectUserDto1 = new RejectUserDto();
                String info = ResManager.loadKDString((String)"\u7533\u62a5\u5355\u63d0\u4ea4", (String)"RejectBillService_1", (String)"epm-eb-business", (Object[])new Object[0]);
                long parentid = centralbill.getLong("parentid");
                String spbillno = centralbill.getString("billno");
                rejectUserDto1.setBillNo(spbillno);
                rejectUserDto1.setApproveDate(centralbill.getDate("createdate"));
                if (parentid > 0L) {
                    DynamicObject entry;
                    long centralentity;
                    DynamicObjectCollection centralapprptentity;
                    DynamicObject data = BusinessDataServiceHelper.loadSingleFromCache((Object)parentid, (String)"eb_centralappbill");
                    if (data != null && (centralapprptentity = data.getDynamicObjectCollection("centralapprptentity")) != null && !centralapprptentity.isEmpty() && (centralentity = (entry = (DynamicObject)centralapprptentity.get(0)).getLong("centralentity.id")) > 0L) {
                        info = ResManager.loadKDString((String)"\u6c47\u603b\u5355\u63d0\u4ea4", (String)"RejectBillService_2", (String)"epm-eb-business", (Object[])new Object[0]);
                    }
                } else {
                    DynamicObject entry;
                    long centralentity;
                    DynamicObjectCollection centralapprptentity = centralbill.getDynamicObjectCollection("centralapprptentity");
                    if (centralapprptentity != null && !centralapprptentity.isEmpty() && (centralentity = (entry = (DynamicObject)centralapprptentity.get(0)).getLong("centralentity.id")) > 0L) {
                        info = ResManager.loadKDString((String)"\u6c47\u603b\u5355\u63d0\u4ea4", (String)"RejectBillService_2", (String)"epm-eb-business", (Object[])new Object[0]);
                    }
                }
                rejectUserDto1.setApproveNodeName(info);
                rejectUserDto1.setUserId(centralbill.getLong("creater.id"));
                rejectUserDto1.setBillNo(centralbill.getString("billno"));
                Long org = UserServiceHelper.getUserMainOrgId((long)centralbill.getLong("creater.id"));
                DynamicObject bosOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)org, (String)"bos_org");
                if (bosOrg != null) {
                    String name = bosOrg.getString("name");
                    rejectUserDto1.setApproveOrg(name);
                }
                result.add(rejectUserDto1);
            }
        }
        this.addLog("billno:", billNo);
        this.addLog("approveRecordSet:", approveRecordSet);
        for (ApproveRecord approveRecord : approveRecordSet) {
            String recordBillNo = approveRecord.getBillNo();
            List approveRecordEntries = approveRecord.getApproveRecordEntries();
            for (ApproveRecordEntry approveRecordEntry : approveRecordEntries) {
                RejectUserDto rejectUserDto1 = new RejectUserDto();
                rejectUserDto1.setApproveNodeName(approveRecordEntry.getApproveNode());
                rejectUserDto1.setUserId(approveRecordEntry.getApprover());
                rejectUserDto1.setApproveOrg(approveRecordEntry.getAmdinOrgName());
                rejectUserDto1.setBillNo(recordBillNo);
                rejectUserDto1.setApproveDate(approveRecordEntry.getApproveDate());
                result.add(rejectUserDto1);
            }
        }
        this.addLog("result:", result);
        return result;
    }

    public Map<String, Object[]> getOldRowData(RejectLogDetail rejectLogDetail, List<BaseColumn> baseColumns) {
        HashMap<String, Object[]> result = new HashMap<String, Object[]>(16);
        String fmodifyrowdatajson = rejectLogDetail.getFmodifyrowdatajson();
        String fmodifyrowdatajsonnew = rejectLogDetail.getFmodifyrowdatajsonnew();
        String faftermodifyrowdatajson = rejectLogDetail.getFaftermodifyrowdatajson();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)fmodifyrowdatajsonnew)) {
            return result;
        }
        List newRowModifyDataList = (List)SerializationUtils.fromJsonString((String)fmodifyrowdatajsonnew, List.class);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)fmodifyrowdatajson)) {
            List oldRowModifyDataList = (List)SerializationUtils.fromJsonString((String)fmodifyrowdatajson, List.class);
            String dataType = oldRowModifyDataList.get(3).toString();
            if (org.apache.commons.lang3.StringUtils.equals((CharSequence)dataType, (CharSequence)EntityRowDataType.NEW_NOTDETAIL.getNumber()) || org.apache.commons.lang3.StringUtils.equals((CharSequence)dataType, (CharSequence)EntityRowDataType.EDIT_NOTDETAIL.getNumber())) {
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)faftermodifyrowdatajson)) {
                    List afterRowModifyDataList = (List)SerializationUtils.fromJsonString((String)faftermodifyrowdatajson, List.class);
                    Object[] objects1 = this.buildOldRowData(oldRowModifyDataList.toArray(), newRowModifyDataList.toArray(), baseColumns, false);
                    Object[] objects = this.buildOldRowData(afterRowModifyDataList.toArray(), objects1, baseColumns, true);
                    result.put("old", objects);
                    result.put("new", afterRowModifyDataList.toArray());
                }
            } else {
                result.put("old", oldRowModifyDataList.toArray());
                result.put("new", newRowModifyDataList.toArray());
            }
        } else if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)faftermodifyrowdatajson)) {
            List afterRowModifyDataList = (List)SerializationUtils.fromJsonString((String)faftermodifyrowdatajson, List.class);
            Object[] objects = this.buildOldRowData(afterRowModifyDataList.toArray(), newRowModifyDataList.toArray(), baseColumns, false);
            result.put("old", objects);
            result.put("new", afterRowModifyDataList.toArray());
        }
        return result;
    }

    public void deleteRejectDataBySpNumbers(Set<String> spNumbers, Long modelId) {
        QFilter filter = new QFilter("srcbillnumber", "in", spNumbers);
        filter.and("model", "=", (Object)modelId);
        DeleteServiceHelper.delete((String)"eb_bgapplybill", (QFilter[])filter.toArray());
        QFilter filter1 = new QFilter("spbillnumber", "in", spNumbers);
        filter1.and("model", "=", (Object)modelId);
        DeleteServiceHelper.delete((String)"eb_billrejectlog", (QFilter[])filter1.toArray());
    }

    private ApproveBill getApproveByBillno(String billno, long modelId) {
        QFilter qFilter = new QFilter("billno", "=", (Object)billno);
        qFilter.and(new QFilter("model", "=", (Object)modelId));
        ApproveBill bill = ApproveBillUtil.getInstance().getApproveBill(qFilter);
        return bill;
    }

    /*
     * WARNING - void declaration
     */
    public void sendMessageToApproveUsers(String bhbillnumber, String frombillno, String tobillno, long modelId, long approveUser, String rejectNodeName, List<Map<String, String>> rejectDataList) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        log.info("RejectBillService#sendMessageToApproveUsers.bhbillnumber:" + bhbillnumber);
        log.info("RejectBillService#sendMessageToApproveUsers.frombillno:" + frombillno);
        log.info("RejectBillService#sendMessageToApproveUsers.tobillno:" + tobillno);
        log.info("RejectBillService#sendMessageToApproveUsers.rejectNodeName:" + rejectNodeName);
        log.info("RejectBillService#sendMessageToApproveUsers.rejectDataList:" + SerializationUtils.toJsonString(rejectDataList));
        if (frombillno == null || tobillno == null) {
            return;
        }
        List<Long> sendUsers = this.getSendUsers(frombillno, tobillno, modelId, rejectDataList);
        sendUsers.add(approveUser);
        List distinctSendUsers = sendUsers.stream().distinct().collect(Collectors.toList());
        log.info("RejectBillService#sendMessageToApproveUsers.distinctSendUsers:" + SerializationUtils.toJsonString(distinctSendUsers));
        if (distinctSendUsers.isEmpty()) {
            return;
        }
        QFilter filter = new QFilter("rejectbillno", "=", (Object)bhbillnumber);
        List<AppAdjustRecord> appAdjustRecords = ApproveRecordUtil.getInstance().getAppAdjustRecords(filter);
        if (appAdjustRecords != null && !appAdjustRecords.isEmpty()) {
            AppAdjustRecord appAdjustRecord = appAdjustRecords.get(0);
            Long template = appAdjustRecord.getTemplate();
            DynamicObject templateDyn = QueryServiceHelper.queryOne((String)"eb_applytemplate", (String)"id, number, dataset, entrycfgjson_tag", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)template)});
            Map dimViewMap = modelCacheHelper.getViewsByDataSet(Long.valueOf(templateDyn.getLong("dataset")));
            ColumnList columnList = ApplyTemplateUtils.getEntrycfgByApplyTemplate(templateDyn);
            List<BaseColumn> basecolums = columnList.getColumns().stream().filter(s -> s.getCategory().equals("h")).collect(Collectors.toList());
            List columns = basecolums.stream().filter(column -> column instanceof NumberColumn).collect(Collectors.toList());
            List<String> rowDimNumList = ApplyTemplateUtils.getRowDimNumList(basecolums, modelCacheHelper);
            List<String> dimKeysList = ApplyTemplateUtils.getDimKeyList(basecolums);
            Map<String, String> keyMapTitle = basecolums.stream().collect(Collectors.toMap(c -> c.getKey(), c -> c.getTitle()));
            HashMap<String, String> columnNumMapDimTitle = new HashMap<String, String>(16);
            if (rowDimNumList != null) {
                for (int i = 0; i < rowDimNumList.size(); ++i) {
                    columnNumMapDimTitle.put(rowDimNumList.get(i), keyMapTitle.get(dimKeysList.get(i)));
                }
            }
            Map<String, List<AppAdjustRecord>> groupBymember = appAdjustRecords.stream().collect(Collectors.groupingBy(s -> s.getDimMemberMap().values().stream().map(String::valueOf).collect(Collectors.joining(","))));
            RejectInfo rejectInfo = new RejectInfo();
            rejectInfo.setRejectBillNo(bhbillnumber);
            rejectInfo.setApproveBillNo(frombillno);
            rejectInfo.setRejectNodeName(rejectNodeName);
            ArrayList<RejectInfo.RejectRowInfo> rowInfos = new ArrayList<RejectInfo.RejectRowInfo>(16);
            rejectInfo.setRowInfo(rowInfos);
            for (Map.Entry<String, List<AppAdjustRecord>> group : groupBymember.entrySet()) {
                void var39_41;
                String key = group.getKey();
                List<AppAdjustRecord> rows = group.getValue();
                ArrayList colUpdates = new ArrayList(16);
                rows.forEach(s -> {
                    List colDataInfos = s.getColDataInfos();
                    colUpdates.addAll(colDataInfos);
                });
                String[] rowDimStr = key.split(",");
                HashMap<String, String> rowValue = new HashMap<String, String>(16);
                RejectInfo.RejectRowInfo rowInfo = new RejectInfo.RejectRowInfo();
                rowInfo.setRowInfo(rowValue);
                rowInfos.add(rowInfo);
                String[] stringArray = rowDimStr;
                int n = stringArray.length;
                boolean bl = false;
                while (var39_41 < n) {
                    String rowDim = stringArray[var39_41];
                    String[] split = rowDim.split("!");
                    String rdim = split[0];
                    if (rowDimNumList.contains(rdim)) {
                        String value = split[1];
                        Member member = modelCacheHelper.getMember(rdim, (Long)dimViewMap.get(rdim), Long.valueOf(value));
                        rowValue.put((String)columnNumMapDimTitle.get(rdim), member.getName());
                    }
                    ++var39_41;
                }
                ArrayList<RejectInfo.RejectInfoDetail> colValues = new ArrayList<RejectInfo.RejectInfoDetail>(16);
                rowInfo.setColInfos(colValues);
                Map<String, List<AdjustRecordColInfo>> colDatas = colUpdates.stream().collect(Collectors.groupingBy(s -> s.getKey()));
                for (Map.Entry<String, List<AdjustRecordColInfo>> cgroup : colDatas.entrySet()) {
                    String colKey = cgroup.getKey();
                    List<AdjustRecordColInfo> coldetails = cgroup.getValue();
                    coldetails.sort(new Comparator<AdjustRecordColInfo>(){

                        @Override
                        public int compare(AdjustRecordColInfo o1, AdjustRecordColInfo o2) {
                            return o1.getPkId().compareTo(o2.getPkId());
                        }
                    });
                    RejectInfo.RejectInfoDetail colinfo = new RejectInfo.RejectInfoDetail();
                    colValues.add(colinfo);
                    String colTitle = keyMapTitle.get(colKey);
                    Object preAdjust = coldetails.get(0).getPreAdjust();
                    Object afterAdjust = coldetails.get(coldetails.size() - 1).getAfterAdjust();
                    if ("".equals(preAdjust.toString()) && preAdjust.toString() == null && "".equals(afterAdjust.toString()) && afterAdjust.toString() == null) continue;
                    Integer decimalDigit = 2;
                    for (BaseColumn column2 : columns) {
                        NumberColumn numberColumn = (NumberColumn)column2;
                        if (!numberColumn.getKey().equals(colKey)) continue;
                        decimalDigit = numberColumn.getDecimaldigit();
                        break;
                    }
                    colinfo.setColName(colTitle);
                    colinfo.setPreAdjust(this.setFormat(preAdjust, decimalDigit));
                    colinfo.setAfterAdjust(this.setFormat(afterAdjust, decimalDigit));
                }
            }
            String title = ResManager.loadKDString((String)"\u9a73\u56de\u8c03\u6574\u5b8c\u6210", (String)"RejectBillService_3", (String)"epm-eb-business", (Object[])new Object[0]);
            String firstRow = ResManager.loadResFormat((String)"\u5355\u636e%1\u5728%2\u8282\u70b9\u7531\u3010%3\u3011\u9a73\u56de\u751f\u6210\u7684\u9a73\u56de\u8c03\u6574\u5355%4\u5df2\u7531\u3010%5\u3011\u5904\u7406\u5b8c\u6210\uff0c\u8c03\u6574\u5185\u5bb9\u5982\u4e0b\uff1a", (String)"RejectBillService_4", (String)"epm-eb-business", (Object[])new Object[]{rejectInfo.getApproveBillNo(), rejectInfo.getRejectNodeName(), this.getUserName(approveUser), rejectInfo.getRejectBillNo(), this.getUserName(UserUtils.getUserId())});
            String content = "";
            List<RejectInfo.RejectRowInfo> rowInfo = rejectInfo.getRowInfo();
            ArrayList<String> rows = new ArrayList<String>(16);
            for (RejectInfo.RejectRowInfo rejectRowInfo : rowInfo) {
                ArrayList<String> crow = new ArrayList<String>(16);
                Map<String, String> rowMap = rejectRowInfo.getRowInfo();
                for (Map.Entry entry : rowMap.entrySet()) {
                    crow.add((String)entry.getKey() + "\uff1a" + (String)entry.getValue());
                }
                List<RejectInfo.RejectInfoDetail> colInfos = rejectRowInfo.getColInfos();
                for (RejectInfo.RejectInfoDetail colInfo : colInfos) {
                    crow.add(ResManager.loadResFormat((String)"\u3010%1\uff1a\u9a73\u56de\u524d\uff1a%2\uff0c\u8c03\u6574\u540e\uff1a%3\u3011", (String)"RejectBillService_5", (String)"epm-eb-business", (Object[])new Object[]{colInfo.getColName(), colInfo.getPreAdjust(), colInfo.getAfterAdjust()}));
                }
                String string = String.join((CharSequence)";", crow);
                rows.add(string);
            }
            content = firstRow + String.join((CharSequence)";\r\n", rows);
            log.info("RejectBillService#sendMessageToApproveUsers.sendcontent:" + content);
            MessageInfo messageInfo = new MessageInfo();
            messageInfo.setMessageTitle((ILocaleString)new LocaleString(title));
            messageInfo.setUserIds(distinctSendUsers);
            messageInfo.setMessageContent((ILocaleString)new LocaleString(content));
            messageInfo.setType("message");
            messageInfo.setEntityNumber("eb_bgapplybill");
            MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
        }
    }

    private String getUserName(Long userId) {
        if (IDUtils.isNull((Long)userId)) {
            return null;
        }
        return this.userMap.computeIfAbsent(userId, f -> {
            DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache((Object)userId, (String)"bos_user", (String)"id, name");
            if (user != null) {
                return user.getString("name");
            }
            return null;
        });
    }

    private String setFormat(Object adjustNumber, Integer decimalDigit) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMaximumFractionDigits(decimalDigit);
        numberFormat.setMinimumFractionDigits(decimalDigit);
        numberFormat.setGroupingUsed(true);
        String formattedNumber = null;
        try {
            Double number = Double.parseDouble(adjustNumber.toString());
            formattedNumber = numberFormat.format(number);
        }
        catch (NumberFormatException e) {
            formattedNumber = adjustNumber.toString();
        }
        return formattedNumber;
    }

    public List<Long> getSendUsers(String frombillno, String tobillno, long modelId, List<Map<String, String>> rejectDataList) {
        ArrayList<Long> sendUserId = new ArrayList<Long>(16);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        CentralAppBillService instance = CentralAppBillService.getInstance();
        Set<Object> billNos = new HashSet<String>(16);
        ApproveBill frombill = this.getApproveByBillno(frombillno, modelId);
        ApproveBill tobill = this.getApproveByBillno(tobillno, modelId);
        Long fromReportEntity = frombill.getReportEntity();
        Long toReportEntity = tobill.getReportEntity();
        Map dimViewMap = modelCacheHelper.getViewsByBusModel(frombill.getBizModelId());
        Long viewId = (Long)dimViewMap.get(SysDimensionEnum.Entity.getNumber());
        Member fromEntity = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), viewId, fromReportEntity);
        Member toEntity = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), viewId, toReportEntity);
        List allMembers = fromEntity.getAllMembers();
        List parents = modelCacheHelper.getParents(viewId, toEntity, true);
        List allids = allMembers.stream().map(s -> s.getId()).collect(Collectors.toList());
        log.info("RejectBillService#getSendUsers.allids.start:" + SerializationUtils.toJsonString(allids));
        List parentids = parents.stream().map(s -> s.getId()).collect(Collectors.toList());
        allids.retainAll(parentids);
        log.info("RejectBillService#getSendUsers.allids.end:" + SerializationUtils.toJsonString(allids));
        Long parentId = frombill.getParentId();
        String mainBillno = "";
        if (parentId != null && parentId > 0L) {
            DynamicObject mainbill = BusinessDataServiceHelper.loadSingleFromCache((Object)parentId, (String)"eb_centralappbill");
            if (mainbill != null) {
                mainBillno = mainbill.getString("billno");
                CentralAppChain centralAppChain = instance.getCentralAppChainByBills(mainBillno, (Long)modelId);
                billNos.addAll(instance.getCentralAppChainsBillSet(centralAppChain));
            }
            log.info("RejectBillService#getSendUsers.parentId:" + parentId);
        } else {
            CentralAppChain centralAppChain = instance.getCentralAppChainByBills(frombillno, (Long)modelId);
            billNos.addAll(instance.getCentralAppChainsBillSet(centralAppChain));
        }
        billNos.add(frombillno);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)mainBillno)) {
            billNos.remove(mainBillno);
        }
        QFilter removeCancleQf = new QFilter("billno", "in", billNos);
        removeCancleQf.and(new QFilter("billstatus", "=", (Object)AppBillStatusEnum.CANCEL));
        DynamicObjectCollection cancleBills = QueryServiceHelper.query((String)"eb_centralappbill", (String)"billno", (QFilter[])removeCancleQf.toArray());
        if (cancleBills != null && !cancleBills.isEmpty()) {
            List cancelBillnos = cancleBills.stream().map(s -> s.getString("billno")).collect(Collectors.toList());
            billNos.removeIf(cancelBillnos::contains);
        }
        QFilter filter = new QFilter("billno", "in", billNos);
        ArrayList<Long> pkids = new ArrayList<Long>(16);
        DynamicObjectCollection datas = QueryServiceHelper.query((String)"eb_centralappbill", (String)"id", (QFilter[])filter.toArray());
        if (datas != null && !datas.isEmpty()) {
            for (DynamicObject data : datas) {
                pkids.add(data.getLong("id"));
            }
        }
        QFilter filter1 = new QFilter("parentid", "in", pkids);
        filter1.and(new QFilter("billstatus", "!=", (Object)AppBillStatusEnum.CANCEL));
        DynamicObjectCollection datas1 = QueryServiceHelper.query((String)"eb_centralappbill", (String)"billno", (QFilter[])filter1.toArray());
        if (datas1 != null && !datas1.isEmpty()) {
            for (DynamicObject data : datas1) {
                billNos.add(data.getString("billno"));
            }
        }
        log.info("RejectBillService#getSendUsers.billnos:" + SerializationUtils.toJsonString(billNos));
        QFilter allfilter = new QFilter("billno", "in", billNos);
        allfilter.and(new QFilter("billstatus", "!=", (Object)AppBillStatusEnum.CANCEL));
        allfilter.and(new QFilter("reportentity", "in", allids));
        DynamicObjectCollection centralbills = QueryServiceHelper.query((String)"eb_centralappbill", (String)"id,billno,reportentity,parentid", (QFilter[])allfilter.toArray());
        if (centralbills != null && !centralbills.isEmpty()) {
            List others;
            billNos = centralbills.stream().map(s -> s.getString("billno")).collect(Collectors.toSet());
            Long toparentId = tobill.getParentId();
            if (toparentId != null && toparentId > 0L) {
                others = centralbills.stream().filter(s -> s.getLong("parentid") == toparentId.longValue() && s.getLong("reportentity") == toReportEntity.longValue() && !s.getString("billno").equals(tobill.getBillNo())).map(s -> s.getString("billno")).collect(Collectors.toList());
                log.info("RejectBillService#getSendUsers.others\u5b50\u5355\uff0c\u8981\u6392\u9664\u5176\u4ed6\u5b50\u5355:" + SerializationUtils.toJsonString(others));
                if (!others.isEmpty()) {
                    billNos.removeIf(s -> others.contains(s));
                }
            } else {
                others = centralbills.stream().filter(s -> s.getLong("reportentity") == toReportEntity.longValue() && !s.getString("billno").equals(tobill.getBillNo())).map(s -> s.getString("billno")).collect(Collectors.toList());
                log.info("RejectBillService#getSendUsers.others\u4e3b\u5355\uff0c\u8981\u6392\u9664\u7f16\u5236\u7ec4\u7ec7\u4e00\u6837\u7684\u5176\u4ed6\u5355\u636e:" + SerializationUtils.toJsonString(others));
                if (!others.isEmpty()) {
                    billNos.removeIf(s -> others.contains(s));
                }
            }
            QFilter qFilter2 = new QFilter("billno", "in", billNos);
            qFilter2.and(new QFilter("model", "=", (Object)modelId));
            List<ApproveBill> approveBills = ApproveBillUtil.getInstance().getApproveBills(qFilter2);
            if (approveBills != null && !approveBills.isEmpty()) {
                for (ApproveBill bill : approveBills) {
                    List finds;
                    List approveconfig = bill.getApproveconfig();
                    boolean mainbill = bill.isMainbill();
                    if (approveconfig == null || mainbill || !CollectionUtils.isNotEmpty(finds = approveconfig.stream().filter(s -> !s.getMatchMemberIds().isEmpty()).collect(Collectors.toList()))) continue;
                    ArrayList filterdatas = new ArrayList(16);
                    for (ApproveBillConfig approveBillConfig : finds) {
                        filterdatas.addAll(approveBillConfig.getMatchMemberIds());
                    }
                    ArrayList<Boolean> isContainbillno = new ArrayList<Boolean>(16);
                    for (Map<String, String> rejectRow : rejectDataList) {
                        boolean allcontain = false;
                        for (Map filterdata : filterdatas) {
                            ArrayList<Boolean> isMatchs = new ArrayList<Boolean>(16);
                            for (Map.Entry<String, String> stringStringEntry : rejectRow.entrySet()) {
                                String rejectDimNumber = stringStringEntry.getKey();
                                Set centralDims = filterdata.keySet();
                                if (!centralDims.contains(rejectDimNumber)) continue;
                                Set centralMembers = (Set)filterdata.get(rejectDimNumber);
                                if (centralMembers == null || centralMembers.isEmpty()) {
                                    isMatchs.add(true);
                                    continue;
                                }
                                String rejectValues = stringStringEntry.getValue();
                                if (!StringUtils.isNotEmpty((String)rejectValues)) continue;
                                String[] arrvalues = rejectValues.split(",");
                                boolean ischildcontain = false;
                                for (String arrvalue : arrvalues) {
                                    Member member = modelCacheHelper.getMember(rejectDimNumber, (Long)dimViewMap.get(rejectDimNumber), arrvalue);
                                    if (member == null || !centralMembers.contains(member.getId())) continue;
                                    ischildcontain = true;
                                    break;
                                }
                                isMatchs.add(ischildcontain);
                            }
                            if (!isMatchs.isEmpty() && !isMatchs.stream().allMatch(s -> s)) continue;
                            allcontain = true;
                            break;
                        }
                        isContainbillno.add(allcontain);
                    }
                    if (isContainbillno.stream().allMatch(s -> s)) continue;
                    billNos.remove(bill.getBillNo());
                    log.info("RejectBillService#getAllApproveRecord.removebillno:" + bill.getBillNo());
                }
            }
            log.info("RejectBillService#getSendUsers.recordbillnos:" + SerializationUtils.toJsonString(billNos));
            Map<String, ApproveRecord> approveRecords = ApproveRecordUtil.getInstance().getApproveRecords(billNos);
            if (approveRecords != null && approveRecords.size() > 0) {
                ApproveRecord approveRecord = approveRecords.get(tobillno);
                List approveRecordEntries = approveRecord.getApproveRecordEntries();
                long currUserId = RequestContext.get().getCurrUserId();
                Optional<ApproveRecordEntry> first = approveRecordEntries.stream().filter(s -> s.getApprover().equals(currUserId)).findFirst();
                if (first.isPresent()) {
                    Long id = first.get().getId();
                    List list = approveRecordEntries.stream().filter(s -> s.getId().compareTo(id) > 0).map(ApproveRecordEntry::getApprover).collect(Collectors.toList());
                    sendUserId.addAll(list);
                } else {
                    List userids = approveRecordEntries.stream().map(ApproveRecordEntry::getApprover).collect(Collectors.toList());
                    sendUserId.addAll(userids);
                }
                for (Map.Entry entry : approveRecords.entrySet()) {
                    List otherappentrys;
                    ApproveRecord value = (ApproveRecord)entry.getValue();
                    if (Objects.equals(value.getId(), approveRecord.getId()) || (otherappentrys = value.getApproveRecordEntries()) == null || otherappentrys.isEmpty()) continue;
                    sendUserId.addAll(otherappentrys.stream().map(ApproveRecordEntry::getApprover).collect(Collectors.toList()));
                }
                sendUserId.removeIf(s -> s.equals(currUserId));
            }
        }
        log.info("RejectBillService#getSendUsers.sendUserId:" + SerializationUtils.toJsonString(sendUserId));
        return sendUserId;
    }

    private static class InnerClass {
        private static RejectBillService instance = new RejectBillService();

        private InnerClass() {
        }
    }
}

