/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.report.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.approveBill.ApproveBillAutoCreate;
import kd.epm.eb.business.approveBill.ApproveBillAutoCreateEB;
import kd.epm.eb.business.approveBill.CommitCheck;
import kd.epm.eb.business.approveBill.CommitExaminCheck;
import kd.epm.eb.business.approveBill.MetricNotNullCheck;
import kd.epm.eb.business.approveBill.helper.ApproveBillSubmitHelper;
import kd.epm.eb.business.approvetype.ApproveUtils;
import kd.epm.eb.business.bailorg.BailOrgService;
import kd.epm.eb.business.bailorg.pojo.BailOrgRelation;
import kd.epm.eb.business.report.dto.ReportSubmitRequest;
import kd.epm.eb.business.report.dto.ReportSubmitResponse;
import kd.epm.eb.business.report.exception.EpmReportSubmitErrorException;
import kd.epm.eb.business.report.service.IReportSubmitService;
import kd.epm.eb.common.approveBill.ApproveBillCommon;
import kd.epm.eb.common.approveBill.Entity.ApproveBillRptTemp;
import kd.epm.eb.common.approveBill.Entity.ApproveBillSubMitDim;
import kd.epm.eb.common.approveBill.Entity.ApproveBillSubMitInfo;
import kd.epm.eb.common.approveBill.Entity.ApproveBillSubMitInfoEB;
import kd.epm.eb.common.approveBill.Entity.CentralBillFilterInfo;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.examine.enums.ExamineExecTypeEnum;
import kd.epm.eb.common.reportprocess.service.impl.ReportProcessAggService;
import kd.epm.eb.common.reportprocess.service.impl.ReportProcessServiceImpl;
import kd.epm.eb.common.utils.ApproveBill.BasicInfoHelper;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UserUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class AbstractReportSubmitService
implements IReportSubmitService {
    private static final Log log = LogFactory.getLog(AbstractReportSubmitService.class);

    @Override
    public void submit(ReportSubmitRequest reportSubmitRequest, ReportSubmitResponse reportSubmitResponse) {
        boolean canSubmit = this.beforeSubmit(reportSubmitRequest, reportSubmitResponse);
        if (!canSubmit) {
            return;
        }
        this.doSubmit(reportSubmitRequest, reportSubmitResponse);
        this.afterSubmit(reportSubmitRequest, reportSubmitResponse);
    }

    @Override
    public boolean beforeSubmit(ReportSubmitRequest reportSubmitRequest, ReportSubmitResponse reportSubmitResponse) {
        if (CollectionUtils.isEmpty(reportSubmitRequest.getRptIds())) {
            return false;
        }
        Set<Long> rptIds = reportSubmitRequest.getRptIds();
        if (rptIds.size() > 2000) {
            throw new EpmReportSubmitErrorException(ResManager.loadKDString((String)"\u4e00\u6b21\u63d0\u4ea4\u4e0d\u80fd\u8d85\u8fc72000\u4e2a\u62a5\u8868\u3002", (String)"AbstractReportSubmitService_003", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        DynamicObjectCollection reportProcessObjList = QueryServiceHelper.query((String)"eb_reportprocess", (String)"entity", (QFilter[])new QFilter[]{new QFilter("id", "in", rptIds)});
        if (CollectionUtils.isEmpty((Collection)reportProcessObjList)) {
            return false;
        }
        boolean entityDifferent = false;
        for (DynamicObject dynamicObject : reportProcessObjList) {
            if (IDUtils.equals((Object)dynamicObject.getLong("entity"), (Object)reportSubmitRequest.getSubmitEntityId())) continue;
            log.info("submit different entityId:" + dynamicObject.getLong("entity"));
            entityDifferent = true;
            break;
        }
        if (entityDifferent) {
            throw new EpmReportSubmitErrorException(ResManager.loadKDString((String)"\u53ea\u80fd\u63d0\u4ea4\u76f8\u540c\u7ec4\u7ec7\u7684\u62a5\u8868\u3002", (String)"AbstractReportSubmitService_001", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        return true;
    }

    @Override
    public void doSubmit(ReportSubmitRequest reportSubmitRequest, ReportSubmitResponse reportSubmitResponse) {
        OperationResult result;
        List<ApproveBillRptTemp> approveBillRptTemps = this.batchGetTempInfo(reportSubmitRequest);
        ApproveBillSubMitInfo approveBillSubMitInfo = this.getApproveBillParams(reportSubmitRequest, approveBillRptTemps);
        if (new CommitCheck().checkCommitRptTempNotValiad(approveBillSubMitInfo, null, result = new OperationResult())) {
            List allErrorInfo = result.getAllErrorInfo();
            if (CollectionUtils.isNotEmpty((Collection)allErrorInfo)) {
                for (OperateErrorInfo operateErrorInfo : allErrorInfo) {
                    reportSubmitResponse.addErrorInfo(operateErrorInfo.getMessage());
                }
                throw new EpmReportSubmitErrorException("");
            }
            return;
        }
        if (!this.checkMetricNotNull(null, approveBillSubMitInfo, reportSubmitRequest, reportSubmitResponse)) {
            throw new EpmReportSubmitErrorException(ResManager.loadKDString((String)"\u5fc5\u5f55\u9879\u6821\u9a8c\u672a\u901a\u8fc7\u3002", (String)"", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        if (!this.checkExamineIsOk(null, approveBillSubMitInfo, reportSubmitRequest, reportSubmitResponse)) {
            return;
        }
        try (TXHandle tx = TX.required();){
            try {
                this.submitBill(approveBillSubMitInfo, reportSubmitRequest, reportSubmitResponse);
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    protected boolean checkExamineIsOk(CentralBillFilterInfo refBillFilterInfo, ApproveBillSubMitInfo bgmBill, ReportSubmitRequest reportSubmitRequest, ReportSubmitResponse reportSubmitResponse) {
        return new CommitExaminCheck().batchCheckExamine(ExamineExecTypeEnum.Commit, refBillFilterInfo, bgmBill, reportSubmitRequest, reportSubmitResponse);
    }

    protected boolean checkMetricNotNull(CentralBillFilterInfo refBillFilterInfo, ApproveBillSubMitInfo bgmBill, ReportSubmitRequest reportSubmitRequest, ReportSubmitResponse reportSubmitResponse) {
        return new MetricNotNullCheck().batchCheckExamine(ExamineExecTypeEnum.Commit, refBillFilterInfo, bgmBill, reportSubmitRequest, reportSubmitResponse);
    }

    private void checkPerm(ApproveBillSubMitInfo rptInfo) {
        String appid = ApproveBillCommon.getAppId((ApproveBillSubMitInfo)rptInfo);
        String formId = ApproveBillCommon.getFormId((ApproveBillSubMitInfo)rptInfo);
        DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"EPMPermissionService", (String)"checkPermission", (Object[])new Object[]{rptInfo.getSubmitDims().getModelId(), UserUtils.getUserId(), AppMetadataCache.getAppInfo((String)appid).getId(), formId, "btn_submit"});
    }

    private Boolean checkReportProcess(ApproveBillSubMitInfo rptInfo) {
        ApproveBillSubMitDim submitDims;
        if (rptInfo != null && (submitDims = rptInfo.getSubmitDims()) != null) {
            Set tempIds = submitDims.getTempIds();
            HashSet<Long> entityIds = new HashSet<Long>(16);
            entityIds.add(submitDims.getOrgId());
            List list = ReportProcessServiceImpl.getInstance().getReportProcessList(submitDims.getModelId(), submitDims.getViewId(), entityIds, tempIds, submitDims.getYearPeriodId(), submitDims.getDataTypeId(), submitDims.getVersionId());
            if (list.size() != tempIds.size()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u62a5\u8868\u5b9e\u4f8b\u4e0d\u5b58\u5728\u3002", (String)"ExportCommand_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
        return true;
    }

    protected void submitBill(ApproveBillSubMitInfo rptInfo, ReportSubmitRequest reportSubmitRequest, ReportSubmitResponse reportSubmitResponse) {
        log.info("submitReport_getApproveBill");
        this.checkPerm(rptInfo);
        log.info("submitReport_checkReportProcess");
        if (!this.checkReportProcess(rptInfo).booleanValue()) {
            return;
        }
        log.info("submitReport_createApproveBillAuto");
        Object[] approveBillIds = this.createApproveBillAuto(rptInfo);
        this.setExtendFieldToApproveBills(reportSubmitRequest.getExtendParamMap(), approveBillIds, reportSubmitResponse);
        log.info("submitReport_submitBills");
        this.submitBills(approveBillIds, rptInfo, reportSubmitRequest, reportSubmitResponse);
        log.info("submitReport_ok");
    }

    private void setExtendFieldToApproveBills(Map<String, Object> extendParamMap, Object[] approveBillIds, ReportSubmitResponse reportSubmitResponse) {
        DynamicObject[] load;
        if (extendParamMap != null && extendParamMap.size() > 0 && (load = (DynamicObject[])BusinessDataServiceHelper.load((Object[])approveBillIds, (IDataEntityType)BusinessDataServiceHelper.newDynamicObject((String)"eb_approvebill").getDataEntityType())) != null && load.length > 0) {
            for (DynamicObject dynamicObject : load) {
                for (Map.Entry<String, Object> entry : extendParamMap.entrySet()) {
                    if (!dynamicObject.containsProperty(entry.getKey())) {
                        reportSubmitResponse.addErrorInfo(ResManager.loadResFormat((String)"\u5ba1\u6279\u5355\u4e0d\u5b58\u5728\u5b57\u6bb5\uff1a%1\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AbstractReportSubmitService_002", (String)"epm-eb-business", (Object[])new Object[]{entry.getKey()}));
                        continue;
                    }
                    dynamicObject.set(entry.getKey(), entry.getValue());
                }
            }
            if (reportSubmitResponse.hasErrorInfo()) {
                throw new EpmReportSubmitErrorException("");
            }
            SaveServiceHelper.update((DynamicObject[])load);
        }
    }

    protected void addBailOrg(ApproveBillSubMitInfo bgmBill, ReportSubmitRequest reportSubmitRequest) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)reportSubmitRequest.getModelId());
        Member member = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), reportSubmitRequest.getSubmitEntityViewId(), reportSubmitRequest.getSubmitEntityId());
        Long bailOrgId = this.fillBailOrg(bgmBill, member);
        if (IDUtils.isNotEmptyLong((Long)bailOrgId).booleanValue()) {
            bgmBill.setBailOrgIds(Collections.singleton(bailOrgId));
        }
    }

    private void submitBills(Object[] approveBillIds, ApproveBillSubMitInfo rptInfo, ReportSubmitRequest reportSubmitRequest, ReportSubmitResponse reportSubmitResponse) {
        if (approveBillIds != null && approveBillIds.length > 0) {
            List<Long> approveBillIdList = Arrays.stream(approveBillIds).map(p -> ((DynamicObject)p).getLong("id")).collect(Collectors.toList());
            this.submitBills(approveBillIdList, rptInfo, reportSubmitRequest, reportSubmitResponse);
        }
    }

    private Object[] createApproveBillAuto(ApproveBillSubMitInfo rptInfo) {
        Object[] approveBillIds = null;
        if (rptInfo != null) {
            approveBillIds = new ApproveBillAutoCreate().createApproveBillAuto(rptInfo);
        }
        if (rptInfo instanceof ApproveBillSubMitInfoEB) {
            approveBillIds = new ApproveBillAutoCreateEB().createApproveBillAuto(rptInfo);
        }
        return approveBillIds;
    }

    protected void addApproveDesc(OperateOption op, ReportSubmitRequest reportSubmitRequest) {
        op.setVariableValue("descInfo", SerializationUtils.toJsonString(reportSubmitRequest.getRptApproveDescMap()));
    }

    private void submitBills(List<Long> toSubmitBills, ApproveBillSubMitInfo rptInfo, ReportSubmitRequest reportSubmitRequest, ReportSubmitResponse reportSubmitResponse) {
        if (CollectionUtils.isEmpty(toSubmitBills)) {
            throw new EpmReportSubmitErrorException(ResManager.loadKDString((String)"\u5ba1\u6279\u5355\u521b\u5efa\u5931\u8d25\u3002", (String)"BgDimRangeSelect_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        String appid = ApproveBillCommon.getAppId((ApproveBillSubMitInfo)rptInfo);
        String formId = ApproveBillCommon.getFormId((ApproveBillSubMitInfo)rptInfo);
        log.info(StringUtils.join((Object[])new String[]{"submitReport_appid:", appid, formId}));
        OperateOption op = OperateOption.create();
        op.setVariableValue("currbizappid", appid);
        this.addApproveDesc(op, reportSubmitRequest);
        OperationResult operationResult = ApproveBillSubmitHelper.getInstance().submitApproveBillWithShowMessage(null, appid, formId, rptInfo.getSubmitDims().getModelId(), new HashSet<Long>(toSubmitBills), op);
        if (operationResult != null) {
            if (operationResult.isSuccess()) {
                if (operationResult.isShowMessage() && StringUtils.isNotBlank((CharSequence)operationResult.getMessage())) {
                    reportSubmitResponse.addWarningInfo(operationResult.getMessage());
                }
            } else {
                if (operationResult.isShowMessage() && StringUtils.isNotBlank((CharSequence)operationResult.getMessage())) {
                    throw new EpmReportSubmitErrorException(operationResult.getMessage());
                }
                String title = ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\u3002", (String)"ApproveBillList_002", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                throw new EpmReportSubmitErrorException(title);
            }
            Set<Long> pkIds = operationResult.getSuccessPkIds().stream().map(ConvertUtils::toLong).collect(Collectors.toSet());
            ApproveUtils.getInstance().saveSubmitInfos(pkIds);
            ApproveUtils.getInstance().saveApproveBillAuditType(pkIds);
            Set<Long> approveReportProcessIds = ApproveUtils.getInstance().getApproveReportProcessIds(pkIds);
            ApproveUtils.getInstance().updateRejectBillStatus(pkIds, approveReportProcessIds);
            operationResult.setSuccessPkIds(new ArrayList(16));
            reportSubmitResponse.getApproveBillIds().addAll(toSubmitBills);
        }
        log.info("submitReport_aftersubmitBills");
    }

    protected ApproveBillSubMitInfo getApproveBillParams(ReportSubmitRequest reportSubmitRequest, Collection<ApproveBillRptTemp> rptTemps) {
        ApproveBillSubMitInfo bgmBill = new ApproveBillSubMitInfo();
        bgmBill.setBtnKey("");
        bgmBill.setRptProcessType(reportSubmitRequest.getProcessTypeEnum().getIndex());
        bgmBill.setRptTemps(rptTemps);
        ApproveBillSubMitDim submitDims = new ApproveBillSubMitDim();
        bgmBill.setSubmitDims(submitDims);
        submitDims.setTempIds(ApproveBillCommon.getTempIds(rptTemps));
        submitDims.setModelId(reportSubmitRequest.getModelId());
        submitDims.setOrgId(reportSubmitRequest.getSubmitEntityId());
        this.getPeriodVersionDataTypeInfo(bgmBill, reportSubmitRequest);
        submitDims.setViewId(reportSubmitRequest.getSubmitEntityViewId());
        submitDims.setCommitType("1");
        log.info("submitReport_addBailOrg");
        this.addBailOrg(bgmBill, reportSubmitRequest);
        Long userId = UserUtils.getUserId();
        bgmBill.setCreaterId(userId);
        bgmBill.setApproveNote(reportSubmitRequest.getApproveNote());
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)userId, (String)"bos_user");
        Map userInfoMap = BasicInfoHelper.setFormInfo(null, null, (boolean)true, (DynamicObject)dynamicObject);
        if (userInfoMap != null) {
            Object company;
            Object position;
            Object department = userInfoMap.get("department");
            if (department != null) {
                bgmBill.setDepartment(Long.valueOf(((DynamicObject)department).getLong("id")));
            }
            if ((position = userInfoMap.get("position")) != null) {
                bgmBill.setPosition(position.toString());
            }
            if ((company = userInfoMap.get("company")) != null) {
                bgmBill.setCreateOrgId(IDUtils.toLong(((Map)company).get("id")));
            }
        }
        return bgmBill;
    }

    private Long fillBailOrg(ApproveBillSubMitInfo rptInfo, Member member) {
        if (member == null) {
            return 0L;
        }
        BailOrgRelation bailOrgRelation = BailOrgService.getInstance().getBailOrgRelation(rptInfo.getSubmitDims().getModelId(), member.getNumber());
        if (bailOrgRelation != null) {
            return bailOrgRelation.getDefaultBailId();
        }
        return 0L;
    }

    protected void getPeriodVersionDataTypeInfo(ApproveBillSubMitInfo bgmBill, ReportSubmitRequest reportSubmitRequest) {
    }

    protected List<ApproveBillRptTemp> batchGetTempInfo(ReportSubmitRequest reportSubmitRequest) {
        ArrayList<ApproveBillRptTemp> result = new ArrayList<ApproveBillRptTemp>(16);
        if (reportSubmitRequest == null || CollectionUtils.isEmpty(reportSubmitRequest.getRptIds())) {
            return result;
        }
        Set<Long> rptIds = reportSubmitRequest.getRptIds();
        DynamicObjectCollection reportProcessDynamicList = ReportProcessAggService.getInstance().queryReportProcessDynamicList(rptIds, "id, template, template.name, template.templatetype, entity, status, approvebill");
        if (CollectionUtils.isEmpty((Collection)reportProcessDynamicList)) {
            return result;
        }
        Map<Long, String> rptApproveDescMap = reportSubmitRequest.getRptApproveDescMap();
        for (DynamicObject dynamicObject : reportProcessDynamicList) {
            ApproveBillRptTemp approveBillRptTemp = new ApproveBillRptTemp();
            if (dynamicObject == null || IDUtils.isEmptyLong((Long)dynamicObject.getLong("template")).booleanValue()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u62a5\u8868\u5b9e\u4f8b\u4e0d\u5b58\u5728\u3002", (String)"ExportCommand_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            String reportName = dynamicObject.getString("template.name");
            approveBillRptTemp.setRptId(Long.valueOf(dynamicObject.getLong("id")));
            approveBillRptTemp.setTempId(Long.valueOf(dynamicObject.getLong("template")));
            approveBillRptTemp.setTempName(reportName);
            approveBillRptTemp.setRptType(dynamicObject.getString("template.templatetype"));
            approveBillRptTemp.setTaskListId(reportSubmitRequest.getTaskListId());
            approveBillRptTemp.setOrgId(Long.valueOf(dynamicObject.getLong("entity")));
            approveBillRptTemp.setStatus(dynamicObject.getString("status"));
            approveBillRptTemp.setApproveBillId(Long.valueOf(dynamicObject.getLong("approvebill")));
            if (rptApproveDescMap != null && rptApproveDescMap.get(dynamicObject.getLong("id")) != null) {
                approveBillRptTemp.setApproveDesc(rptApproveDescMap.get(dynamicObject.getLong("id")));
            }
            result.add(approveBillRptTemp);
        }
        return result;
    }

    @Override
    public void afterSubmit(ReportSubmitRequest reportSubmitRequest, ReportSubmitResponse reportSubmitResponse) {
    }
}

