/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.report.service;

import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.report.dto.ReportSubmitRequest;
import kd.epm.eb.business.report.dto.ReportSubmitResponse;
import kd.epm.eb.business.report.service.AbstractReportSubmitService;
import kd.epm.eb.business.report.service.impl.ReportSubmitExcelServiceImpl;
import kd.epm.eb.business.report.service.impl.ReportSubmitSchemeServiceImpl;
import kd.epm.eb.business.report.service.impl.ReportSubmitTaskServiceImpl;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ReportSubmitAggService {
    private static final Log log = LogFactory.getLog(ReportSubmitAggService.class);
    private static final ReportSubmitAggService instance = new ReportSubmitAggService();

    private ReportSubmitAggService() {
    }

    public static ReportSubmitAggService getInstance() {
        return instance;
    }

    public ReportSubmitResponse submit(ReportSubmitRequest reportSubmitRequest) {
        log.info("begin submit.");
        if (reportSubmitRequest == null) {
            return null;
        }
        ReportSubmitResponse reportSubmitResponse = new ReportSubmitResponse();
        AbstractReportSubmitService reportSubmitService = null;
        switch (reportSubmitRequest.getSubmitType()) {
            case "report": {
                reportSubmitService = ReportSubmitSchemeServiceImpl.getInstance();
                break;
            }
            case "task": {
                reportSubmitService = ReportSubmitTaskServiceImpl.getInstance();
                break;
            }
            case "excel": {
                reportSubmitService = ReportSubmitExcelServiceImpl.getInstance();
                break;
            }
        }
        if (reportSubmitService == null) {
            reportSubmitResponse.addErrorInfo(ResManager.loadResFormat((String)"\u53c2\u6570%1\u4e0d\u6b63\u786e\u3002", (String)"ReportSubmitAggService_001", (String)"epm-eb-business", (Object[])new Object[]{"submitType"}));
            return reportSubmitResponse;
        }
        try {
            reportSubmitService.submit(reportSubmitRequest, reportSubmitResponse);
        }
        catch (Exception e) {
            log.error("submit error:");
            log.error((Throwable)e);
            if (e instanceof KDBizException) {
                if (StringUtils.isNotBlank((CharSequence)e.getMessage())) {
                    reportSubmitResponse.addErrorInfo(e.getMessage());
                }
            }
            reportSubmitResponse.addErrorInfo(ResManager.loadResFormat((String)"\u63d0\u4ea4\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u8be2\u65e5\u5fd7\u3002Trace ID\uff1a%1\u3002", (String)"ReportSubmitAggService_002", (String)"epm-eb-business", (Object[])new Object[]{RequestContext.get().getTraceId()}));
        }
        if (CollectionUtils.isNotEmpty(reportSubmitResponse.getErrorInfoList())) {
            reportSubmitResponse.setStatus(ReportSubmitResponse.SubmitStatusEnum.ERROR);
        } else if (CollectionUtils.isEmpty(reportSubmitResponse.getWarningInfoList())) {
            reportSubmitResponse.setStatus(ReportSubmitResponse.SubmitStatusEnum.WARN);
        } else {
            reportSubmitResponse.setStatus(ReportSubmitResponse.SubmitStatusEnum.SUCCESS);
        }
        return reportSubmitResponse;
    }
}

