/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.reportscheme.service;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.reportscheme.entity.TebSchemeAssign;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.SqlBatchUtils;
import kd.epm.eb.common.utils.UserUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class ReportSchemeAssignService {
    private static ReportSchemeAssignService instance = new ReportSchemeAssignService();

    private ReportSchemeAssignService() {
    }

    public static ReportSchemeAssignService getInstance() {
        return instance;
    }

    public Object[] saveAssignRecord(List<TebSchemeAssign> tebSchemeAssigns) {
        DynamicObject[] dynamicObjects = new DynamicObject[tebSchemeAssigns.size()];
        for (int i = 0; i < tebSchemeAssigns.size(); ++i) {
            dynamicObjects[i] = this.newSaveDynamic(tebSchemeAssigns.get(i));
        }
        return SaveServiceHelper.save((DynamicObject[])dynamicObjects);
    }

    private DynamicObject newSaveDynamic(TebSchemeAssign schemeAssign) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"eb_schemeassign");
        dynamicObject.set("scheme", (Object)schemeAssign.getSchemeId());
        dynamicObject.set("year", (Object)schemeAssign.getYear());
        dynamicObject.set("datatype", (Object)schemeAssign.getDataType());
        dynamicObject.set("version", (Object)schemeAssign.getVersion());
        dynamicObject.set("assigner", (Object)schemeAssign.getAssignerId());
        dynamicObject.set("assigntime", (Object)schemeAssign.getAssignTime());
        if (schemeAssign.getCreatedate() != null) {
            dynamicObject.set("createdate", (Object)schemeAssign.getCreatedate());
        }
        dynamicObject.set("assignseq", (Object)schemeAssign.getSeq());
        dynamicObject.set("bizrange", (Object)schemeAssign.getBizrangeId());
        dynamicObject.set("model", (Object)schemeAssign.getModelId());
        dynamicObject.set("applyscope", (Object)schemeAssign.getApplyscope());
        dynamicObject.set("description", (Object)schemeAssign.getDescription());
        dynamicObject.set("name", (Object)schemeAssign.getName());
        return dynamicObject;
    }

    public int getMaxSeq(Long modelId) {
        QFilter qf = new QFilter("model", "in", (Object)modelId);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"eb_schemeassign", (String)"assignseq", (QFilter[])new QFilter[]{qf}, (String)"assignseq desc", (int)1);
        if (dynamicObjects == null || dynamicObjects.size() == 0) {
            return 0;
        }
        return ((DynamicObject)dynamicObjects.get(0)).getInt("assignseq");
    }

    public DynamicObject[] queryRecordByModel(Long modelId, Set<Long> schemeIds) {
        QFilter qf = new QFilter("model", "in", (Object)modelId);
        qf.and("scheme", "in", schemeIds);
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"eb_schemeassign", (String)"id", (QFilter[])new QFilter[]{qf});
        if (dynamicObjectCollection == null) {
            return new DynamicObject[0];
        }
        Set ids = dynamicObjectCollection.stream().map(x -> x.getLong("id")).collect(Collectors.toSet());
        return (DynamicObject[])BusinessDataServiceHelper.load((Object[])ids.toArray(), (IDataEntityType)ORM.create().getDataEntityType("eb_schemeassign"));
    }

    public DynamicObject[] queryRecordByQFilters(List<QFilter> qFilters) {
        return this.queryRecordByQFilters(null, qFilters);
    }

    public DynamicObject[] queryRecordByQFilters(Long modelId, List<QFilter> qFilters) {
        DynamicObjectCollection dynamicObjectCollection;
        LinkedList<QFilter> qFilterList = new LinkedList<QFilter>();
        if (IDUtils.isNotNull((Long)modelId)) {
            qFilterList.add(new QFilter("model", "=", (Object)modelId));
        }
        if (qFilters != null) {
            qFilterList.addAll(qFilters);
        }
        if ((dynamicObjectCollection = QueryServiceHelper.query((String)"eb_schemeassign", (String)"id", (QFilter[])qFilterList.toArray(new QFilter[0]))) == null) {
            return new DynamicObject[0];
        }
        Set ids = dynamicObjectCollection.stream().map(x -> x.getLong("id")).collect(Collectors.toSet());
        return (DynamicObject[])BusinessDataServiceHelper.load((Object[])ids.toArray(), (IDataEntityType)ORM.create().getDataEntityType("eb_schemeassign"));
    }

    public DynamicObjectCollection queryRecordByScheme(List<Long> schemeIds) {
        String selects = "id,scheme,year,datatype,version,assigner,assigntime,assignseq,bizrange,model,applyscope";
        QFilter qf = new QFilter("scheme", "in", schemeIds);
        return QueryServiceHelper.query((String)"eb_schemeassign", (String)selects, (QFilter[])new QFilter[]{qf}, (String)"assigntime asc");
    }

    public void deleteAssignRecord(List<Long> ids) {
        DeleteServiceHelper.delete((String)"eb_schemeassign", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
    }

    public static Boolean checkSchemeAssgin(Long year, Long version, Long datatype, Long scheme) {
        QFBuilder qfBuilder = new QFBuilder("scheme", "=", (Object)scheme);
        qfBuilder.add("year", "=", (Object)year);
        qfBuilder.add("version", "=", (Object)version);
        qfBuilder.add("datatype", "=", (Object)datatype);
        return QueryServiceHelper.exists((String)"eb_schemeassign", (QFilter[])qfBuilder.toArrays());
    }

    public DynamicObjectCollection querySchemesGroup(Long year, Long version, Long datatype, Long model) {
        if (model == null || model == 0L) {
            return null;
        }
        String selectFields = "id,scheme,scheme.name,year,year.name,datatype,datatype.name,version,version.name,bizrange";
        QFBuilder qfBuilder = new QFBuilder("model", "in", (Object)model);
        if (year != null) {
            qfBuilder.add("year", "=", (Object)year);
        }
        if (version != null) {
            qfBuilder.add("version", "=", (Object)version);
        }
        if (datatype != null) {
            qfBuilder.add("datatype", "=", (Object)datatype);
        }
        return QueryServiceHelper.query((String)"eb_schemeassign", (String)selectFields, (QFilter[])qfBuilder.toArrays(), (String)"assigntime asc,scheme.number");
    }

    public void updateModifyMsg(Set<Long> ids, OrmLocaleValue description, String schemetext) {
        if (ids != null && !ids.isEmpty()) {
            QFilter qFilter = new QFilter("id", "in", ids);
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"eb_schemeassign", (String)"id, name,assigner, assigntime, description", (QFilter[])qFilter.toArray());
            Date date = new Date();
            for (DynamicObject dynamicObject : dynamicObjects) {
                dynamicObject.set("assigner", (Object)UserUtils.getUserId());
                dynamicObject.set("assigntime", (Object)date);
                if (description.isEmpty() || StringUtils.isEmpty((String)description.getLocaleValue())) {
                    dynamicObject.set("description", null);
                } else {
                    dynamicObject.set("description", (Object)description);
                }
                dynamicObject.set("name", (Object)schemetext);
            }
            SaveServiceHelper.update((DynamicObject[])dynamicObjects);
        }
    }

    public Set<Long> getPeriodsOfSchemeHasApTem(Long modelId) {
        HashSet<Long> periods = new HashSet<Long>(16);
        HashSet<Long> schemeIds = new HashSet<Long>(16);
        String sql = "select fid from t_eb_rptscheme where fmodelid = " + modelId;
        try (DataSet ds = DB.queryDataSet((String)"query_curmodel_schemes", (DBRoute)BgBaseConstant.epm, (String)sql);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                schemeIds.add(row.getLong("fid"));
            }
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        if (schemeIds.size() < 1) {
            return periods;
        }
        HashSet<Long> hasApplyTemSchemeIds = new HashSet<Long>(16);
        String sql1 = "select fschemeid from t_eb_templateorg where ftemplatetype = '1' and fschemeid in (" + SqlBatchUtils.getBatchParamsSql((int)schemeIds.size()) + ")";
        try (DataSet ds = DB.queryDataSet((String)"query_applytemplate_allocate_record", (DBRoute)BgBaseConstant.epm, (String)sql1, (Object[])schemeIds.toArray());){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                hasApplyTemSchemeIds.add(row.getLong("fschemeid"));
            }
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        if (hasApplyTemSchemeIds.size() < 1) {
            return periods;
        }
        String sql2 = "select fyearid from t_eb_schemeassign where fschemeid in (" + SqlBatchUtils.getBatchParamsSql((int)hasApplyTemSchemeIds.size()) + ")";
        try (DataSet ds = DB.queryDataSet((String)"query_assignRecord_period", (DBRoute)BgBaseConstant.epm, (String)sql2, (Object[])hasApplyTemSchemeIds.toArray());){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                periods.add(row.getLong("fyearid"));
            }
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        return periods;
    }

    public Map<Long, Map<String, Object>> getSchemeVariableInfo(List<Long> schemeIds) {
        LinkedHashMap<Long, Map<String, Object>> varInfo = new LinkedHashMap<Long, Map<String, Object>>(schemeIds.size() * 5);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_schemeassign", (String)"id,scheme,assigntime", (QFilter[])new QFilter("scheme", "in", schemeIds).toArray());
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject dynamicObject : query) {
            DynamicObject value = (DynamicObject)map.get(dynamicObject.getLong("scheme"));
            if (value == null) {
                map.put(dynamicObject.getLong("scheme"), dynamicObject);
                continue;
            }
            if (dynamicObject.getDate("assigntime").compareTo(value.getDate("assigntime")) <= 0) continue;
            map.put(dynamicObject.getLong("scheme"), dynamicObject);
        }
        if (map.isEmpty()) {
            return varInfo;
        }
        List<Long> assignIds = map.values().stream().map(x -> x.getLong("id")).collect(Collectors.toList());
        return this.getSchemeVariableByAssignId(assignIds);
    }

    public Map<Long, Map<String, Object>> getSchemeVariableByAssignId(List<Long> assignIds) {
        LinkedHashMap<Long, Map<String, Object>> varInfo = new LinkedHashMap<Long, Map<String, Object>>(assignIds.size() * 5);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append(" select v.fdimension,v.fvariablenumber,v.fvariable,v.fvariablejsontext from t_eb_schemevariable v ", new Object[0]);
        sqlBuilder.append(" where ", new Object[0]);
        sqlBuilder.appendIn(" v.fid", assignIds.toArray(new Object[0]));
        sqlBuilder.append(" order by v.fseq", new Object[0]);
        try (DataSet rows = DB.queryDataSet((String)"getSchemeVariableInfo", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);){
            while (rows.hasNext()) {
                Row memberRow = rows.next();
                Long varId = memberRow.getLong("fvariablenumber");
                HashMap<String, Object> data = new HashMap<String, Object>(16);
                data.put("dimension", memberRow.get("fdimension"));
                data.put("variable", memberRow.get("fvariablenumber"));
                data.put("variableValue", memberRow.getString("fvariable"));
                data.put("variableJson", memberRow.getString("fvariablejsontext"));
                varInfo.put(varId, data);
            }
        }
        return varInfo;
    }

    public void getSchemeTemplateInfoMap(Set<Long> schemeIds, List<Long> budgetTemplateIds, Set<Long> applyTemplateIds) {
        DynamicObjectCollection allocateRecord = QueryServiceHelper.query((String)"eb_templateorg", (String)"templatetype,template,applytemplate", (QFilter[])new QFilter("scheme", "in", schemeIds).toArray());
        if (allocateRecord != null && allocateRecord.size() > 0) {
            for (DynamicObject record : allocateRecord) {
                String templateType = record.getString("templatetype");
                if ("1".equals(templateType)) {
                    applyTemplateIds.add(record.getLong("applytemplate"));
                    continue;
                }
                budgetTemplateIds.add(record.getLong("template"));
            }
        }
    }

    public Map<Long, String> getSchemeAssignInfoUseOfTip(Set<Long> schemeAssignRecordIds) {
        if (schemeAssignRecordIds.isEmpty()) {
            return new HashMap<Long, String>(0);
        }
        String selectFields = "year.name,version.name,datatype.name,scheme.name,scheme.number,id,name";
        QFilter qFilter = new QFilter("id", "in", schemeAssignRecordIds);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_schemeassign", (String)selectFields, (QFilter[])qFilter.toArray());
        if (CollectionUtils.isEmpty((Collection)query)) {
            return new HashMap<Long, String>(0);
        }
        HashMap<Long, String> schemeAssignInfo = new HashMap<Long, String>(16);
        for (DynamicObject assignRecord : query) {
            long schemeAssignRecordId = assignRecord.getLong("id");
            String assignSchemeName = StringUtils.isNotEmpty((String)assignRecord.getString("name")) ? assignRecord.getString("name") : assignRecord.getString("scheme.name");
            String assignStr = assignSchemeName + "-" + assignRecord.getString("year.name") + "-" + assignRecord.getString("version.name") + "-" + assignRecord.getString("datatype.name");
            schemeAssignInfo.put(schemeAssignRecordId, assignStr);
        }
        return schemeAssignInfo;
    }
}

