/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.reportscheme.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.reportprocess.entity.domain.ReportProcess;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import org.apache.commons.collections4.CollectionUtils;

public class ReportSchemeTemplateSortService {
    private static final ReportSchemeTemplateSortService instance = new ReportSchemeTemplateSortService();

    public static ReportSchemeTemplateSortService getInstance() {
        return instance;
    }

    private ReportSchemeTemplateSortService() {
    }

    public Map<Long, Integer> getTemplateSortMap(Long relationId) {
        QFilter qFilter = new QFilter("relation", "=", (Object)relationId);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_templatesort_scheme", (String)"entryentity.template, entryentity.order", (QFilter[])qFilter.toArray());
        LinkedHashMap<Long, Integer> templateSortMap = new LinkedHashMap<Long, Integer>(16);
        if (CollectionUtils.isNotEmpty((Collection)query)) {
            for (DynamicObject dynamicObject : query) {
                templateSortMap.put(dynamicObject.getLong("entryentity.template"), dynamicObject.getInt("entryentity.order"));
            }
        }
        return templateSortMap;
    }

    public DataSet queryTemplateByScheme(Long schemeId) {
        QFilter qFilter = new QFilter("scheme", "=", (Object)schemeId);
        qFilter.and("templatetype", "=", (Object)"0");
        return QueryServiceHelper.queryDataSet((String)"queryTemplateByScheme", (String)"eb_templateorg", (String)"template, template.number, template.name, template.templatecatalog.name", (QFilter[])qFilter.toArray(), (String)"template.number asc");
    }

    public Map<Long, Integer> getTemplateSortMap(Long relationId, Set<Long> templateIds) {
        List collect;
        HashMap<Long, Integer> result = new HashMap<Long, Integer>(16);
        if (CollectionUtils.isEmpty(templateIds) || IDUtils.isEmptyLong((Long)relationId).booleanValue()) {
            return result;
        }
        if (templateIds.size() == 1) {
            return result;
        }
        DynamicObjectCollection templateCollection = QueryServiceHelper.query((String)"eb_templateentity", (String)"number, id", (QFilter[])new QFilter[]{new QFilter("id", "in", templateIds)}, (String)"number asc");
        Map<Long, Integer> templateSortMap = this.getTemplateSortMap(relationId);
        ArrayList<DynamicObject> templateCollectionBySort = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> templateCollectionByNoSort = new ArrayList<DynamicObject>(16);
        if (templateSortMap != null && templateSortMap.size() > 0) {
            for (DynamicObject dynamicObject : templateCollection) {
                long templateId = dynamicObject.getLong("id");
                Integer order = templateSortMap.get(templateId);
                if (order == null) {
                    templateCollectionByNoSort.add(dynamicObject);
                    continue;
                }
                templateCollectionBySort.add(dynamicObject);
            }
            List collectBySort = templateCollectionBySort.stream().sorted((o1, o2) -> {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null) {
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                Long templateId1 = o1.getLong("id");
                Long templateId2 = o2.getLong("id");
                Integer order1 = (Integer)templateSortMap.get(templateId1);
                Integer order2 = (Integer)templateSortMap.get(templateId2);
                if (order1 == null && order2 == null) {
                    return 0;
                }
                if (order1 == null) {
                    return 1;
                }
                if (order2 == null) {
                    return -1;
                }
                return order1 - order2;
            }).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(templateCollectionByNoSort)) {
                List collectByNoSort = templateCollectionByNoSort.stream().sorted((o1, o2) -> {
                    if (o1 == null && o2 == null) {
                        return 0;
                    }
                    if (o1 == null) {
                        return 1;
                    }
                    if (o2 == null) {
                        return -1;
                    }
                    String number1 = o1.getString("number");
                    String number2 = o2.getString("number");
                    if (StringUtils.isEmpty((String)number1) && StringUtils.isEmpty((String)number2)) {
                        return 0;
                    }
                    if (StringUtils.isEmpty((String)number1)) {
                        return 1;
                    }
                    if (StringUtils.isEmpty((String)number2)) {
                        return -1;
                    }
                    return number1.compareTo(number2);
                }).collect(Collectors.toList());
                collectBySort.addAll(collectByNoSort);
            }
            collect = collectBySort;
        } else {
            collect = templateCollection.stream().sorted((o1, o2) -> {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null) {
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                String number1 = o1.getString("number");
                String number2 = o2.getString("number");
                if (StringUtils.isEmpty((String)number1) && StringUtils.isEmpty((String)number2)) {
                    return 0;
                }
                if (StringUtils.isEmpty((String)number1)) {
                    return 1;
                }
                if (StringUtils.isEmpty((String)number2)) {
                    return -1;
                }
                return number1.compareTo(number2);
            }).collect(Collectors.toList());
        }
        int order = 0;
        for (DynamicObject dynamicObject : collect) {
            result.put(dynamicObject.getLong("id"), order++);
        }
        return result;
    }

    public List<Long> getTemplateIdsBySort(Long relationId, Set<Long> templateIds) {
        List<Long> result = new ArrayList<Long>(16);
        if (CollectionUtils.isEmpty(templateIds) || IDUtils.isEmptyLong((Long)relationId).booleanValue()) {
            return result;
        }
        Map<Long, Integer> templateSortMap = this.getTemplateSortMap(relationId, templateIds);
        result = templateSortMap != null && templateSortMap.size() > 0 ? templateIds.stream().sorted((o1, o2) -> {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            Integer templateSeq1 = (Integer)templateSortMap.get(o1);
            Integer templateSeq2 = (Integer)templateSortMap.get(o2);
            if (templateSeq1 == null && templateSeq2 == null) {
                return 0;
            }
            if (templateSeq1 == null) {
                return 1;
            }
            if (templateSeq2 == null) {
                return -1;
            }
            return templateSeq1 - templateSeq2;
        }).collect(Collectors.toList()) : new ArrayList<Long>(templateIds);
        return result;
    }

    public TableValueSetter getTemplateSortListTableValueSetter(Long schemeId, boolean reset) {
        TableValueSetter tableValueSetter = new TableValueSetter(new String[]{"templateid", "templatenumber", "templatename", "templatecatalog"});
        List<Object> sortMapList = new ArrayList(16);
        HashSet<Long> templateIds = new HashSet<Long>(16);
        DataSet dataSet = this.queryTemplateByScheme(schemeId);
        Object object = null;
        try {
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long templateId = row.getLong("template");
                if (templateIds.contains(templateId)) continue;
                templateIds.add(templateId);
                String templateNumber = row.getString("template.number");
                String templateName = row.getString("template.name");
                String templateCatalogName = row.getString("template.templatecatalog.name");
                Object[] map = new Object[]{templateId, templateNumber, templateName, templateCatalogName};
                sortMapList.add(map);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        Map<Long, Integer> templateSortMap = this.getTemplateSortMap(schemeId, templateIds);
        if (templateSortMap != null && templateSortMap.size() > 0) {
            sortMapList = sortMapList.stream().sorted((o1, o2) -> {
                int seq;
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null) {
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                if (o1[0] == null && o2[0] == null) {
                    return 0;
                }
                if (o1[0] == null) {
                    return 1;
                }
                if (o2[0] == null) {
                    return -1;
                }
                Long templateId1 = IDUtils.toLong((Object)o1[0]);
                Long templateId2 = IDUtils.toLong((Object)o2[0]);
                if (!reset) {
                    Integer order1 = (Integer)templateSortMap.get(templateId1);
                    Integer order2 = (Integer)templateSortMap.get(templateId2);
                    if (order1 == null && order2 == null) {
                        return 0;
                    }
                    if (order1 == null) {
                        return 1;
                    }
                    if (order2 == null) {
                        return -1;
                    }
                    seq = order1 - order2;
                } else {
                    String templateNum1 = o1[1] + "";
                    String templateNum2 = o2[1] + "";
                    seq = templateNum1.compareTo(templateNum2);
                }
                return seq;
            }).collect(Collectors.toList());
        }
        for (Object[] objectArray : sortMapList) {
            if (objectArray == null || objectArray[0] == null) continue;
            tableValueSetter.addRow(new Object[]{objectArray[0], objectArray[1], objectArray[2], objectArray[3]});
        }
        return tableValueSetter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveTemplateSort(Long modelId, Long schemeId, DynamicObjectCollection entryEntity) {
        DynamicObject toSaveObj = BusinessDataServiceHelper.newDynamicObject((String)"eb_templatesort_scheme");
        toSaveObj.set("model", (Object)modelId);
        toSaveObj.set("relation", (Object)schemeId);
        toSaveObj.set("creater", (Object)UserUtils.getUserId());
        toSaveObj.set("status", (Object)"1");
        DynamicObjectCollection toSaveEntryEntity = toSaveObj.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isNotEmpty((Collection)entryEntity)) {
            int index = 0;
            for (DynamicObject dynamicObject : entryEntity) {
                DynamicObject dynamicObject1 = toSaveEntryEntity.addNew();
                dynamicObject1.set("template", (Object)dynamicObject.getLong("templateid"));
                dynamicObject1.set("order", (Object)index++);
            }
            try (DLock lock = DLock.create((String)("eb/saveTemplateSort/" + schemeId));){
                boolean isLock = lock.tryLock(5000L);
                try {
                    if (!isLock) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u6709\u7528\u6237\u6b63\u5728\u5bf9\u6b64\u65b9\u6848\u8fdb\u884c\u6a21\u677f\u987a\u5e8f\u7684\u4fdd\u5b58\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"ReportSchemeTemplateSortService_01", (String)"epm-eb-business", (Object[])new Object[0]));
                    }
                    this.deleteTemplateSortByRelation(schemeId);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{toSaveObj});
                }
                finally {
                    if (isLock) {
                        lock.unlock();
                    }
                }
            }
        }
    }

    public void deleteTemplateSortByRelation(Long relation) {
        this.deleteTemplateSortByRelation(Collections.singleton(relation));
    }

    public void deleteTemplateSortByRelation(Set<Long> relationIds) {
        QFilter qFilter = new QFilter("relation", "in", relationIds);
        if (QueryServiceHelper.exists((String)"eb_templatesort_scheme", (QFilter[])qFilter.toArray())) {
            DeleteServiceHelper.delete((String)"eb_templatesort_scheme", (QFilter[])qFilter.toArray());
        }
    }

    public boolean schemeHasAssignBudgetTemplate(Long schemeId) {
        QFilter qFilter = new QFilter("scheme", "=", (Object)schemeId);
        qFilter.and("templatetype", "=", (Object)"0");
        return QueryServiceHelper.exists((String)"eb_templateorg", (QFilter[])new QFilter[]{qFilter});
    }

    public void copyTemplateSort(Long sourceRelationId, Set<Long> targetRelationIds) {
        if (IDUtils.isEmptyLong((Long)sourceRelationId).booleanValue() || CollectionUtils.isEmpty(targetRelationIds)) {
            return;
        }
        QFilter qFilter = new QFilter("relation", "=", (Object)sourceRelationId);
        if (!QueryServiceHelper.exists((String)"eb_templatesort_scheme", (QFilter[])qFilter.toArray())) {
            return;
        }
        DynamicObject sourceObject = BusinessDataServiceHelper.loadSingle((String)"eb_templatesort_scheme", (String)"id,model,status,entryentity,entryentity.template,entryentity.order", (QFilter[])qFilter.toArray());
        if (sourceObject == null || sourceObject.get("id") == null) {
            return;
        }
        ArrayList<DynamicObject> toSaveObjects = new ArrayList<DynamicObject>(16);
        for (Long targetRelationId : targetRelationIds) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"eb_templatesort_scheme");
            dynamicObject.set("model", sourceObject.get("model"));
            dynamicObject.set("relation", (Object)targetRelationId);
            dynamicObject.set("status", sourceObject.get("status"));
            dynamicObject.set("creater", (Object)UserUtils.getUserId());
            DynamicObjectCollection targetEntryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
            DynamicObjectCollection sourceEntryEntity = sourceObject.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isNotEmpty((Collection)sourceEntryEntity)) {
                for (DynamicObject object : sourceEntryEntity) {
                    DynamicObject dynamicObject1 = targetEntryEntity.addNew();
                    dynamicObject1.set("template", object.get("template"));
                    dynamicObject1.set("order", object.get("order"));
                }
            }
            toSaveObjects.add(dynamicObject);
        }
        this.deleteTemplateSortByRelation(targetRelationIds);
        SaveServiceHelper.save((DynamicObject[])toSaveObjects.toArray(new DynamicObject[0]));
    }

    public void copyTemplateSort(Long sourceRelationId, Long targetRelationId) {
        this.copyTemplateSort(sourceRelationId, Collections.singleton(targetRelationId));
    }

    public void sortTemplateForExport(List<ReportProcess> currentEntityAllReportProcess, Set<Long> exportByOrgTemplateIdSet, Long relationId) {
        if (CollectionUtils.isEmpty(currentEntityAllReportProcess) || CollectionUtils.isEmpty(exportByOrgTemplateIdSet)) {
            return;
        }
        Map<Long, Integer> templateSortMap = this.getTemplateSortMap(relationId, exportByOrgTemplateIdSet);
        currentEntityAllReportProcess.sort((o1, o2) -> {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            Long templateId1 = o1.getTemplateId();
            Long templateId2 = o2.getTemplateId();
            Integer order1 = (Integer)templateSortMap.get(templateId1);
            Integer order2 = (Integer)templateSortMap.get(templateId2);
            if (order1 == null && order2 == null) {
                return 0;
            }
            if (order1 == null) {
                return 1;
            }
            if (order2 == null) {
                return -1;
            }
            return order1.compareTo(order2);
        });
    }
}

