/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.rpa;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.epm.eb.business.rpa.RpaConstants;
import kd.epm.eb.business.rpa.dao.RpaIntegrationCellDao;
import kd.epm.eb.business.rpa.model.CellAreaMapping;
import kd.epm.eb.business.rpa.model.CellMapping;
import kd.epm.eb.common.utils.ExcelUtils;
import kd.epm.eb.common.utils.Point;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.afix.multimanager.MultiAreaManager;
import kd.epm.eb.spread.template.afix.multisetting.IMultiAreaSetting;
import kd.epm.eb.spread.template.afix.multisetting.MultiAreaSetting;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class CellMappingService {
    public static int isInFloatArea(int row, int col, List<Pair<Integer[], List<Integer[]>>> allAreaList) {
        for (Pair<Integer[], List<Integer[]>> pair : allAreaList) {
            Integer[] areaInt = (Integer[])pair.getKey();
            List floatAreaInts = (List)pair.getValue();
            for (Integer[] floatArea : floatAreaInts) {
                if (floatArea[0] > row || floatArea[1] > col || floatArea[2] < row || floatArea[3] < col) continue;
                if (floatArea[0] == row) {
                    return 1;
                }
                return 2;
            }
            if (areaInt[0] > row || areaInt[1] > col || areaInt[2] < row || areaInt[3] < col) continue;
            return 3;
        }
        return 4;
    }

    public static Map<String, List<String>> getFloatArea(IEbSpreadManager spreadManager, ITemplateModel templateModel) {
        LinkedHashMap<String, List<String>> areaMap = new LinkedHashMap<String, List<String>>(16);
        List areaSettings = templateModel.getAreaRanges();
        if (CollectionUtils.isEmpty((Collection)areaSettings)) {
            return areaMap;
        }
        List areaManagers = spreadManager.getMultiAreaManager();
        for (int i = 0; i < areaManagers.size(); ++i) {
            MultiAreaManager areaManager = (MultiAreaManager)areaManagers.get(i);
            IMultiAreaSetting areaSetting = (IMultiAreaSetting)areaSettings.get(i);
            String areaRange = areaManager.getAreaRange().toString();
            if (StringUtils.isBlank((CharSequence)areaRange)) continue;
            HashMap<Integer, String> floatMap = new HashMap<Integer, String>(16);
            ArrayList<Integer> floatIndexList = new ArrayList<Integer>(16);
            String[] areaArr = areaRange.split(":");
            Point startPoint = ExcelUtils.pos2Point((String)areaArr[0]);
            Point endPoint = areaArr.length == 1 ? ExcelUtils.pos2Point((String)areaArr[0]) : ExcelUtils.pos2Point((String)areaArr[1]);
            String[] dataStartPoint = areaManager.getStartpoint().split(":");
            int dataStartRow = Integer.parseInt(dataStartPoint[1]) + startPoint.y;
            int dataStartCol = Integer.parseInt(dataStartPoint[0]) + startPoint.x;
            int delRowSize = areaManager.getColpartitionDims().size();
            int delColSize = areaManager.getRowpartitionDims().size();
            if (CollectionUtils.isNotEmpty((Collection)areaSetting.getFloatInfos())) {
                for (MultiAreaSetting.FloatInfo floatInfo : areaSetting.getFloatInfos()) {
                    int floatRowOffset = floatInfo.getRow_offset();
                    int floatRowEnd = floatInfo.getRowEnd_offset();
                    int floatColOffset = floatInfo.getCol_offset();
                    int realRowStart = dataStartRow + (floatRowOffset > 0 ? floatRowOffset - delRowSize : 0);
                    int realRowEnd = realRowStart + (floatRowEnd - floatRowOffset);
                    int realColStart = dataStartCol + (floatColOffset > 0 ? floatColOffset - delColSize : 0);
                    int realColEnd = endPoint.x;
                    String floatStartPos = ExcelUtils.xy2Pos((int)realColStart, (int)realRowStart);
                    String floatEndPos = ExcelUtils.xy2Pos((int)realColEnd, (int)realRowEnd);
                    floatMap.put(floatRowOffset, floatStartPos + ":" + floatEndPos);
                    floatIndexList.add(floatRowOffset);
                }
            }
            List<Object> floatRangeList = Collections.emptyList();
            if (floatIndexList.size() > 0) {
                floatRangeList = CellMappingService.sortAreaRangeList(floatIndexList, floatMap);
            }
            areaMap.put(areaRange, floatRangeList);
        }
        return areaMap;
    }

    private static List<String> sortAreaRangeList(List<Integer> areaRangeList, Map<Integer, String> floatMap) {
        Collections.sort(areaRangeList);
        LinkedList<String> newList = new LinkedList<String>();
        for (Integer integer : areaRangeList) {
            newList.add(floatMap.get(integer));
        }
        return newList;
    }

    public static void saveMappingCell(JSONObject dataCacheMap, Long sheetId, Long rpaIntegrationId, IEbSpreadManager spreadManager, Map<String, List<String>> areaMap, String enumFieldConfig) {
        boolean hasMapping = false;
        Map<String, Object> mappingData = CellMappingService.getOrderData(dataCacheMap, spreadManager, areaMap);
        if (MapUtils.isNotEmpty(mappingData)) {
            hasMapping = true;
        }
        RpaIntegrationCellDao.getInstance().save(rpaIntegrationId, sheetId, JSONObject.toJSONString(mappingData), hasMapping, enumFieldConfig);
    }

    private static Map<String, Object> getOrderData(JSONObject dataCacheMap, IEbSpreadManager spreadManager, Map<String, List<String>> areaMap) {
        List areaManagers = spreadManager.getMultiAreaManager();
        if (CollectionUtils.isEmpty((Collection)areaManagers)) {
            return Collections.emptyMap();
        }
        if (MapUtils.isEmpty((Map)dataCacheMap)) {
            return Collections.emptyMap();
        }
        int areaIndex = 0;
        int totalFloatArea = 0;
        LinkedHashMap<String, List<CellMapping>> dataMap = new LinkedHashMap<String, List<CellMapping>>(16);
        LinkedHashMap<String, JSONObject> floatIndexMap = new LinkedHashMap<String, JSONObject>(16);
        for (MultiAreaManager areaManager : areaManagers) {
            String areaRange = areaManager.getAreaRange().toString();
            List<String> floatArea = areaMap.get(areaRange);
            List<Integer[]> floatAreaInt = CellMappingService.getAreaInt(floatArea);
            String[] areaArr = areaRange.split(":");
            Point startPoint = ExcelUtils.pos2Point((String)areaArr[0]);
            Point endPoint = areaArr.length == 1 ? ExcelUtils.pos2Point((String)areaArr[0]) : ExcelUtils.pos2Point((String)areaArr[1]);
            boolean inFloatFlag = false;
            for (int row = startPoint.y; row <= endPoint.y; ++row) {
                for (int col = startPoint.x; col <= endPoint.x; ++col) {
                    String dataKey;
                    String ebCell = row + "#" + col;
                    CellMapping cellMapping = (CellMapping)dataCacheMap.getObject(ebCell, CellMapping.class);
                    if (cellMapping == null) continue;
                    Pair<Boolean, Integer> floatResult = CellMappingService.inFloatArea(row, col, floatAreaInt);
                    boolean inFloat = (Boolean)floatResult.getLeft();
                    if (inFloatFlag ^ inFloat) {
                        ++areaIndex;
                    }
                    inFloatFlag = inFloat;
                    if (!inFloat) {
                        dataKey = "g_" + areaIndex;
                    } else {
                        Integer floatIndex = (Integer)floatResult.getRight();
                        dataKey = "f_" + areaIndex + "_" + floatIndex;
                        if (!floatIndexMap.containsKey(dataKey)) {
                            JSONObject floatInfo = new JSONObject();
                            floatInfo.fluentPut("index", (Object)(totalFloatArea + floatIndex)).fluentPut("area", (Object)floatArea.get(floatIndex));
                            floatIndexMap.put(dataKey, floatInfo);
                        }
                    }
                    CellMappingService.setOrderValue(dataMap, dataKey, cellMapping);
                }
            }
            totalFloatArea += floatArea.size();
        }
        ArrayList caList = new ArrayList(dataMap.size());
        dataMap.forEach((k, v) -> caList.add(new CellAreaMapping((String)k, (List<CellMapping>)v)));
        HashMap<String, Object> mappingData = new HashMap<String, Object>(2);
        mappingData.put("data", caList);
        mappingData.put("floatIndexMap", floatIndexMap);
        return mappingData;
    }

    private static void setOrderValue(Map<String, List<CellMapping>> dataMap, String dataKey, CellMapping cellMapping) {
        List dataList = dataMap.computeIfAbsent(dataKey, k -> new ArrayList(256));
        dataList.add(cellMapping);
    }

    private static Pair<Boolean, Integer> inFloatArea(int row, int col, List<Integer[]> floatAreaInt) {
        for (int i = 0; i < floatAreaInt.size(); ++i) {
            Integer[] area = floatAreaInt.get(i);
            if (area == null || area[0] > row || area[2] < row || area[1] > col || area[3] < col) continue;
            return Pair.of((Object)Boolean.TRUE, (Object)i);
        }
        return Pair.of((Object)Boolean.FALSE, (Object)0);
    }

    public static List<Integer[]> getAreaInt(List<String> areas) {
        return areas.stream().map(area -> {
            String[] areaArr = area.split(":");
            Point startPoint = ExcelUtils.pos2Point((String)areaArr[0]);
            Point endPoint = areaArr.length == 1 ? ExcelUtils.pos2Point((String)areaArr[0]) : ExcelUtils.pos2Point((String)areaArr[1]);
            return new Integer[]{startPoint.y, startPoint.x, endPoint.y, endPoint.x};
        }).collect(Collectors.toList());
    }

    public static RpaConstants.FileType getWorkbookType(String url) {
        String fileType = url.substring(url.lastIndexOf("."));
        if (".xls".equalsIgnoreCase(fileType)) {
            return RpaConstants.FileType.XLS;
        }
        if (".xlsx".equalsIgnoreCase(fileType)) {
            return RpaConstants.FileType.XLSX;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u9644\u4ef6\u8bfb\u53d6\u9519\u8bef", (String)"CellMappingService_1", (String)"epm-eb-business", (Object[])new Object[0]));
    }

    public static Workbook getWorkbook(String url, RpaConstants.FileType type) {
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        InputStream ins = fileService.getInputStream(url);
        HSSFWorkbook xwb = null;
        try {
            if (type == RpaConstants.FileType.XLS) {
                xwb = new HSSFWorkbook(ins);
            } else if (type == RpaConstants.FileType.XLSX) {
                xwb = new XSSFWorkbook(ins);
            }
        }
        catch (IOException e1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9644\u4ef6\u8bfb\u53d6\u9519\u8bef", (String)"CellMappingService_1", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        if (xwb == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9644\u4ef6\u8bfb\u53d6\u9519\u8bef", (String)"CellMappingService_1", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        return xwb;
    }
}

