/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.rpa;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class JoinCheerExcelService {
    private static final Log log = LogFactory.getLog(JoinCheerExcelService.class);

    public static JoinCheerExcelService getInstance() {
        return InnerClass.instance;
    }

    private JoinCheerExcelService() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> getSheetNameList(String fileUrl) {
        FileService fs = FileServiceFactory.getAttachmentFileService();
        try (InputStream in = fs.getInputStream(fileUrl);){
            int i;
            HSSFWorkbook wb;
            ArrayList<String> names = new ArrayList<String>();
            String fileType = fileUrl.substring(fileUrl.lastIndexOf("."));
            if (".xls".equalsIgnoreCase(fileType)) {
                wb = new HSSFWorkbook(in);
                for (i = 0; i < wb.getNumberOfSheets(); ++i) {
                    names.add(wb.getSheetAt(i).getSheetName());
                }
            } else if (".xlsx".equalsIgnoreCase(fileType)) {
                wb = new XSSFWorkbook(in);
                for (i = 0; i < wb.getNumberOfSheets(); ++i) {
                    names.add(wb.getSheetAt(i).getSheetName());
                }
            }
            ArrayList<String> arrayList = names;
            return arrayList;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    private static class InnerClass {
        private static final JoinCheerExcelService instance = new JoinCheerExcelService();

        private InnerClass() {
        }
    }
}

