/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.rpa;

import com.alibaba.fastjson.JSON;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.epm.eb.business.rpa.RpaConstants;
import kd.epm.eb.business.rpa.dao.RpaTaskLogDao;
import kd.epm.eb.business.rpa.entity.RpaScheme;
import kd.epm.eb.common.thread.EpmThreadPools;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class RpaService {
    private static final Log log = LogFactory.getLog(RpaService.class);
    private static final String LOG_PREFIX = "EB-RPA";
    private static final String CLOUD_ID = "rpac";
    private static final String APP_ID = "rpacp";
    private static final String SERVICE_NAME = "RpaService";

    public static RpaService getInstance() {
        return InnerClass.instance;
    }

    private RpaService() {
    }

    public List<Map<String, Object>> getProcessList() {
        String methodName = "getProcessList";
        long userId = RequestContext.get().getCurrUserId();
        return (List)DispatchServiceHelper.invokeBizService((String)CLOUD_ID, (String)APP_ID, (String)SERVICE_NAME, (String)methodName, (Object[])new Object[]{String.valueOf(userId), null});
    }

    public String getProcessComboId(String id, String procCode) {
        return id + "#" + procCode;
    }

    public Pair<String, String> getProcessIdAndCode(String comboId) {
        String[] split = comboId.split("#");
        return Pair.of((Object)split[0], (Object)split[1]);
    }

    public List<Map<String, Object>> getRobotList(String processId) {
        String methodName = "getRobotList";
        log.info("{} call `{}` processId:{} ", new Object[]{LOG_PREFIX, methodName, processId});
        List robotList = (List)DispatchServiceHelper.invokeBizService((String)CLOUD_ID, (String)APP_ID, (String)SERVICE_NAME, (String)methodName, (Object[])new Object[]{processId});
        log.info("{} call `{}` processId:{} resp:{}", new Object[]{LOG_PREFIX, methodName, processId, robotList});
        return robotList;
    }

    public String addTask(String procCode, String robotId, String downloadFile, List<String> fileList, RpaScheme rpaScheme) {
        List<Map<String, Object>> rpaParams = null;
        try {
            rpaParams = this.getProcessParms(procCode);
        }
        catch (Exception e) {
            log.error("RPA getProcessParms error", (Throwable)e);
        }
        if (CollectionUtils.isNotEmpty(rpaParams)) {
            for (Map<String, Object> map : rpaParams) {
                if ("download_filename".equals(map.get("Name"))) {
                    map.put("Value", downloadFile);
                    continue;
                }
                if ("download_path".equals(map.get("Name"))) {
                    map.put("Value", rpaScheme.getExportPath());
                    continue;
                }
                if ("file_list".equals(map.get("Name"))) {
                    map.put("Value", JSON.toJSONString(fileList));
                    continue;
                }
                if (!"install_path".equals(map.get("Name")) || !StringUtils.isNotBlank((CharSequence)rpaScheme.getInstallPath())) continue;
                map.put("Value", rpaScheme.getInstallPath());
            }
        }
        String methodName = "addTask";
        if (StringUtils.isBlank((CharSequence)robotId)) {
            robotId = "deptall";
        }
        log.info("{} call `{}` procCode:{} robotId:{} param:{}", new Object[]{LOG_PREFIX, methodName, procCode, robotId, rpaParams});
        String taskId = (String)DispatchServiceHelper.invokeBizService((String)CLOUD_ID, (String)APP_ID, (String)SERVICE_NAME, (String)methodName, (Object[])new Object[]{procCode, robotId, null, rpaParams});
        RpaTaskLogDao.getInstance().saveTaskLog(taskId, procCode, "running", rpaScheme, RpaConstants.RpaLogType.RPA);
        log.info("{} call `{}` procCode:{} robotId:{} param:{} resp:{}", new Object[]{LOG_PREFIX, methodName, procCode, robotId, rpaParams, taskId});
        String traceId = RequestContext.getOrCreate().getTraceId();
        EpmThreadPools.CommPools.execute(() -> {
            RequestContext.getOrCreate().setTraceId(traceId);
            try {
                TimeUnit.SECONDS.sleep(120L);
                Map<String, Object> taskInfo = RpaService.getInstance().getTaskInfo(taskId);
                if (MapUtils.isNotEmpty(taskInfo)) {
                    RpaTaskLogDao.getInstance().updateStatus(taskId, taskInfo);
                }
            }
            catch (InterruptedException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        });
        return taskId;
    }

    public String getTaskLogUrl(String taskId) {
        String methodName = "getTaskLogUrl";
        log.info("{} call `{}` taskId:{}", new Object[]{LOG_PREFIX, methodName, taskId});
        String taskLogUrl = (String)DispatchServiceHelper.invokeBizService((String)CLOUD_ID, (String)APP_ID, (String)SERVICE_NAME, (String)methodName, (Object[])new Object[]{taskId});
        log.info("{} call `{}` taskId:{} resp:{}", new Object[]{LOG_PREFIX, methodName, taskId, taskLogUrl});
        return taskLogUrl;
    }

    public Map<String, Object> getTaskInfo(String taskId) {
        String methodName = "getTaskInfo";
        log.info("{} call `{}` taskId:{}", new Object[]{LOG_PREFIX, methodName, taskId});
        Map respMap = (Map)DispatchServiceHelper.invokeBizService((String)CLOUD_ID, (String)APP_ID, (String)SERVICE_NAME, (String)methodName, (Object[])new Object[]{taskId});
        log.info("{} call `{}` taskId:{} resp:{}", new Object[]{LOG_PREFIX, methodName, taskId, respMap == null ? null : respMap.toString()});
        return respMap;
    }

    public List<Map<String, Object>> getProcessParms(String procCode) {
        String methodName = "getProcessParms";
        log.info("{} call `{}` procCode:{}", new Object[]{LOG_PREFIX, methodName, procCode});
        List params = (List)DispatchServiceHelper.invokeBizService((String)CLOUD_ID, (String)APP_ID, (String)SERVICE_NAME, (String)methodName, (Object[])new Object[]{procCode, null});
        log.info("{} call `{}` procCode:{} resp:{}", new Object[]{LOG_PREFIX, methodName, procCode, params});
        return params;
    }

    private static class InnerClass {
        private static final RpaService instance = new RpaService();

        private InnerClass() {
        }
    }
}

