/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.rpa;

import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.epm.eb.business.rpa.dao.RpaIntegrationAttachmentDao;
import kd.epm.eb.business.rpa.model.JQReport;
import kd.epm.eb.business.rpa.model.JQTable;
import org.apache.commons.lang3.tuple.Pair;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class RpaXmlOperatorHelper {
    public static Map<String, JQReport> getReport(Long rpaIntegrationId) {
        LinkedHashMap<String, JQReport> tableMap = new LinkedHashMap<String, JQReport>(30);
        Map<String, Element> reportElement = RpaXmlOperatorHelper.getReportElement(rpaIntegrationId);
        reportElement.forEach((key, element) -> {
            String reportName = element.getName();
            String reportCode = element.attribute("code").getValue().toLowerCase();
            String reportDesc = element.attribute("description").getValue();
            JQReport jqReport = new JQReport(reportCode, reportName, reportDesc);
            tableMap.put(reportCode, jqReport);
            Iterator tableIte = element.elementIterator();
            if ("unitcat".equals(reportName)) {
                JQTable jqTable = new JQTable(reportCode, reportName);
                jqReport.getTables().put(reportCode, jqTable);
                while (tableIte.hasNext()) {
                    Element field = (Element)tableIte.next();
                    String index = field.attribute("index").getValue();
                    if ("1".equals(index) || "2".equals(index)) continue;
                    String fieldCode = field.attribute("code").getValue();
                    jqTable.getFields().add(fieldCode);
                    String fieldName = field.attribute("name").getValue();
                    jqTable.getFieldNames().put(fieldCode, fieldName);
                }
            } else {
                while (tableIte.hasNext()) {
                    Element table = (Element)tableIte.next();
                    String tableName = table.getName();
                    String tableCode = table.attribute("code").getValue().toLowerCase();
                    JQTable jqTable = new JQTable(tableCode, tableName);
                    jqReport.getTables().put(tableCode, jqTable);
                    Iterator fieldIte = table.elementIterator();
                    while (fieldIte.hasNext()) {
                        Element field = (Element)fieldIte.next();
                        String index = field.attribute("index").getValue();
                        if ("1".equals(index) || "2".equals(index)) continue;
                        String fieldCode = field.attribute("code").getValue();
                        jqTable.getFields().add(fieldCode);
                        String fieldName = field.attribute("name").getValue();
                        jqTable.getFieldNames().put(fieldCode, fieldName);
                    }
                }
            }
        });
        return tableMap;
    }

    private static Map<String, Element> getReportElement(Long rpaIntegrationId) {
        String xmlFileUrl = RpaIntegrationAttachmentDao.getInstance().getXmlFileUrl(rpaIntegrationId);
        Document document = RpaXmlOperatorHelper.initDocument(xmlFileUrl);
        Element root = document.getRootElement();
        Iterator reportIterator = root.elementIterator("report");
        LinkedHashMap<String, Element> result = new LinkedHashMap<String, Element>(16);
        while (reportIterator.hasNext()) {
            Element report = (Element)reportIterator.next();
            String num = report.attributeValue("code");
            result.put(num.toLowerCase(Locale.ENGLISH), report);
        }
        Iterator unitcatIterator = root.elementIterator("unitcat");
        while (unitcatIterator.hasNext()) {
            Element unitcat = (Element)unitcatIterator.next();
            String num = unitcat.attributeValue("code");
            result.put(num.toLowerCase(Locale.ENGLISH), unitcat);
        }
        return result;
    }

    private static Document initDocument(String url) {
        Document document;
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        try (InputStream ins = fileService.getInputStream(url);){
            SAXReader reader = new SAXReader();
            document = reader.read(ins);
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"xml\u6587\u4ef6\u5b58\u5728\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"RpaXmlOperatorHelper_1", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        return document;
    }

    public static String createXML(Long rpaIntegrationId, Map<String, Pair<String, StringBuilder>> csvFileMap) {
        String xmlFileUrl = RpaIntegrationAttachmentDao.getInstance().getXmlFileUrl(rpaIntegrationId);
        Document document = RpaXmlOperatorHelper.initDocument(xmlFileUrl);
        Element root = document.getRootElement();
        Iterator reportIterator = root.elementIterator("report");
        while (reportIterator.hasNext()) {
            String tableCode;
            Element report = (Element)reportIterator.next();
            Element baseTable = report.element("basetable");
            if (baseTable != null && csvFileMap.containsKey(tableCode = baseTable.attributeValue("code"))) {
                baseTable.addAttribute("datafile", (String)csvFileMap.get(tableCode).getLeft() + ".csv");
            }
            Iterator subTableIterator = report.elementIterator("subtable");
            while (subTableIterator.hasNext()) {
                Element subTable = (Element)subTableIterator.next();
                String tableCode2 = subTable.attributeValue("code");
                if (!csvFileMap.containsKey(tableCode2)) continue;
                subTable.addAttribute("datafile", (String)csvFileMap.get(tableCode2).getLeft() + ".csv");
            }
        }
        Iterator unitcatIterator = root.elementIterator("unitcat");
        while (unitcatIterator.hasNext()) {
            Element unitcat = (Element)unitcatIterator.next();
            String unitcatCode = unitcat.attributeValue("code");
            if (!csvFileMap.containsKey(unitcatCode)) continue;
            unitcat.addAttribute("datafile", (String)csvFileMap.get(unitcatCode).getLeft() + ".csv");
        }
        return document.asXML();
    }
}

