/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.rpa.dao;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.rpa.entity.RpaEntityRef;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections4.CollectionUtils;

public class RpaEntityRefDao {
    private static final String ENTITY_NAME = "eb_rpa_entity_ref";

    public static RpaEntityRefDao getInstance() {
        return InnerClass.instance;
    }

    private RpaEntityRefDao() {
    }

    public DynamicObject load(Long orgId) {
        return BusinessDataServiceHelper.loadSingle((Object)orgId, (String)ENTITY_NAME);
    }

    public DynamicObject load(Long entityId, Long integrationId) {
        QFilter q1 = new QFilter("entity", "=", (Object)entityId);
        QFilter q2 = new QFilter("rpainte", "=", (Object)integrationId);
        return BusinessDataServiceHelper.loadSingle((String)ENTITY_NAME, (String)"id, name, number, view, entity, reporttype", (QFilter[])new QFilter[]{q1, q2});
    }

    public DynamicObject[] load(List<Long> ids) {
        QFilter q1 = new QFilter("id", "in", ids);
        return BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)"id, entity, rpainte", (QFilter[])new QFilter[]{q1});
    }

    public List<RpaEntityRef> loadDataToModel(Long rpaIntegrationId) {
        QFilter q1 = new QFilter("rpainte", "=", (Object)rpaIntegrationId);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)"id, name, number, view, entity, reporttype, entity, rpainte, model", (QFilter[])new QFilter[]{q1});
        if (load.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.stream(load).map(this::transToModel).collect(Collectors.toList());
    }

    public DynamicObject[] loadByIntegration(List<Long> integrationIds) {
        QFilter q = new QFilter("rpainte", "in", integrationIds);
        return BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)"id, name, number, view, entity, reporttype, entity, rpainte", (QFilter[])new QFilter[]{q});
    }

    public Map<Long, Long> loadEntityView(Long rpaIntegrationId, List<Long> entityIds) {
        QFilter qFilter = new QFilter("rpainte", "=", (Object)rpaIntegrationId);
        qFilter.and("entity", "in", entityIds);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)ENTITY_NAME, (String)"view, entity", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            return new HashMap<Long, Long>(16);
        }
        return dynamicObjects.stream().collect(Collectors.toMap(e -> e.getLong("entity"), e -> e.getLong("view"), (o1, o2) -> o1));
    }

    public boolean numberIsExists(Long id, String number, String reportType, Long integrationId) {
        QFilter qFilter = new QFilter("number", "=", (Object)number);
        qFilter.and(new QFilter("reporttype", "=", (Object)reportType));
        qFilter.and(new QFilter("rpainte", "=", (Object)integrationId));
        if (IDUtils.isNotEmptyLong((Long)id).booleanValue()) {
            qFilter.and(new QFilter("id", "!=", (Object)id));
        }
        return QueryServiceHelper.exists((String)ENTITY_NAME, (QFilter[])new QFilter[]{qFilter});
    }

    public boolean entityNumberIsExists(Long id, Long entityId, Long integrationId) {
        QFilter qFilter = new QFilter("entity", "=", (Object)entityId);
        qFilter.and(new QFilter("rpainte", "=", (Object)integrationId));
        if (IDUtils.isNotEmptyLong((Long)id).booleanValue()) {
            qFilter.and(new QFilter("id", "!=", (Object)id));
        }
        return QueryServiceHelper.exists((String)ENTITY_NAME, (QFilter[])new QFilter[]{qFilter});
    }

    public List<Long> getEntityIds(Long integrationId) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)ENTITY_NAME, (String)"entity", (QFilter[])new QFilter[]{new QFilter("rpainte", "=", (Object)integrationId)});
        if (CollectionUtils.isNotEmpty((Collection)query)) {
            return query.stream().map(dynamicObject -> dynamicObject.getLong("entity")).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public void deleteByRpaIntegration(List<Long> rpaIntegrationIds) {
        DeleteServiceHelper.delete((String)ENTITY_NAME, (QFilter[])new QFilter[]{new QFilter("rpainte", "in", rpaIntegrationIds)});
    }

    public void save(List<RpaEntityRef> data) {
        this.save((DynamicObject[])data.stream().map(this::packageDynamicObject).toArray(DynamicObject[]::new));
    }

    public void save(DynamicObject[] newDyDynamicObjects) {
        try (TXHandle tx = TX.required();){
            try {
                SaveServiceHelper.save((DynamicObject[])newDyDynamicObjects);
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    public void delete(List<Long> ids) {
        try (TXHandle tx = TX.required();){
            try {
                DeleteServiceHelper.delete((String)ENTITY_NAME, (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
            }
            catch (Throwable e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    public void copy(Long oldRpaIntegrationId, Long newRpaIntegrationId) {
        List<RpaEntityRef> load = this.loadDataToModel(oldRpaIntegrationId);
        if (CollectionUtils.isEmpty(load)) {
            return;
        }
        Long currUserId = RequestContext.get().getCurrUserId();
        Date now = TimeServiceHelper.now();
        DynamicObject[] newDyDynamicObjects = new DynamicObject[load.size()];
        AtomicInteger row = new AtomicInteger(0);
        load.forEach(data -> {
            RpaEntityRef newModel = new RpaEntityRef();
            try {
                BeanUtils.copyProperties((Object)newModel, (Object)data);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new KDBizException(e.getMessage());
            }
            newModel.setId(null);
            newModel.setRpaInteId(newRpaIntegrationId);
            newModel.setModifier(currUserId);
            newModel.setModifyTime(now);
            DynamicObject newDynamicObject = this.packageDynamicObject(newModel);
            int i = row.getAndIncrement();
            newDyDynamicObjects[i] = newDynamicObject;
        });
        SaveServiceHelper.save((DynamicObject[])newDyDynamicObjects);
    }

    private RpaEntityRef transToModel(DynamicObject dynamicObject) {
        RpaEntityRef model = new RpaEntityRef();
        model.setId(dynamicObject.getLong("id"));
        model.setModel(dynamicObject.getLong("model.id"));
        model.setRpaInteId(dynamicObject.getLong("rpainte.id"));
        model.setViewId(dynamicObject.getLong("view.id"));
        model.setEntityId(dynamicObject.getLong("entity.id"));
        model.setCorpNumber(dynamicObject.getString("number"));
        model.setCorpName(dynamicObject.getString("name"));
        model.setReportType(dynamicObject.getString("reporttype"));
        return model;
    }

    private DynamicObject packageDynamicObject(RpaEntityRef model) {
        DynamicObject dynamicObject;
        Long id = model.getId();
        if (IDUtils.isNull((Long)id)) {
            id = GlobalIdUtil.genGlobalLongId();
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_NAME);
        } else {
            dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)ENTITY_NAME);
        }
        dynamicObject.set("id", (Object)id);
        dynamicObject.set("model", (Object)model.getModel());
        dynamicObject.set("view", (Object)model.getViewId());
        dynamicObject.set("rpainte", (Object)model.getRpaInteId());
        dynamicObject.set("entity", (Object)model.getEntityId());
        dynamicObject.set("number", (Object)model.getCorpNumber());
        dynamicObject.set("name", (Object)model.getCorpName());
        dynamicObject.set("reporttype", (Object)model.getReportType());
        dynamicObject.set("modifier", (Object)model.getModifier());
        dynamicObject.set("modifytime", (Object)model.getModifyTime());
        return dynamicObject;
    }

    private static class InnerClass {
        private static final RpaEntityRefDao instance = new RpaEntityRefDao();

        private InnerClass() {
        }
    }
}

