/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.rpa.dao;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.extension.FileServiceExtFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class RpaIntegrationAttachmentDao {
    private static final String ENTITY_NAME = "bos_attachment";
    private static final Log log = LogFactory.getLog(RpaIntegrationAttachmentDao.class);

    public static RpaIntegrationAttachmentDao getInstance() {
        return InnerClass.instance;
    }

    private RpaIntegrationAttachmentDao() {
    }

    public void deleteAttachment(List<Long> rpaIntegrationIds) {
        List ids = rpaIntegrationIds.stream().map(String::valueOf).collect(Collectors.toList());
        DeleteServiceHelper.delete((String)ENTITY_NAME, (QFilter[])new QFilter[]{new QFilter("fbilltype", "=", (Object)"eb_rpa_integration"), new QFilter("finterid", "in", ids)});
    }

    public boolean checkAttachmentExisted(Long rpaIntegrationId) {
        QFilter qf1 = new QFilter("fbilltype", "=", (Object)"eb_rpa_integration");
        QFilter qf2 = new QFilter("finterid", "=", (Object)String.valueOf(rpaIntegrationId));
        return QueryServiceHelper.exists((String)ENTITY_NAME, (QFilter[])new QFilter[]{qf1, qf2});
    }

    public void copyAttachment(Long oldRpaIntegrationId, Long newRpaIntegrationId) {
        String selectProperties = "fbilltype, fnumber, finterid, ffileid, fattachmentname, fextname, fattachmentsize, fbillstatus,fattachmentpanel";
        QFilter qf1 = new QFilter("fbilltype", "=", (Object)"eb_rpa_integration");
        QFilter qf2 = new QFilter("finterid", "=", (Object)String.valueOf(oldRpaIntegrationId));
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)selectProperties, (QFilter[])new QFilter[]{qf1, qf2});
        Long currUserId = RequestContext.get().getCurrUserId();
        Date now = TimeServiceHelper.now();
        List<DynamicObject> attachList = Arrays.stream(dynamicObjects).map(dynamicObject -> {
            DynamicObject dynObj = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_NAME);
            dynObj.set("fbilltype", (Object)"eb_rpa_integration");
            dynObj.set("fnumber", dynamicObject.get("fnumber"));
            dynObj.set("finterid", (Object)newRpaIntegrationId);
            dynObj.set("ffileid", dynamicObject.get("ffileid"));
            dynObj.set("fattachmentname", dynamicObject.get("fattachmentname"));
            dynObj.set("fextname", dynamicObject.get("fextname"));
            dynObj.set("fattachmentsize", dynamicObject.get("fattachmentsize"));
            dynObj.set("fbillstatus", (Object)"A");
            dynObj.set("fcreatemen", (Object)currUserId);
            dynObj.set("fcreatetime", (Object)now);
            dynObj.set("fmodifymen", (Object)currUserId);
            dynObj.set("fmodifytime", (Object)now);
            dynObj.set("fattachmentpanel", dynamicObject.get("fattachmentpanel"));
            return dynObj;
        }).collect(Collectors.toList());
        this.save(attachList);
    }

    public void save(List<DynamicObject> dynObj) {
        try (TXHandle tx = TX.required();){
            try {
                SaveServiceHelper.save((DynamicObject[])dynObj.toArray(new DynamicObject[0]));
            }
            catch (Throwable e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    public String getExcelFileUrl(Long rpaIntegrationId) {
        DynamicObjectCollection dynObj = QueryServiceHelper.query((String)ENTITY_NAME, (String)"fextname, fFileId", (QFilter[])new QFilter[]{new QFilter("fbilltype", "=", (Object)"eb_rpa_integration"), new QFilter("finterid", "=", (Object)String.valueOf(rpaIntegrationId))});
        Optional<DynamicObject> excelFile = dynObj.stream().filter(e -> e.getString("fextname").toLowerCase(Locale.ENGLISH).endsWith("xls") || e.getString("fextname").toLowerCase(Locale.ENGLISH).endsWith("xlsx")).findFirst();
        if (excelFile.isPresent()) {
            DynamicObject dynamicObject = excelFile.get();
            String fFileId = dynamicObject.getString("fFileId");
            if (!fFileId.toLowerCase(Locale.ENGLISH).endsWith(".xls") && !fFileId.toLowerCase(Locale.ENGLISH).endsWith(".xlsx")) {
                return FileServiceExtFactory.getAttachFileServiceExt().getRealPath(fFileId);
            }
            return fFileId;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u65b9\u6848\u65e0xls\u6216xlsx\u9644\u4ef6\uff0c\u8bf7\u4e0a\u4f20\u9644\u4ef6\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"RpaIntegrationAttachmentDao_0", (String)"epm-eb-business", (Object[])new Object[0]));
    }

    public String getXmlFileUrl(Long rpaIntegrationId) {
        DynamicObjectCollection dynObj = QueryServiceHelper.query((String)ENTITY_NAME, (String)"fextname, fFileId", (QFilter[])new QFilter[]{new QFilter("fbilltype", "=", (Object)"eb_rpa_integration"), new QFilter("finterid", "=", (Object)String.valueOf(rpaIntegrationId))});
        Optional<DynamicObject> xmlFile = dynObj.stream().filter(e -> e.getString("fextname").toLowerCase(Locale.ENGLISH).endsWith("xml")).findFirst();
        if (xmlFile.isPresent()) {
            DynamicObject dynamicObject = xmlFile.get();
            String fFileId = dynamicObject.getString("fFileId");
            if (!fFileId.toLowerCase(Locale.ENGLISH).endsWith(".xml")) {
                return FileServiceExtFactory.getAttachFileServiceExt().getRealPath(fFileId);
            }
            return fFileId;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u65b9\u6848\u65e0xml\u9644\u4ef6\uff0c\u8bf7\u4e0a\u4f20\u9644\u4ef6\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"RpaIntegrationAttachmentDao_1", (String)"epm-eb-business", (Object[])new Object[0]));
    }

    private static class InnerClass {
        private static final RpaIntegrationAttachmentDao instance = new RpaIntegrationAttachmentDao();

        private InnerClass() {
        }
    }
}

