/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.rpa.dao;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;

public class RpaIntegrationCateDao {
    private static final String ENTITY_NAME = "eb_rpa_integration_cate";

    public static RpaIntegrationCateDao getInstance() {
        return InnerClass.instance;
    }

    private RpaIntegrationCateDao() {
    }

    public DynamicObject load(Long id) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)ENTITY_NAME);
        return dynamicObject;
    }

    public int getCurNodeSequence(Long modelId, Long parentId) {
        QFilter model = new QFilter("model", "=", (Object)modelId);
        QFilter parent = new QFilter("parent", "=", (Object)parentId);
        QFilter[] filters = new QFilter[]{model, parent};
        int result = 0;
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)ENTITY_NAME, (String)"sequence", (QFilter[])filters, (String)"sequence desc");
        if (dcs != null && dcs.size() > 0) {
            result = dcs.stream().map(seqDy -> seqDy.getInt("sequence")).max((a, b) -> a > b ? 1 : -1).get();
            ++result;
        } else {
            result = 1;
        }
        return result;
    }

    public boolean checkNumberExisted(Long id, Long modelId, String number) {
        QFBuilder qb = new QFBuilder();
        qb.add("model", "=", (Object)modelId);
        qb.add("number", "=", (Object)number);
        if (IDUtils.isNotEmptyLong((Long)id).booleanValue()) {
            qb.add(new QFilter("id", "!=", (Object)id));
        }
        return QueryServiceHelper.exists((String)ENTITY_NAME, (QFilter[])qb.toArrays());
    }

    public void deleteById(List<Long> childIds) {
        try (TXHandle tx = TX.required();){
            try {
                DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)ENTITY_NAME), (Object[])childIds.toArray());
            }
            catch (Throwable e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    private static class InnerClass {
        private static final RpaIntegrationCateDao instance = new RpaIntegrationCateDao();

        private InnerClass() {
        }
    }
}

